<?php

class AgendarProcedimentoIndividual extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = '';
    private static $activeRecord = '';
    private static $primaryKey = '';
    private static $formName = 'form_AgendarProcedimentoIndividual';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param = null)
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Agendar Procedimento");


        $id_paciente = new TSeekButton('id_paciente');
        $nome_paciente = new TEntry('nome_paciente');
        $id_procedimento = new TSeekButton('id_procedimento');
        $procedimento = new TEntry('procedimento');
        $id_profissional = new TSeekButton('id_profissional');
        $nome_profissional = new TEntry('nome_profissional');
        $id_tipo_agendamento = new TRadioGroup('id_tipo_agendamento');

        $id_tipo_agendamento->addValidation("tipo de agendamento", new TRequiredValidator()); 

        $id_tipo_agendamento->setLayout('horizontal');
        $id_tipo_agendamento->addItems(['1'=>' Primeira Consulta','2'=>' Retorno','3'=>'Encaixe']);
        $id_tipo_agendamento->setBreakItems(3);

        $id_paciente->setSize('20%');
        $procedimento->setSize('78%');
        $nome_paciente->setSize('77%');
        $id_procedimento->setSize('20%');
        $id_profissional->setSize('20%');
        $nome_profissional->setSize('78%');
        $id_tipo_agendamento->setSize('100%');

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_paciente_seekAction = new TAction(['PacienteSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id_paciente', 'column'=>'{id}'],
            ['name'=> 'id_paciente', 'column'=>'{id}'],
            ['name'=> 'nome_paciente', 'column'=>'{nome_paciente}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_paciente_seekAction->setParameter('_seek_fields', $seekFields);
        $id_paciente_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_paciente_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id_paciente->setAction($id_paciente_seekAction);

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_procedimento_seekAction = new TAction(['ProcedimentoSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id_procedimento', 'column'=>'{id}'],
            ['name'=> 'id_procedimento', 'column'=>'{id}'],
            ['name'=> 'procedimento', 'column'=>'{descricao_procedimento}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_procedimento_seekAction->setParameter('_seek_fields', $seekFields);
        $id_procedimento_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_procedimento_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id_procedimento->setAction($id_procedimento_seekAction);

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_profissional_seekAction = new TAction(['ProfissionalSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id_profissional', 'column'=>'{id}'],
            ['name'=> 'id_profissional', 'column'=>'{id}'],
            ['name'=> 'nome_profissional', 'column'=>'{nome_profissional}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_profissional_seekAction->setParameter('_seek_fields', $seekFields);
        $id_profissional_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_profissional_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id_profissional->setAction($id_profissional_seekAction);

        $row1 = $this->form->addFields([new TLabel("Usuário:", '#FF0000', '14px', null)],[$id_paciente,$nome_paciente]);
        $row2 = $this->form->addFields([new TLabel("Procedimento:", '#ff0000', '14px', null)],[$id_procedimento,$procedimento]);
        $row3 = $this->form->addFields([new TLabel("Profissional:", '#FF0000', '14px', null)],[$id_profissional,$nome_profissional]);
        $row4 = $this->form->addFields([new TLabel("Tipo de Agendamento:", '#ff0000', '14px', null)],[$id_tipo_agendamento]);

        // create the form actions
        $btn_onaction = $this->form->addAction("Próximo Passo", new TAction([$this, 'onAction']), 'fas:arrow-circle-right #ffffff');
        $this->btn_onaction = $btn_onaction;
        $btn_onaction->addStyleClass('btn-primary'); 

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Agendamento","Agendar Consulta"]));
        }
        $container->add($this->form);

        $tstep = new TStep();

        $tstep->addItem('Selecionar o Paciente', true, false);
        $tstep->addItem('Selecionar a Escala de Atendimento', false, false);
        $tstep->addItem('Selecionar a Data do Atendimento', false, false);
        $tstep->addItem('Confirmar Agendamento', false, false);

        parent::add($tstep);

        parent::add($container);

    }

    public function onAction($param = null) 
    {
        try
        {
            $data = $this->form->getData();

            if(!$data->id_paciente)
            {
                throw new Exception(AdiantiCoreTranslator::translate('The field ^1 is required', 'Paciente'));
            }                       

            if(!$data->id_procedimento)
            {
                throw new Exception(AdiantiCoreTranslator::translate('The field ^1 is required', 'Procedimento'));
            }                       

            if(!$data->id_tipo_agendamento)
            {
                throw new Exception(AdiantiCoreTranslator::translate('The field ^1 is required', 'Tipo de Agendamento'));
            }                       

            if(!$data->id_profissional)
            {
                throw new Exception(AdiantiCoreTranslator::translate('The field ^1 is required', 'Profissional'));
            }        
            //echo $data->id_procedimento;
            TSession::setValue('agendar_step1', $data);
            TSession::setValue('paciente', $data->id_paciente);
            TSession::setValue('id_procedimento', $data->id_procedimento);
            TSession::setValue('tipo_agendamento', $data->id_tipo_agendamento);
            TSession::setValue('profissional', $data->id_profissional);

            //$page ='AgendarStep2List';
            $page ='EscolherEscalaCardList';
            $metodo = 'onShow';

            AdiantiCoreApplication::loadPage($page, $metodo);

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    public function onShow($param = null)
    {               

    } 

    public function fireEvents( $object )
    {
        $obj = new stdClass;
        if(is_object($object) && get_class($object) == 'stdClass')
        {
            if(isset($object->id_paciente))
            {
                $value = $object->id_paciente;

                $obj->id_paciente = $value;
            }
            if(isset($object->id_procedimento))
            {
                $value = $object->id_procedimento;

                $obj->id_procedimento = $value;
            }
            if(isset($object->id_profissional))
            {
                $value = $object->id_profissional;

                $obj->id_profissional = $value;
            }
        }
        elseif(is_object($object))
        {
            if(isset($object->id_paciente))
            {
                $value = $object->id_paciente;

                $obj->id_paciente = $value;
            }
            if(isset($object->id_procedimento))
            {
                $value = $object->id_procedimento;

                $obj->id_procedimento = $value;
            }
            if(isset($object->id_profissional))
            {
                $value = $object->id_profissional;

                $obj->id_profissional = $value;
            }
        }
        TForm::sendData(self::$formName, $obj);
    }  

}

