<?php

class ConfirmarAgendamentoForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'Agendamento';
    private static $primaryKey = 'id';
    private static $formName = 'form_Agendamento';

    private $paciente;
    private $procedimento;
    private $tipo_agendamento;
    private $id_escala;
    private $data_agendamento;
    private $id_unidade;

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Confirmar Agendamento");


        $id = new THidden('id');
        $flg_atendimento = new THidden('flg_atendimento');
        $flg_app_agenda = new THidden('flg_app_agenda');
        $nome_paciente = new TEntry('nome_paciente');
        $id_procedimento = new TEntry('id_procedimento');
        $id_profissional = new TEntry('id_profissional');
        $id_unidade_saude = new TEntry('id_unidade_saude');
        $id_turno = new TEntry('id_turno');
        $turno_horario = new TEntry('turno_horario');
        $tipo_agendamento = new TEntry('tipo_agendamento');
        $data_agendamento = new TEntry('data_agendamento');

        $nome_paciente->addValidation("Cód. Paciente", new TRequiredValidator()); 
        $id_turno->addValidation("Unidade de Saúde", new TRequiredValidator()); 
        $data_agendamento->addValidation("Data Agendamento", new TRequiredValidator()); 

        $flg_app_agenda->setValue('W');
        $flg_atendimento->setValue('N');

        $id_turno->setEditable(false);
        $nome_paciente->setEditable(false);
        $turno_horario->setEditable(false);
        $id_procedimento->setEditable(false);
        $id_profissional->setEditable(false);
        $id_unidade_saude->setEditable(false);
        $tipo_agendamento->setEditable(false);
        $data_agendamento->setEditable(false);

        $id->setSize(200);
        $id_turno->setSize('100%');
        $flg_app_agenda->setSize(200);
        $flg_atendimento->setSize(200);
        $nome_paciente->setSize('100%');
        $turno_horario->setSize('100%');
        $id_procedimento->setSize('100%');
        $id_profissional->setSize('100%');
        $id_unidade_saude->setSize('100%');
        $tipo_agendamento->setSize('100%');
        $data_agendamento->setSize('100%');

        $row1 = $this->form->addFields([new TLabel(" ", null, '14px', null)],[$id,$flg_atendimento,$flg_app_agenda]);
        $row2 = $this->form->addFields([new TLabel("Paciente:", '#000000', '14px', null)],[$nome_paciente],[new TLabel("Procedimento:", '#000000', '14px', null)],[$id_procedimento]);
        $row3 = $this->form->addFields([new TLabel("Profissional:", '#000000', '14px', null)],[$id_profissional],[new TLabel("Unidade de Saúde:", '#000000', '14px', null)],[$id_unidade_saude]);
        $row4 = $this->form->addFields([new TLabel("Turno:", '#000000', '14px', null)],[$id_turno],[new TLabel("Horário:", '#000000', '14px', null)],[$turno_horario]);
        $row5 = $this->form->addFields([new TLabel("Tipo de Atendimento:", '#000000', '14px', null)],[$tipo_agendamento],[new TLabel("Data Atendimento:", '#ff0000', '14px', 'B')],[$data_agendamento]);

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave']), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-success'); 

        $btn_onaction = $this->form->addAction("Cancelar", new TAction([$this, 'onAction']), 'fas:eraser #DD5A43');
        $this->btn_onaction = $btn_onaction;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Agendamento","Confirmar Agendamento"]));
        }
        $container->add($this->form);

       $tstep = new TStep();

       $tstep->addItem('Selecionar o Paciente', false, true);
       $tstep->addItem('Selecionar a Escala de Atendimento', false, true);
       $tstep->addItem('Selecionar a Data do Atendimento', false, true);
       $tstep->addItem('Confirmar Agendamento', true, false);

       parent::add($tstep);

        parent::add($container);

    }

    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $this->paciente = TSession::getValue('paciente');
            $this->procedimento = TSession::getValue('procedimento');
            $this->tipo_agendamento = TSession::getValue('tipo_agendamento');
            $this->id_escala = TSession::getValue('id_escala');
            $this->data_agendamento = TSession::getValue('data_agendamento');
            $this->id_unidade = TSession::getValue('id_unidade_saude');

            $object = new Agendamento(); // create an empty object 

            $object->id_paciente = $this->paciente;
            $object->id_escala = $this->id_escala;
            $object->id_unidade_saude = $this->id_unidade;
            $object->id_situacao = '1';
            $object->data_agendamento = date($this->data_agendamento);
            $object->flg_atendimento = 'A';
            $object->flg_tipo_agendamento = $this->tipo_agendamento;
            $object->flg_app_agenda = 'W';
            $object->id_procedimento = TSession::getValue('id_procedimento');
            $object->id_profissional = (Escala::find($this->id_escala))->id_profissional;

            $object->store(); // save the object 

            /* get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            */

            $objHisAgendamento = new HistoricoAgendamento();
            $objHisAgendamento->id_status = '1';
            $objHisAgendamento->id_agendamento = $object->id;
            $objHisAgendamento->justificativa = 'Agendamento realizado!';
            $objHisAgendamento->data_hora = date('Y-m-d H:i:s');
            $objHisAgendamento->id_usuario = TSession::getValue('userid');

            $objHisAgendamento->store(); 

            TTransaction::close();// close the transaction
            $this->form->clear(true);

            unset($object);

            TSession::delValue('paciente');
            TSession::delValue('procedimento');
            TSession::delValue('tipo_agendamento');
            TSession::delValue('id_escala');
            TSession::delValue('data_agendamento');
            TSession::delValue('id_unidade_saude');

            $page ='AgendarProcedimentoIndividual';
            $metodo = 'onShow';

            AdiantiCoreApplication::loadPage($page, $metodo);            

            new TMessage('info', "Registro salvo", $messageAction); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode> 

            new TMessage('error', $e->getMessage()); // shows the exception error message
           // $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }
    public function onAction($param = null) 
    {
        try 
        {

            TSession::delValue('paciente');
            TSession::delValue('procedimento');
            TSession::delValue('tipo_agendamento');
            TSession::delValue('id_escala');
            TSession::delValue('data_agendamento');
            TSession::delValue('id_unidade_saude');

            $page ='AgendarProcedimentoIndividual';
            $metodo = 'onShow';

            AdiantiCoreApplication::loadPage($page, $metodo);            

        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new Agendamento($key); // instantiates the Active Record 

                $this->form->setData($object); // fill the form 

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

            TSession::delValue('paciente');
            TSession::delValue('procedimento');
            TSession::delValue('tipo_agendamento');
            TSession::delValue('id_escala');
            TSession::delValue('data_agendamento');
            TSession::delValue('id_unidade_saude');

    }

    public function onShow($param = null)
    {

           TTransaction::open(self::$database); 

           $this->paciente = TSession::getValue('paciente');
           $this->procedimento = TSession::getValue('id_procedimento');
           $this->tipo_agendamento = TSession::getValue('tipo_agendamento');
           $this->id_escala = TSession::getValue('id_escala');
           $this->data_agendamento = TSession::getValue('data_agendamento');
           $this->id_unidade = TSession::getValue('id_unidade_saude');

           $objPaciente = Paciente::find($this->paciente);
           $objProcedimento = Procedimento::find( $this->procedimento );
           $objEscala = Escala::find($this->id_escala);
           $objProfissional = Profissional::find($objEscala->id_profissional);
           $objUnidadeSaude = UnidadeSaude::find($objEscala->id_unidade_saude);
           $objTurno = Turno::find($objEscala->id_turno);

           TSession::setValue('data_agendamento', $param['key']);
           TSession::setValue('id_unidade_saude', $objEscala->id_unidade_saude);

           $object = new stdClass();
           $object->nome_paciente = $objPaciente->nome_paciente;
           $object->id_procedimento = $objProcedimento->descricao_procedimento;
           $object->id_profissional = $objProfissional->nome_profissional;
           $object->id_unidade_saude = $objUnidadeSaude->nome;
           $object->id_turno = $objTurno->nome;
           $object->turno_horario = $objTurno->horario;
           $object->data_agendamento = (new DateTime($param['key']))->format('d-m-Y');

            switch ($this->tipo_agendamento) {
              case 1:{
                 $object->tipo_agendamento = 'PRIMEIRA VEZ';
                 break;
              }
              case 2: {
                 $object->tipo_agendamento = 'RETORNO';
                 break;
              }
              case 3: {
                 $object->tipo_agendamento = 'ENCAIXE';
                 break;
              }

            }

           TForm::sendData(self::$formName, $object);

           TTransaction::close();

    } 

}

