<?php

class EscolherDataCardList extends TPage
{
    private $form; // form
    private $cardView; // listing
    private $pageNavigation;
    private $loaded;
    private $filter_criteria;
    private static $database = 'reabilitar';
    private static $items = [];
    private static $activeRecord = 'Escala';
    private static $primaryKey = 'id';
    private static $formName = 'formCardList_Escala';
    private $showMethods = ['onReload', 'onSearch'];

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct()
    {
        parent::__construct();
        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);

        // define the form title
        $this->form->setFormTitle("Escolha a Data do Atendimento");

        $nome_paciente = new TEntry('nome_paciente');
        $id_procedimento = new TEntry('id_procedimento');
        $id_profissional = new TEntry('id_profissional');
        $id_unidade_saude = new TEntry('id_unidade_saude');
        $button_voltar = new TButton('button_voltar');

        $button_voltar->setAction(new TAction(['EscolherEscalaCardList', 'onShow']), "Voltar");
        $button_voltar->addStyleClass('btn-danger');
        $button_voltar->setImage('fas:backspace #ffffff');

        $nome_paciente->setSize('100%');
        $id_procedimento->setSize('100%');
        $id_profissional->setSize('100%');
        $id_unidade_saude->setSize('100%');

        $nome_paciente->setEditable(false);
        $id_procedimento->setEditable(false);
        $id_profissional->setEditable(false);
        $id_unidade_saude->setEditable(false);

        $row1 = $this->form->addFields([new TLabel("Paciente:", null, '14px', null)],[$nome_paciente],[new TLabel("Procedimento:", null, '14px', null)],[$id_procedimento]);
        $row2 = $this->form->addFields([new TLabel("Profissional:", null, '14px', null)],[$id_profissional],[new TLabel("Unidade de Saúde:", null, '14px', null)],[$id_unidade_saude]);
        $row5 = $this->form->addFields([$button_voltar],[]);
        $row5->layout = [' col-sm-2',' col-sm-10'];

        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        $startHidden = true;

        if(TSession::getValue('EscolherDataCardList_expand_start_hidden') === false)
        {
            $startHidden = false;
        }
        elseif(TSession::getValue('EscolherDataCardList_expand_start_hidden') === true)
        {
            $startHidden = true; 
        }
        $expandButton = $this->form->addExpandButton("Expandir", 'fas:expand #000000', false);
        $expandButton->addStyleClass('btn-default');
        $expandButton->setAction(new TAction([$this, 'onExpandForm'], ['static'=>1]), "Expandir");
        $this->form->addField($expandButton);

        $this->cardView = new TCardView;

        $this->cardView->setTitleAttribute('titulo');
        $this->cardView->setColorAttribute('cor');
        
        $this->cardView->setItemTemplate("{conteudo}");

        $action_EscolherDataCardList_onShow = new TAction(['ConfirmarAgendamentoForm', 'onShow'], ['key'=> '{id}']);  
        $action_EscolherDataCardList_onShow->setParameter('id_escala', '{id}');
        $this->cardView->addAction($action_EscolherDataCardList_onShow, "Selecionar", 'fas:check-double #478fca'); 
       // $this->cardView->addAction($action_EscolherDataCardList_onShow, "Selecionar", 'fas:check-double #478fca','EscalaCardList::exibir'); <<-- Recurso para exibir os dias de afastamento sem permitir a seleção (próxima versão).
        $this->cardView->setContentHeight(50);
        

        $panel = new TPanelGroup;
        $panel->add($this->cardView);

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->add(TBreadCrumb::create(["Agendamento","Escolher Data"]));
        $container->add($this->form);
        $container->add($panel);

       //retirar deixar de buscar os itens no banco de dados
       $this->cardView->setItemDatabase(null);

       $tstep = new TStep();

       $tstep->addItem('Selecionar o Paciente', false, true);
       $tstep->addItem('Selecionar a Escala de Atendimento', false, true);
       $tstep->addItem('Selecionar a Data do Atendimento', true, false);
       $tstep->addItem('Confirmar Agendamento', false, false);

       parent::add($tstep);

       parent::add($container);

    }

    /**
     * Register the filter in the session
     */
    public function onSearch()
    {
        // get the search form data
        $data = $this->form->getData();
        $filters = [];

        TSession::setValue(__CLASS__.'_filter_data', NULL);
        TSession::setValue(__CLASS__.'_filters', NULL);

        $param = array();
        $param['offset']     = 0;
        $param['first_page'] = 1;

        // fill the form with data again
        $this->form->setData($data);

        // keep the search data in the session
        TSession::setValue(__CLASS__.'_filter_data', $data);
        TSession::setValue(__CLASS__.'_filters', $filters);

        $this->onReload($param);
    }

    public function onReload($param = NULL)
    {
        try
        {

            date_default_timezone_set('America/Sao_Paulo');
 
            $formatter = new IntlDateFormatter('pt_BR',
                             IntlDateFormatter::FULL,
                             IntlDateFormatter::NONE,
                             'America/Sao_Paulo',          
                             IntlDateFormatter::GREGORIAN);
                             

            TTransaction::open(self::$database);

            $limit = Parametros::find('1')->num_dias_abertura_agenda; // aqui deve ser utilizado o parâmetro de dias de abertura da agenda.

            $paciente = TSession::getValue('paciente');
            $procedimento = TSession::getValue('id_procedimento');
            $tipo_agendamento = TSession::getValue('tipo_agendamento');
            $id_escala = $param['id_escala'];
            
            TSession::setValue('id_escala', $id_escala);

            $objPaciente = Paciente::find($paciente);
            $objProcedimento = Procedimento::find( $procedimento );
            $objEscala = Escala::find($id_escala);
            $objProfissional = Profissional::find($objEscala->id_profissional);
            $objUnidadeSaude = UnidadeSaude::find($objEscala->id_unidade_saude);
            $objTurno = Turno::find($objEscala->id_turno);
            
            
            $object = new stdClass();
            $object->nome_paciente = $objPaciente->nome_paciente;
            $object->id_procedimento = $objProcedimento->descricao_procedimento;
            $object->id_profissional = $objProfissional->nome_profissional;
            $object->id_unidade_saude = $objUnidadeSaude->nome;
            $object->id_turno = $objTurno->nome;
            $object->turno_horario = $objTurno->horario;

            switch ($tipo_agendamento) {
              case 1:{
                 $object->tipo_agendamento = 'PRIMEIRA VEZ';
                 break;
              }
              case 2: {
                 $object->tipo_agendamento = 'RETORNO';
                 break;
              }
              case 3: {
                 $object->tipo_agendamento = 'ENCAIXE';
                 break;
              }

            }



           TForm::sendData(self::$formName, $object);


            //Carregar Datas de Agendamento
            if (isset($id_escala)) {

                $objetoEscala = Escala::find( $id_escala );

                $objetoEscalaDia = EscalaDia::where('id_escala',  '=', $id_escala)
                                 ->orderBy('id')
                                 ->load();

                 $lista_dias = array();
                 $lista_datas = array();
                 $lista_afastamento = array();
                 $lista_feriados = array();
                 
                 $lista_afastamento = $this->carregarDatasAfastamento($objEscala->id_profissional);
                 $lista_feriado = $this->carregarDatasFeriado();

                 if (isset($objetoEscalaDia)) {
                    foreach ($objetoEscalaDia as $escaladia){
                       array_push($lista_dias, $escaladia->dia_semana);
                    }
                 }

                 if (isset($objetoEscala)){

                   if ($tipo_agendamento == '1') {
                      $qtd_max_agendamento = $objetoEscala->qtd_primeira_vez;
                   } else {
                      $qtd_max_agendamento = $objetoEscala->qtd_retorno;
                   }


                   $inicio  = new DateTime(date('Y-m-d', strtotime('+1 days', strtotime($objetoEscala->data_inicio))));
                   $fim = new DateTime(date('Y-m-d', strtotime('+1 days', strtotime($objetoEscala->data_limite))));
  
                   $frequencia = new DateInterval('P1D');

                   $intervalo = new DatePeriod($inicio, $frequencia ,$fim);
  
                   $datas_intervalo = array();

                   foreach ($lista_dias as $dia){
                     foreach ($intervalo as $data){

                        if (($dia == date('w', strtotime($data->format('Y-m-d')))) && (!in_array($data->format('Y-m-d'), $lista_afastamento)) && ((!in_array($data->format('Y-m-d'), $lista_feriado)))){

                           $objeto = AgendamentoEscala::where('data_agendamento',  '=', ($data->format('Y-m-d')))
                                                      ->where('tipo_agendamento', '=', $tipo_agendamento)
                                                      ->where('id_escala', '=', $id_escala)
                                                      ->first();

                           if (isset($objeto)){

                             if ($objeto->numero_de_agendamentos_dia < $qtd_max_agendamento) {
                               
                                  array_push($datas_intervalo, $data->format('Y-m-d'));                          
                             }
                             
                           } else {
                               
                                 array_push($datas_intervalo, $data->format('Y-m-d'));                          
                           }
                       }
                     }
                   }

                   asort($datas_intervalo);
  
                   $items = array();
                   
                   $i = 1;
                   
                   foreach ($datas_intervalo as $data){
                      $items[] = (object) [ 'id' => (new DateTime($data))->format('Y-m-d'), 'titulo' => 'Opção '.$i, 
                     'conteudo' => '<b>Data: </b>' . $formatter->format(new DateTime($data)) 
                     .'</p><b>Turno: </b>' .$objTurno->nome 
                     .'</p><b>Horário: </b>' .$objTurno->horario
                     .'</p><b>Tipo Agendamento: </b>' .$object->tipo_agendamento, 'cor' => '#57D557' ];   
                      $i++;
                      if ($i==$limit+1){
                          break;
                      }
                   }
                }
              TTransaction::close();
            }

            $this->cardView->clear();
            if ($items)
            {
                // iterate the collection of active records
                foreach ($items as $object)
                {

                    $this->cardView->addItem($object);

                }
            }

            // close the transaction
            TTransaction::close();
            $this->loaded = true;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    public function onShow($param = null)
    {
        //<onShow>

        //</onShow>
    }
 
    //verificar se o profissional tem afastamento na data
    public function carregarDatasAfastamento($Profissional)
    {
       
       $lstAfastamento = array();
       
       $objAfastamentosProfissional = AfastamentoProfissional::where('id_profissional',  '=', $Profissional)
                                      ->orderBy('id')
                                      ->load();
        
       foreach ($objAfastamentosProfissional as $datasAfastamento) {

             $inicio  = new DateTime ($datasAfastamento->data_inicio);
             $fim = new DateTime ($datasAfastamento->data_fim);
             
             $frequencia = new DateInterval('P1D');
             $intervalo = new DatePeriod($inicio, $frequencia ,$fim);
             
             foreach ($intervalo as $data){
                 array_push($lstAfastamento, $data->format('Y-m-d'));
             }
       }
       
       return $lstAfastamento; 
                                      

    }

    //verificar se o profissional tem afastamento na data
    public function carregarDatasFeriado($param = null)
    {
       
       $lstFeriado = array();
       
       $objFeriados = Feriados::orderBy('id')
                              ->load();
        
       foreach ($objFeriados as $dataFeriado) {

             $data  = $dataFeriado->data_feriado;
             array_push($lstFeriado, $data);
       }
       
       return ($lstFeriado); 
                                      

    }


    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        if (!$this->loaded AND (!isset($_GET['method']) OR !(in_array($_GET['method'],  $this->showMethods))) )
        {
            if (func_num_args() > 0)
            {
                $this->onReload( func_get_arg(0) );
            }
            else
            {
                $this->onReload();
            }
        }
        parent::show();
    }

    public static function onExpandForm($param = null)
    {
        try
        {
            $startHidden = true;

            if(TSession::getValue('EscolherDataCardList_expand_start_hidden') === false)
            {
                TSession::setValue('EscolherDataCardList_expand_start_hidden', true);
            }
            elseif(TSession::getValue('EscolherDataCardList_expand_start_hidden') === true)
            {
                TSession::setValue('EscolherDataCardList_expand_start_hidden', false);
            }
            else
            {
                TSession::setValue('EscolherDataCardList_expand_start_hidden', !$startHidden);
            }

        }
        catch(Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

}

