<?php

class EscolherEscalaCardList extends TPage
{
    private $form; // form
    private $cardView; // listing
    private $pageNavigation;
    private $loaded;
    private $filter_criteria;
    private static $database = 'reabilitar';
    private static $activeRecord = 'Escala';
    private static $primaryKey = 'id';
    private static $formName = 'formCardList_Escala';
    private $showMethods = ['onReload', 'onSearch'];

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct()
    {
        parent::__construct();
        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);

        // define the form title
        $this->form->setFormTitle("Escolha a Escala de Atendimento");

        $nome_paciente = new TEntry('nome_paciente');
        $id_procedimento = new TEntry('id_procedimento');
        $tipo_agendamento = new TEntry('tipo_agendamento');
        $nome_profissional = new TEntry('nome_profissional');
        $button_voltar = new TButton('button_voltar');

        $button_voltar->setAction(new TAction(['AgendarProcedimentoIndividual', 'onShow']), "Voltar");
        $button_voltar->addStyleClass('btn-danger');
        $button_voltar->setImage('fas:backspace #ffffff');

        $nome_paciente->setSize('100%');
        $id_procedimento->setSize('100%');
        $tipo_agendamento->setSize('100%');
        $nome_profissional->setSize('100%');

        $nome_paciente->setEditable(false);
        $id_procedimento->setEditable(false);
        $tipo_agendamento->setEditable(false);
        $nome_profissional->setEditable(false);

        $row1 = $this->form->addFields([new TLabel("Paciente:", null, '14px', null)],[$nome_paciente]);
        $row2 = $this->form->addFields([new TLabel("Procedimento:", null, '14px', null)],[$id_procedimento]);
        $row3 = $this->form->addFields([new TLabel("Tipo Agendamento:", null, '14px', null)],[$tipo_agendamento]);
        $row4 = $this->form->addFields([new TLabel("Profissional:", null, '14px', null)],[$nome_profissional]);
        $row5 = $this->form->addFields([$button_voltar],[]);
        $row5->layout = [' col-sm-2',' col-sm-10'];

        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        $startHidden = false;

        if(TSession::getValue('EscolherEscalaCardList_expand_start_hidden') === false)
        {
            $startHidden = false;
        }
        elseif(TSession::getValue('EscolherEscalaCardList_expand_start_hidden') === true)
        {
            $startHidden = true; 
        }
        $expandButton = $this->form->addExpandButton("Expandir", 'fas:expand #000000', $startHidden);
        $expandButton->addStyleClass('btn-default');
        $expandButton->setAction(new TAction([$this, 'onExpandForm'], ['static'=>1]), "Expandir");
        $this->form->addField($expandButton);

        $this->cardView = new TCardView;

        $this->cardView->setContentHeight(170);
        $this->cardView->setTitleTemplate('{unidade_saude->cnes_unidade}  - {unidade_saude->nome} ');
        $this->cardView->setColorAttribute('id_unidade_saude');
        $this->cardView->setItemTemplate("<b>Procedimento:</b> {procedimento->descricao_procedimento} </P>
<b>Profissional:  {profissional->nome_profissional} </b></p>
<b>Turno:</b>  {turno->nome} </p>
<b>Horário:</b>  {turno->horario}  ");

        $this->cardView->setItemDatabase(self::$database);

        $this->filter_criteria = new TCriteria;

        $action_EscolherDataCardList_onShow = new TAction(['EscolherDataCardList', 'onShow'], ['key'=> '{id}']);
        $action_EscolherDataCardList_onShow->setParameter('id_escala', '{id}');
        $this->cardView->addAction($action_EscolherDataCardList_onShow, "Selecionar", 'fas:check-double #478fca','EscolherEscalaCardList::exibir'); 

        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->enableCounters();
        $this->pageNavigation->setAction(new TAction(array($this, 'onReload')));

        $panel = new TPanelGroup;
        $panel->add($this->cardView);

        $panel->addFooter($this->pageNavigation);

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->add(TBreadCrumb::create(["Agendamento","Escolher Escala"]));
        $container->add($this->form);
        $container->add($panel);

       $tstep = new TStep();

       $tstep->addItem('Selecionar o Paciente', false, true);
       $tstep->addItem('Selecionar a Unidade de Atendimento', true, false);
       $tstep->addItem('Selecionar a Data do Atendimento', false, false);
       $tstep->addItem('Confirmar Agendamento', false, false);

       parent::add($tstep);

        parent::add($container);

    }

    public static function exibir($object)
    {
        try 
        {
            if($object)
            {
                return true;
            }

            return false;
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
    }

    /**
     * Register the filter in the session
     */
    public function onSearch()
    {
        // get the search form data
        $data = $this->form->getData();
        $filters = [];

        TSession::setValue(__CLASS__.'_filter_data', NULL);
        TSession::setValue(__CLASS__.'_filters', NULL);

        $param = array();
        $param['offset']     = 0;
        $param['first_page'] = 1;

        // fill the form with data again
        $this->form->setData($data);

        // keep the search data in the session
        TSession::setValue(__CLASS__.'_filter_data', $data);
        TSession::setValue(__CLASS__.'_filters', $filters);

        $this->onReload($param);
    }

    public function onReload($param = NULL)
    {
        try
        {

            // open a transaction with database 'reabilitar'
            TTransaction::open(self::$database);

            // creates a repository for Escala
            $repository = new TRepository(self::$activeRecord);
            $limit = 0;

            $criteria = clone $this->filter_criteria;

            if (empty($param['order']))
            {
                $param['order'] = 'id_unidade_saude';    
            }

            if (empty($param['direction']))
            {
                $param['direction'] = 'asc';
            }

            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $limit);

            if($filters = TSession::getValue(__CLASS__.'_filters'))
            {
                foreach ($filters as $filter) 
                {
                    $criteria->add($filter);       
                }
            }

            $criteria=null;

            $criteria = new TCriteria;

            $paciente = TSession::getValue('paciente');
            $procedimento = TSession::getValue('id_procedimento');
            $tipo_agendamento = TSession::getValue('tipo_agendamento');
            $profissional = TSession::getValue('profissional');

            $objPaciente = Paciente::find($paciente);
            $objProcedimento = Procedimento::find( $procedimento );
            $objProfissional = Profissional::find( $profissional );

            $object = new stdClass();
            $object->nome_paciente = $objPaciente->nome_paciente;
            $object->id_procedimento = $objProcedimento->descricao_procedimento;
            $object->nome_profissional = $objProfissional->nome_profissional;

            switch ($tipo_agendamento) {
              case 1:{
                 $object->tipo_agendamento = 'PRIMEIRA VEZ';
                 $criteria->add(new TFilter('qtd_primeira_vez', '>', 0));
                 break;
              }
              case 2: {
                 $object->tipo_agendamento = 'RETORNO';
                 $criteria->add(new TFilter('qtd_retorno', '>', 0));
                 break;
              }
              case 3: {
                 $object->tipo_agendamento = 'ENCAIXE';
                 $criteria->add(new TFilter('encaixe', '=', 1));
                 break;
              }

            }

           TForm::sendData(self::$formName, $object);

            $criteria->resetProperties();
            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $this->limit);

            //filtro por procedimento
            $filterVar = $procedimento;
            $criteria->add(new TFilter('id_procedimento', '=', $filterVar));

            //filtro por profissional
            $filterVar = $profissional;
            $criteria->add(new TFilter('id_profissional', '=', $filterVar));

            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);

            $this->cardView->clear();
            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {

                    $this->cardView->addItem($object);

                }
            }

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            $this->pageNavigation->setCount($count); // count of records
            $this->pageNavigation->setProperties($param); // order, page
            $this->pageNavigation->setLimit($limit); // limit

            // close the transaction
            TTransaction::close();
            $this->loaded = true;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    public function onShow($param = null)
    {

    }

    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        if (!$this->loaded AND (!isset($_GET['method']) OR !(in_array($_GET['method'],  $this->showMethods))) )
        {
            if (func_num_args() > 0)
            {
                $this->onReload( func_get_arg(0) );
            }
            else
            {
                $this->onReload();
            }
        }
        parent::show();
    }

    public static function onExpandForm($param = null)
    {
        try
        {
            $startHidden = false;

            if(TSession::getValue('EscolherEscalaCardList_expand_start_hidden') === false)
            {
                TSession::setValue('EscolherEscalaCardList_expand_start_hidden', true);
            }
            elseif(TSession::getValue('EscolherEscalaCardList_expand_start_hidden') === true)
            {
                TSession::setValue('EscolherEscalaCardList_expand_start_hidden', false);
            }
            else
            {
                TSession::setValue('EscolherEscalaCardList_expand_start_hidden', !$startHidden);
            }

        }
        catch(Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

}

