<?php

class GerirAgendamento extends TPage
{
    private $form; // form
    private $datagrid; // listing
    private $pageNavigation;
    private $loaded;
    private $filter_criteria;
    private static $database = 'reabilitar';
    private static $activeRecord = 'Agendamento';
    private static $primaryKey = 'id';
    private static $formName = 'formList_Agendamento';
    private $showMethods = ['onReload', 'onSearch'];
    private $limit = 20;

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct($param = null)
    {
        parent::__construct();
        // creates the form

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        $this->limit = 20;

        $data_agendamento = new TEntry('data_agendamento');
        $paciente_nome_paciente = new TEntry('paciente_nome_paciente');
        $escala_profissional_nome_profissional = new TDBCombo('escala_profissional_nome_profissional', 'reabilitar', 'Escala', 'id_profissional', '{profissional->nome_profissional}','id asc'  );
        $flg_tipo_agendamento = new TEntry('flg_tipo_agendamento');
        $id_escala = new TDBCombo('id_escala', 'reabilitar', 'Turno', 'id', '{nome}','id asc'  );
        $flg_atendimento = new TEntry('flg_atendimento');

        $data_agendamento->exitOnEnter();
        $paciente_nome_paciente->exitOnEnter();
        $flg_tipo_agendamento->exitOnEnter();
        $flg_atendimento->exitOnEnter();

        $data_agendamento->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $paciente_nome_paciente->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $flg_tipo_agendamento->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $flg_atendimento->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));

        $escala_profissional_nome_profissional->setChangeAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $id_escala->setChangeAction(new TAction([$this, 'onSearch'], ['static'=>'1']));

        $paciente_nome_paciente->forceUpperCase();
        $data_agendamento->setMask('9999-99-99');

        $id_escala->setSize('100%');
        $flg_atendimento->setSize('100%');
        $data_agendamento->setSize('100%');
        $flg_tipo_agendamento->setSize('100%');
        $paciente_nome_paciente->setSize('100%');
        $escala_profissional_nome_profissional->setSize('100%');

        // creates a Datagrid
        $this->datagrid = new TDataGrid;
        $this->datagrid->disableHtmlConversion();

        $this->datagrid_form = new TForm(self::$formName);
        $this->datagrid_form->onsubmit = 'return false';

        $this->datagrid = new BootstrapDatagridWrapper($this->datagrid);
        $this->filter_criteria = new TCriteria;

        $this->datagrid->disableDefaultClick();
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        $column_data_agendamento_transformed = new TDataGridColumn('data_agendamento', "Data", 'center' , '10%');
        $column_paciente_nome_paciente = new TDataGridColumn('paciente->nome_paciente', "Usuário", 'left' , '30%');
        $column_escala_profissional_nome_profissional_transformed = new TDataGridColumn('escala->profissional->nome_profissional', "Profissional", 'left' , '25%');
        $column_flg_tipo_agendamento_transformed = new TDataGridColumn('flg_tipo_agendamento', "Tipo", 'center' , '10%');
        $column_escala_turno_nome = new TDataGridColumn('escala->turno->nome', "Turno", 'left' , '10px');
        $column_flg_atendimento_transformed = new TDataGridColumn('flg_atendimento', "Atendido", 'center');

        $column_data_agendamento_transformed->setTransformer(function($value, $object, $row) 
        {
            if(!empty(trim($value)))
            {
                try
                {
                    $date = new DateTime($value);
                    return $date->format('d/m/Y');
                }
                catch (Exception $e)
                {
                    return $value;
                }
            }
        });

        $column_escala_profissional_nome_profissional_transformed->setTransformer(function($value, $object, $row) 
        {
            if($value)
            {
                return mb_strtoupper($value);
            }
        });

        $column_flg_tipo_agendamento_transformed->setTransformer(function($value, $object, $row)
        {
            //code here

            switch ($value) {
            case 1:
                return "PRIMEIRA VEZ";
                break;
            case 2:
                return "RETORNO";
                break;
            case 3:
                return "ENCAIXE";
                break;
            }

        });

        $column_flg_atendimento_transformed->setTransformer(function($value, $object, $row)
        {
            //code here

            switch ($value) {
            case 'A':
                return "AGENDADO";
                break;
            case 'S':
                return "USUÁRIO ATENDIDO";
                break;
            case 'U':
                return "USUÁRIO FALTOU";
                break;
            case 'P':
                return "PROFISSIONAL FALTOU";
                break;
            case 'R':
                return "REAGENDADO";
                break;

            }

        });        

        $this->datagrid->addColumn($column_data_agendamento_transformed);
        $this->datagrid->addColumn($column_paciente_nome_paciente);
        $this->datagrid->addColumn($column_escala_profissional_nome_profissional_transformed);
        $this->datagrid->addColumn($column_flg_tipo_agendamento_transformed);
        $this->datagrid->addColumn($column_escala_turno_nome);
        $this->datagrid->addColumn($column_flg_atendimento_transformed);

        $action_RegistrarAtendimento = new TDataGridAction(array('GerirAgendamento', 'RegistrarAtendimento'));
        $action_RegistrarAtendimento->setUseButton(false);
        $action_RegistrarAtendimento->setButtonClass('btn btn-default btn-sm');
        $action_RegistrarAtendimento->setLabel("Confirmar Atendimento");
        $action_RegistrarAtendimento->setImage('fas:award #4CAF50');
        $action_RegistrarAtendimento->setField(self::$primaryKey);
        $action_RegistrarAtendimento->setDisplayCondition('GerirAgendamento::exibirRegistrarAtendimento');
        $action_RegistrarAtendimento->setParameter('agendamentoID', '{id}');
        $this->datagrid->addAction($action_RegistrarAtendimento);

        $action_RegistrarAusenciaPaciente = new TDataGridAction(array('GerirAgendamento', 'RegistrarAusenciaPaciente'));
        $action_RegistrarAusenciaPaciente->setUseButton(false);
        $action_RegistrarAusenciaPaciente->setButtonClass('btn btn-default btn-sm');
        $action_RegistrarAusenciaPaciente->setLabel("Registrar Ausência do Paciente");
        $action_RegistrarAusenciaPaciente->setImage('far:angry #FF9800');
        $action_RegistrarAusenciaPaciente->setField(self::$primaryKey);
        $action_RegistrarAusenciaPaciente->setDisplayCondition('GerirAgendamento::exibirAusenciaUsuario');
        $action_RegistrarAusenciaPaciente->setParameter('agendamentoID', '{id}');
        $this->datagrid->addAction($action_RegistrarAusenciaPaciente);

        $action_RegistrarFaltaProfissional = new TDataGridAction(array('GerirAgendamento', 'RegistrarFaltaProfissional'));
        $action_RegistrarFaltaProfissional->setUseButton(false);
        $action_RegistrarFaltaProfissional->setButtonClass('btn btn-default btn-sm');
        $action_RegistrarFaltaProfissional->setLabel("Registrar Ausência do Médico");
        $action_RegistrarFaltaProfissional->setImage('fas:book-reader #9C27B0');
        $action_RegistrarFaltaProfissional->setField(self::$primaryKey);
        $action_RegistrarFaltaProfissional->setDisplayCondition('GerirAgendamento::exibirAusenciaProfissional');
        $action_RegistrarFaltaProfissional->setParameter('agendamentoID', '{id}');
        $this->datagrid->addAction($action_RegistrarFaltaProfissional);

        $action_onShow = new TDataGridAction(array('HistoricoAgendamentoTimeLine', 'onShow'));
        $action_onShow->setUseButton(false);
        $action_onShow->setButtonClass('btn btn-default btn-sm');
        $action_onShow->setLabel("Exibir Histórico");
        $action_onShow->setImage('fas:clipboard-list #607D8B');
        $action_onShow->setField(self::$primaryKey);

        $action_onShow->setParameter('id_agendamento', '{id}');
        $this->datagrid->addAction($action_onShow);

        $action_onDelete = new TDataGridAction(array('GerirAgendamento', 'onDelete'));
        $action_onDelete->setUseButton(false);
        $action_onDelete->setButtonClass('btn btn-default btn-sm');
        $action_onDelete->setLabel("Cancelar Agendamento");
        $action_onDelete->setImage('far:trash-alt #F44336');
        $action_onDelete->setField(self::$primaryKey);
        $action_onDelete->setDisplayCondition('GerirAgendamento::exibirExcluir');

        $this->datagrid->addAction($action_onDelete);

        // create the datagrid model
        $this->datagrid->createModel();

        $tr = new TElement('tr');
        $this->datagrid->prependRow($tr);

        $tr->add(TElement::tag('td', ''));
        $tr->add(TElement::tag('td', ''));
        $tr->add(TElement::tag('td', ''));
        $tr->add(TElement::tag('td', ''));
        $tr->add(TElement::tag('td', ''));
        $td_data_agendamento = TElement::tag('td', $data_agendamento);
        $tr->add($td_data_agendamento);
        $td_paciente_nome_paciente = TElement::tag('td', $paciente_nome_paciente);
        $tr->add($td_paciente_nome_paciente);
        $td_escala_profissional_nome_profissional = TElement::tag('td', $escala_profissional_nome_profissional);
        $tr->add($td_escala_profissional_nome_profissional);
        $td_flg_tipo_agendamento = TElement::tag('td', $flg_tipo_agendamento);
        $tr->add($td_flg_tipo_agendamento);
        $td_id_escala = TElement::tag('td', $id_escala);
        $tr->add($td_id_escala);
        $td_flg_atendimento = TElement::tag('td', $flg_atendimento);
        $tr->add($td_flg_atendimento);

        $this->datagrid_form->addField($data_agendamento);
        $this->datagrid_form->addField($paciente_nome_paciente);
        $this->datagrid_form->addField($escala_profissional_nome_profissional);
        $this->datagrid_form->addField($flg_tipo_agendamento);
        $this->datagrid_form->addField($id_escala);
        $this->datagrid_form->addField($flg_atendimento);

        $this->datagrid_form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->enableCounters();
        $this->pageNavigation->setAction(new TAction(array($this, 'onReload')));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());

        $this->datagrid->disableDefaultClick(); 

        $panel = new TPanelGroup("Gestão de Agendamentos");
        $panel->datagrid = 'datagrid-container';
        $this->datagridPanel = $panel;
        $panel->getBody()->class .= ' table-responsive';

        $panel->addFooter($this->pageNavigation);

        $headerActions = new TElement('div');
        $headerActions->class = ' datagrid-header-actions ';

        $head_left_actions = new TElement('div');
        $head_left_actions->class = ' datagrid-header-actions-left-actions ';

        $head_right_actions = new TElement('div');
        $head_right_actions->class = ' datagrid-header-actions-left-actions ';

        $headerActions->add($head_left_actions);
        $headerActions->add($head_right_actions);

        $this->datagrid_form->add($this->datagrid);
        $panel->add($headerActions);
        $panel->add($this->datagrid_form);

        $dropdown_button_exportar = new TDropDown("Exportar", 'fas:file-export #2d3436');
        $dropdown_button_exportar->setPullSide('right');
        $dropdown_button_exportar->setButtonClass('btn btn-default waves-effect dropdown-toggle');
        $dropdown_button_exportar->addPostAction( "CSV", new TAction(['GerirAgendamento', 'onExportCsv'],['static' => 1]), self::$formName, 'fas:table #00b894' );
        $dropdown_button_exportar->addPostAction( "PDF", new TAction(['GerirAgendamento', 'onExportPdf'],['static' => 1]), self::$formName, 'far:file-pdf #e74c3c' );
        $dropdown_button_exportar->addPostAction( "XML", new TAction(['GerirAgendamento', 'onExportXml'],['static' => 1]), self::$formName, 'far:file-code #95a5a6' );

        $head_right_actions->add($dropdown_button_exportar);

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Agendamento","Gerir Agendamento"]));
        }
        $container->add($panel);

        parent::add($container);

    }

    public function RegistrarAtendimento($param = null) 
    {

      if(isset($param['registrarAtendimento']) && $param['registrarAtendimento'] == 1){

        try 
        {
            //code here
            TTransaction::open('reabilitar');

            $objeto = new HistoricoAgendamento();
            $objeto->id_status = '2';
            $objeto->id_agendamento = $param['agendamentoID'];
            $objeto->justificativa = 'Usuário foi atendido.';
            $objeto->data_hora = date('Y-m-d H:i:s');
            $objeto->id_usuario = TSession::getValue('userid');
            $objeto->store();

            $objs = HistoricoAgendamento::where('id_status',  '=', 2)
                                        ->where('id_agendamento', '=', $param['agendamentoID'])
                                        ->orderBy('id')
                                        ->first();
            if (!$objs){
               $objeto->store();
            }

            $objAgendamento = Agendamento::find($param['agendamentoID']);
            if ($objAgendamento){

            $objAgendamento->flg_atendimento = 'S';
            $objAgendamento->store();

            }

            TTransaction::close();

            $this->onReload( $param );
            //</autoCode>
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
      } else {
          $action = new TAction(array($this, 'RegistrarAtendimento'));
          $action->setParameters($param); // pass the key paramseter ahead
          $action->setParameter('registrarAtendimento', 1);

          new TQuestion('Tem certeza que quer confirmar o atendimento do usuário?', $action); 
      }
    }
    public static function exibirRegistrarAtendimento($object)
    {
        try 
        {
            if (($object->flg_atendimento == 'A') || ($object->flg_atendimento == 'R'))
            {
                return true;
            }

            return false;
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
    }
    public function RegistrarAusenciaPaciente($param = null) 
    {

      if(isset($param['faltaUsuario']) && $param['faltaUsuario'] == 1){

        try 
        {
            //code here

            // Código gerado pelo snippet: "Conexão com banco de dados"
            //var_dump($param);

            TTransaction::open('reabilitar');

            $objeto = new HistoricoAgendamento();
            $objeto->id_status = '3';
            $objeto->id_agendamento = $param['agendamentoID'];
            $objeto->justificativa = 'Usuário faltou a consulta.';
            $objeto->data_hora = date('Y-m-d H:i:s');
            $objeto->id_usuario = TSession::getValue('userid');

            $objs = HistoricoAgendamento::where('id_status',  '=', 3)
                                        ->where('id_agendamento', '=', $param['agendamentoID'])
                                        ->orderBy('id')
                                        ->first();
            if (!$objs){
               $objeto->store();
            }

            $objAgendamento = Agendamento::find($param['agendamentoID']);
            if ($objAgendamento){

            $objAgendamento->flg_atendimento = 'U';
            $objAgendamento->store();

            }

            TTransaction::close();

            $this->onReload( $param );

            //</autoCode>
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
      }else{
            // define the delete action
            $action = new TAction(array($this, 'RegistrarAusenciaPaciente'));
            $action->setParameters($param); // pass the key paramseter ahead
            $action->setParameter('faltaUsuario', 1);
            // shows a dialog to the user
            new TQuestion('Tem certeza que quer registrar ausência do usuário?', $action);   
        }    

    }
    public static function exibirAusenciaUsuario($object)
    {
        try 
        {
            if (($object->flg_atendimento == 'A') || ($object->flg_atendimento == 'R'))
            {
                return true;
            }

            return false;
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
    }
    public function RegistrarFaltaProfissional($param = null) 
    {

       if(isset($param['faltaProfissional']) && $param['faltaProfissional'] == 1){
        try 
        {
            //code here
            TTransaction::open('reabilitar');

            $objeto = new HistoricoAgendamento();
            $objeto->id_status = '4';
            $objeto->id_agendamento = $param['agendamentoID'];
            $objeto->justificativa = 'Profissional faltou ao serviço.';
            $objeto->data_hora = date('Y-m-d H:i:s');
            $objeto->id_usuario = TSession::getValue('userid');
            $objeto->store();

            $objs = HistoricoAgendamento::where('id_status',  '=', 4)
                                        ->where('id_agendamento', '=', $param['agendamentoID'])
                                        ->orderBy('id')
                                        ->first();
            if (!$objs){
               $objeto->store();
            }

            $objAgendamento = Agendamento::find($param['agendamentoID']);
            if ($objAgendamento){

            $objAgendamento->flg_atendimento = 'P';
            $objAgendamento->store();

            }

            TTransaction::close();

            $this->onReload( $param );
            //</autoCode>
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
      }else{
            // define the delete action
            $action = new TAction(array($this, 'RegistrarFaltaProfissional'));
            $action->setParameters($param); // pass the key paramseter ahead
            $action->setParameter('faltaProfissional', 1);
            // shows a dialog to the user
            new TQuestion('Tem certeza que quer registrar ausência do profissional ?', $action);   
        }

    }
    public static function exibirAusenciaProfissional($object)
    {
        try 
        {
            if (($object->flg_atendimento == 'A') || ($object->flg_atendimento == 'R'))
            {
                return true;
            }

            return false;
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
    }
    public function onDelete($param = null) 
    { 
        if(isset($param['delete']) && $param['delete'] == 1)
        {
            try
            {
                // get the paramseter $key
                $key = $param['key'];
                // open a transaction with database
                TTransaction::open(self::$database);

                // instantiates object
                $object = new Agendamento($key, FALSE); 

                $object->deleteComposite('HistoricoAgendamento', 'id_agendamento', $object->id);

                // deletes the object from the database
                $object->delete();

                $this->onReload( $param );                

                // close the transaction
                TTransaction::close();

                // reload the listing
                $this->onReload( $param );
                // shows the success message
                TToast::show('success', AdiantiCoreTranslator::translate('Record deleted'), 'topRight', 'far:check-circle');
            }
            catch (Exception $e) // in case of exception
            {
                // shows the exception error message
                new TMessage('error', $e->getMessage());
                // undo all pending operations
                TTransaction::rollback();
            }
        }
        else
        {
            // define the delete action
            $action = new TAction(array($this, 'onDelete'));
            $action->setParameters($param); // pass the key paramseter ahead
            $action->setParameter('delete', 1);
            // shows a dialog to the user
            new TQuestion(AdiantiCoreTranslator::translate('Do you really want to delete ?'), $action);   
        }
    }
    public static function exibirExcluir($object)
    {
        try 
        {
            $grupo = TSession::getValue('usergroupids');

            if(in_array(1, $grupo))
            {
                return true;
            }

            return false;
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
    }
    public function onExportCsv($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.csv';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $objects = $this->onReload();

                if ($objects)
                {
                    $handler = fopen($output, 'w');
                    TTransaction::open(self::$database);

                    foreach ($objects as $object)
                    {
                        $row = [];
                        foreach ($this->datagrid->getColumns() as $column)
                        {
                            $column_name = $column->getName();

                            if (isset($object->$column_name))
                            {
                                $row[] = is_scalar($object->$column_name) ? $object->$column_name : '';
                            }
                            else if (method_exists($object, 'render'))
                            {
                                $column_name = (strpos($column_name, '{') === FALSE) ? ( '{' . $column_name . '}') : $column_name;
                                $row[] = $object->render($column_name);
                            }
                        }

                        fputcsv($handler, $row);
                    }

                    fclose($handler);
                    TTransaction::close();
                }
                else
                {
                    throw new Exception(_t('No records found'));
                }

                TPage::openFile($output);
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public function onExportPdf($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.pdf';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $this->datagrid->prepareForPrinting();
                $this->onReload();

                $html = clone $this->datagrid;
                $contents = file_get_contents('app/resources/styles-print.html') . $html->getContents();

                $dompdf = new \Dompdf\Dompdf;
                $dompdf->loadHtml($contents);
                $dompdf->setPaper('A4', 'portrait');
                $dompdf->render();

                file_put_contents($output, $dompdf->output());

                $window = TWindow::create('PDF', 0.8, 0.8);
                $object = new TElement('object');
                $object->data  = $output;
                $object->type  = 'application/pdf';
                $object->style = "width: 100%; height:calc(100% - 10px)";

                $window->add($object);
                $window->show();
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public function onExportXml($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.xml';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $objects = $this->onReload();

                if ($objects)
                {
                    TTransaction::open(self::$database);

                    $dom = new DOMDocument('1.0', 'UTF-8');
                    $dom->{'formatOutput'} = true;
                    $dataset = $dom->appendChild( $dom->createElement('dataset') );

                    foreach ($objects as $object)
                    {
                        $row = $dataset->appendChild( $dom->createElement( self::$activeRecord ) );

                        foreach ($this->datagrid->getColumns() as $column)
                        {
                            $column_name = $column->getName();
                            $column_name_raw = str_replace(['(','{','->', '-','>','}',')', ' '], ['','','_','','','','','_'], $column_name);

                            if (isset($object->$column_name))
                            {
                                $value = is_scalar($object->$column_name) ? $object->$column_name : '';
                                $row->appendChild($dom->createElement($column_name_raw, $value)); 
                            }
                            else if (method_exists($object, 'render'))
                            {
                                $column_name = (strpos($column_name, '{') === FALSE) ? ( '{' . $column_name . '}') : $column_name;
                                $value = $object->render($column_name);
                                $row->appendChild($dom->createElement($column_name_raw, $value));
                            }
                        }
                    }

                    $dom->save($output);

                    TTransaction::close();
                }
                else
                {
                    throw new Exception(_t('No records found'));
                }

                TPage::openFile($output);
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Register the filter in the session
     */
    public function onSearch($param = null)
    {
        // get the search form data
        $data = $this->datagrid_form->getData();
        $filters = [];

        TSession::setValue(__CLASS__.'_filter_data', NULL);
        TSession::setValue(__CLASS__.'_filters', NULL);

        if (isset($data->data_agendamento) AND ( (is_scalar($data->data_agendamento) AND $data->data_agendamento !== '') OR (is_array($data->data_agendamento) AND (!empty($data->data_agendamento)) )) )
        {

            $filters[] = new TFilter('data_agendamento', '=', $data->data_agendamento);// create the filter 
        }

        if (isset($data->escala_profissional_nome_profissional) AND ( (is_scalar($data->escala_profissional_nome_profissional) AND $data->escala_profissional_nome_profissional !== '') OR (is_array($data->escala_profissional_nome_profissional) AND (!empty($data->escala_profissional_nome_profissional)) )) )
        {

            $filters[] = new TFilter('id_profissional', '=', $data->escala_profissional_nome_profissional);// create the filter 
        }

        if (isset($data->flg_tipo_agendamento) AND ( (is_scalar($data->flg_tipo_agendamento) AND $data->flg_tipo_agendamento !== '') OR (is_array($data->flg_tipo_agendamento) AND (!empty($data->flg_tipo_agendamento)) )) )
        {

            $filters[] = new TFilter('flg_tipo_agendamento', 'like', "%{$data->flg_tipo_agendamento}%");// create the filter 
        }

        if (isset($data->id_escala) AND ( (is_scalar($data->id_escala) AND $data->id_escala !== '') OR (is_array($data->id_escala) AND (!empty($data->id_escala)) )) )
        {

            $filters[] = new TFilter('flg_tipo_agendamento', '=', $data->id_escala);// create the filter 
        }

        if (isset($data->flg_atendimento) AND ( (is_scalar($data->flg_atendimento) AND $data->flg_atendimento !== '') OR (is_array($data->flg_atendimento) AND (!empty($data->flg_atendimento)) )) )
        {

            $filters[] = new TFilter('flg_atendimento', 'like', "%{$data->flg_atendimento}%");// create the filter 
        }

        // fill the form with data again
        $this->datagrid_form->setData($data);

        // keep the search data in the session
        TSession::setValue(__CLASS__.'_filter_data', $data);
        TSession::setValue(__CLASS__.'_filters', $filters);

        if (isset($param['static']) && ($param['static'] == '1') )
        {
            $class = get_class($this);
            $onReloadParam = ['offset' => 0, 'first_page' => 1];
            AdiantiCoreApplication::loadPage($class, 'onReload', $onReloadParam);
        }
        else
        {
            $this->onReload(['offset' => 0, 'first_page' => 1]);
        }
    }

    /**
     * Load the datagrid with data
     */
    public function onReload($param = NULL)
    {
        try
        {
            // open a transaction with database 'reabilitar'
            TTransaction::open(self::$database);

            // creates a repository for Agendamento
            $repository = new TRepository(self::$activeRecord);

            $criteria = clone $this->filter_criteria;

            if (empty($param['order']))
            {
                $param['order'] = 'id';    
            }
            if (empty($param['direction']))
            {
                $param['direction'] = 'desc';
            }

            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $this->limit);

            if($filters = TSession::getValue(__CLASS__.'_filters'))
            {
                foreach ($filters as $filter) 
                {
                    $criteria->add($filter);       
                }
            }

            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);

            $this->datagrid->clear();
            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {

                    $row = $this->datagrid->addItem($object);
                    $row->id = "row_{$object->id}";

                }
            }

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            $this->pageNavigation->setCount($count); // count of records
            $this->pageNavigation->setProperties($param); // order, page
            $this->pageNavigation->setLimit($this->limit); // limit

            // close the transaction
            TTransaction::close();
            $this->loaded = true;

            return $objects;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    public function onShow($param = null)
    {

    }

    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        // check if the datagrid is already loaded
        if (!$this->loaded AND (!isset($_GET['method']) OR !(in_array($_GET['method'],  $this->showMethods))) )
        {
            if (func_num_args() > 0)
            {
                $this->onReload( func_get_arg(0) );
            }
            else
            {
                $this->onReload();
            }
        }
        parent::show();
    }

}

