<?php

class HistoricoAgendamentoForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'HistoricoAgendamento';
    private static $primaryKey = 'id';
    private static $formName = 'form_HistoricoAgendamentoForm';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Registrar Histórico");


        $id = new TEntry('id');
        $id_agendamento = new TDBCombo('id_agendamento', 'reabilitar', 'Agendamento', 'id', '{id}','id asc'  );
        $id_status = new TDBCombo('id_status', 'reabilitar', 'EventoAgendamento', 'id', '{id}','id asc'  );
        $justificativa = new TText('justificativa');
        $data_hora = new TDateTime('data_hora');

        $id_agendamento->addValidation("Agendamento  ", new TRequiredValidator()); 
        $id_status->addValidation("Evento  ", new TRequiredValidator()); 
        $justificativa->addValidation("Justificativa  ", new TRequiredValidator()); 
        $data_hora->addValidation("Data Evento ", new TRequiredValidator()); 

        $data_hora->setMask('dd/mm/yyyy hh:ii');
        $data_hora->setDatabaseMask('yyyy-mm-dd hh:ii');

        $id->setEditable(false);
        $id_status->setEditable(false);
        $data_hora->setEditable(false);
        $id_agendamento->setEditable(false);

        $id->setSize(100);
        $data_hora->setSize(210);
        $id_status->setSize('100%');
        $id_agendamento->setSize('100%');
        $justificativa->setSize('99%', 190);

        $row1 = $this->form->addFields([new TLabel("Id:", null, '14px', null)],[$id]);
        $row2 = $this->form->addFields([new TLabel("Agendamento  :", '#ff0000', '14px', null)],[$id_agendamento]);
        $row3 = $this->form->addFields([new TLabel("Evento  :", '#ff0000', '14px', null)],[$id_status]);
        $row4 = $this->form->addFields([new TLabel("Justificativa  :", '#ff0000', '14px', null)],[$justificativa]);
        $row5 = $this->form->addFields([new TLabel("Data Evento :", '#ff0000', '14px', null)],[$data_hora]);

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave']), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-primary'); 

        $btn_onclear = $this->form->addAction("Limpar formulário", new TAction([$this, 'onClear']), 'fas:eraser #dd5a43');
        $this->btn_onclear = $btn_onclear;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Agendamento","Registrar Histórico"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $object = new HistoricoAgendamento(); // create an empty object 

            $data = $this->form->getData(); // get form data as array
            $object->fromArray( (array) $data); // load the object with data

            $object->store(); // save the object 

            // get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction

            new TMessage('info', "Registro salvo", $messageAction); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode> 

            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new HistoricoAgendamento($key); // instantiates the Active Record 

                $this->form->setData($object); // fill the form 

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

    }

    public function onShow($param = null)
    {

    } 

}

