<?php

class HistoricoAgendamentoTimeLine extends TPage
{
    private static $database = 'reabilitar';
    private static $activeRecord = 'HistoricoAgendamento';
    private static $primaryKey = 'id';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param = null )
    {
        try
        {
            parent::__construct();

            TTransaction::open(self::$database);

            if(!empty($param['target_container']))
            {
                $this->adianti_target_container = $param['target_container'];
            }

            $this->timeline = new TTimeline;
            $this->timeline->setItemDatabase(self::$database);
            $this->timelineCriteria = new TCriteria;

            if(!empty($param['id_agendamento']))
            {
                TSession::setValue(__CLASS__.'load_filter_id_agendamento', $param['id_agendamento']);
            }
            $filterVar = TSession::getValue(__CLASS__.'load_filter_id_agendamento');
            $this->timelineCriteria->add(new TFilter('id_agendamento', '=', $filterVar));

            $limit = 0;

            $this->timelineCriteria->setProperty('limit', $limit);
            $this->timelineCriteria->setProperty('order', 'id');

            $objects = HistoricoAgendamento::getObjects($this->timelineCriteria);

            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {

                    $id = $object->id;
                    $title = "Status: {status->descricao} ";
                    $htmlTemplate = "Justificativa:  {justificativa} <br />
Data:  {data_hora} <br />
Usuário:  {usuario->name} ";
                    $date = $object->data_hora;
                    $icon = 'fa:arrow-left bg-green';
                    $position = 'left';

                    if(empty($positionValue[$object->id_status]))
                    {
                        $lastPosition = (empty($lastPosition) || $lastPosition == 'right') ? 'left' : 'right';
                        $bg = ($lastPosition == 'left') ? 'bg-green' : 'bg-blue';

                        $positionValue[$object->id_status]['position'] = $lastPosition;
                        $positionValue[$object->id_status]['bg'] = $bg;
                        $position = $positionValue[$object->id_status]['position'];
                        $icon = "fa:arrow-{$lastPosition} {$bg}";
                    }
                    else
                    {
                        $position = $positionValue[$object->id_status]['position'];
                        $lastPosition = $position;
                        $icon = "fa:arrow-{$lastPosition} {$positionValue[$object->id_status]['bg']}";
                    }

                    $this->timeline->addItem($id, $title, $htmlTemplate, $date, $icon, $position, $object);

                }
            }

            $this->timeline->setUseBothSides();
            $this->timeline->setTimeDisplayMask('dd/mm/yyyy');
            $this->timeline->setFinalIcon( 'fas:flag-checkered #ffffff #de1414' );

            $container = new TVBox;

            $container->style = 'width: 100%';
            $container->class = 'form-container';

            parent::setTargetContainer('adianti_right_panel');
            $container->style .= '; padding: 0 15px';
            $div = new TElement('div');
            $div->style = 'margin-top: 20px; margin-right: 20px; float: right';

            $btnClose = new TButton('closeCurtain');
            $btnClose->class = 'btn btn-sm btn-default';

            $btnClose->onClick = "Template.closeRightPanel();";
            $btnClose->setLabel("Fechar");
            $btnClose->setImage('fas:times');

            $div->add($btnClose);
            $container->add($div);
            $container->add($this->timeline);

            $style = new TStyle('right-panel');
            $style->width = '40% !important';   
            $style->show(true);

            TTransaction::close();

            parent::add($container);
        }
        catch(Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    public function onShow($param = null)
    {

    } 

}

