<?php

class ListaUsuarioAgendadoSimpleList extends TPage
{

    private $datagrid; // listing
    private $pageNavigation;
    private $loaded;
    private static $database = 'reabilitar';
    private static $activeRecord = 'Agendamento';
    private static $primaryKey = 'id';
    private static $formName = 'formList_Agendamento';
    private $limit = 20;

    private $relacaoAgendamentos;

    public function __construct($param = null)
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        $this->limit = 0;

        // creates a Datagrid
        $this->datagrid = new TDataGrid;
        $this->datagrid->disableHtmlConversion();

        $this->datagrid = new BootstrapDatagridWrapper($this->datagrid);

        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        $column_data_agendamento = new TDataGridColumn('data_agendamento', "Data Agendamento", 'center' , '20%');
        $column_paciente_nome_paciente = new TDataGridColumn('paciente->nome_paciente', "Usuário", 'left' , '35%');
        $column_profissional_nome_profissional = new TDataGridColumn('profissional->nome_profissional', "Profissional", 'left' , '30%');
        $column_procedimento_descricao_procedimento = new TDataGridColumn('procedimento->descricao_procedimento', "Procedimento", 'left');


        $this->datagrid->addColumn($column_data_agendamento);
        $this->datagrid->addColumn($column_paciente_nome_paciente);
        $this->datagrid->addColumn($column_profissional_nome_profissional);
        $this->datagrid->addColumn($column_procedimento_descricao_procedimento);

        // create the datagrid model
        $this->datagrid->createModel();

        $panel = new TPanelGroup;
        $panel->datagrid = 'datagrid-container';
        $this->datagridPanel = $panel;
        $panel->add($this->datagrid);
        $panel->getBody()->class .= ' table-responsive';

        $this->datagrid_form = new TForm('datagrid_'.self::$formName);

        $head = $panel->getHeader();
        $head->clearChildren();
        $head->style = 'background-color:#fff; justify-content: space-between;';
        $head->class .= ' datagrid-header-actions ';

        $head_left_actions = new TElement('div');
        $head_left_actions->class = ' datagrid-header-actions-left-actions ';

        $head_right_actions = new TElement('div');
        $head_right_actions->class = ' datagrid-header-actions-left-actions ';

        $head->add($head_left_actions);
        $head->add($head_right_actions);

        $button_transferir_agenda = new TButton('button_button_transferir_agenda');
        $button_transferir_agenda->setAction(new TAction(['ListaUsuarioAgendadoSimpleList', 'transferirAgenda']), "Transferir Agenda");
        $button_transferir_agenda->addStyleClass('');
        $button_transferir_agenda->setImage('fas:edit #000000');
        $this->datagrid_form->addField($button_transferir_agenda);

        $dropdown_button_exportar = new TDropDown("Exportar", 'fas:file-export #2d3436');
        $dropdown_button_exportar->setPullSide('right');
        $dropdown_button_exportar->setButtonClass('btn btn-default waves-effect dropdown-toggle');
        $dropdown_button_exportar->addPostAction( "CSV", new TAction(['ListaUsuarioAgendadoSimpleList', 'onExportCsv']), 'datagrid_'.self::$formName, 'fas:table #00b894' );
        $dropdown_button_exportar->addPostAction( "PDF", new TAction(['ListaUsuarioAgendadoSimpleList', 'onExportPdf']), 'datagrid_'.self::$formName, 'far:file-pdf #e74c3c' );
        $dropdown_button_exportar->addPostAction( "XML", new TAction(['ListaUsuarioAgendadoSimpleList', 'onExportXml']), 'datagrid_'.self::$formName, 'far:file-code #95a5a6' );

        $head_left_actions->add($button_transferir_agenda);

        $head_right_actions->add($dropdown_button_exportar);

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Agendamento","Lista de Usuários Agendado"]));
        }
        $container->add($this->form);

        $this->datagrid_form->add($panel);

        $container->add($this->datagrid_form);

        parent::add($container);

    }

    public function onExportCsv($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.csv';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $objects = $this->onReload();

                if ($objects)
                {
                    $handler = fopen($output, 'w');
                    TTransaction::open(self::$database);

                    foreach ($objects as $object)
                    {
                        $row = [];
                        foreach ($this->datagrid->getColumns() as $column)
                        {
                            $column_name = $column->getName();

                            if (isset($object->$column_name))
                            {
                                $row[] = is_scalar($object->$column_name) ? $object->$column_name : '';
                            }
                            else if (method_exists($object, 'render'))
                            {
                                $column_name = (strpos($column_name, '{') === FALSE) ? ( '{' . $column_name . '}') : $column_name;
                                $row[] = $object->render($column_name);
                            }
                        }

                        fputcsv($handler, $row);
                    }

                    fclose($handler);
                    TTransaction::close();
                }
                else
                {
                    throw new Exception(_t('No records found'));
                }

                TPage::openFile($output);
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public function onExportPdf($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.pdf';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $this->datagrid->prepareForPrinting();
                $this->onReload();

                $html = clone $this->datagrid;
                $contents = file_get_contents('app/resources/styles-print.html') . $html->getContents();

                $dompdf = new \Dompdf\Dompdf;
                $dompdf->loadHtml($contents);
                $dompdf->setPaper('A4', 'portrait');
                $dompdf->render();

                file_put_contents($output, $dompdf->output());

                $window = TWindow::create('PDF', 0.8, 0.8);
                $object = new TElement('object');
                $object->data  = $output;
                $object->type  = 'application/pdf';
                $object->style = "width: 100%; height:calc(100% - 10px)";

                $window->add($object);
                $window->show();
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public function onExportXml($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.xml';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $objects = $this->onReload();

                if ($objects)
                {
                    TTransaction::open(self::$database);

                    $dom = new DOMDocument('1.0', 'UTF-8');
                    $dom->{'formatOutput'} = true;
                    $dataset = $dom->appendChild( $dom->createElement('dataset') );

                    foreach ($objects as $object)
                    {
                        $row = $dataset->appendChild( $dom->createElement( self::$activeRecord ) );

                        foreach ($this->datagrid->getColumns() as $column)
                        {
                            $column_name = $column->getName();
                            $column_name_raw = str_replace(['(','{','->', '-','>','}',')', ' '], ['','','_','','','','','_'], $column_name);

                            if (isset($object->$column_name))
                            {
                                $value = is_scalar($object->$column_name) ? $object->$column_name : '';
                                $row->appendChild($dom->createElement($column_name_raw, $value)); 
                            }
                            else if (method_exists($object, 'render'))
                            {
                                $column_name = (strpos($column_name, '{') === FALSE) ? ( '{' . $column_name . '}') : $column_name;
                                $value = $object->render($column_name);
                                $row->appendChild($dom->createElement($column_name_raw, $value));
                            }
                        }
                    }

                    $dom->save($output);

                    TTransaction::close();
                }
                else
                {
                    throw new Exception(_t('No records found'));
                }

                TPage::openFile($output);
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }
    public function transferirAgenda($param = null) 
    {

        if(isset($param['registrarTransferencia']) && $param['registrarTransferencia'] == 1){

        try 
        {
            TTransaction::open('reabilitar');

            $nova_data = new DateTime(date('Y-m-d', strtotime('+' .(Parametros::find(1)->num_dias_transferencia_agenda) .'days', strtotime(TSession::getValue('data_agendamento')))));

            TTransaction::close();

            $data = $this->verificarDia($this->verificarAfastamento($this->verificarFeriado($nova_data)));

            TTransaction::open('reabilitar');

            $ObjAgendamentos = Agendamento::where('id_profissional', '=', TSession::getValue('id_profissional'))
                                          ->where('id_unidade_saude', '=', TSession::getValue('id_unidade'))
                                          ->where('data_agendamento', '=', TSession::getValue('data_agendamento'))
                                          ->load();

            if (isset($ObjAgendamentos)){

               foreach ($ObjAgendamentos as $objAgendamento){

                 $objeto = new Agendamento( $objAgendamento->id );

                 if($objeto){
                     $objeto->data_agendamento = $data->format('Y-m-d');
                     $objeto->flg_atendimento = 'R';
                     $objeto->store();    
                 }

                 $objHistoricoAgendamento = new HistoricoAgendamento();
                 $objHistoricoAgendamento->id_status = '5';
                 $objHistoricoAgendamento->id_agendamento = $objAgendamento->id;
                 $objHistoricoAgendamento->justificativa = 'Reagendamento automático pelo sistema.';
                 $objHistoricoAgendamento->data_hora = date('Y-m-d H:i:s');
                 $objHistoricoAgendamento->id_usuario = TSession::getValue('userid');
                 $objHistoricoAgendamento->store();

               }
            }

            TTransaction::close();

            TApplication::loadPage('MigrarAgendamentos', 'onShow', null);

            //</autoCode>
        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
      } else {
          $action = new TAction(array($this, 'transferirAgenda'));
          $action->setParameters($param); // pass the key paramseter ahead
          $action->setParameter('registrarTransferencia', 1);

          new TQuestion('Tem certeza que deseja transferir agendamento dos pacientes?', $action); 
      }
    }

    /**
     * Load the datagrid with data
     */
    public function onReload($param = NULL)
    {
        try
        {
            // open a transaction with database 'reabilitar'
            TTransaction::open(self::$database);

            // creates a repository for Agendamento
            $repository = new TRepository(self::$activeRecord);
            // creates a criteria
            $criteria = new TCriteria;

            if (empty($param['order']))
            {
                $param['order'] = 'id';    
            }
            if (empty($param['direction']))
            {
                $param['direction'] = 'desc';
            }

            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $this->limit);

            if($filters = TSession::getValue(__CLASS__.'_filters'))
            {
                foreach ($filters as $filter) 
                {
                    $criteria->add($filter);       
                }
            }

            $filterVar = TSession::getValue('data_agendamento');
            $criteria->add(new TFilter('data_agendamento', '=', $filterVar));

            $filterVar =  TSession::getValue('id_profissional');
            $criteria->add(new TFilter('id_profissional', '=', $filterVar));

            $filterVar = TSession::getValue('id_unidade');
            $criteria->add(new TFilter('id_unidade_saude', '=', $filterVar));

            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);

            $this->datagrid->clear();
            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {

                    $row = $this->datagrid->addItem($object);
                    $row->id = "row_{$object->id}";

                }
            }

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            // close the transaction
            TTransaction::close();
            $this->loaded = true;

            return $objects;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    public function onShow($param = null)
    {

    }

    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        // check if the datagrid is already loaded
        if (!$this->loaded AND (!isset($_GET['method']) OR !(in_array($_GET['method'],  array('onReload', 'onSearch')))) )
        {
            if (func_num_args() > 0)
            {
                $this->onReload( func_get_arg(0) );
            }
            else
            {
                $this->onReload();
            }
        }
        parent::show();
    }

   //verificar se a data da transferência é feriado.
   private function verificarFeriado ($nova_data){

     try{

        $data_verificar = $nova_data;

        $i = true;

        do {

        TTransaction::open('reabilitar');

        $qtdFeriado = Feriados::where('data_feriado', '=', $data_verificar->format('Y-m-d')) //substr($data_verificar->format('Y-m-d'), 8,2))
                             // ->where('mes', '=', substr($data_verificar->format('Y-m-d'), 5,2))
                              ->count();

        if ($qtdFeriado > 0) {
            $data_verificar = new DateTime(date('Y-m-d', strtotime('+1 days', strtotime($data_verificar->format('Y-m-d')))));

        } else {
            $i = false;
        }

        TTransaction::close();
        // -----

        } while ($i == true);

       return $data_verificar;

     }catch (Exception $e){
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
     }

   }

   //verificar se a data da transferência é afeta por algum afastamento do profissional
   private function verificarAfastamento ($nova_data){

     try{

        $data_verificar = $nova_data;

        $i = true;

        do {

        TTransaction::open('reabilitar');

        $qtdAfastamento = AfastamentoProfissional::where('id_profissional','=',TSession::getValue('id_profissional'))
                                                 ->where('data_inicio', '<=' , $data_verificar->format('Y-m-d'))
                                                 ->where('data_fim', '>=', $data_verificar->format('Y-m-d'))
                                                 ->count();
        if ($qtdAfastamento > 0) {
            $data_verificar = new DateTime(date('Y-m-d', strtotime('+1 days', strtotime($data_verificar->format('Y-m-d')))));
        } else {
            $i = false;
        }

        TTransaction::close();
        // -----

        } while ($i == true);

       return $this->verificarFeriado($data_verificar);

     }catch (Exception $e){
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
     }

   }

   private function verificarDia($nova_data){

     try{
            $dt = $nova_data;

            TTransaction::open('reabilitar');

            $objAgendamento = Agendamento::where('id_profissional', '=', TSession::getValue('id_profissional'))
                                         ->where('id_unidade_saude', '=',TSession::getValue('id_unidade'))
                                         ->where('data_agendamento','=', date(TSession::getValue('data_agendamento')))
                                         ->first();

            $objEscalaDia = EscalaDia::where('id_escala','=', $objAgendamento->id_escala)->load();

            $lista_dias = array();

            if (isset($objEscalaDia)) {
               foreach ($objEscalaDia as $escaladia){
                   array_push($lista_dias, $escaladia->dia_semana);
             } }

            $novo_dia = date('w', strtotime($dt->format('Y-m-d')));

            $i = false;
            while ($i==false) {
                if (in_array($novo_dia, $lista_dias)) {
                  break;
                  $i = true;
                } else {
                   if ($novo_dia <=7){
                       $novo_dia++;
                       $dt = new DateTime(date('Y-m-d', strtotime('+1 days', strtotime($dt->format('Y-m-d')))));
                   } else {
                       $novo_dia = 1;
                   }
                }

            }

           TTransaction::close();

           return $dt;//$this->verificarAfastamento($dt);

     }catch (Exception $e){
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
     }

   }

}

