<?php

class MigrarAgendamentos extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = '';
    private static $activeRecord = '';
    private static $primaryKey = '';
    private static $formName = 'form_MigrarAgendamentos';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param = null)
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Transferir Agenda");


        $id_unidade = new TSeekButton('id_unidade');
        $nome_unidade = new TEntry('nome_unidade');
        $id_profissional = new TSeekButton('id_profissional');
        $nome_profissional = new TEntry('nome_profissional');
        $data_agendamento = new TDate('data_agendamento');

        $data_agendamento->setMask('dd/mm/yyyy');
        $nome_unidade->forceUpperCase();
        $data_agendamento->setDatabaseMask('yyyy-mm-dd');

        $id_unidade->setSize('20%');
        $nome_unidade->setSize('78%');
        $id_profissional->setSize('20%');
        $data_agendamento->setSize('50%');
        $nome_profissional->setSize('78%');

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_unidade_seekAction = new TAction(['UnidadeSaudeSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id_unidade', 'column'=>'{id}'],
            ['name'=> 'id_unidade', 'column'=>'{id}'],
            ['name'=> 'nome_unidade', 'column'=>'{nome}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_unidade_seekAction->setParameter('_seek_fields', $seekFields);
        $id_unidade_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_unidade_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id_unidade->setAction($id_unidade_seekAction);

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_profissional_seekAction = new TAction(['ProfissionalSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id_profissional', 'column'=>'{id}'],
            ['name'=> 'id_profissional', 'column'=>'{id}'],
            ['name'=> 'nome_profissional', 'column'=>'{nome_profissional}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_profissional_seekAction->setParameter('_seek_fields', $seekFields);
        $id_profissional_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_profissional_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id_profissional->setAction($id_profissional_seekAction);

        $row1 = $this->form->addFields([new TLabel("Unidade de Saúde:", '#F00000', '14px', null)],[$id_unidade,$nome_unidade]);
        $row2 = $this->form->addFields([new TLabel("Profissional:", '#F00000', '14px', null)],[$id_profissional,$nome_profissional]);
        $row3 = $this->form->addFields([new TLabel("Data do Agendamento:", '#F00000', '14px', null)],[$data_agendamento],[],[]);

        // create the form actions
        $btn_onaction = $this->form->addAction("Listar Agendamentos", new TAction([$this, 'onAction']), 'fas:calendar-alt #ffffff');
        $this->btn_onaction = $btn_onaction;
        $btn_onaction->addStyleClass('btn-primary'); 

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Agendamento","Transferir Agenda"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public function onAction($param = null) 
    {
        try
        {
            $data = $this->form->getData();

            if(!$data->id_unidade)
            {
                throw new Exception(AdiantiCoreTranslator::translate('The field ^1 is required', 'Unidade'));
            }                       

            if(!$data->data_agendamento)
            {
                throw new Exception(AdiantiCoreTranslator::translate('The field ^1 is required', 'Data do Agendamento'));
            }                       

            if(!$data->id_profissional)
            {
                throw new Exception(AdiantiCoreTranslator::translate('The field ^1 is required', 'Profissional'));
            }        

            TSession::setValue('id_unidade', $data->id_unidade);
            TSession::setValue('data_agendamento', $data->data_agendamento);
            TSession::setValue('id_profissional', $data->id_profissional);

            TTransaction::open('reabilitar');
            $ObjAgendamentos = Agendamento::where('id_profissional', '=', $data->id_profissional)
                                          ->where('id_unidade_saude', '=', $data->id_unidade)
                                          ->where('data_agendamento', '=', $data->data_agendamento)
                                          ->load();
            //var_dump($$ObjAgendamentos);

            TTransaction::close();

            if (!empty($ObjAgendamentos)){

                $page ='ListaUsuarioAgendadoSimpleList';
                $metodo = 'onShow';

                AdiantiCoreApplication::loadPage($page, $metodo);
            } else {
                new TMessage('Informação','Agendamento não localizado.');
            }

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    }

    public function onShow($param = null)
    {               

    } 

    public function fireEvents( $object )
    {
        $obj = new stdClass;
        if(is_object($object) && get_class($object) == 'stdClass')
        {
            if(isset($object->id_unidade))
            {
                $value = $object->id_unidade;

                $obj->id_unidade = $value;
            }
            if(isset($object->id_profissional))
            {
                $value = $object->id_profissional;

                $obj->id_profissional = $value;
            }
        }
        elseif(is_object($object))
        {
            if(isset($object->id_unidade))
            {
                $value = $object->id_unidade;

                $obj->id_unidade = $value;
            }
            if(isset($object->id_profissional))
            {
                $value = $object->id_profissional;

                $obj->id_profissional = $value;
            }
        }
        TForm::sendData(self::$formName, $obj);
    }  

}

