<?php

class UnidadeSaudeForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'UnidadeSaude';
    private static $primaryKey = 'id';
    private static $formName = 'form_UnidadeSaude';

    use BuilderMasterDetailTrait;

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Cadastro de unidade saude");


        $id = new TEntry('id');
        $cnes_unidade = new TNumeric('cnes_unidade', '0', ',', '.' );
        $nome = new TEntry('nome');
        $setor_unidade_descricao_setor = new TEntry('setor_unidade_descricao_setor');
        $setor_unidade_id = new THidden('setor_unidade_id');
        $button_adicionar_setor_unidade = new TButton('button_adicionar_setor_unidade');

        $cnes_unidade->addValidation("CNES", new TRequiredValidator()); 
        $nome->addValidation("Nome", new TRequiredValidator()); 

        $id->setEditable(false);
        $button_adicionar_setor_unidade->setAction(new TAction([$this, 'onAddDetailSetorUnidade'],['static' => 1]), "Adicionar");
        $button_adicionar_setor_unidade->addStyleClass('btn-default');
        $button_adicionar_setor_unidade->setImage('fas:plus #2ecc71');
        $nome->setMaxLength(50);
        $setor_unidade_descricao_setor->setMaxLength(50);

        $nome->forceUpperCase();
        $setor_unidade_descricao_setor->forceUpperCase();

        $button_adicionar_setor_unidade->id = '60745196b8bcc';

        $id->setSize(100);
        $nome->setSize('100%');
        $cnes_unidade->setSize('13%');
        $setor_unidade_id->setSize(200);
        $setor_unidade_descricao_setor->setSize('100%');

        $this->form->appendPage("Dados Básicos");

        $this->form->addFields([new THidden('current_tab')]);
        $this->form->setTabFunction("$('[name=current_tab]').val($(this).attr('data-current_page'));");

        $row1 = $this->form->addFields([new TLabel("Cód. Unidade:", null, '14px', null)],[$id]);
        $row2 = $this->form->addFields([new TLabel("CNES", '#ff0000', '14px', null)],[$cnes_unidade]);
        $row3 = $this->form->addFields([new TLabel("Nome:", '#ff0000', '14px', null)],[$nome]);

        $this->form->appendPage("Setores da Unidade de Saúde");
        $row4 = $this->form->addFields([new TLabel("Adicione Setores à Unidade de Saúde", null, '16px', 'B')]);
        $row4->layout = [' col-sm-12'];

        $this->detailFormSetorUnidade = new BootstrapFormBuilder('detailFormSetorUnidade');
        $this->detailFormSetorUnidade->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormSetorUnidade->setProperty('class', 'form-horizontal builder-detail-form');

        $row5 = $this->detailFormSetorUnidade->addFields([new TLabel("Setor:", '#ff0000', '14px', null)],[$setor_unidade_descricao_setor,$setor_unidade_id]);
        $row6 = $this->detailFormSetorUnidade->addFields([$button_adicionar_setor_unidade]);
        $row6->layout = [' col-sm-12'];

        $row7 = $this->detailFormSetorUnidade->addFields([new TLabel(" ", null, '14px', null)]);
        $row7->layout = [' col-sm-12'];

        $row8 = $this->detailFormSetorUnidade->addFields([new THidden('setor_unidade__row__id')]);
        $this->setor_unidade_criteria = new TCriteria();

        $this->setor_unidade_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->setor_unidade_list->disableHtmlConversion();;
        $this->setor_unidade_list->generateHiddenFields();
        $this->setor_unidade_list->setId('setor_unidade_list');

        $this->setor_unidade_list->style = 'width:100%';
        $this->setor_unidade_list->class .= ' table-bordered';

        $column_setor_unidade_descricao_setor = new TDataGridColumn('descricao_setor', "Setor", 'left');

        $column_setor_unidade__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_setor_unidade__row__data->setVisibility(false);

        $action_onEditDetailSetor = new TDataGridAction(array('UnidadeSaudeForm', 'onEditDetailSetor'));
        $action_onEditDetailSetor->setUseButton(false);
        $action_onEditDetailSetor->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailSetor->setLabel("Editar");
        $action_onEditDetailSetor->setImage('far:edit #478fca');
        $action_onEditDetailSetor->setFields(['__row__id', '__row__data']);

        $this->setor_unidade_list->addAction($action_onEditDetailSetor);
        $action_onDeleteDetailSetor = new TDataGridAction(array('UnidadeSaudeForm', 'onDeleteDetailSetor'));
        $action_onDeleteDetailSetor->setUseButton(false);
        $action_onDeleteDetailSetor->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailSetor->setLabel("Excluir");
        $action_onDeleteDetailSetor->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailSetor->setFields(['__row__id', '__row__data']);

        $this->setor_unidade_list->addAction($action_onDeleteDetailSetor);

        $this->setor_unidade_list->addColumn($column_setor_unidade_descricao_setor);

        $this->setor_unidade_list->addColumn($column_setor_unidade__row__data);

        $this->setor_unidade_list->createModel();
        $this->detailFormSetorUnidade->addContent([$this->setor_unidade_list]);

        $row9 = $this->form->addFields([$this->detailFormSetorUnidade]);
        $row9->layout = [' col-sm-12'];

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave'],['static' => 1]), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-primary'); 

        $btn_onclear = $this->form->addAction("Limpar formulário", new TAction([$this, 'onClear']), 'fas:eraser #dd5a43');
        $this->btn_onclear = $btn_onclear;

        $btn_onshow = $this->form->addAction("Voltar", new TAction(['UnidadeSaudeHeaderList', 'onShow']), 'fas:arrow-left #000000');
        $this->btn_onshow = $btn_onshow;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Cadastros Básicos","Cadastro de unidade saude"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public  function onAddDetailSetorUnidade($param = null) 
    {
        try
        {
            $data = $this->form->getData();

                $errors = [];
                $requiredFields = [];
                $requiredFields["setor_unidade_descricao_setor"] = "Descricao setor";
                foreach($requiredFields as $keyFieldName => $labelRequired)
                {
                    try
                    {
                        (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                    }
                    catch(Exception $e)
                    {
                        $errors[] = $e->getMessage() . '.';
                    }
                 }
                 if(count($errors) > 0)
                 {
                     throw new Exception(implode('<br>', $errors));
                 }

                $__row__id = !empty($data->setor_unidade__row__id) ? $data->setor_unidade__row__id : 'b'.uniqid();

                TTransaction::open(self::$database);

                $grid_data = new Setor();
                $grid_data->__row__id = $__row__id;
                $grid_data->descricao_setor = $data->setor_unidade_descricao_setor;
                $grid_data->id = $data->setor_unidade_id;

                $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
                $__row__data['__row__id'] = $__row__id;
                $__row__data['__display__']['descricao_setor'] =  $param['setor_unidade_descricao_setor'] ?? null;
                $__row__data['__display__']['id'] =  $param['setor_unidade_id'] ?? null;

                $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
                $row = $this->setor_unidade_list->addItem($grid_data);
                $row->id = $grid_data->__row__id;

                TDataGrid::replaceRowById('setor_unidade_list', $grid_data->__row__id, $row);

                TTransaction::close();

                $data = new stdClass;
                $data->setor_unidade_descricao_setor = '';
                $data->setor_unidade_id = '';
                $data->setor_unidade__row__id = '';

                TForm::sendData(self::$formName, $data);
                TScript::create("
                   var element = $('#60745196b8bcc');
                   if(typeof element.attr('add') != 'undefined')
                   {
                       element.html(base64_decode(element.attr('add')));
                   }
                ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onEditDetailSetor($param = null) 
    {
        try
        {

                $__row__data = unserialize(base64_decode($param['__row__data']));
                $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

                $data = new stdClass;
                $data->setor_unidade_descricao_setor = $__row__data->__display__->descricao_setor ?? null;
                $data->setor_unidade_id = $__row__data->__display__->id ?? null;
                $data->setor_unidade__row__id = $__row__data->__row__id;

                TForm::sendData(self::$formName, $data);
                TScript::create("
                   var element = $('#60745196b8bcc');
                   if(!element.attr('add')){
                       element.attr('add', base64_encode(element.html()));
                   }
                   element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
                   if(!element.attr('edit')){
                       element.attr('edit', base64_encode(element.html()));
                   }
                ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onDeleteDetailSetor($param = null) 
    {
        try
        {

                $__row__data = unserialize(base64_decode($param['__row__data']));

                $data = new stdClass;
                $data->setor_unidade_descricao_setor = '';
                $data->setor_unidade_id = '';
                $data->setor_unidade__row__id = '';

                TForm::sendData(self::$formName, $data);

                TDataGrid::removeRowById('setor_unidade_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $object = new UnidadeSaude(); // create an empty object 

            $data = $this->form->getData(); // get form data as array
            $object->fromArray( (array) $data); // load the object with data

            $object->store(); // save the object 

            TForm::sendData(self::$formName, (object)['id' => $object->id]);

            $loadPageParam = [];

            if(!empty($param['target_container']))
            {
                $loadPageParam['target_container'] = $param['target_container'];
            }

            $setor_unidade_items = $this->storeMasterDetailItems('Setor', 'id_unidade', 'setor_unidade', $object, $param['setor_unidade_list___row__data'] ?? [], $this->form, $this->setor_unidade_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            // get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction

            TToast::show('success', "Registro salvo", 'topRight', 'far:check-circle');
            TApplication::loadPage('UnidadeSaudeHeaderList', 'onShow', $loadPageParam); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode> 

            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new UnidadeSaude($key); // instantiates the Active Record 

                $setor_unidade_items = $this->loadMasterDetailItems('Setor', 'id_unidade', 'setor_unidade', $object, $this->form, $this->setor_unidade_list, $this->setor_unidade_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                }); 

                $this->form->setData($object); // fill the form 

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

    }

    public function onShow($param = null)
    {

    } 

}

