<?php

class AgendaDiariaLoteDocument extends TPage
{
    private static $database = 'reabilitar';
    private static $activeRecord = 'Profissional';
    private static $primaryKey = 'id';
    private static $htmlFile = 'app/documents/AgendaDiariaProfissionalDocumentTemplate.html';
    private static $formName = 'form_AgendaDiariaLoteDocument';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct()
    {
        parent::__construct();

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);

        // define the form title
        $this->form->setFormTitle("Consultar Agenda Diária");

        $criteria_desc_turno = new TCriteria();

        $id = new TSeekButton('id');
        $nome_profissional = new TEntry('nome_profissional');
        $data_agendamento = new TDate('data_agendamento');
        $desc_turno = new TDBCombo('desc_turno', 'reabilitar', 'Turno', 'id', '{nome}','id asc' , $criteria_desc_turno );

        $nome_profissional->setEditable(false);
        $data_agendamento->setMask('dd/mm/yyyy');
        $data_agendamento->setDatabaseMask('yyyy-mm-dd');
        $desc_turno->setDefaultOption(false);

        $id->setSize('20%');
        $desc_turno->setSize('100%');
        $data_agendamento->setSize('53%');
        $nome_profissional->setSize('78%');

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_seekAction = new TAction(['ProfissionalUnidadeSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id', 'column'=>'{id_profissional}'],
            ['name'=> 'id', 'column'=>'{id_profissional}'],
            ['name'=> 'nome_profissional', 'column'=>'{profissional->nome_profissional}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_seekAction->setParameter('_seek_fields', $seekFields);
        $id_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id->setAction($id_seekAction);

        $row1 = $this->form->addFields([new TLabel("Profissional:", null, '14px', null)],[$id,$nome_profissional]);
        $row2 = $this->form->addFields([new TLabel("Data:", null, '14px', null)],[$data_agendamento],[new TLabel("Turno:", null, '14px', null)],[$desc_turno]);

        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );
        $this->fireEvents( TSession::getValue(__CLASS__.'_filter_data') );

        $btn_ongenerate = $this->form->addAction("Gerar", new TAction([$this, 'onGenerate']), 'fas:cog #ffffff');
        $this->btn_ongenerate = $btn_ongenerate;
        $btn_ongenerate->addStyleClass('btn-primary'); 

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->add(TBreadCrumb::create(["Consultas","Consultar Agenda Diária"]));
        $container->add($this->form);

        parent::add($container);

    }

    public function onGenerate($param)
    {
        try 
        {
            TTransaction::open(self::$database);

            $data = $this->form->getData();
            $criteria = new TCriteria();

            if (isset($data->id) AND ( (is_scalar($data->id) AND $data->id !== '') OR (is_array($data->id) AND (!empty($data->id)) )) ) 
            {

                $criteria->add(new TFilter('id', '=', $data->id));
            }
            if (isset($data->data_agendamento) AND ( (is_scalar($data->data_agendamento) AND $data->data_agendamento !== '') OR (is_array($data->data_agendamento) AND (!empty($data->data_agendamento)) )) ) 
            {

                $criteria->add(new TFilter('id', 'in', "(SELECT id_profissional FROM agendamento WHERE data_agendamento = '{$data->data_agendamento}')"));
            }
            if (isset($data->desc_turno) AND ( (is_scalar($data->desc_turno) AND $data->desc_turno !== '') OR (is_array($data->desc_turno) AND (!empty($data->desc_turno)) )) ) 
            {

                $criteria->add(new TFilter('id', 'in', "(SELECT id_profissional FROM agendamento WHERE id_escala in  (SELECT id FROM escala WHERE id_turno = '{$data->desc_turno}') )"));
            }

            $objects = Profissional::getObjects($criteria, FALSE);
            if ($objects)
            {
                
                $output = '';

                $count = 1;
                $count_records = count($objects);

                foreach ($objects as $object)
                {
                    
                    $html = new AdiantiHTMLDocumentParser(self::$htmlFile);
                    $object->data_agendamento = $data->data_agendamento;
                    
                    switch ($data->desc_turno) {
                       case 1: 
                          $object->nome = 'Manhã';
                          break;
                       case 2:
                          $object->nome = 'Tarde';
                          break;
                       case 3:
                          $object->nome = 'Noite';
                          break;
                     }

                    $html->setMaster($object);
                    
                    $objectsAgendamento_id_profissional = Agendamento::where('id_profissional', '=', $object->id)->load();

                    if (!empty($data->data_agendamento))

                          $conn = TTransaction::get();
                          /*
                          $sql = 'select a.*, t.nome as nome, p.mf_paciente as mf_paciente, p.nome_paciente as nome_paciente from agendamento a, escala e, turno t, paciente p where a.id_profissional = :profissional and a.data_agendamento = :data and e.id_turno = :turno and a.id_escala = e.id and e.id_turno = t.id and a.id_paciente = p.id';
                          */
                          //$sql = 'select a.*, t.nome as nome, pr.codigo_procedimento as codigo_procedimento, p.mf_paciente as mf_paciente, p.nome_paciente as nome_paciente, p.cns_paciente as cns_paciente, p.data_nascimento as data_nascimento, p.sexo_paciente as sexo, b.nome_bairro as procedencia, substring(c.descricao_cid,1,3) as cid from agendamento a, escala e, procedimento pr, turno t, paciente p, endereco_paciente ep, bairro b, paciente_cid10 pc, cid10 c where a.id_profissional = :profissional and a.data_agendamento = :data and e.id_turno = :turno and a.id_escala = e.id and e.id_turno = t.id and e.id_procedimento = pr.id and a.id_paciente = p.id and p.id = ep.id_paciente and ep.id_bairro = b.id and pc.id_paciente = p.id and pc.id_cid = c.id and pc.id_tipo_cid = 1';
                           $sql = 'select a.*, t.nome as nome, pr.codigo_procedimento as codigo_procedimento, p.mf_paciente as mf_paciente, p.nome_paciente as nome_paciente, p.cns_paciente as cns_paciente, p.data_nascimento as data_nascimento, p.sexo_paciente as sexo, b.nome_bairro as procedencia, (select substring(c.descricao_cid,1,3) from cid10 c, paciente_cid10 pc where pc.id_tipo_cid = 1 and pc.id_paciente = p.id and pc.id_cid = c.id limit 1) as cid from agendamento a INNER JOIN escala e ON a.id_escala = e.id INNER JOIN procedimento pr ON e.id_procedimento = pr.id INNER JOIN turno t
                                  ON e.id_turno = t.id INNER JOIN paciente p ON a.id_paciente = p.id INNER JOIN endereco_paciente ep ON p.id = ep.id_paciente INNER JOIN 
                                  bairro b ON ep.id_bairro = b.id where a.id_profissional = :profissional and a.data_agendamento = :data and e.id_turno = :turno';

                          $stm = $conn->prepare($sql);
                          $stm->bindParam(':profissional', $object->id, PDO::PARAM_INT);
                          $stm->bindParam(':data', $data->data_agendamento, PDO::PARAM_STR);
                          $stm->bindParam(':turno', $data->desc_turno, PDO::PARAM_INT);
                          $stm->execute();                      

                          $objectsAgendamento_id_profissional = $stm->fetchAll(PDO::FETCH_CLASS, "stdClass");

                           $i = 1;
                           foreach ($objectsAgendamento_id_profissional as $objAgendamento){

                               switch ($objAgendamento->flg_tipo_agendamento){
                                  case 1:
                                      $objAgendamento->flg_tipo_agendamento = '1ª Vez';
                                      break;
                                  case 2:
                                      $objAgendamento->flg_tipo_agendamento = 'Retorno';
                                      break;
                                  case 3: 
                                      $objAgendamento->flg_tipo_agendamento = 'Encaixe';
                                      break;
                                }
                               
                                switch ($objAgendamento->sexo){
                                  case 1:
                                      $objAgendamento->sexo = 'F';
                                      break;
                                  case 2:
                                      $objAgendamento->sexo = 'M';
                                      break;
                                }


                                $objAgendamento->id = $i;
                                $i++;
                             }

                    $html->setDetail('Agendamento.id_profissional', $objectsAgendamento_id_profissional);

                    $html->process();

                    if ($count < $count_records)
                    {
                        $html->addPageBreak();
                    }

                    $content = $html->getContents();
                    $dom = pQuery::parseStr($content);
                    $body = $dom->query('body');

                    if($body->count() > 0)
                    {
                        $output .= $body->html();    
                    }
                    else 
                    {
                        $output .= $content;    
                    }

                    $count ++;
                }

                $dom = pQuery::parseStr(file_get_contents(self::$htmlFile));
                $body = $dom->query('body');
                if($body->count() > 0)
                {
                    $body->html('<div>{$body}</div>');
                    $html = $dom->html();

                    $output = str_replace('<div>{$body}</div>', $output, $html);
                }

                $document = 'tmp/'.uniqid().'.pdf'; 
                $html = AdiantiHTMLDocumentParser::newFromString($output);
                $html->saveAsPDF($document, 'A4', 'landscape');

                parent::openFile($document);
                new TMessage('info', _t('Document successfully generated'));
            }
            else
            {
                new TMessage('info', _t('No records found'));   
            }

            TTransaction::close();

            TSession::setValue(__CLASS__.'_filter_data', $data);

            $this->form->setData($data);
            $this->fireEvents($data);
        } 
        catch (Exception $e) 
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    } 

    public function fireEvents( $object )
    {
        $obj = new stdClass;
        if(is_object($object) && get_class($object) == 'stdClass')
        {
            if(isset($object->id))
            {
                $value = $object->id;

                $obj->id = $value;
            }
        }
        elseif(is_object($object))
        {
            if(isset($object->id))
            {
                $value = $object->id;

                $obj->id = $value;
            }
        }
        TForm::sendData(self::$formName, $obj);
    }  

    public function onShow($param = null)
    {

    }

}

