<?php

class AgendaDiariaProfissionalDocument extends TPage
{
    private static $database = 'reabilitar';
    private static $activeRecord = 'Profissional';
    private static $primaryKey = 'id';
    private static $htmlFile = 'app/documents/AgendaDiariaProfissionalDocumentTemplate.html';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {

    }

    public static function onGenerate($param)
    {
        try 
        {
            TTransaction::open(self::$database);

            $class = self::$activeRecord;
            $object = new $class($param['key']);

            $html = new AdiantiHTMLDocumentParser(self::$htmlFile);
            $html->setMaster($object);

            $criteria_Agendamento_id_profissional = new TCriteria();
            $criteria_Agendamento_id_profissional->add(new TFilter('id_profissional', '=', $param['key']));

            $objectsAgendamento_id_profissional = Agendamento::getObjects($criteria_Agendamento_id_profissional);
            $html->setDetail('Agendamento.id_profissional', $objectsAgendamento_id_profissional);

            $pageSize = 'A4';
            $document = 'tmp/'.uniqid().'.pdf'; 

            $html->process();

            $html->saveAsPDF($document, $pageSize, 'landscape');

            TTransaction::close();

            if(empty($param['returnFile']))
            {
                parent::openFile($document);

                new TMessage('info', _t('Document successfully generated'));    
            }
            else
            {
                return $document;
            }
        } 
        catch (Exception $e) 
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    }

}

