<?php

class VwConsultaAgendaList extends TPage
{
    private $form; // form
    private $datagrid; // listing
    private $pageNavigation;
    private $loaded;
    private $filter_criteria;
    private static $database = 'agendamento';
    private static $activeRecord = 'VwConsultaAgenda';
    private static $primaryKey = 'id_profissional';
    private static $formName = 'formList_VwConsultaAgenda';
    private $showMethods = ['onReload', 'onSearch', 'onRefresh', 'onClearFilters'];
    private $limit = 20;

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct($param = null)
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);

        // define the form title
        $this->form->setFormTitle("Consultar Agenda do Profissional");
        $this->limit = 20;

        $id_usuario = new TDBUniqueSearch('id_usuario', 'agendamento', 'Paciente', 'id', 'nome_paciente','nome_paciente asc'  );
        $id_profissional = new TDBUniqueSearch('id_profissional', 'agendamento', 'Profissional', 'id', 'nome_profissional','nome_profissional asc'  );
        $data_atendimento = new TDate('data_atendimento');


        $data_atendimento->setDatabaseMask('yyyy-mm-dd');

        $id_usuario->setMinLength(2);
        $id_profissional->setMinLength(2);

        $id_usuario->setSize('70%');
        $data_atendimento->setSize(200);
        $id_profissional->setSize('70%');

        $id_usuario->setMask('{nome_paciente}');
        $data_atendimento->setMask('dd/mm/yyyy');
        $id_profissional->setMask('{nome_profissional}');

        $row1 = $this->form->addFields([new TLabel("Paciente:", null, '14px', null)],[$id_usuario]);
        $row2 = $this->form->addFields([new TLabel("Profissional", null, '14px', null)],[$id_profissional]);
        $row3 = $this->form->addFields([new TLabel("Data do Agendamento:", null, '14px', null)],[$data_atendimento]);

        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        $btn_onsearch = $this->form->addAction("Buscar", new TAction([$this, 'onSearch']), 'fas:search #ffffff');
        $this->btn_onsearch = $btn_onsearch;
        $btn_onsearch->addStyleClass('btn-primary'); 

        $btn_onexportcsv = $this->form->addAction("Exportar como CSV", new TAction([$this, 'onExportCsv']), 'far:file-alt #000000');
        $this->btn_onexportcsv = $btn_onexportcsv;

        // creates a Datagrid
        $this->datagrid = new TDataGrid;
        $this->datagrid->disableHtmlConversion();

        $this->datagrid_form = new TForm('datagrid_'.self::$formName);
        $this->datagrid_form->onsubmit = 'return false';

        $this->datagrid = new BootstrapDatagridWrapper($this->datagrid);
        $this->filter_criteria = new TCriteria;

        $this->datagrid->disableDefaultClick();
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        $column_data_atendimento_transformed = new TDataGridColumn('data_atendimento', "Data", 'center');
        $column_nome_usuario = new TDataGridColumn('nome_usuario', "Usuário", 'center');
        $column_nome_profissional = new TDataGridColumn('nome_profissional', "Profissional", 'center');
        $column_desc_ocupacao = new TDataGridColumn('desc_ocupacao', "Ocupação", 'center');
        $column_desc_tipo_atendimento = new TDataGridColumn('desc_tipo_atendimento', "Tipo de Atendimento", 'center');
        $column_desc_tipo_escala = new TDataGridColumn('desc_tipo_escala', "Escala", 'center');
        $column_desc_turno = new TDataGridColumn('desc_turno', "Turno", 'center');
        $column_vigencia_inicial = new TDataGridColumn('vigencia_inicial', "Vigência Inicial", 'center');
        $column_vigencia_final = new TDataGridColumn('vigencia_final', "Vigência Final", 'center');

        $column_data_atendimento_transformed->setTransformer(function($value, $object, $row) 
        {
            if(!empty(trim($value)))
            {
                try
                {
                    $date = new DateTime($value);
                    return $date->format('d/m/Y');
                }
                catch (Exception $e)
                {
                    return $value;
                }
            }
        });        

        $order_data_atendimento_transformed = new TAction(array($this, 'onReload'));
        $order_data_atendimento_transformed->setParameter('order', 'data_atendimento');
        $column_data_atendimento_transformed->setAction($order_data_atendimento_transformed);
        $order_nome_usuario = new TAction(array($this, 'onReload'));
        $order_nome_usuario->setParameter('order', 'nome_usuario');
        $column_nome_usuario->setAction($order_nome_usuario);
        $order_desc_tipo_atendimento = new TAction(array($this, 'onReload'));
        $order_desc_tipo_atendimento->setParameter('order', 'desc_tipo_atendimento');
        $column_desc_tipo_atendimento->setAction($order_desc_tipo_atendimento);

        $this->datagrid->setGroupColumn('dia_semana', '<b>Dia Semana</b>: <i>{dia_semana_extenso}</i>');       

        $this->datagrid->addColumn($column_data_atendimento_transformed);
        $this->datagrid->addColumn($column_nome_usuario);
        $this->datagrid->addColumn($column_nome_profissional);
        $this->datagrid->addColumn($column_desc_ocupacao);
        $this->datagrid->addColumn($column_desc_tipo_atendimento);
        $this->datagrid->addColumn($column_desc_tipo_escala);
        $this->datagrid->addColumn($column_desc_turno);
        $this->datagrid->addColumn($column_vigencia_inicial);
        $this->datagrid->addColumn($column_vigencia_final);


        // create the datagrid model
        $this->datagrid->createModel();

        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->enableCounters();
        $this->pageNavigation->setAction(new TAction(array($this, 'onReload')));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());

        $this->datagrid->disableDefaultClick();

        $panel = new TPanelGroup();
        $panel->datagrid = 'datagrid-container';
        $this->datagridPanel = $panel;
        $this->datagrid_form->add($this->datagrid);
        $panel->add($this->datagrid_form);

        $panel->getBody()->class .= ' table-responsive';

        $panel->addFooter($this->pageNavigation);

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Consultas","Consultar Agenda"]));
        }
        $container->add($this->form);
        $container->add($panel);

        parent::add($container);

    }

    public function onExportCsv($param = null) 
    {
        try
        {
            $this->onSearch();

            TTransaction::open(self::$database); // open a transaction
            $repository = new TRepository(self::$activeRecord); // creates a repository for Customer
            $criteria = $this->filter_criteria;

            if($filters = TSession::getValue(__CLASS__.'_filters'))
            {
                foreach ($filters as $filter) 
                {
                    $criteria->add($filter);       
                }
            }

            $records = $repository->load($criteria); // load the objects according to criteria
            if ($records)
            {
                $file = 'tmp/'.uniqid().'.csv';
                $handle = fopen($file, 'w');
                $columns = $this->datagrid->getColumns();

                $csvColumns = [];
                foreach($columns as $column)
                {
                    $csvColumns[] = $column->getLabel();
                }
                fputcsv($handle, $csvColumns, ';');

                foreach ($records as $record)
                {
                    $csvColumns = [];
                    foreach($columns as $column)
                    {
                        $name = $column->getName();
                        $csvColumns[] = $record->{$name};
                    }
                    fputcsv($handle, $csvColumns, ';');
                }
                fclose($handle);

                TPage::openFile($file);
            }
            else
            {
                new TMessage('info', _t('No records found'));       
            }

            TTransaction::close(); // close the transaction
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Register the filter in the session
     */
    public function onSearch($param = null)
    {
        $data = $this->form->getData();
        $filters = [];

        TSession::setValue(__CLASS__.'_filter_data', NULL);
        TSession::setValue(__CLASS__.'_filters', NULL);

        if (isset($data->id_usuario) AND ( (is_scalar($data->id_usuario) AND $data->id_usuario !== '') OR (is_array($data->id_usuario) AND (!empty($data->id_usuario)) )) )
        {

            $filters[] = new TFilter('id_usuario', '=', $data->id_usuario);// create the filter 
        }

        if (isset($data->id_profissional) AND ( (is_scalar($data->id_profissional) AND $data->id_profissional !== '') OR (is_array($data->id_profissional) AND (!empty($data->id_profissional)) )) )
        {

            $filters[] = new TFilter('id_profissional', '=', $data->id_profissional);// create the filter 
        }

        if (isset($data->data_atendimento) AND ( (is_scalar($data->data_atendimento) AND $data->data_atendimento !== '') OR (is_array($data->data_atendimento) AND (!empty($data->data_atendimento)) )) )
        {

            $filters[] = new TFilter('data_atendimento', '=', $data->data_atendimento);// create the filter 
        }

        // fill the form with data again
        $this->form->setData($data);

        // keep the search data in the session
        TSession::setValue(__CLASS__.'_filter_data', $data);
        TSession::setValue(__CLASS__.'_filters', $filters);

        $this->onReload(['offset' => 0, 'first_page' => 1]);
    }

    /**
     * Load the datagrid with data
     */
    public function onReload($param = NULL)
    {
        try
        {
            // open a transaction with database 'agendamento'
            TTransaction::open(self::$database);

            // creates a repository for VwConsultaAgenda
            $repository = new TRepository(self::$activeRecord);

            $criteria = clone $this->filter_criteria;

            if (empty($param['order']))
            {
                $param['order'] = 'dia_semana';    
            }

            if (empty($param['direction']))
            {
                $param['direction'] = 'asc';
            }

            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $this->limit);

            if($filters = TSession::getValue(__CLASS__.'_filters'))
            {
                foreach ($filters as $filter) 
                {
                    $criteria->add($filter);       
                }
            }

            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);

            $this->datagrid->clear();
            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {

                    $row = $this->datagrid->addItem($object);
                    $row->id = "row_{$object->id_profissional}";

                }
            }

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            $this->pageNavigation->setCount($count); // count of records
            $this->pageNavigation->setProperties($param); // order, page
            $this->pageNavigation->setLimit($this->limit); // limit

            // close the transaction
            TTransaction::close();
            $this->loaded = true;

            return $objects;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    public function onShow($param = null)
    {

    }

    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        // check if the datagrid is already loaded
        if (!$this->loaded AND (!isset($_GET['method']) OR !(in_array($_GET['method'],  $this->showMethods))) )
        {
            if (func_num_args() > 0)
            {
                $this->onReload( func_get_arg(0) );
            }
            else
            {
                $this->onReload();
            }
        }
        parent::show();
    }

}

