<?php

class VwbpiprofissionalBatchDocument extends TPage
{
    private static $database = 'reabilitar';
    private static $activeRecord = 'Vwbpiprofissional';
    private static $primaryKey = 'id';
    private static $htmlFile = 'app/documents/BPIProfissionalDocumentTemplate.html';
    private static $formName = 'form_VwbpiprofissionalBatchDocument';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct()
    {
        parent::__construct();

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);

        // define the form title
        $this->form->setFormTitle("Emitir BPI");

        $id_profissional = new TEntry('id_profissional');
        $data_atendimento = new TDate('data_atendimento');

        $data_atendimento->setDatabaseMask('yyyy-mm-dd');
        $data_atendimento->setMask('dd/mm/yyyy');

        $id_profissional->setSize(100);
        $data_atendimento->setSize('53%');

        $row1 = $this->form->addFields([new TLabel("Profissional:", null, '14px', null)],[$id_profissional]);
        $row2 = $this->form->addFields([new TLabel("Data de Atendimento:", null, '14px', null)],[$data_atendimento],[],[]);

        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        $btn_ongenerate = $this->form->addAction("Gerar", new TAction([$this, 'onGenerate']), 'fas:cog #ffffff');
        $this->btn_ongenerate = $btn_ongenerate;
        $btn_ongenerate->addStyleClass('btn-primary'); 

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->add(TBreadCrumb::create(["Consultas","Emitir BPI"]));
        $container->add($this->form);

        parent::add($container);

    }

    public function onGenerate($param)
    {
        try 
        {
            TTransaction::open(self::$database);

            $data = $this->form->getData();
            $criteria = new TCriteria();

            if (isset($data->id_profissional) AND ( (is_scalar($data->id_profissional) AND $data->id_profissional !== '') OR (is_array($data->id_profissional) AND (!empty($data->id_profissional)) )) ) 
            {

                $criteria->add(new TFilter('id_profissional', '=', $data->id_profissional));
            }
            if (isset($data->data_atendimento) AND ( (is_scalar($data->data_atendimento) AND $data->data_atendimento !== '') OR (is_array($data->data_atendimento) AND (!empty($data->data_atendimento)) )) ) 
            {

                $criteria->add(new TFilter('data_atendimento', '=', $data->data_atendimento));
            }

            $objects = Vwbpiprofissional::getObjects($criteria, FALSE);
            if ($objects)
            {
                $output = '';

                $count = 1;
                $count_records = count($objects);

                foreach ($objects as $object)
                {

                    $html = new AdiantiHTMLDocumentParser(self::$htmlFile);
                    $html->setMaster($object);

                    $html->process();

                    if ($count < $count_records)
                    {
                        $html->addPageBreak();
                    }

                    $content = $html->getContents();
                    $dom = pQuery::parseStr($content);
                    $body = $dom->query('body');

                    if($body->count() > 0)
                    {
                        $output .= $body->html();    
                    }
                    else 
                    {
                        $output .= $content;    
                    }

                    $count ++;
                }

                $dom = pQuery::parseStr(file_get_contents(self::$htmlFile));
                $body = $dom->query('body');
                if($body->count() > 0)
                {
                    $body->html('<div>{$body}</div>');
                    $html = $dom->html();

                    $output = str_replace('<div>{$body}</div>', $output, $html);
                }

                $document = 'tmp/'.uniqid().'.pdf'; 
                $html = AdiantiHTMLDocumentParser::newFromString($output);
                $html->saveAsPDF($document, 'A4', 'landscape');

                parent::openFile($document);
                new TMessage('info', _t('Document successfully generated'));
            }
            else
            {
                new TMessage('info', _t('No records found'));   
            }

            TTransaction::close();

            TSession::setValue(__CLASS__.'_filter_data', $data);

            $this->form->setData($data);

        } 
        catch (Exception $e) 
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    } 

    public function onShow($param = null)
    {

    }

}

