<?php

class DistritoForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'Distrito';
    private static $primaryKey = 'id';
    private static $formName = 'form_Distrito';

    use BuilderMasterDetailTrait;

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Manter Distrito");


        $id = new TEntry('id');
        $nome_distrito = new TEntry('nome_distrito');
        $distrito_bairro_distrito_id_bairro = new TDBCombo('distrito_bairro_distrito_id_bairro', 'reabilitar', 'Bairro', 'id', '{nome_bairro}','id asc'  );
        $distrito_bairro_distrito_id = new THidden('distrito_bairro_distrito_id');
        $button_adicionar_distrito_bairro_distrito = new TButton('button_adicionar_distrito_bairro_distrito');

        $nome_distrito->addValidation("Nome distrito", new TRequiredValidator()); 

        $id->setEditable(false);
        $nome_distrito->setMaxLength(50);
        $nome_distrito->forceUpperCase();
        $button_adicionar_distrito_bairro_distrito->setAction(new TAction([$this, 'onAddDetailDistritoBairroDistrito'],['static' => 1]), "Adicionar");
        $button_adicionar_distrito_bairro_distrito->addStyleClass('btn-default');
        $button_adicionar_distrito_bairro_distrito->setImage('fas:plus #2ecc71');

        $button_adicionar_distrito_bairro_distrito->id = '61dcd3535e00b';

        $id->setSize(100);
        $nome_distrito->setSize('100%');
        $distrito_bairro_distrito_id->setSize(200);
        $distrito_bairro_distrito_id_bairro->setSize('100%');

        $this->form->appendPage("Dados do Distrito");

        $this->form->addFields([new THidden('current_tab')]);
        $this->form->setTabFunction("$('[name=current_tab]').val($(this).attr('data-current_page'));");

        $row1 = $this->form->addFields([new TLabel("Id:", null, '14px', null)],[$id]);
        $row2 = $this->form->addFields([new TLabel("Distrito:", '#ff0000', '14px', null)],[$nome_distrito]);

        $this->form->appendPage("Bairros");

        $this->detailFormDistritoBairroDistrito = new BootstrapFormBuilder('detailFormDistritoBairroDistrito');
        $this->detailFormDistritoBairroDistrito->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormDistritoBairroDistrito->setProperty('class', 'form-horizontal builder-detail-form');

        $row3 = $this->detailFormDistritoBairroDistrito->addFields([new TLabel("Bairro :", '#ff0000', '14px', null)],[$distrito_bairro_distrito_id_bairro,$distrito_bairro_distrito_id],[],[]);
        $row4 = $this->detailFormDistritoBairroDistrito->addFields([$button_adicionar_distrito_bairro_distrito]);
        $row4->layout = [' col-sm-12'];

        $row5 = $this->detailFormDistritoBairroDistrito->addFields([new THidden('distrito_bairro_distrito__row__id')]);
        $this->distrito_bairro_distrito_criteria = new TCriteria();

        $this->distrito_bairro_distrito_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->distrito_bairro_distrito_list->disableHtmlConversion();;
        $this->distrito_bairro_distrito_list->generateHiddenFields();
        $this->distrito_bairro_distrito_list->setId('distrito_bairro_distrito_list');

        $this->distrito_bairro_distrito_list->style = 'width:100%';
        $this->distrito_bairro_distrito_list->class .= ' table-bordered';

        $column_distrito_bairro_distrito_bairro_nome_bairro = new TDataGridColumn('bairro->nome_bairro', "Bairro", 'left');

        $column_distrito_bairro_distrito__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_distrito_bairro_distrito__row__data->setVisibility(false);

        $action_onEditDetailDistritoBairro = new TDataGridAction(array('DistritoForm', 'onEditDetailDistritoBairro'));
        $action_onEditDetailDistritoBairro->setUseButton(false);
        $action_onEditDetailDistritoBairro->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailDistritoBairro->setLabel("Editar");
        $action_onEditDetailDistritoBairro->setImage('far:edit #478fca');
        $action_onEditDetailDistritoBairro->setFields(['__row__id', '__row__data']);

        $this->distrito_bairro_distrito_list->addAction($action_onEditDetailDistritoBairro);
        $action_onDeleteDetailDistritoBairro = new TDataGridAction(array('DistritoForm', 'onDeleteDetailDistritoBairro'));
        $action_onDeleteDetailDistritoBairro->setUseButton(false);
        $action_onDeleteDetailDistritoBairro->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailDistritoBairro->setLabel("Excluir");
        $action_onDeleteDetailDistritoBairro->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailDistritoBairro->setFields(['__row__id', '__row__data']);

        $this->distrito_bairro_distrito_list->addAction($action_onDeleteDetailDistritoBairro);

        $this->distrito_bairro_distrito_list->addColumn($column_distrito_bairro_distrito_bairro_nome_bairro);

        $this->distrito_bairro_distrito_list->addColumn($column_distrito_bairro_distrito__row__data);

        $this->distrito_bairro_distrito_list->createModel();
        $tableResponsiveDiv = new TElement('div');
        $tableResponsiveDiv->class = 'table-responsive';
        $tableResponsiveDiv->add($this->distrito_bairro_distrito_list);
        $this->detailFormDistritoBairroDistrito->addContent([$tableResponsiveDiv]);

        $row6 = $this->form->addFields([$this->detailFormDistritoBairroDistrito]);
        $row6->layout = [' col-sm-6 col-lg-12'];

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave'],['static' => 1]), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-primary'); 

        $btn_onclear = $this->form->addAction("Limpar formulário", new TAction([$this, 'onClear']), 'fas:eraser #dd5a43');
        $this->btn_onclear = $btn_onclear;

        $btn_onshow = $this->form->addAction("Voltar", new TAction(['DistritoHeaderList', 'onShow']), 'fas:arrow-left #000000');
        $this->btn_onshow = $btn_onshow;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Estrutura","Cadastro de distrito"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public  function onAddDetailDistritoBairroDistrito($param = null) 
    {
        try
        {
            $data = $this->form->getData();

                $errors = [];
                $requiredFields = [];
                $requiredFields["distrito_bairro_distrito_id_bairro"] = "Bairro ";
                foreach($requiredFields as $keyFieldName => $labelRequired)
                {
                    try
                    {
                        (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                    }
                    catch(Exception $e)
                    {
                        $errors[] = $e->getMessage() . '.';
                    }
                 }
                 if(count($errors) > 0)
                 {
                     throw new Exception(implode('<br>', $errors));
                 }

                $__row__id = !empty($data->distrito_bairro_distrito__row__id) ? $data->distrito_bairro_distrito__row__id : 'b'.uniqid();

                TTransaction::open(self::$database);

                $grid_data = new DistritoBairro();
                $grid_data->__row__id = $__row__id;
                $grid_data->id_bairro = $data->distrito_bairro_distrito_id_bairro;
                $grid_data->id = $data->distrito_bairro_distrito_id;

                $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
                $__row__data['__row__id'] = $__row__id;
                $__row__data['__display__']['id_bairro'] =  $param['distrito_bairro_distrito_id_bairro'] ?? null;
                $__row__data['__display__']['id'] =  $param['distrito_bairro_distrito_id'] ?? null;

                $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
                $row = $this->distrito_bairro_distrito_list->addItem($grid_data);
                $row->id = $grid_data->__row__id;

                TDataGrid::replaceRowById('distrito_bairro_distrito_list', $grid_data->__row__id, $row);

                TTransaction::close();

                $data = new stdClass;
                $data->distrito_bairro_distrito_id_bairro = '';
                $data->distrito_bairro_distrito_id = '';
                $data->distrito_bairro_distrito__row__id = '';

                TForm::sendData(self::$formName, $data);
                TScript::create("
                   var element = $('#61dcd3535e00b');
                   if(typeof element.attr('add') != 'undefined')
                   {
                       element.html(base64_decode(element.attr('add')));
                   }
                ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onEditDetailDistritoBairro($param = null) 
    {
        try
        {

                $__row__data = unserialize(base64_decode($param['__row__data']));
                $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

                $data = new stdClass;
                $data->distrito_bairro_distrito_id_bairro = $__row__data->__display__->id_bairro ?? null;
                $data->distrito_bairro_distrito_id = $__row__data->__display__->id ?? null;
                $data->distrito_bairro_distrito__row__id = $__row__data->__row__id;

                TForm::sendData(self::$formName, $data);
                TScript::create("
                   var element = $('#61dcd3535e00b');
                   if(!element.attr('add')){
                       element.attr('add', base64_encode(element.html()));
                   }
                   element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
                   if(!element.attr('edit')){
                       element.attr('edit', base64_encode(element.html()));
                   }
                ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onDeleteDetailDistritoBairro($param = null) 
    {
        try
        {

                $__row__data = unserialize(base64_decode($param['__row__data']));

                $data = new stdClass;
                $data->distrito_bairro_distrito_id_bairro = '';
                $data->distrito_bairro_distrito_id = '';
                $data->distrito_bairro_distrito__row__id = '';

                TForm::sendData(self::$formName, $data);

                TDataGrid::removeRowById('distrito_bairro_distrito_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $object = new Distrito(); // create an empty object 

            $data = $this->form->getData(); // get form data as array
            $object->fromArray( (array) $data); // load the object with data

            $object->store(); // save the object 

            TForm::sendData(self::$formName, (object)['id' => $object->id]);

            $loadPageParam = [];

            if(!empty($param['target_container']))
            {
                $loadPageParam['target_container'] = $param['target_container'];
            }

            $distrito_bairro_distrito_items = $this->storeMasterDetailItems('DistritoBairro', 'id_distrito', 'distrito_bairro_distrito', $object, $param['distrito_bairro_distrito_list___row__data'] ?? [], $this->form, $this->distrito_bairro_distrito_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            // get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction

            TToast::show('success', "Registro salvo", 'topRight', 'far:check-circle');
            TApplication::loadPage('DistritoHeaderList', 'onShow', $loadPageParam); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode> 

            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new Distrito($key); // instantiates the Active Record 

                $distrito_bairro_distrito_items = $this->loadMasterDetailItems('DistritoBairro', 'id_distrito', 'distrito_bairro_distrito', $object, $this->form, $this->distrito_bairro_distrito_list, $this->distrito_bairro_distrito_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                }); 

                $this->form->setData($object); // fill the form 

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

    }

    public function onShow($param = null)
    {

    } 

}

