<?php

class EquipeForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'Equipe';
    private static $primaryKey = 'id';
    private static $formName = 'form_Equipe';

    use BuilderMasterDetailTrait;

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Cadastro de equipe");


        $id = new TEntry('id');
        $nome = new TEntry('nome');
        $id_unidade = new TDBCombo('id_unidade', 'reabilitar', 'UnidadeSaude', 'id', '{nome}','id asc'  );
        $profissional_equipe_equipe_id_profissional = new TCombo('profissional_equipe_equipe_id_profissional');
        $button_adicionar_profissional_equipe_equipe = new TButton('button_adicionar_profissional_equipe_equipe');
        $profissional_equipe_equipe_id = new THidden('profissional_equipe_equipe_id');

        $id_unidade->setChangeAction(new TAction([$this,'onChangeid_unidade']));

        $nome->addValidation("Nome", new TRequiredValidator()); 

        $id->setEditable(false);
        $nome->setMaxLength(50);
        $nome->forceUpperCase();
        $button_adicionar_profissional_equipe_equipe->setAction(new TAction([$this, 'onAddDetailProfissionalEquipeEquipe'],['static' => 1]), "Adicionar");
        $button_adicionar_profissional_equipe_equipe->addStyleClass('btn-default');
        $button_adicionar_profissional_equipe_equipe->setImage('fas:plus #2ecc71');

        $button_adicionar_profissional_equipe_equipe->id = '60745c4bb8beb';

        $id->setSize(100);
        $nome->setSize('100%');
        $id_unidade->setSize('100%');
        $profissional_equipe_equipe_id->setSize(200);
        $profissional_equipe_equipe_id_profissional->setSize('100%');

        $row1 = $this->form->addFields([new TLabel("Código da Equipe:", null, '14px', null)],[$id]);
        $row2 = $this->form->addFields([new TLabel("Descrição da Equipe:", '#ff0000', '14px', null)],[$nome]);
        $row3 = $this->form->addFields([new TLabel("Unidade de Saúde:", '#ff0000', '14px', null)],[$id_unidade]);
        $row4 = $this->form->addFields([new TFormSeparator("", '#333333', '18', '#eeeeee')]);
        $row4->layout = [' col-sm-12'];

        $this->detailFormProfissionalEquipeEquipe = new BootstrapFormBuilder('detailFormProfissionalEquipeEquipe');
        $this->detailFormProfissionalEquipeEquipe->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormProfissionalEquipeEquipe->setProperty('class', 'form-horizontal builder-detail-form');

        $row5 = $this->detailFormProfissionalEquipeEquipe->addFields([new TLabel("Adicione os Profissionais da Equipe", null, '17px', 'B')]);
        $row5->layout = [' col-sm-12'];

        $row6 = $this->detailFormProfissionalEquipeEquipe->addFields([new TLabel("Profissional:", '#ff0000', '14px', null)],[$profissional_equipe_equipe_id_profissional]);
        $row7 = $this->detailFormProfissionalEquipeEquipe->addFields([$button_adicionar_profissional_equipe_equipe]);
        $row7->layout = [' col-sm-12'];

        $row8 = $this->detailFormProfissionalEquipeEquipe->addFields([new TLabel(" ", null, '14px', null),$profissional_equipe_equipe_id]);
        $row8->layout = [' col-sm-12'];

        $row9 = $this->detailFormProfissionalEquipeEquipe->addFields([new THidden('profissional_equipe_equipe__row__id')]);
        $this->profissional_equipe_equipe_criteria = new TCriteria();

        $this->profissional_equipe_equipe_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->profissional_equipe_equipe_list->disableHtmlConversion();;
        $this->profissional_equipe_equipe_list->generateHiddenFields();
        $this->profissional_equipe_equipe_list->setId('profissional_equipe_equipe_list');

        $this->profissional_equipe_equipe_list->style = 'width:100%';
        $this->profissional_equipe_equipe_list->class .= ' table-bordered';

        $column_profissional_equipe_equipe_profissional_cpf = new TDataGridColumn('profissional->cpf', "CPF", 'left');
        $column_profissional_equipe_equipe_profissional_cns_profissional = new TDataGridColumn('profissional->cns_profissional', "CNS", 'left');
        $column_profissional_equipe_equipe_profissional_nome_profissional = new TDataGridColumn('profissional->nome_profissional', "Profissional", 'left');

        $column_profissional_equipe_equipe__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_profissional_equipe_equipe__row__data->setVisibility(false);

        $action_onEditDetailProfissionalEquipe = new TDataGridAction(array('EquipeForm', 'onEditDetailProfissionalEquipe'));
        $action_onEditDetailProfissionalEquipe->setUseButton(false);
        $action_onEditDetailProfissionalEquipe->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailProfissionalEquipe->setLabel("Editar");
        $action_onEditDetailProfissionalEquipe->setImage('far:edit #478fca');
        $action_onEditDetailProfissionalEquipe->setFields(['__row__id', '__row__data']);

        $this->profissional_equipe_equipe_list->addAction($action_onEditDetailProfissionalEquipe);
        $action_onDeleteDetailProfissionalEquipe = new TDataGridAction(array('EquipeForm', 'onDeleteDetailProfissionalEquipe'));
        $action_onDeleteDetailProfissionalEquipe->setUseButton(false);
        $action_onDeleteDetailProfissionalEquipe->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailProfissionalEquipe->setLabel("Excluir");
        $action_onDeleteDetailProfissionalEquipe->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailProfissionalEquipe->setFields(['__row__id', '__row__data']);

        $this->profissional_equipe_equipe_list->addAction($action_onDeleteDetailProfissionalEquipe);

        $this->profissional_equipe_equipe_list->addColumn($column_profissional_equipe_equipe_profissional_cpf);
        $this->profissional_equipe_equipe_list->addColumn($column_profissional_equipe_equipe_profissional_cns_profissional);
        $this->profissional_equipe_equipe_list->addColumn($column_profissional_equipe_equipe_profissional_nome_profissional);

        $this->profissional_equipe_equipe_list->addColumn($column_profissional_equipe_equipe__row__data);

        $this->profissional_equipe_equipe_list->createModel();
        $this->detailFormProfissionalEquipeEquipe->addContent([$this->profissional_equipe_equipe_list]);

        $row10 = $this->form->addFields([$this->detailFormProfissionalEquipeEquipe]);
        $row10->layout = [' col-sm-12'];

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave'],['static' => 1]), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-primary'); 

        $btn_onclear = $this->form->addAction("Limpar formulário", new TAction([$this, 'onClear']), 'fas:eraser #dd5a43');
        $this->btn_onclear = $btn_onclear;

        $btn_onshow = $this->form->addAction("Voltar", new TAction(['EquipeHeaderList', 'onShow']), 'fas:arrow-left #000000');
        $this->btn_onshow = $btn_onshow;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Pessoas","Cadastro de equipe"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public static function onChangeid_unidade($param)
    {
        try
        {

            if (isset($param['id_unidade']) && $param['id_unidade'])
            { 
                $criteria = TCriteria::create(['id_unidade' => $param['id_unidade']]);
                TDBCombo::reloadFromModel(self::$formName, 'profissional_equipe_equipe_id_profissional', 'reabilitar', 'ProfissionalUnidade', 'id_profissional', '{profissional->nome_profissional}', 'id asc', $criteria, TRUE); 
            } 
            else 
            { 
                TCombo::clearField(self::$formName, 'profissional_equipe_equipe_id_profissional'); 
            }  

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    } 

    public  function onAddDetailProfissionalEquipeEquipe($param = null) 
    {
        try
        {
            $data = $this->form->getData();

                $errors = [];
                $requiredFields = [];
                $requiredFields["profissional_equipe_equipe_id_profissional"] = "Id profissional";
                foreach($requiredFields as $keyFieldName => $labelRequired)
                {
                    try
                    {
                        (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                    }
                    catch(Exception $e)
                    {
                        $errors[] = $e->getMessage() . '.';
                    }
                 }
                 if(count($errors) > 0)
                 {
                     throw new Exception(implode('<br>', $errors));
                 }

                $__row__id = !empty($data->profissional_equipe_equipe__row__id) ? $data->profissional_equipe_equipe__row__id : 'b'.uniqid();

                TTransaction::open(self::$database);

                $grid_data = new ProfissionalEquipe();
                $grid_data->__row__id = $__row__id;
                $grid_data->id_profissional = $data->profissional_equipe_equipe_id_profissional;
                $grid_data->id = $data->profissional_equipe_equipe_id;

                $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
                $__row__data['__row__id'] = $__row__id;
                $__row__data['__display__']['id_profissional'] =  $param['profissional_equipe_equipe_id_profissional'] ?? null;
                $__row__data['__display__']['id'] =  $param['profissional_equipe_equipe_id'] ?? null;

                $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
                $row = $this->profissional_equipe_equipe_list->addItem($grid_data);
                $row->id = $grid_data->__row__id;

                TDataGrid::replaceRowById('profissional_equipe_equipe_list', $grid_data->__row__id, $row);

                TTransaction::close();

                $data = new stdClass;
                $data->profissional_equipe_equipe_id_profissional = '';
                $data->profissional_equipe_equipe_id = '';
                $data->profissional_equipe_equipe__row__id = '';

                TForm::sendData(self::$formName, $data);
                TScript::create("
                   var element = $('#60745c4bb8beb');
                   if(typeof element.attr('add') != 'undefined')
                   {
                       element.html(base64_decode(element.attr('add')));
                   }
                ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onEditDetailProfissionalEquipe($param = null) 
    {
        try
        {

                $__row__data = unserialize(base64_decode($param['__row__data']));
                $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

                $data = new stdClass;
                $data->profissional_equipe_equipe_id_profissional = $__row__data->__display__->id_profissional ?? null;
                $data->profissional_equipe_equipe_id = $__row__data->__display__->id ?? null;
                $data->profissional_equipe_equipe__row__id = $__row__data->__row__id;

                TForm::sendData(self::$formName, $data);
                TScript::create("
                   var element = $('#60745c4bb8beb');
                   if(!element.attr('add')){
                       element.attr('add', base64_encode(element.html()));
                   }
                   element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
                   if(!element.attr('edit')){
                       element.attr('edit', base64_encode(element.html()));
                   }
                ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onDeleteDetailProfissionalEquipe($param = null) 
    {
        try
        {

                $__row__data = unserialize(base64_decode($param['__row__data']));

                $data = new stdClass;
                $data->profissional_equipe_equipe_id_profissional = '';
                $data->profissional_equipe_equipe_id = '';
                $data->profissional_equipe_equipe__row__id = '';

                TForm::sendData(self::$formName, $data);

                TDataGrid::removeRowById('profissional_equipe_equipe_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $object = new Equipe(); // create an empty object 

            $data = $this->form->getData(); // get form data as array
            $object->fromArray( (array) $data); // load the object with data

            $object->store(); // save the object 

            $this->fireEvents($object);

            TForm::sendData(self::$formName, (object)['id' => $object->id]);

            $loadPageParam = [];

            if(!empty($param['target_container']))
            {
                $loadPageParam['target_container'] = $param['target_container'];
            }

            $profissional_equipe_equipe_items = $this->storeMasterDetailItems('ProfissionalEquipe', 'id_equipe', 'profissional_equipe_equipe', $object, $param['profissional_equipe_equipe_list___row__data'] ?? [], $this->form, $this->profissional_equipe_equipe_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            // get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction

            TToast::show('success', "Registro salvo", 'topRight', 'far:check-circle');
            TApplication::loadPage('EquipeHeaderList', 'onShow', $loadPageParam); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode> 

            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new Equipe($key); // instantiates the Active Record 

                $profissional_equipe_equipe_items = $this->loadMasterDetailItems('ProfissionalEquipe', 'id_equipe', 'profissional_equipe_equipe', $object, $this->form, $this->profissional_equipe_equipe_list, $this->profissional_equipe_equipe_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                    $objectItems->id_unidade = null;
                    if(isset($detailObject->id_unidade) && $detailObject->id_unidade)
                    {
                        $objectItems->__display__->id_unidade = $detailObject->id_unidade;
                    }

                    $objectItems->profissional_equipe_equipe_id_profissional = null;
                    if(isset($detailObject->id_profissional) && $detailObject->id_profissional)
                    {
                        $objectItems->__display__->id_profissional = $detailObject->id_profissional;
                    }

                }); 

                $this->form->setData($object); // fill the form 

                $this->fireEvents($object);

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

    }

    public function onShow($param = null)
    {

    } 

    public function fireEvents( $object )
    {
        $obj = new stdClass;
        if(is_object($object) && get_class($object) == 'stdClass')
        {
            if(isset($object->id_unidade))
            {
                $value = $object->id_unidade;

                $obj->id_unidade = $value;
            }
            if(isset($object->profissional_equipe_equipe_id_profissional))
            {
                $value = $object->profissional_equipe_equipe_id_profissional;

                $obj->profissional_equipe_equipe_id_profissional = $value;
            }
        }
        elseif(is_object($object))
        {
            if(isset($object->id_unidade))
            {
                $value = $object->id_unidade;

                $obj->id_unidade = $value;
            }
            if(isset($object->profissional_equipe->equipe->id_profissional))
            {
                $value = $object->profissional_equipe->equipe->id_profissional;

                $obj->profissional_equipe_equipe_id_profissional = $value;
            }
        }
        TForm::sendData(self::$formName, $obj);
    }  

}

