<?php

class EscalaIndividualForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'Escala';
    private static $primaryKey = 'id';
    private static $formName = 'form_Escala';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Cadastro de Escala Individual");


        $id = new TEntry('id');
        $id_profissional = new TSeekButton('id_profissional');
        $nome_profissional = new TEntry('nome_profissional');
        $id_unidade_saude = new TEntry('id_unidade_saude');
        $nome_unidade = new TEntry('nome_unidade');
        $id_ocupacao = new TSeekButton('id_ocupacao');
        $descricao_ocupacao = new TEntry('descricao_ocupacao');
        $id_procedimento = new TSeekButton('id_procedimento');
        $nome_procedimento = new TEntry('nome_procedimento');
        $qtd_primeira_vez = new TNumeric('qtd_primeira_vez', '0', ',', '.' );
        $qtd_retorno = new TNumeric('qtd_retorno', '0', ',', '.' );
        $id_turno = new TDBCombo('id_turno', 'reabilitar', 'Turno', 'id', '{nome}','id asc'  );
        $dias_escala = new TCheckGroup('dias_escala');
        $encaixe = new TRadioGroup('encaixe');
        $data_inicio = new TDate('data_inicio');
        $data_limite = new TDate('data_limite');

        $id_profissional->setExitAction(new TAction([$this,'limparOcupacao']));

        $qtd_primeira_vez->addValidation("Informe a quantidade máxima de agendamento para a escala.", new TRequiredValidator()); 
        $dias_escala->addValidation("Selecione os dias da escala", new TRequiredValidator()); 
        $encaixe->addValidation("encaixe", new TRequiredValidator()); 
        $data_limite->addValidation("Informe a data limite de abertura da agenda", new TRequiredValidator()); 

        $encaixe->addItems(['1'=>' SIM','2'=>' NÃO']);
        $dias_escala->addItems(['1'=>'Segunda-Feira','2'=>'Terça-Feira','3'=>'Quarta-Feira','4'=>'Quinta-Feira','5'=>'Sexta-Feira','6'=>'Sábado','0'=>'Domingo']);

        $encaixe->setLayout('horizontal');
        $dias_escala->setLayout('horizontal');

        $encaixe->setBreakItems(1);
        $dias_escala->setBreakItems(1);

        $data_inicio->setMask('dd/mm/yyyy');
        $data_limite->setMask('dd/mm/yyyy');

        $data_inicio->setDatabaseMask('yyyy-mm-dd');
        $data_limite->setDatabaseMask('yyyy-mm-dd');

        $id->setEditable(false);
        $nome_unidade->setEditable(false);
        $id_unidade_saude->setEditable(false);

        $id->setSize(100);
        $encaixe->setSize(80);
        $id_turno->setSize('100%');
        $id_ocupacao->setSize('20%');
        $qtd_retorno->setSize('27%');
        $nome_unidade->setSize('77%');
        $dias_escala->setSize('100%');
        $data_inicio->setSize('100%');
        $data_limite->setSize('100%');
        $id_profissional->setSize('20%');
        $id_procedimento->setSize('20%');
        $id_unidade_saude->setSize('20%');
        $qtd_primeira_vez->setSize('27%');
        $nome_profissional->setSize('77%');
        $nome_procedimento->setSize('77%');
        $descricao_ocupacao->setSize('77%');

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_profissional_seekAction = new TAction(['ProfissionalUnidadeSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id_profissional', 'column'=>'{id_profissional}'],
            ['name'=> 'id_profissional', 'column'=>'{id_profissional}'],
            ['name'=> 'nome_profissional', 'column'=>'{profissional->nome_profissional}'],
            ['name'=> 'id_unidade_saude', 'column'=>'{id_unidade}'],
            ['name'=> 'nome_unidade', 'column'=>'{unidade->nome}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_profissional_seekAction->setParameter('_seek_fields', $seekFields);
        $id_profissional_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_profissional_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id_profissional->setAction($id_profissional_seekAction);

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_ocupacao_seekAction = new TAction(['ProfissionalOcupacaoSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id_ocupacao', 'column'=>'{id_ocupacao}'],
            ['name'=> 'id_ocupacao', 'column'=>'{id_ocupacao}'],
            ['name'=> 'descricao_ocupacao', 'column'=>'{ocupacao->descricao_ocupacao}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_ocupacao_seekAction->setParameter('_seek_fields', $seekFields);
        $id_ocupacao_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_ocupacao_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id_ocupacao->setAction($id_ocupacao_seekAction);

        $seed = AdiantiApplicationConfig::get()['general']['seed'];
        $id_procedimento_seekAction = new TAction(['ProcedimentoSeekWindow', 'onShow']);
        $seekFilters = [];
        $seekFields = base64_encode(serialize([
            ['name'=> 'id_procedimento', 'column'=>'{id}'],
            ['name'=> 'id_procedimento', 'column'=>'{id}'],
            ['name'=> 'nome_procedimento', 'column'=>'{descricao_procedimento}']
        ]));

        $seekFilters = base64_encode(serialize($seekFilters));
        $id_procedimento_seekAction->setParameter('_seek_fields', $seekFields);
        $id_procedimento_seekAction->setParameter('_seek_filters', $seekFilters);
        $id_procedimento_seekAction->setParameter('_seek_hash', md5($seed.$seekFields.$seekFilters));
        $id_procedimento->setAction($id_procedimento_seekAction);

        $row1 = $this->form->addFields([new TLabel("Código da Escala:", null, '14px', null)],[$id]);
        $row2 = $this->form->addFields([new TLabel("Profissional:", '#ff0000', '14px', null)],[$id_profissional,$nome_profissional]);
        $row3 = $this->form->addFields([new TLabel("Unidade de Atendimento:", '#ff0000', '14px', null)],[$id_unidade_saude,$nome_unidade]);
        $row4 = $this->form->addFields([new TLabel("Ocupação:", '#FF0000', '14px', null)],[$id_ocupacao,$descricao_ocupacao]);
        $row5 = $this->form->addFields([new TLabel("Procedimento:", '#ff0000', '14px', null)],[$id_procedimento,$nome_procedimento]);
        $row6 = $this->form->addFields([new TLabel("Qtd. 1ª Vez:", '#ff0000', '14px', null)],[$qtd_primeira_vez],[new TLabel("Qtd. Retorno:", '#ff0000', '14px', null)],[$qtd_retorno]);
        $row7 = $this->form->addFields([new TLabel("Turno", '#ff0000', '14px', null)],[$id_turno],[],[]);
        $row8 = $this->form->addFields([new TLabel("Dias:", '#ff0000', '14px', null)],[$dias_escala],[new TLabel("Permitir Encaixe:", '#ff0000', '14px', null)],[$encaixe]);
        $row9 = $this->form->addFields([new TLabel("Data Início Agenda:", '#FF0000', '14px', null)],[$data_inicio],[new TLabel("Data Limite Agenda:", '#ff0000', '14px', null)],[$data_limite]);

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave']), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-primary'); 

        $btn_onclear = $this->form->addAction("Limpar formulário", new TAction([$this, 'onClear']), 'fas:eraser #dd5a43');
        $this->btn_onclear = $btn_onclear;

        $btn_onshow = $this->form->addAction("Voltar", new TAction(['EscalaIndividuallHeaderList', 'onShow']), 'fas:arrow-left #000000');
        $this->btn_onshow = $btn_onshow;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Pessoas","Cadastro de escala individual"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public static function limparOcupacao($param = null) 
    {
        try 
        {
            //code here
           if (empty($param['id_profissional'])){
               $object = new stdClass();
               $object->id_ocupacao = '';
               $object->descricao_ocupacao = ''; //sample
               TForm::sendData(self::$formName, $object);
           }

        }
        catch (Exception $e) 
        {
            new TMessage('error', $e->getMessage());    
        }
    }

    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $object = new Escala(); // create an empty object 

            $data = $this->form->getData(); // get form data as array
            $object->fromArray( (array) $data); // load the object with data

            $object->store(); // save the object 

            $this->fireEvents($object);

            $repository = EscalaDia::where('id_escala', '=', $object->id);
            $repository->delete(); 

            if ($data->dias_escala) 
            {
                foreach ($data->dias_escala as $dias_escala_value) 
                {
                    $escala_dia = new EscalaDia;

                    $escala_dia->dia_semana = $dias_escala_value;
                    $escala_dia->id_escala = $object->id;
                    $escala_dia->store();
                }
            }

            $loadPageParam = [];

            if(!empty($param['target_container']))
            {
                $loadPageParam['target_container'] = $param['target_container'];
            }

            // get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction

            TToast::show('success', "Registro salvo", 'topRight', 'far:check-circle');
            TApplication::loadPage('EscalaIndividuallHeaderList', 'onShow', $loadPageParam); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode>  

            echo 'entrou';
            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new Escala($key); // instantiates the Active Record 

                $object->dias_escala = EscalaDia::where('id_escala', '=', $object->id)->getIndexedArray('dia_semana', 'dia_semana');

                $object->nome_profissional = Profissional::find($object->id_profissional)->nome_profissional;
                $object->nome_unidade = UnidadeSaude::find($object->id_unidade_saude)->nome;
                $object->descricao_ocupacao = Ocupacao::find($object->id_ocupacao)->descricao_ocupacao;
                $object->nome_procedimento = Procedimento::find($object->id_procedimento)->descricao_procedimento;

                $this->form->setData($object); // fill the form 

                $this->fireEvents($object);

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

    }

    public function onShow($param = null)
    {

    } 

    public function fireEvents( $object )
    {
        $obj = new stdClass;
        if(is_object($object) && get_class($object) == 'stdClass')
        {
            if(isset($object->id_profissional))
            {
                $value = $object->id_profissional;

                $obj->id_profissional = $value;
            }
            if(isset($object->id_ocupacao))
            {
                $value = $object->id_ocupacao;

                $obj->id_ocupacao = $value;
            }
            if(isset($object->id_procedimento))
            {
                $value = $object->id_procedimento;

                $obj->id_procedimento = $value;
            }
        }
        elseif(is_object($object))
        {
            if(isset($object->id_profissional))
            {
                $value = $object->id_profissional;

                $obj->id_profissional = $value;
            }
            if(isset($object->id_ocupacao))
            {
                $value = $object->id_ocupacao;

                $obj->id_ocupacao = $value;
            }
            if(isset($object->id_procedimento))
            {
                $value = $object->id_procedimento;

                $obj->id_procedimento = $value;
            }
        }
        TForm::sendData(self::$formName, $obj);
    }  

}

