<?php

class EscalaIndividuallHeaderList extends TPage
{
    private $form; // form
    private $datagrid; // listing
    private $pageNavigation;
    private $loaded;
    private $filter_criteria;
    private static $database = 'reabilitar';
    private static $activeRecord = 'Escala';
    private static $primaryKey = 'id';
    private static $formName = 'formList_Escala';
    private $showMethods = ['onReload', 'onSearch'];
    private $limit = 20;

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct($param = null)
    {
        parent::__construct();
        // creates the form

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        $this->limit = 20;

        $id = new TEntry('id');
        $id_profissional = new TDBCombo('id_profissional', 'reabilitar', 'Profissional', 'id', '{nome_profissional}','id asc'  );
        $id_ocupacao = new TEntry('id_ocupacao');
        $id_unidade_saude = new TDBCombo('id_unidade_saude', 'reabilitar', 'UnidadeSaude', 'id', '{nome}','id asc'  );
        $procedimento_descricao_procedimento = new TDBCombo('procedimento_descricao_procedimento', 'reabilitar', 'Procedimento', 'id', '{descricao_procedimento}','id asc'  );
        $id_turno = new TDBCombo('id_turno', 'reabilitar', 'Turno', 'id', '{nome}','id asc'  );
        $qtd_primeira_vez = new TEntry('qtd_primeira_vez');
        $qtd_retorno = new TEntry('qtd_retorno');

        $id->exitOnEnter();
        $id_ocupacao->exitOnEnter();
        $qtd_primeira_vez->exitOnEnter();
        $qtd_retorno->exitOnEnter();

        $id->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $id_ocupacao->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $qtd_primeira_vez->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $qtd_retorno->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));

        $id_profissional->setChangeAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $id_unidade_saude->setChangeAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $procedimento_descricao_procedimento->setChangeAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $id_turno->setChangeAction(new TAction([$this, 'onSearch'], ['static'=>'1']));

        $id->setSize('100%');
        $id_turno->setSize('100%');
        $id_ocupacao->setSize('100%');
        $qtd_retorno->setSize('100%');
        $id_profissional->setSize('100%');
        $id_unidade_saude->setSize('100%');
        $qtd_primeira_vez->setSize('100%');
        $procedimento_descricao_procedimento->setSize('100%');

        // creates a Datagrid
        $this->datagrid = new TDataGrid;
        $this->datagrid->disableHtmlConversion();

        $this->datagrid_form = new TForm(self::$formName);
        $this->datagrid_form->onsubmit = 'return false';

        $this->datagrid = new BootstrapDatagridWrapper($this->datagrid);
        $this->filter_criteria = new TCriteria;

        $filterVar = NULL;
        $this->filter_criteria->add(new TFilter('id_equipe', 'is', $filterVar));

        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        $column_id = new TDataGridColumn('id', "Cód. da Escala", 'center' , '96px');
        $column_profissional_nome_profissional = new TDataGridColumn('profissional->nome_profissional', "Profissional", 'left');
        $column_ocupacao_descricao_ocupacao = new TDataGridColumn('ocupacao->descricao_ocupacao', "Ocupação", 'left');
        $column_unidade_saude_nome = new TDataGridColumn('unidade_saude->nome', "Unidade de Saúde", 'left');
        $column_procedimento_descricao_procedimento = new TDataGridColumn('procedimento->descricao_procedimento', "Procedimento", 'left');
        $column_turno_nome = new TDataGridColumn('turno->nome', "Turno", 'left');
        $column_qtd_primeira_vez = new TDataGridColumn('qtd_primeira_vez', "Qtd. 1ª Vez", 'center' , '100px');
        $column_qtd_retorno = new TDataGridColumn('qtd_retorno', "Qtd Retorno", 'center');

        $order_id = new TAction(array($this, 'onReload'));
        $order_id->setParameter('order', 'id');
        $column_id->setAction($order_id);

        $this->datagrid->addColumn($column_id);
        $this->datagrid->addColumn($column_profissional_nome_profissional);
        $this->datagrid->addColumn($column_ocupacao_descricao_ocupacao);
        $this->datagrid->addColumn($column_unidade_saude_nome);
        $this->datagrid->addColumn($column_procedimento_descricao_procedimento);
        $this->datagrid->addColumn($column_turno_nome);
        $this->datagrid->addColumn($column_qtd_primeira_vez);
        $this->datagrid->addColumn($column_qtd_retorno);

        $action_onEdit = new TDataGridAction(array('EscalaIndividualForm', 'onEdit'));
        $action_onEdit->setUseButton(false);
        $action_onEdit->setButtonClass('btn btn-default btn-sm');
        $action_onEdit->setLabel("Editar");
        $action_onEdit->setImage('far:edit #478fca');
        $action_onEdit->setField(self::$primaryKey);

        $this->datagrid->addAction($action_onEdit);

        $action_onDelete = new TDataGridAction(array('EscalaIndividuallHeaderList', 'onDelete'));
        $action_onDelete->setUseButton(false);
        $action_onDelete->setButtonClass('btn btn-default btn-sm');
        $action_onDelete->setLabel("Excluir");
        $action_onDelete->setImage('fas:trash-alt #dd5a43');
        $action_onDelete->setField(self::$primaryKey);

        $this->datagrid->addAction($action_onDelete);

        // create the datagrid model
        $this->datagrid->createModel();

        $tr = new TElement('tr');
        $this->datagrid->prependRow($tr);

        $tr->add(TElement::tag('td', ''));
        $tr->add(TElement::tag('td', ''));
        $td_id = TElement::tag('td', $id);
        $tr->add($td_id);
        $td_id_profissional = TElement::tag('td', $id_profissional);
        $tr->add($td_id_profissional);
        $td_id_ocupacao = TElement::tag('td', $id_ocupacao);
        $tr->add($td_id_ocupacao);
        $td_id_unidade_saude = TElement::tag('td', $id_unidade_saude);
        $tr->add($td_id_unidade_saude);
        $td_procedimento_descricao_procedimento = TElement::tag('td', $procedimento_descricao_procedimento);
        $tr->add($td_procedimento_descricao_procedimento);
        $td_id_turno = TElement::tag('td', $id_turno);
        $tr->add($td_id_turno);
        $td_qtd_primeira_vez = TElement::tag('td', $qtd_primeira_vez);
        $tr->add($td_qtd_primeira_vez);
        $td_qtd_retorno = TElement::tag('td', $qtd_retorno);
        $tr->add($td_qtd_retorno);

        $this->datagrid_form->addField($id);
        $this->datagrid_form->addField($id_profissional);
        $this->datagrid_form->addField($id_ocupacao);
        $this->datagrid_form->addField($id_unidade_saude);
        $this->datagrid_form->addField($procedimento_descricao_procedimento);
        $this->datagrid_form->addField($id_turno);
        $this->datagrid_form->addField($qtd_primeira_vez);
        $this->datagrid_form->addField($qtd_retorno);

        $this->datagrid_form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->enableCounters();
        $this->pageNavigation->setAction(new TAction(array($this, 'onReload')));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());

        $panel = new TPanelGroup("Listagem de Escalas Individuais");
        $panel->datagrid = 'datagrid-container';
        $this->datagridPanel = $panel;
        $panel->getBody()->class .= ' table-responsive';

        $panel->addFooter($this->pageNavigation);

        $headerActions = new TElement('div');
        $headerActions->class = ' datagrid-header-actions ';

        $head_left_actions = new TElement('div');
        $head_left_actions->class = ' datagrid-header-actions-left-actions ';

        $head_right_actions = new TElement('div');
        $head_right_actions->class = ' datagrid-header-actions-left-actions ';

        $headerActions->add($head_left_actions);
        $headerActions->add($head_right_actions);

        $this->datagrid_form->add($this->datagrid);
        $panel->add($headerActions);
        $panel->add($this->datagrid_form);

        $button_cadastrar = new TButton('button_button_cadastrar');
        $button_cadastrar->setAction(new TAction(['EscalaIndividualForm', 'onShow']), "Cadastrar");
        $button_cadastrar->addStyleClass('');
        $button_cadastrar->setImage('fas:plus #69aa46');
        $this->datagrid_form->addField($button_cadastrar);

        $dropdown_button_exportar = new TDropDown("Exportar", 'fas:file-export #2d3436');
        $dropdown_button_exportar->setPullSide('right');
        $dropdown_button_exportar->setButtonClass('btn btn-default waves-effect dropdown-toggle');
        $dropdown_button_exportar->addPostAction( "CSV", new TAction(['EscalaIndividuallHeaderList', 'onExportCsv'],['static' => 1]), self::$formName, 'fas:table #00b894' );
        $dropdown_button_exportar->addPostAction( "PDF", new TAction(['EscalaIndividuallHeaderList', 'onExportPdf'],['static' => 1]), self::$formName, 'far:file-pdf #e74c3c' );
        $dropdown_button_exportar->addPostAction( "XML", new TAction(['EscalaIndividuallHeaderList', 'onExportXml'],['static' => 1]), self::$formName, 'far:file-code #95a5a6' );

        $head_left_actions->add($button_cadastrar);

        $head_right_actions->add($dropdown_button_exportar);

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Pessoas","Escalas"]));
        }

        $container->add($panel);

        parent::add($container);

    }

    public function onDelete($param = null) 
    { 
        if(isset($param['delete']) && $param['delete'] == 1)
        {
            try
            {
                // get the paramseter $key
                $key = $param['key'];
                // open a transaction with database
                TTransaction::open(self::$database);

                // instantiates object
                $object = new Escala($key, FALSE); 

                // deletes the object from the database
                $object->deleteComposite('EscalaDia', 'id_escala', $object->id);

                $object->delete();

                // close the transaction
                TTransaction::close();

                // reload the listing
                $this->onReload( $param );
                // shows the success message
                TToast::show('success', AdiantiCoreTranslator::translate('Record deleted'), 'topRight', 'far:check-circle');
            }
            catch (Exception $e) // in case of exception
            {
                // shows the exception error message
                new TMessage('error', $e->getMessage());
                // undo all pending operations
                TTransaction::rollback();
            }
        }
        else
        {
            // define the delete action
            $action = new TAction(array($this, 'onDelete'));
            $action->setParameters($param); // pass the key paramseter ahead
            $action->setParameter('delete', 1);
            // shows a dialog to the user
            new TQuestion(AdiantiCoreTranslator::translate('Do you really want to delete ?'), $action);   
        }
    }
    public function onExportCsv($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.csv';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $objects = $this->onReload();

                if ($objects)
                {
                    $handler = fopen($output, 'w');
                    TTransaction::open(self::$database);

                    foreach ($objects as $object)
                    {
                        $row = [];
                        foreach ($this->datagrid->getColumns() as $column)
                        {
                            $column_name = $column->getName();

                            if (isset($object->$column_name))
                            {
                                $row[] = is_scalar($object->$column_name) ? $object->$column_name : '';
                            }
                            else if (method_exists($object, 'render'))
                            {
                                $column_name = (strpos($column_name, '{') === FALSE) ? ( '{' . $column_name . '}') : $column_name;
                                $row[] = $object->render($column_name);
                            }
                        }

                        fputcsv($handler, $row);
                    }

                    fclose($handler);
                    TTransaction::close();
                }
                else
                {
                    throw new Exception(_t('No records found'));
                }

                TPage::openFile($output);
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public function onExportPdf($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.pdf';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $this->datagrid->prepareForPrinting();
                $this->onReload();

                $html = clone $this->datagrid;
                $contents = file_get_contents('app/resources/styles-print.html') . $html->getContents();

                $dompdf = new \Dompdf\Dompdf;
                $dompdf->loadHtml($contents);
                $dompdf->setPaper('A4', 'portrait');
                $dompdf->render();

                file_put_contents($output, $dompdf->output());

                $window = TWindow::create('PDF', 0.8, 0.8);
                $object = new TElement('object');
                $object->data  = $output;
                $object->type  = 'application/pdf';
                $object->style = "width: 100%; height:calc(100% - 10px)";

                $window->add($object);
                $window->show();
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public function onExportXml($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.xml';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $objects = $this->onReload();

                if ($objects)
                {
                    TTransaction::open(self::$database);

                    $dom = new DOMDocument('1.0', 'UTF-8');
                    $dom->{'formatOutput'} = true;
                    $dataset = $dom->appendChild( $dom->createElement('dataset') );

                    foreach ($objects as $object)
                    {
                        $row = $dataset->appendChild( $dom->createElement( self::$activeRecord ) );

                        foreach ($this->datagrid->getColumns() as $column)
                        {
                            $column_name = $column->getName();
                            $column_name_raw = str_replace(['(','{','->', '-','>','}',')', ' '], ['','','_','','','','','_'], $column_name);

                            if (isset($object->$column_name))
                            {
                                $value = is_scalar($object->$column_name) ? $object->$column_name : '';
                                $row->appendChild($dom->createElement($column_name_raw, $value)); 
                            }
                            else if (method_exists($object, 'render'))
                            {
                                $column_name = (strpos($column_name, '{') === FALSE) ? ( '{' . $column_name . '}') : $column_name;
                                $value = $object->render($column_name);
                                $row->appendChild($dom->createElement($column_name_raw, $value));
                            }
                        }
                    }

                    $dom->save($output);

                    TTransaction::close();
                }
                else
                {
                    throw new Exception(_t('No records found'));
                }

                TPage::openFile($output);
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Register the filter in the session
     */
    public function onSearch($param = null)
    {
        // get the search form data
        $data = $this->datagrid_form->getData();
        $filters = [];

        TSession::setValue(__CLASS__.'_filter_data', NULL);
        TSession::setValue(__CLASS__.'_filters', NULL);

        if (isset($data->id) AND ( (is_scalar($data->id) AND $data->id !== '') OR (is_array($data->id) AND (!empty($data->id)) )) )
        {

            $filters[] = new TFilter('id', '=', $data->id);// create the filter 
        }

        if (isset($data->id_profissional) AND ( (is_scalar($data->id_profissional) AND $data->id_profissional !== '') OR (is_array($data->id_profissional) AND (!empty($data->id_profissional)) )) )
        {

            $filters[] = new TFilter('id_profissional', '=', $data->id_profissional);// create the filter 
        }

        if (isset($data->id_unidade_saude) AND ( (is_scalar($data->id_unidade_saude) AND $data->id_unidade_saude !== '') OR (is_array($data->id_unidade_saude) AND (!empty($data->id_unidade_saude)) )) )
        {

            $filters[] = new TFilter('id_unidade_saude', '=', $data->id_unidade_saude);// create the filter 
        }

        if (isset($data->procedimento_descricao_procedimento) AND ( (is_scalar($data->procedimento_descricao_procedimento) AND $data->procedimento_descricao_procedimento !== '') OR (is_array($data->procedimento_descricao_procedimento) AND (!empty($data->procedimento_descricao_procedimento)) )) )
        {

            $filters[] = new TFilter('id_procedimento', '=', $data->procedimento_descricao_procedimento);// create the filter 
        }

        if (isset($data->id_turno) AND ( (is_scalar($data->id_turno) AND $data->id_turno !== '') OR (is_array($data->id_turno) AND (!empty($data->id_turno)) )) )
        {

            $filters[] = new TFilter('id_turno', '=', $data->id_turno);// create the filter 
        }

        if (isset($data->qtd_primeira_vez) AND ( (is_scalar($data->qtd_primeira_vez) AND $data->qtd_primeira_vez !== '') OR (is_array($data->qtd_primeira_vez) AND (!empty($data->qtd_primeira_vez)) )) )
        {

            $filters[] = new TFilter('qtd_primeira_vez', '=', $data->qtd_primeira_vez);// create the filter 
        }

        // fill the form with data again
        $this->datagrid_form->setData($data);

        // keep the search data in the session
        TSession::setValue(__CLASS__.'_filter_data', $data);
        TSession::setValue(__CLASS__.'_filters', $filters);

        if (isset($param['static']) && ($param['static'] == '1') )
        {
            $class = get_class($this);
            $onReloadParam = ['offset' => 0, 'first_page' => 1];
            AdiantiCoreApplication::loadPage($class, 'onReload', $onReloadParam);
        }
        else
        {
            $this->onReload(['offset' => 0, 'first_page' => 1]);
        }
    }

    /**
     * Load the datagrid with data
     */
    public function onReload($param = NULL)
    {
        try
        {
            // open a transaction with database 'reabilitar'
            TTransaction::open(self::$database);

            // creates a repository for Escala
            $repository = new TRepository(self::$activeRecord);

            $criteria = clone $this->filter_criteria;

            if(!self::$activeRecord::countObjects($criteria))
            {
                $this->datagrid_form->style = 'display:none !important';
                if(!empty($this->datagridPanel->getChildren()[2]))
                {
                    $this->datagridPanel->getChildren()[2]->style = 'display:none !important';
                }
                $noRecordsMessage = <<<HTML
                Nenhuma escala cadastrada.
HTML;

                $this->datagridPanel->add($noRecordsMessage);
                TTransaction::close();
                $this->loaded = true;
                return [];
            }

            if (empty($param['order']))
            {
                $param['order'] = 'id';    
            }
            if (empty($param['direction']))
            {
                $param['direction'] = 'asc';
            }

            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $this->limit);

            if($filters = TSession::getValue(__CLASS__.'_filters'))
            {
                foreach ($filters as $filter) 
                {
                    $criteria->add($filter);       
                }
            }

            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);

            $this->datagrid->clear();
            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {

                    $row = $this->datagrid->addItem($object);
                    $row->id = "row_{$object->id}";

                }
            }

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            $this->pageNavigation->setCount($count); // count of records
            $this->pageNavigation->setProperties($param); // order, page
            $this->pageNavigation->setLimit($this->limit); // limit

            // close the transaction
            TTransaction::close();
            $this->loaded = true;

            return $objects;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    public function onShow($param = null)
    {

    }

    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        // check if the datagrid is already loaded
        if (!$this->loaded AND (!isset($_GET['method']) OR !(in_array($_GET['method'],  $this->showMethods))) )
        {
            if (func_num_args() > 0)
            {
                $this->onReload( func_get_arg(0) );
            }
            else
            {
                $this->onReload();
            }
        }
        parent::show();
    }

}

