<?php

class EscalaMultidisciplinarForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'Escala';
    private static $primaryKey = 'id';
    private static $formName = 'form_Escala';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Cadastro de Escala Multidisciplinar");

        $criteria_id_unidade_saude = new TCriteria();
        $criteria_id_procedimento = new TCriteria();

        $filterVar = "%MULTIDISCIPLINAR%";
        $criteria_id_procedimento->add(new TFilter('descricao_procedimento', 'like', "%{$filterVar}%")); 

        $id = new TEntry('id');
        $id_equipe = new TDBCombo('id_equipe', 'reabilitar', 'Equipe', 'id', '{nome}','id asc'  );
        $id_unidade_saude = new TDBCombo('id_unidade_saude', 'reabilitar', 'UnidadeSaude', 'id', '{nome}','id asc' , $criteria_id_unidade_saude );
        $id_procedimento = new TDBCombo('id_procedimento', 'reabilitar', 'Procedimento', 'id', '{descricao_procedimento}','id asc' , $criteria_id_procedimento );
        $qtd_primeira_vez = new TNumeric('qtd_primeira_vez', '0', ',', '.', true, true );
        $qtd_retorno = new TNumeric('qtd_retorno', '0', ',', '.' );
        $id_turno = new TDBCombo('id_turno', 'reabilitar', 'Turno', 'id', '{nome}','id asc'  );
        $data_limite = new TDate('data_limite');
        $dias_escala = new TCheckGroup('dias_escala');
        $encaixe = new TRadioGroup('encaixe');

        $id_equipe->addValidation("Selecione a equipe.", new TRequiredValidator()); 
        $id_unidade_saude->addValidation("Informe a unidade de atendimento", new TRequiredValidator()); 
        $qtd_primeira_vez->addValidation("Informe a quantidade máxima de agendamento para a escala.", new TRequiredValidator()); 
        $data_limite->addValidation("Informe a data limite de abertura da agenda", new TRequiredValidator()); 
        $dias_escala->addValidation("Selecione os dias da escala", new TRequiredValidator()); 
        $encaixe->addValidation("encaixe", new TRequiredValidator()); 

        $id->setEditable(false);
        $id_equipe->setDefaultOption(false);
        $data_limite->setMask('dd/mm/yyyy');
        $data_limite->setDatabaseMask('yyyy-mm-dd');

        $encaixe->addItems(['1'=>' SIM','2'=>' NÃO']);
        $dias_escala->addItems(['1'=>'Segunda-Feira','2'=>'Terça-Feira','3'=>'Quarta-Feira','4'=>'Quinta-Feira','5'=>'Sexta-Feira','6'=>'Sábado','0'=>'Domingo']);

        $encaixe->setLayout('horizontal');
        $dias_escala->setLayout('horizontal');

        $encaixe->setBreakItems(1);
        $dias_escala->setBreakItems(1);

        $id->setSize(100);
        $encaixe->setSize(80);
        $id_turno->setSize('100%');
        $id_equipe->setSize('100%');
        $qtd_retorno->setSize('27%');
        $data_limite->setSize('100%');
        $dias_escala->setSize('100%');
        $id_procedimento->setSize('100%');
        $qtd_primeira_vez->setSize('27%');
        $id_unidade_saude->setSize('100%');

        $row1 = $this->form->addFields([new TLabel("Código da Escala:", null, '14px', null)],[$id]);
        $row2 = $this->form->addFields([new TLabel("Equipe:", '#ff0000', '14px', null)],[$id_equipe]);
        $row3 = $this->form->addFields([new TLabel("Unidade de Atendimento:", '#ff0000', '14px', null)],[$id_unidade_saude]);
        $row4 = $this->form->addFields([new TLabel("Procedimento:", '#FF0000', '14px', null)],[$id_procedimento]);
        $row5 = $this->form->addFields([new TLabel("Qtd. 1ª Vez:", '#ff0000', '14px', null)],[$qtd_primeira_vez],[new TLabel("Qtd. Retorno:", '#ff0000', '14px', null)],[$qtd_retorno]);
        $row6 = $this->form->addFields([new TLabel("Turno", '#ff0000', '14px', null)],[$id_turno],[new TLabel("Data Limite Agenda:", '#ff0000', '14px', null)],[$data_limite]);
        $row7 = $this->form->addFields([new TLabel("Dias:", '#ff0000', '14px', null)],[$dias_escala],[new TLabel("Permitir Encaixe:", '#ff0000', '14px', null)],[$encaixe]);
        $row8 = $this->form->addContent([new TFormSeparator("", '#333333', '18', '#eeeeee')]);

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave']), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-primary'); 

        $btn_onclear = $this->form->addAction("Limpar formulário", new TAction([$this, 'onClear']), 'fas:eraser #dd5a43');
        $this->btn_onclear = $btn_onclear;

        $btn_onshow = $this->form->addAction("Voltar", new TAction(['EscalaMultidisciplinarHeaderList', 'onShow']), 'fas:arrow-left #000000');
        $this->btn_onshow = $btn_onshow;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Pessoas","Cadastro de escala multidisciplinar"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $object = new Escala(); // create an empty object 

            $data = $this->form->getData(); // get form data as array
            $object->fromArray( (array) $data); // load the object with data

            $object->store(); // save the object 

            $repository = EscalaDia::where('id_escala', '=', $object->id);
            $repository->delete(); 

            if ($data->dias_escala) 
            {
                foreach ($data->dias_escala as $dias_escala_value) 
                {
                    $escala_dia = new EscalaDia;

                    $escala_dia->dia_semana = $dias_escala_value;
                    $escala_dia->id_escala = $object->id;
                    $escala_dia->store();
                }
            }

            $loadPageParam = [];

            if(!empty($param['target_container']))
            {
                $loadPageParam['target_container'] = $param['target_container'];
            }

            // get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction

            TToast::show('success', "Registro salvo", 'topRight', 'far:check-circle');
            TApplication::loadPage('EscalaMultidisciplinarHeaderList', 'onShow', $loadPageParam); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode> 

            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new Escala($key); // instantiates the Active Record 

                $object->dias_escala = EscalaDia::where('id_escala', '=', $object->id)->getIndexedArray('dia_semana', 'dia_semana');

                $this->form->setData($object); // fill the form 

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

    }

    public function onShow($param = null)
    {

    } 

}

