<?php

class PacienteForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'Paciente';
    private static $primaryKey = 'id';
    private static $formName = 'form_Paciente';

    use BuilderMasterDetailTrait;

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Cadastro de Usuário");


        $id = new TEntry('id');
        $mf_paciente = new TEntry('mf_paciente');
        $cpf = new TEntry('cpf');
        $cns_paciente = new TEntry('cns_paciente');
        $nome_paciente = new TEntry('nome_paciente');
        $data_nascimento = new TDate('data_nascimento');
        $sexo_paciente = new TCombo('sexo_paciente');
        $mae_paciente = new TEntry('mae_paciente');
        $pai_paciente = new TEntry('pai_paciente');
        $telefone = new TEntry('telefone');
        $celular_paciente = new TEntry('celular_paciente');
        $cpf_responsavel = new TEntry('cpf_responsavel');
        $responsavel_paciente = new TEntry('responsavel_paciente');
        $naturalidade = new TEntry('naturalidade');
        $data_admissao = new TDate('data_admissao');
        $flg_externo = new TCheckGroup('flg_externo');
        $endereco_paciente_paciente_cep_logradouro = new TEntry('endereco_paciente_paciente_cep_logradouro');
        $endereco_paciente_paciente_id = new THidden('endereco_paciente_paciente_id');
        $endereco_paciente_paciente_id_tipo = new TDBCombo('endereco_paciente_paciente_id_tipo', 'reabilitar', 'TipoLogradouro', 'id', '{descricao}','id asc'  );
        $endereco_paciente_paciente_logradouro = new TEntry('endereco_paciente_paciente_logradouro');
        $endereco_paciente_paciente_num_logradouro = new TEntry('endereco_paciente_paciente_num_logradouro');
        $endereco_paciente_paciente_id_estado = new TDBCombo('endereco_paciente_paciente_id_estado', 'reabilitar', 'Estado', 'id', '{nome_estado}','id asc'  );
        $endereco_paciente_paciente_id_cidade = new TCombo('endereco_paciente_paciente_id_cidade');
        $endereco_paciente_paciente_id_bairro = new TCombo('endereco_paciente_paciente_id_bairro');
        $endereco_paciente_paciente_complemento = new TEntry('endereco_paciente_paciente_complemento');
        $endereco_paciente_paciente_ponto_referencia = new TEntry('endereco_paciente_paciente_ponto_referencia');
        $button_adicionar_endereco_paciente_paciente = new TButton('button_adicionar_endereco_paciente_paciente');
        $paciente_cid10_paciente_id_cid = new TDBCombo('paciente_cid10_paciente_id_cid', 'reabilitar', 'Cid10', 'id', '{descricao_cid}','id asc'  );
        $paciente_cid10_paciente_id = new THidden('paciente_cid10_paciente_id');
        $paciente_cid10_paciente_id_tipo_cid = new TDBRadioGroup('paciente_cid10_paciente_id_tipo_cid', 'reabilitar', 'TipoCid', 'id', '{descricao}','id asc'  );
        $button_adicionar_paciente_cid10_paciente = new TButton('button_adicionar_paciente_cid10_paciente');

        $endereco_paciente_paciente_id_estado->setChangeAction(new TAction([$this,'onChangeendereco_paciente_paciente_id_estado']));
        $endereco_paciente_paciente_id_cidade->setChangeAction(new TAction([$this,'onChangeendereco_paciente_paciente_id_cidade']));

        $mf_paciente->addValidation("MF", new TRequiredValidator()); 
        $nome_paciente->addValidation("Nome", new TRequiredValidator()); 
        $mae_paciente->addValidation("Mae", new TRequiredValidator()); 
        $telefone->addValidation("Telefone", new TRequiredValidator()); 
        $data_admissao->addValidation("Data nascimento", new TRequiredValidator()); 

        $flg_externo->setValueSeparator(',');
        $id->setEditable(false);
        $data_admissao->setDatabaseMask('yyyy-mm-dd');
        $data_nascimento->setDatabaseMask('yyyy-mm-dd');

        $flg_externo->addItems(['1'=>'SIM']);
        $sexo_paciente->addItems(['1'=>' FEMININO','2'=>' MASCULINO']);

        $flg_externo->setLayout('horizontal');
        $paciente_cid10_paciente_id_tipo_cid->setLayout('horizontal');

        $button_adicionar_paciente_cid10_paciente->setAction(new TAction([$this, 'onAddDetailPacienteCid10Paciente'],['static' => 1]), "Adicionar");
        $button_adicionar_endereco_paciente_paciente->setAction(new TAction([$this, 'onAddDetailEnderecoPacientePaciente'],['static' => 1]), "Adicionar");

        $button_adicionar_paciente_cid10_paciente->addStyleClass('btn-default');
        $button_adicionar_endereco_paciente_paciente->addStyleClass('btn-default');

        $button_adicionar_paciente_cid10_paciente->setImage('fas:plus #2ecc71');
        $button_adicionar_endereco_paciente_paciente->setImage('fas:plus #2ecc71');

        $button_adicionar_paciente_cid10_paciente->id = '61cd9d953ae74';
        $button_adicionar_endereco_paciente_paciente->id = '60742b5a5fb44';

        $cpf->setMask('999.999.999-99');
        $telefone->setMask('(99)9 9999-9999');
        $data_admissao->setMask('dd/mm/yyyy');
        $data_nascimento->setMask('dd/mm/yyyy');
        $cpf_responsavel->setMask('999.999.999-99');
        $celular_paciente->setMask('(99)9 9999-9999');
        $endereco_paciente_paciente_cep_logradouro->setMask('99.999-999');

        $cpf->setMaxLength(14);
        $telefone->setMaxLength(15);
        $mae_paciente->setMaxLength(50);
        $nome_paciente->setMaxLength(50);
        $endereco_paciente_paciente_logradouro->setMaxLength(50);
        $endereco_paciente_paciente_complemento->setMaxLength(50);
        $endereco_paciente_paciente_cep_logradouro->setMaxLength(10);

        $mae_paciente->forceUpperCase();
        $pai_paciente->forceUpperCase();
        $naturalidade->forceUpperCase();
        $nome_paciente->forceUpperCase();
        $responsavel_paciente->forceUpperCase();
        $endereco_paciente_paciente_logradouro->forceUpperCase();
        $endereco_paciente_paciente_complemento->forceUpperCase();
        $endereco_paciente_paciente_ponto_referencia->forceUpperCase();

        $id->setSize(100);
        $cpf->setSize('100%');
        $telefone->setSize('100%');
        $flg_externo->setSize('100%');
        $mf_paciente->setSize('100%');
        $cns_paciente->setSize('100%');
        $naturalidade->setSize('100%');
        $mae_paciente->setSize('100%');
        $pai_paciente->setSize('100%');
        $data_admissao->setSize('100%');
        $sexo_paciente->setSize('100%');
        $nome_paciente->setSize('100%');
        $data_nascimento->setSize('100%');
        $cpf_responsavel->setSize('100%');
        $celular_paciente->setSize('100%');
        $responsavel_paciente->setSize('100%');
        $paciente_cid10_paciente_id->setSize(200);
        $endereco_paciente_paciente_id->setSize(200);
        $paciente_cid10_paciente_id_cid->setSize('100%');
        $endereco_paciente_paciente_id_tipo->setSize('100%');
        $paciente_cid10_paciente_id_tipo_cid->setSize('100%');
        $endereco_paciente_paciente_id_estado->setSize('100%');
        $endereco_paciente_paciente_id_cidade->setSize('100%');
        $endereco_paciente_paciente_id_bairro->setSize('100%');
        $endereco_paciente_paciente_logradouro->setSize('100%');
        $endereco_paciente_paciente_complemento->setSize('100%');
        $endereco_paciente_paciente_cep_logradouro->setSize('50%');
        $endereco_paciente_paciente_num_logradouro->setSize('100%');
        $endereco_paciente_paciente_ponto_referencia->setSize('100%');

        $this->form->appendPage("Dados Básicos");

        $this->form->addFields([new THidden('current_tab')]);
        $this->form->setTabFunction("$('[name=current_tab]').val($(this).attr('data-current_page'));");

        $row1 = $this->form->addFields([new TLabel("Id:", null, '14px', null)],[$id],[new TLabel("MF:", '#ff0000', '14px', null)],[$mf_paciente]);
        $row2 = $this->form->addFields([new TLabel("CPF:", '#ff0000', '14px', null)],[$cpf],[new TLabel("CNS do Paciente:", null, '14px', null)],[$cns_paciente]);
        $row3 = $this->form->addFields([new TLabel("Nome:", '#ff0000', '14px', null)],[$nome_paciente]);
        $row4 = $this->form->addFields([new TLabel("Data de Nascimento:", '#ff0000', '14px', null)],[$data_nascimento],[new TLabel("Sexo:", '#ff0000', '14px', null)],[$sexo_paciente]);
        $row5 = $this->form->addFields([new TLabel("Mãe:", '#ff0000', '14px', null)],[$mae_paciente],[new TLabel("Pai:", null, '14px', null)],[$pai_paciente]);
        $row6 = $this->form->addFields([new TLabel("Telefone:", '#ff0000', '14px', null)],[$telefone],[new TLabel("Celular:", '#ff0000', '14px', null)],[$celular_paciente]);
        $row7 = $this->form->addFields([new TLabel("CPF Responsável:", null, '14px', null)],[$cpf_responsavel],[new TLabel("Responsável:", null, '14px', null)],[$responsavel_paciente]);
        $row8 = $this->form->addFields([new TLabel("Naturalidade:", '#ff0000', '14px', null)],[$naturalidade],[new TLabel("Data de Admissão:", '#ff0000', '14px', null)],[$data_admissao]);
        $row9 = $this->form->addFields([new TLabel("Paciente Externo:", null, '14px', null)],[$flg_externo],[],[]);

        $this->form->appendPage("Endereço do Paciente");

        $this->detailFormEnderecoPacientePaciente = new BootstrapFormBuilder('detailFormEnderecoPacientePaciente');
        $this->detailFormEnderecoPacientePaciente->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormEnderecoPacientePaciente->setProperty('class', 'form-horizontal builder-detail-form');

        $row10 = $this->detailFormEnderecoPacientePaciente->addFields([new TLabel("CEP:", '#ff0000', '14px', null)],[$endereco_paciente_paciente_cep_logradouro],[$endereco_paciente_paciente_id],[]);
        $row11 = $this->detailFormEnderecoPacientePaciente->addFields([new TLabel("Tipo Logradouro:", '#ff0000', '14px', null)],[$endereco_paciente_paciente_id_tipo],[],[]);
        $row12 = $this->detailFormEnderecoPacientePaciente->addFields([new TLabel("Logradouro:", '#ff0000', '14px', null)],[$endereco_paciente_paciente_logradouro]);
        $row13 = $this->detailFormEnderecoPacientePaciente->addFields([new TLabel("Número:", '#ff0000', '14px', null)],[$endereco_paciente_paciente_num_logradouro],[new TLabel("Estado:", '#ff0000', '14px', null)],[$endereco_paciente_paciente_id_estado]);
        $row14 = $this->detailFormEnderecoPacientePaciente->addFields([new TLabel("Cidade:", '#ff0000', '14px', null)],[$endereco_paciente_paciente_id_cidade],[new TLabel("Bairro:", '#ff0000', '14px', null)],[$endereco_paciente_paciente_id_bairro]);
        $row15 = $this->detailFormEnderecoPacientePaciente->addFields([new TLabel("Complemento:", null, '14px', null)],[$endereco_paciente_paciente_complemento]);
        $row16 = $this->detailFormEnderecoPacientePaciente->addFields([new TLabel("Ponto Referência:", null, '14px', null)],[$endereco_paciente_paciente_ponto_referencia]);
        $row17 = $this->detailFormEnderecoPacientePaciente->addFields([$button_adicionar_endereco_paciente_paciente]);
        $row17->layout = [' col-sm-12'];

        $row18 = $this->detailFormEnderecoPacientePaciente->addFields([new THidden('endereco_paciente_paciente__row__id')]);
        $this->endereco_paciente_paciente_criteria = new TCriteria();

        $this->endereco_paciente_paciente_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->endereco_paciente_paciente_list->disableHtmlConversion();;
        $this->endereco_paciente_paciente_list->generateHiddenFields();
        $this->endereco_paciente_paciente_list->setId('endereco_paciente_paciente_list');

        $this->endereco_paciente_paciente_list->style = 'width:100%';
        $this->endereco_paciente_paciente_list->class .= ' table-bordered';

        $column_endereco_paciente_paciente_cep_logradouro = new TDataGridColumn('cep_logradouro', "CEP", 'center');
        $column_endereco_paciente_paciente_tipo_descricao = new TDataGridColumn('tipo->descricao', "Tipo", 'center');
        $column_endereco_paciente_paciente_logradouro = new TDataGridColumn('logradouro', "Logradouro", 'left');
        $column_endereco_paciente_paciente_num_logradouro = new TDataGridColumn('num_logradouro', "Núm.", 'center');
        $column_endereco_paciente_paciente_estado_nome_estado = new TDataGridColumn('estado->nome_estado', "Estado", 'left');
        $column_endereco_paciente_paciente_cidade_nome_cidade = new TDataGridColumn('cidade->nome_cidade', "Cidade", 'left');
        $column_endereco_paciente_paciente_bairro_nome_bairro = new TDataGridColumn('bairro->nome_bairro', "Bairro", 'left');

        $column_endereco_paciente_paciente__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_endereco_paciente_paciente__row__data->setVisibility(false);

        $action_onEditDetailEnderecoPaciente = new TDataGridAction(array('PacienteForm', 'onEditDetailEnderecoPaciente'));
        $action_onEditDetailEnderecoPaciente->setUseButton(false);
        $action_onEditDetailEnderecoPaciente->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailEnderecoPaciente->setLabel("Editar");
        $action_onEditDetailEnderecoPaciente->setImage('far:edit #478fca');
        $action_onEditDetailEnderecoPaciente->setFields(['__row__id', '__row__data']);

        $this->endereco_paciente_paciente_list->addAction($action_onEditDetailEnderecoPaciente);
        $action_onDeleteDetailEnderecoPaciente = new TDataGridAction(array('PacienteForm', 'onDeleteDetailEnderecoPaciente'));
        $action_onDeleteDetailEnderecoPaciente->setUseButton(false);
        $action_onDeleteDetailEnderecoPaciente->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailEnderecoPaciente->setLabel("Excluir");
        $action_onDeleteDetailEnderecoPaciente->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailEnderecoPaciente->setFields(['__row__id', '__row__data']);

        $this->endereco_paciente_paciente_list->addAction($action_onDeleteDetailEnderecoPaciente);

        $this->endereco_paciente_paciente_list->addColumn($column_endereco_paciente_paciente_cep_logradouro);
        $this->endereco_paciente_paciente_list->addColumn($column_endereco_paciente_paciente_tipo_descricao);
        $this->endereco_paciente_paciente_list->addColumn($column_endereco_paciente_paciente_logradouro);
        $this->endereco_paciente_paciente_list->addColumn($column_endereco_paciente_paciente_num_logradouro);
        $this->endereco_paciente_paciente_list->addColumn($column_endereco_paciente_paciente_estado_nome_estado);
        $this->endereco_paciente_paciente_list->addColumn($column_endereco_paciente_paciente_cidade_nome_cidade);
        $this->endereco_paciente_paciente_list->addColumn($column_endereco_paciente_paciente_bairro_nome_bairro);

        $this->endereco_paciente_paciente_list->addColumn($column_endereco_paciente_paciente__row__data);

        $this->endereco_paciente_paciente_list->createModel();
        $this->detailFormEnderecoPacientePaciente->addContent([$this->endereco_paciente_paciente_list]);

        $row19 = $this->form->addFields([$this->detailFormEnderecoPacientePaciente]);
        $row19->layout = [' col-sm-12'];

        $this->form->appendPage("CID");

        $this->detailFormPacienteCid10Paciente = new BootstrapFormBuilder('detailFormPacienteCid10Paciente');
        $this->detailFormPacienteCid10Paciente->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormPacienteCid10Paciente->setProperty('class', 'form-horizontal builder-detail-form');

        $row20 = $this->detailFormPacienteCid10Paciente->addFields([new TLabel("CID:", '#ff0000', '14px', null)],[$paciente_cid10_paciente_id_cid,$paciente_cid10_paciente_id]);
        $row21 = $this->detailFormPacienteCid10Paciente->addFields([new TLabel("Tipo do CID :", '#ff0000', '14px', null)],[$paciente_cid10_paciente_id_tipo_cid]);
        $row22 = $this->detailFormPacienteCid10Paciente->addFields([$button_adicionar_paciente_cid10_paciente]);
        $row22->layout = [' col-sm-12'];

        $row23 = $this->detailFormPacienteCid10Paciente->addFields([new THidden('paciente_cid10_paciente__row__id')]);
        $this->paciente_cid10_paciente_criteria = new TCriteria();

        $this->paciente_cid10_paciente_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->paciente_cid10_paciente_list->disableHtmlConversion();;
        $this->paciente_cid10_paciente_list->generateHiddenFields();
        $this->paciente_cid10_paciente_list->setId('paciente_cid10_paciente_list');

        $this->paciente_cid10_paciente_list->style = 'width:100%';
        $this->paciente_cid10_paciente_list->class .= ' table-bordered';

        $column_paciente_cid10_paciente_tipo_cid_id = new TDataGridColumn('tipo_cid->id', "CID", 'left');
        $column_paciente_cid10_paciente_tipo_cid_descricao = new TDataGridColumn('tipo_cid->descricao', "Tipo do CID", 'left');

        $column_paciente_cid10_paciente__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_paciente_cid10_paciente__row__data->setVisibility(false);

        $action_onEditDetailPacienteCid10 = new TDataGridAction(array('PacienteForm', 'onEditDetailPacienteCid10'));
        $action_onEditDetailPacienteCid10->setUseButton(false);
        $action_onEditDetailPacienteCid10->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailPacienteCid10->setLabel("Editar");
        $action_onEditDetailPacienteCid10->setImage('far:edit #478fca');
        $action_onEditDetailPacienteCid10->setFields(['__row__id', '__row__data']);

        $this->paciente_cid10_paciente_list->addAction($action_onEditDetailPacienteCid10);
        $action_onDeleteDetailPacienteCid10 = new TDataGridAction(array('PacienteForm', 'onDeleteDetailPacienteCid10'));
        $action_onDeleteDetailPacienteCid10->setUseButton(false);
        $action_onDeleteDetailPacienteCid10->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailPacienteCid10->setLabel("Excluir");
        $action_onDeleteDetailPacienteCid10->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailPacienteCid10->setFields(['__row__id', '__row__data']);

        $this->paciente_cid10_paciente_list->addAction($action_onDeleteDetailPacienteCid10);

        $this->paciente_cid10_paciente_list->addColumn($column_paciente_cid10_paciente_tipo_cid_id);
        $this->paciente_cid10_paciente_list->addColumn($column_paciente_cid10_paciente_tipo_cid_descricao);

        $this->paciente_cid10_paciente_list->addColumn($column_paciente_cid10_paciente__row__data);

        $this->paciente_cid10_paciente_list->createModel();
        $tableResponsiveDiv = new TElement('div');
        $tableResponsiveDiv->class = 'table-responsive';
        $tableResponsiveDiv->add($this->paciente_cid10_paciente_list);
        $this->detailFormPacienteCid10Paciente->addContent([$tableResponsiveDiv]);

        $row24 = $this->form->addFields([$this->detailFormPacienteCid10Paciente]);
        $row24->layout = [' col-12 col-sm-12 col-lg-12 col-xl-12 col-md-12'];

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave'],['static' => 1]), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-primary'); 

        $btn_onclear = $this->form->addAction("Limpar formulário", new TAction([$this, 'onClear']), 'fas:eraser #dd5a43');
        $this->btn_onclear = $btn_onclear;

        $btn_onshow = $this->form->addAction("Voltar", new TAction(['PacienteHeaderList', 'onShow']), 'fas:arrow-left #000000');
        $this->btn_onshow = $btn_onshow;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Pessoas","Cadastro de paciente"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public static function onChangeendereco_paciente_paciente_id_estado($param)
    {
        try
        {

            if (isset($param['endereco_paciente_paciente_id_estado']) && $param['endereco_paciente_paciente_id_estado'])
            { 
                $criteria = TCriteria::create(['id_estado' => $param['endereco_paciente_paciente_id_estado']]);
                TDBCombo::reloadFromModel(self::$formName, 'endereco_paciente_paciente_id_cidade', 'reabilitar', 'Cidade', 'id', '{nome_cidade}', 'id asc', $criteria, TRUE); 
            } 
            else 
            { 
                TCombo::clearField(self::$formName, 'endereco_paciente_paciente_id_cidade'); 
            }  

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    } 

    public static function onChangeendereco_paciente_paciente_id_cidade($param)
    {
        try
        {

            if (isset($param['endereco_paciente_paciente_id_cidade']) && $param['endereco_paciente_paciente_id_cidade'])
            { 
                $criteria = TCriteria::create(['id_cidade' => $param['endereco_paciente_paciente_id_cidade']]);
                TDBCombo::reloadFromModel(self::$formName, 'endereco_paciente_paciente_id_bairro', 'reabilitar', 'Bairro', 'id', '{nome_bairro}', 'id asc', $criteria, TRUE); 
            } 
            else 
            { 
                TCombo::clearField(self::$formName, 'endereco_paciente_paciente_id_bairro'); 
            }  

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    } 

    public  function onAddDetailEnderecoPacientePaciente($param = null) 
    {
        try
        {
            $data = $this->form->getData();

            $errors = [];
            $requiredFields = [];
            $requiredFields["endereco_paciente_paciente_cep_logradouro"] = "Cep logradouro";
            $requiredFields["endereco_paciente_paciente_id_tipo"] = "Id tipo";
            $requiredFields["endereco_paciente_paciente_logradouro"] = "Logradouro";
            $requiredFields["endereco_paciente_paciente_num_logradouro"] = "Num logradouro";
            $requiredFields["endereco_paciente_paciente_id_estado"] = "Id estado";
            $requiredFields["endereco_paciente_paciente_id_cidade"] = "Id cidade";
            $requiredFields["endereco_paciente_paciente_id_bairro"] = "Id bairro";
            foreach($requiredFields as $keyFieldName => $labelRequired)
            {
                try
                {
                    (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                }
                catch(Exception $e)
                {
                    $errors[] = $e->getMessage() . '.';
                }
             }
             if(count($errors) > 0)
             {
                 throw new Exception(implode('<br>', $errors));
             }

            $__row__id = !empty($data->endereco_paciente_paciente__row__id) ? $data->endereco_paciente_paciente__row__id : 'b'.uniqid();

            TTransaction::open(self::$database);

            $grid_data = new EnderecoPaciente();
            $grid_data->__row__id = $__row__id;
            $grid_data->cep_logradouro = $data->endereco_paciente_paciente_cep_logradouro;
            $grid_data->id = $data->endereco_paciente_paciente_id;
            $grid_data->id_tipo = $data->endereco_paciente_paciente_id_tipo;
            $grid_data->logradouro = $data->endereco_paciente_paciente_logradouro;
            $grid_data->num_logradouro = $data->endereco_paciente_paciente_num_logradouro;
            $grid_data->id_estado = $data->endereco_paciente_paciente_id_estado;
            $grid_data->id_cidade = $data->endereco_paciente_paciente_id_cidade;
            $grid_data->id_bairro = $data->endereco_paciente_paciente_id_bairro;
            $grid_data->complemento = $data->endereco_paciente_paciente_complemento;
            $grid_data->ponto_referencia = $data->endereco_paciente_paciente_ponto_referencia;

            $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
            $__row__data['__row__id'] = $__row__id;
            $__row__data['__display__']['cep_logradouro'] =  $param['endereco_paciente_paciente_cep_logradouro'] ?? null;
            $__row__data['__display__']['id'] =  $param['endereco_paciente_paciente_id'] ?? null;
            $__row__data['__display__']['id_tipo'] =  $param['endereco_paciente_paciente_id_tipo'] ?? null;
            $__row__data['__display__']['logradouro'] =  $param['endereco_paciente_paciente_logradouro'] ?? null;
            $__row__data['__display__']['num_logradouro'] =  $param['endereco_paciente_paciente_num_logradouro'] ?? null;
            $__row__data['__display__']['id_estado'] =  $param['endereco_paciente_paciente_id_estado'] ?? null;
            $__row__data['__display__']['id_cidade'] =  $param['endereco_paciente_paciente_id_cidade'] ?? null;
            $__row__data['__display__']['id_bairro'] =  $param['endereco_paciente_paciente_id_bairro'] ?? null;
            $__row__data['__display__']['complemento'] =  $param['endereco_paciente_paciente_complemento'] ?? null;
            $__row__data['__display__']['ponto_referencia'] =  $param['endereco_paciente_paciente_ponto_referencia'] ?? null;

            $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
            $row = $this->endereco_paciente_paciente_list->addItem($grid_data);
            $row->id = $grid_data->__row__id;

            TDataGrid::replaceRowById('endereco_paciente_paciente_list', $grid_data->__row__id, $row);

            TTransaction::close();

            $data = new stdClass;
            $data->endereco_paciente_paciente_cep_logradouro = '';
            $data->endereco_paciente_paciente_id = '';
            $data->endereco_paciente_paciente_id_tipo = '';
            $data->endereco_paciente_paciente_logradouro = '';
            $data->endereco_paciente_paciente_num_logradouro = '';
            $data->endereco_paciente_paciente_id_estado = '';
            $data->endereco_paciente_paciente_id_cidade = '';
            $data->endereco_paciente_paciente_id_bairro = '';
            $data->endereco_paciente_paciente_complemento = '';
            $data->endereco_paciente_paciente_ponto_referencia = '';
            $data->endereco_paciente_paciente__row__id = '';

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#60742b5a5fb44');
               if(typeof element.attr('add') != 'undefined')
               {
                   element.html(base64_decode(element.attr('add')));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public  function onAddDetailPacienteCid10Paciente($param = null) 
    {
        try
        {
            $data = $this->form->getData();

                $errors = [];
                $requiredFields = [];
                $requiredFields["paciente_cid10_paciente_id_cid"] = "Id cid";
                $requiredFields["paciente_cid10_paciente_id_tipo_cid"] = "Tipo do CID ";
                foreach($requiredFields as $keyFieldName => $labelRequired)
                {
                    try
                    {
                        (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                    }
                    catch(Exception $e)
                    {
                        $errors[] = $e->getMessage() . '.';
                    }
                 }
                 if(count($errors) > 0)
                 {
                     throw new Exception(implode('<br>', $errors));
                 }

                $__row__id = !empty($data->paciente_cid10_paciente__row__id) ? $data->paciente_cid10_paciente__row__id : 'b'.uniqid();

                TTransaction::open(self::$database);

                $grid_data = new PacienteCid10();
                $grid_data->__row__id = $__row__id;
                $grid_data->id_cid = $data->paciente_cid10_paciente_id_cid;
                $grid_data->id = $data->paciente_cid10_paciente_id;
                $grid_data->id_tipo_cid = $data->paciente_cid10_paciente_id_tipo_cid;

                $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
                $__row__data['__row__id'] = $__row__id;
                $__row__data['__display__']['id_cid'] =  $param['paciente_cid10_paciente_id_cid'] ?? null;
                $__row__data['__display__']['id'] =  $param['paciente_cid10_paciente_id'] ?? null;
                $__row__data['__display__']['id_tipo_cid'] =  $param['paciente_cid10_paciente_id_tipo_cid'] ?? null;

                $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
                $row = $this->paciente_cid10_paciente_list->addItem($grid_data);
                $row->id = $grid_data->__row__id;

                TDataGrid::replaceRowById('paciente_cid10_paciente_list', $grid_data->__row__id, $row);

                TTransaction::close();

                $data = new stdClass;
                $data->paciente_cid10_paciente_id_cid = '';
                $data->paciente_cid10_paciente_id = '';
                $data->paciente_cid10_paciente_id_tipo_cid = '';
                $data->paciente_cid10_paciente__row__id = '';

                TForm::sendData(self::$formName, $data);
                TScript::create("
                   var element = $('#61cd9d953ae74');
                   if(typeof element.attr('add') != 'undefined')
                   {
                       element.html(base64_decode(element.attr('add')));
                   }
                ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onEditDetailEnderecoPaciente($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));
            $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

            $data = new stdClass;
            $data->endereco_paciente_paciente_cep_logradouro = $__row__data->__display__->cep_logradouro ?? null;
            $data->endereco_paciente_paciente_id = $__row__data->__display__->id ?? null;
            $data->endereco_paciente_paciente_id_tipo = $__row__data->__display__->id_tipo ?? null;
            $data->endereco_paciente_paciente_logradouro = $__row__data->__display__->logradouro ?? null;
            $data->endereco_paciente_paciente_num_logradouro = $__row__data->__display__->num_logradouro ?? null;
            $data->endereco_paciente_paciente_id_estado = $__row__data->__display__->id_estado ?? null;
            $data->endereco_paciente_paciente_id_cidade = $__row__data->__display__->id_cidade ?? null;
            $data->endereco_paciente_paciente_id_bairro = $__row__data->__display__->id_bairro ?? null;
            $data->endereco_paciente_paciente_complemento = $__row__data->__display__->complemento ?? null;
            $data->endereco_paciente_paciente_ponto_referencia = $__row__data->__display__->ponto_referencia ?? null;
            $data->endereco_paciente_paciente__row__id = $__row__data->__row__id;

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#60742b5a5fb44');
               if(!element.attr('add')){
                   element.attr('add', base64_encode(element.html()));
               }
               element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
               if(!element.attr('edit')){
                   element.attr('edit', base64_encode(element.html()));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onDeleteDetailEnderecoPaciente($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));

            $data = new stdClass;
            $data->endereco_paciente_paciente_cep_logradouro = '';
            $data->endereco_paciente_paciente_id = '';
            $data->endereco_paciente_paciente_id_tipo = '';
            $data->endereco_paciente_paciente_logradouro = '';
            $data->endereco_paciente_paciente_num_logradouro = '';
            $data->endereco_paciente_paciente_id_estado = '';
            $data->endereco_paciente_paciente_id_cidade = '';
            $data->endereco_paciente_paciente_id_bairro = '';
            $data->endereco_paciente_paciente_complemento = '';
            $data->endereco_paciente_paciente_ponto_referencia = '';
            $data->endereco_paciente_paciente__row__id = '';

            TForm::sendData(self::$formName, $data);

            TDataGrid::removeRowById('endereco_paciente_paciente_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onEditDetailPacienteCid10($param = null) 
    {
        try
        {

                $__row__data = unserialize(base64_decode($param['__row__data']));
                $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

                $data = new stdClass;
                $data->paciente_cid10_paciente_id_cid = $__row__data->__display__->id_cid ?? null;
                $data->paciente_cid10_paciente_id = $__row__data->__display__->id ?? null;
                $data->paciente_cid10_paciente_id_tipo_cid = $__row__data->__display__->id_tipo_cid ?? null;
                $data->paciente_cid10_paciente__row__id = $__row__data->__row__id;

                TForm::sendData(self::$formName, $data);
                TScript::create("
                   var element = $('#61cd9d953ae74');
                   if(!element.attr('add')){
                       element.attr('add', base64_encode(element.html()));
                   }
                   element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
                   if(!element.attr('edit')){
                       element.attr('edit', base64_encode(element.html()));
                   }
                ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onDeleteDetailPacienteCid10($param = null) 
    {
        try
        {

                $__row__data = unserialize(base64_decode($param['__row__data']));

                $data = new stdClass;
                $data->paciente_cid10_paciente_id_cid = '';
                $data->paciente_cid10_paciente_id = '';
                $data->paciente_cid10_paciente_id_tipo_cid = '';
                $data->paciente_cid10_paciente__row__id = '';

                TForm::sendData(self::$formName, $data);

                TDataGrid::removeRowById('paciente_cid10_paciente_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $object = new Paciente(); // create an empty object 

            $data = $this->form->getData(); // get form data as array

            $object->fromArray( (array) $data); // load the object with data

            if (empty($data->flg_externo[0])){
              $object->flg_externo = '2';
            } else {
              $object->flg_externo = '1';    
            }

            $object->store(); // save the object 

            $this->fireEvents($object);

            TForm::sendData(self::$formName, (object)['id' => $object->id]);

            $loadPageParam = [];

            if(!empty($param['target_container']))
            {
                $loadPageParam['target_container'] = $param['target_container'];
            }

            $paciente_cid10_paciente_items = $this->storeMasterDetailItems('PacienteCid10', 'id_paciente', 'paciente_cid10_paciente', $object, $param['paciente_cid10_paciente_list___row__data'] ?? [], $this->form, $this->paciente_cid10_paciente_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            $endereco_paciente_paciente_items = $this->storeMasterDetailItems('EnderecoPaciente', 'id_paciente', 'endereco_paciente_paciente', $object, $param['endereco_paciente_paciente_list___row__data'] ?? [], $this->form, $this->endereco_paciente_paciente_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            // get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction

            TToast::show('success', "Registro salvo", 'topRight', 'far:check-circle');
            TApplication::loadPage('PacienteHeaderList', 'onShow', $loadPageParam); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode>  

            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new Paciente($key); // instantiates the Active Record 

                $paciente_cid10_paciente_items = $this->loadMasterDetailItems('PacienteCid10', 'id_paciente', 'paciente_cid10_paciente', $object, $this->form, $this->paciente_cid10_paciente_list, $this->paciente_cid10_paciente_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                }); 

                $endereco_paciente_paciente_items = $this->loadMasterDetailItems('EnderecoPaciente', 'id_paciente', 'endereco_paciente_paciente', $object, $this->form, $this->endereco_paciente_paciente_list, $this->endereco_paciente_paciente_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                    $objectItems->endereco_paciente_paciente_id_cidade = null;
                    if(isset($detailObject->id_cidade) && $detailObject->id_cidade)
                    {
                        $objectItems->__display__->id_cidade = $detailObject->id_cidade;
                    }

                    $objectItems->endereco_paciente_paciente_id_bairro = null;
                    if(isset($detailObject->id_bairro) && $detailObject->id_bairro)
                    {
                        $objectItems->__display__->id_bairro = $detailObject->id_bairro;
                    }

                    $objectItems->endereco_paciente_paciente_id_estado = null;
                    if(isset($detailObject->id_estado) && $detailObject->id_estado)
                    {
                        $objectItems->__display__->id_estado = $detailObject->id_estado;
                    }

                    $objectItems->endereco_paciente_paciente_id_cidade = null;
                    if(isset($detailObject->id_cidade) && $detailObject->id_cidade)
                    {
                        $objectItems->__display__->id_cidade = $detailObject->id_cidade;
                    }

                }); 

                $this->form->setData($object); // fill the form 

                $this->fireEvents($object);

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

    }

    public function onShow($param = null)
    {

    } 

    public function fireEvents( $object )
    {
        $obj = new stdClass;
        if(is_object($object) && get_class($object) == 'stdClass')
        {
            if(isset($object->endereco_paciente_paciente_id_estado))
            {
                $value = $object->endereco_paciente_paciente_id_estado;

                $obj->endereco_paciente_paciente_id_estado = $value;
            }
            if(isset($object->endereco_paciente_paciente_id_cidade))
            {
                $value = $object->endereco_paciente_paciente_id_cidade;

                $obj->endereco_paciente_paciente_id_cidade = $value;
            }
            if(isset($object->endereco_paciente_paciente_id_bairro))
            {
                $value = $object->endereco_paciente_paciente_id_bairro;

                $obj->endereco_paciente_paciente_id_bairro = $value;
            }
        }
        elseif(is_object($object))
        {
            if(isset($object->endereco_paciente->paciente->id_estado))
            {
                $value = $object->endereco_paciente->paciente->id_estado;

                $obj->endereco_paciente_paciente_id_estado = $value;
            }
            if(isset($object->endereco_paciente->paciente->id_cidade))
            {
                $value = $object->endereco_paciente->paciente->id_cidade;

                $obj->endereco_paciente_paciente_id_cidade = $value;
            }
            if(isset($object->endereco_paciente->paciente->id_bairro))
            {
                $value = $object->endereco_paciente->paciente->id_bairro;

                $obj->endereco_paciente_paciente_id_bairro = $value;
            }
        }
        TForm::sendData(self::$formName, $obj);
    }  

}

