<?php

class PacienteHeaderList extends TPage
{
    private $form; // form
    private $datagrid; // listing
    private $pageNavigation;
    private $loaded;
    private $filter_criteria;
    private static $database = 'reabilitar';
    private static $activeRecord = 'Paciente';
    private static $primaryKey = 'id';
    private static $formName = 'formList_Paciente';
    private $showMethods = ['onReload', 'onSearch'];
    private $limit = 20;

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct($param = null)
    {
        parent::__construct();
        // creates the form

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        $this->limit = 20;

        $id = new TEntry('id');
        $mf_paciente = new TEntry('mf_paciente');
        $cpf = new TEntry('cpf');
        $cns_paciente = new TEntry('cns_paciente');
        $nome_paciente = new TEntry('nome_paciente');
        $data_nascimento = new TEntry('data_nascimento');
        $mae_paciente = new TEntry('mae_paciente');
        $telefone = new TEntry('telefone');
        $celular_paciente = new TEntry('celular_paciente');
        $naturalidade = new TEntry('naturalidade');
        $flg_externo = new TEntry('flg_externo');

        $id->exitOnEnter();
        $mf_paciente->exitOnEnter();
        $cpf->exitOnEnter();
        $cns_paciente->exitOnEnter();
        $nome_paciente->exitOnEnter();
        $data_nascimento->exitOnEnter();
        $mae_paciente->exitOnEnter();
        $telefone->exitOnEnter();
        $celular_paciente->exitOnEnter();
        $naturalidade->exitOnEnter();
        $flg_externo->exitOnEnter();

        $id->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $mf_paciente->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $cpf->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $cns_paciente->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $nome_paciente->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $data_nascimento->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $mae_paciente->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $telefone->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $celular_paciente->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $naturalidade->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));
        $flg_externo->setExitAction(new TAction([$this, 'onSearch'], ['static'=>'1']));

        $cpf->setMask('999.999.999-99');
        $telefone->setMask('(99)9 9999-9999');
        $data_nascimento->setMask('99/99/9999');

        $cpf->forceUpperCase();
        $mae_paciente->forceUpperCase();
        $nome_paciente->forceUpperCase();

        $id->setSize('100%');
        $cpf->setSize('100%');
        $telefone->setSize('100%');
        $mf_paciente->setSize('100%');
        $flg_externo->setSize('100%');
        $cns_paciente->setSize('100%');
        $mae_paciente->setSize('100%');
        $naturalidade->setSize('100%');
        $nome_paciente->setSize('100%');
        $data_nascimento->setSize('100%');
        $celular_paciente->setSize('100%');


        // creates a Datagrid
        $this->datagrid = new TDataGrid;
        $this->datagrid->disableHtmlConversion();

        $this->datagrid_form = new TForm(self::$formName);
        $this->datagrid_form->onsubmit = 'return false';

        $this->datagrid = new BootstrapDatagridWrapper($this->datagrid);
        $this->filter_criteria = new TCriteria;

        $this->datagrid->style = 'width: 100%';
        $this->datagrid->setHeight(320);

        $column_id = new TDataGridColumn('id', "Cód. Paciente", 'center' , '49px');
        $column_mf_paciente = new TDataGridColumn('mf_paciente', "MF", 'left');
        $column_cpf = new TDataGridColumn('cpf', "CPF", 'center');
        $column_cns_paciente = new TDataGridColumn('cns_paciente', "CNS", 'left');
        $column_nome_paciente_transformed = new TDataGridColumn('nome_paciente', "Paciente", 'left');
        $column_data_nascimento = new TDataGridColumn('data_nascimento', "Data Nasc.", 'center');
        $column_mae_paciente = new TDataGridColumn('mae_paciente', "Mae", 'left');
        $column_telefone = new TDataGridColumn('telefone', "Telefone", 'center');
        $column_celular_paciente = new TDataGridColumn('celular_paciente', "Celular", 'left');
        $column_naturalidade = new TDataGridColumn('naturalidade', "Naturalidade", 'left');
        $column_flg_externo_transformed = new TDataGridColumn('flg_externo', "Pac. Externo", 'center');

        $column_nome_paciente_transformed->setTransformer(function($value, $object, $row) 
        {
            if($value)
            {
                return mb_strtoupper($value);
            }
        });

        $column_flg_externo_transformed->setTransformer(function($value, $object, $row) 
        {
            if($value === true || $value == 't' || $value === 1 || $value == '1' || $value == 's' || $value == 'S' || $value == 'T')
                return 'Sim';

            return 'Não';

        });        

        $order_id = new TAction(array($this, 'onReload'));
        $order_id->setParameter('order', 'id');
        $column_id->setAction($order_id);

        $this->datagrid->addColumn($column_id);
        $this->datagrid->addColumn($column_mf_paciente);
        $this->datagrid->addColumn($column_cpf);
        $this->datagrid->addColumn($column_cns_paciente);
        $this->datagrid->addColumn($column_nome_paciente_transformed);
        $this->datagrid->addColumn($column_data_nascimento);
        $this->datagrid->addColumn($column_mae_paciente);
        $this->datagrid->addColumn($column_telefone);
        $this->datagrid->addColumn($column_celular_paciente);
        $this->datagrid->addColumn($column_naturalidade);
        $this->datagrid->addColumn($column_flg_externo_transformed);

        $action_onEdit = new TDataGridAction(array('PacienteForm', 'onEdit'));
        $action_onEdit->setUseButton(false);
        $action_onEdit->setButtonClass('btn btn-default btn-sm');
        $action_onEdit->setLabel("Editar");
        $action_onEdit->setImage('far:edit #478fca');
        $action_onEdit->setField(self::$primaryKey);

        $this->datagrid->addAction($action_onEdit);

        $action_onDelete = new TDataGridAction(array('PacienteHeaderList', 'onDelete'));
        $action_onDelete->setUseButton(false);
        $action_onDelete->setButtonClass('btn btn-default btn-sm');
        $action_onDelete->setLabel("Excluir");
        $action_onDelete->setImage('fas:trash-alt #dd5a43');
        $action_onDelete->setField(self::$primaryKey);

        $this->datagrid->addAction($action_onDelete);

        $action_onGenerate = new TDataGridAction(array('VwFichaPacienteDocument', 'onGenerate'));
        $action_onGenerate->setUseButton(false);
        $action_onGenerate->setButtonClass('btn btn-default btn-sm');
        $action_onGenerate->setLabel("");
        $action_onGenerate->setImage('fas:print #000000');
        $action_onGenerate->setField(self::$primaryKey);

        $action_onGenerate->setParameter('key', '{id}');
        $this->datagrid->addAction($action_onGenerate);

        // create the datagrid model
        $this->datagrid->createModel();

        $tr = new TElement('tr');
        $this->datagrid->prependRow($tr);

        $tr->add(TElement::tag('td', ''));
        $tr->add(TElement::tag('td', ''));
        $tr->add(TElement::tag('td', ''));
        $td_id = TElement::tag('td', $id);
        $tr->add($td_id);
        $td_mf_paciente = TElement::tag('td', $mf_paciente);
        $tr->add($td_mf_paciente);
        $td_cpf = TElement::tag('td', $cpf);
        $tr->add($td_cpf);
        $td_cns_paciente = TElement::tag('td', $cns_paciente);
        $tr->add($td_cns_paciente);
        $td_nome_paciente = TElement::tag('td', $nome_paciente);
        $tr->add($td_nome_paciente);
        $td_data_nascimento = TElement::tag('td', $data_nascimento);
        $tr->add($td_data_nascimento);
        $td_mae_paciente = TElement::tag('td', $mae_paciente);
        $tr->add($td_mae_paciente);
        $td_telefone = TElement::tag('td', $telefone);
        $tr->add($td_telefone);
        $td_celular_paciente = TElement::tag('td', $celular_paciente);
        $tr->add($td_celular_paciente);
        $td_naturalidade = TElement::tag('td', $naturalidade);
        $tr->add($td_naturalidade);
        $td_flg_externo = TElement::tag('td', $flg_externo);
        $tr->add($td_flg_externo);

        $this->datagrid_form->addField($id);
        $this->datagrid_form->addField($mf_paciente);
        $this->datagrid_form->addField($cpf);
        $this->datagrid_form->addField($cns_paciente);
        $this->datagrid_form->addField($nome_paciente);
        $this->datagrid_form->addField($data_nascimento);
        $this->datagrid_form->addField($mae_paciente);
        $this->datagrid_form->addField($telefone);
        $this->datagrid_form->addField($celular_paciente);
        $this->datagrid_form->addField($naturalidade);
        $this->datagrid_form->addField($flg_externo);

        $this->datagrid_form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        // creates the page navigation
        $this->pageNavigation = new TPageNavigation;
        $this->pageNavigation->enableCounters();
        $this->pageNavigation->setAction(new TAction(array($this, 'onReload')));
        $this->pageNavigation->setWidth($this->datagrid->getWidth());

        $panel = new TPanelGroup("Listagem de Usuários");
        $panel->datagrid = 'datagrid-container';
        $this->datagridPanel = $panel;
        $panel->getBody()->class .= ' table-responsive';

        $panel->addFooter($this->pageNavigation);

        $headerActions = new TElement('div');
        $headerActions->class = ' datagrid-header-actions ';

        $head_left_actions = new TElement('div');
        $head_left_actions->class = ' datagrid-header-actions-left-actions ';

        $head_right_actions = new TElement('div');
        $head_right_actions->class = ' datagrid-header-actions-left-actions ';

        $headerActions->add($head_left_actions);
        $headerActions->add($head_right_actions);

        $this->datagrid_form->add($this->datagrid);
        $panel->add($headerActions);
        $panel->add($this->datagrid_form);

        $button_cadastrar = new TButton('button_button_cadastrar');
        $button_cadastrar->setAction(new TAction(['PacienteForm', 'onShow']), "Cadastrar");
        $button_cadastrar->addStyleClass('');
        $button_cadastrar->setImage('fas:plus #69aa46');
        $this->datagrid_form->addField($button_cadastrar);

        $dropdown_button_exportar = new TDropDown("Exportar", 'fas:file-export #2d3436');
        $dropdown_button_exportar->setPullSide('right');
        $dropdown_button_exportar->setButtonClass('btn btn-default waves-effect dropdown-toggle');
        $dropdown_button_exportar->addPostAction( "CSV", new TAction(['PacienteHeaderList', 'onExportCsv'],['static' => 1]), self::$formName, 'fas:table #00b894' );
        $dropdown_button_exportar->addPostAction( "PDF", new TAction(['PacienteHeaderList', 'onExportPdf'],['static' => 1]), self::$formName, 'far:file-pdf #e74c3c' );
        $dropdown_button_exportar->addPostAction( "XML", new TAction(['PacienteHeaderList', 'onExportXml'],['static' => 1]), self::$formName, 'far:file-code #95a5a6' );

        $head_left_actions->add($button_cadastrar);

        $head_right_actions->add($dropdown_button_exportar);

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Pessoas","Usuários"]));
        }

        $container->add($panel);

        parent::add($container);

    }

    public function onDelete($param = null) 
    { 
        if(isset($param['delete']) && $param['delete'] == 1)
        {
            try
            {
                // get the paramseter $key
                $key = $param['key'];
                // open a transaction with database
                TTransaction::open(self::$database);

                // instantiates object
                $object = new Paciente($key, FALSE); 

                // deletes the object from the database
                $object->delete();

                // close the transaction
                TTransaction::close();

                // reload the listing
                $this->onReload( $param );
                // shows the success message
                TToast::show('success', AdiantiCoreTranslator::translate('Record deleted'), 'topRight', 'far:check-circle');
            }
            catch (Exception $e) // in case of exception
            {
                // shows the exception error message
                new TMessage('error', $e->getMessage());
                // undo all pending operations
                TTransaction::rollback();
            }
        }
        else
        {
            // define the delete action
            $action = new TAction(array($this, 'onDelete'));
            $action->setParameters($param); // pass the key paramseter ahead
            $action->setParameter('delete', 1);
            // shows a dialog to the user
            new TQuestion(AdiantiCoreTranslator::translate('Do you really want to delete ?'), $action);   
        }
    }

    public function onExportCsv($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.csv';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $objects = $this->onReload();

                if ($objects)
                {
                    $handler = fopen($output, 'w');
                    TTransaction::open(self::$database);

                    foreach ($objects as $object)
                    {
                        $row = [];
                        foreach ($this->datagrid->getColumns() as $column)
                        {
                            $column_name = $column->getName();

                            if (isset($object->$column_name))
                            {
                                $row[] = is_scalar($object->$column_name) ? $object->$column_name : '';
                            }
                            else if (method_exists($object, 'render'))
                            {
                                $column_name = (strpos($column_name, '{') === FALSE) ? ( '{' . $column_name . '}') : $column_name;
                                $row[] = $object->render($column_name);
                            }
                        }

                        fputcsv($handler, $row);
                    }

                    fclose($handler);
                    TTransaction::close();
                }
                else
                {
                    throw new Exception(_t('No records found'));
                }

                TPage::openFile($output);
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public function onExportPdf($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.pdf';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $this->datagrid->prepareForPrinting();
                $this->onReload();

                $html = clone $this->datagrid;
                $contents = file_get_contents('app/resources/styles-print.html') . $html->getContents();

                $dompdf = new \Dompdf\Dompdf;
                $dompdf->loadHtml($contents);
                $dompdf->setPaper('A4', 'portrait');
                $dompdf->render();

                file_put_contents($output, $dompdf->output());

                $window = TWindow::create('PDF', 0.8, 0.8);
                $object = new TElement('object');
                $object->data  = $output;
                $object->type  = 'application/pdf';
                $object->style = "width: 100%; height:calc(100% - 10px)";

                $window->add($object);
                $window->show();
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public function onExportXml($param = null) 
    {
        try
        {
            $output = 'app/output/'.uniqid().'.xml';

            if ( (!file_exists($output) && is_writable(dirname($output))) OR is_writable($output))
            {
                $this->limit = 0;
                $objects = $this->onReload();

                if ($objects)
                {
                    TTransaction::open(self::$database);

                    $dom = new DOMDocument('1.0', 'UTF-8');
                    $dom->{'formatOutput'} = true;
                    $dataset = $dom->appendChild( $dom->createElement('dataset') );

                    foreach ($objects as $object)
                    {
                        $row = $dataset->appendChild( $dom->createElement( self::$activeRecord ) );

                        foreach ($this->datagrid->getColumns() as $column)
                        {
                            $column_name = $column->getName();
                            $column_name_raw = str_replace(['(','{','->', '-','>','}',')', ' '], ['','','_','','','','','_'], $column_name);

                            if (isset($object->$column_name))
                            {
                                $value = is_scalar($object->$column_name) ? $object->$column_name : '';
                                $row->appendChild($dom->createElement($column_name_raw, $value)); 
                            }
                            else if (method_exists($object, 'render'))
                            {
                                $column_name = (strpos($column_name, '{') === FALSE) ? ( '{' . $column_name . '}') : $column_name;
                                $value = $object->render($column_name);
                                $row->appendChild($dom->createElement($column_name_raw, $value));
                            }
                        }
                    }

                    $dom->save($output);

                    TTransaction::close();
                }
                else
                {
                    throw new Exception(_t('No records found'));
                }

                TPage::openFile($output);
            }
            else
            {
                throw new Exception(_t('Permission denied') . ': ' . $output);
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Register the filter in the session
     */
    public function onSearch($param = null)
    {
        // get the search form data
        $data = $this->datagrid_form->getData();
        $filters = [];

        TSession::setValue(__CLASS__.'_filter_data', NULL);
        TSession::setValue(__CLASS__.'_filters', NULL);

        if (isset($data->id) AND ( (is_scalar($data->id) AND $data->id !== '') OR (is_array($data->id) AND (!empty($data->id)) )) )
        {

            $filters[] = new TFilter('id', '=', $data->id);// create the filter 
        }

        if (isset($data->cpf) AND ( (is_scalar($data->cpf) AND $data->cpf !== '') OR (is_array($data->cpf) AND (!empty($data->cpf)) )) )
        {

            $filters[] = new TFilter('cpf', 'like', "%{$data->cpf}%");// create the filter 
        }

        if (isset($data->cns_paciente) AND ( (is_scalar($data->cns_paciente) AND $data->cns_paciente !== '') OR (is_array($data->cns_paciente) AND (!empty($data->cns_paciente)) )) )
        {

            $filters[] = new TFilter('cns_paciente', '=', $data->cns_paciente);// create the filter 
        }

        if (isset($data->nome_paciente) AND ( (is_scalar($data->nome_paciente) AND $data->nome_paciente !== '') OR (is_array($data->nome_paciente) AND (!empty($data->nome_paciente)) )) )
        {

            $filters[] = new TFilter('nome_paciente', 'like', "%{$data->nome_paciente}%");// create the filter 
        }

        if (isset($data->data_nascimento) AND ( (is_scalar($data->data_nascimento) AND $data->data_nascimento !== '') OR (is_array($data->data_nascimento) AND (!empty($data->data_nascimento)) )) )
        {

            $filters[] = new TFilter('data_nascimento', '=', $data->data_nascimento);// create the filter 
        }

        if (isset($data->mae_paciente) AND ( (is_scalar($data->mae_paciente) AND $data->mae_paciente !== '') OR (is_array($data->mae_paciente) AND (!empty($data->mae_paciente)) )) )
        {

            $filters[] = new TFilter('mae_paciente', 'like', "%{$data->mae_paciente}%");// create the filter 
        }

        if (isset($data->telefone) AND ( (is_scalar($data->telefone) AND $data->telefone !== '') OR (is_array($data->telefone) AND (!empty($data->telefone)) )) )
        {

            $filters[] = new TFilter('telefone', 'like', "%{$data->telefone}%");// create the filter 
        }

        if (isset($data->flg_externo) AND ( (is_scalar($data->flg_externo) AND $data->flg_externo !== '') OR (is_array($data->flg_externo) AND (!empty($data->flg_externo)) )) )
        {

            $filters[] = new TFilter('flg_externo', '=', $data->flg_externo);// create the filter 
        }

        // fill the form with data again
        $this->datagrid_form->setData($data);

        // keep the search data in the session
        TSession::setValue(__CLASS__.'_filter_data', $data);
        TSession::setValue(__CLASS__.'_filters', $filters);

        if (isset($param['static']) && ($param['static'] == '1') )
        {
            $class = get_class($this);
            $onReloadParam = ['offset' => 0, 'first_page' => 1];
            AdiantiCoreApplication::loadPage($class, 'onReload', $onReloadParam);
        }
        else
        {
            $this->onReload(['offset' => 0, 'first_page' => 1]);
        }
    }

    /**
     * Load the datagrid with data
     */
    public function onReload($param = NULL)
    {
        try
        {
            // open a transaction with database 'reabilitar'
            TTransaction::open(self::$database);

            // creates a repository for Paciente
            $repository = new TRepository(self::$activeRecord);

            $criteria = clone $this->filter_criteria;

            if(!self::$activeRecord::countObjects($criteria))
            {
                $this->datagrid_form->style = 'display:none !important';
                if(!empty($this->datagridPanel->getChildren()[2]))
                {
                    $this->datagridPanel->getChildren()[2]->style = 'display:none !important';
                }
                $noRecordsMessage = <<<HTML
                Nenhum paciente cadastrado.
HTML;

                $this->datagridPanel->add($noRecordsMessage);
                TTransaction::close();
                $this->loaded = true;
                return [];
            }

            if (empty($param['order']))
            {
                $param['order'] = 'id';    
            }
            if (empty($param['direction']))
            {
                $param['direction'] = 'desc';
            }

            $criteria->setProperties($param); // order, offset
            $criteria->setProperty('limit', $this->limit);

            if($filters = TSession::getValue(__CLASS__.'_filters'))
            {
                foreach ($filters as $filter) 
                {
                    $criteria->add($filter);       
                }
            }

            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);

            $this->datagrid->clear();
            if ($objects)
            {
                // iterate the collection of active records
                foreach ($objects as $object)
                {

                    $row = $this->datagrid->addItem($object);
                    $row->id = "row_{$object->id}";

                }
            }

            // reset the criteria for record count
            $criteria->resetProperties();
            $count= $repository->count($criteria);

            $this->pageNavigation->setCount($count); // count of records
            $this->pageNavigation->setProperties($param); // order, page
            $this->pageNavigation->setLimit($this->limit); // limit

            // close the transaction
            TTransaction::close();
            $this->loaded = true;

            return $objects;
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    public function onShow($param = null)
    {

    }

    /**
     * method show()
     * Shows the page
     */
    public function show()
    {
        // check if the datagrid is already loaded
        if (!$this->loaded AND (!isset($_GET['method']) OR !(in_array($_GET['method'],  $this->showMethods))) )
        {
            if (func_num_args() > 0)
            {
                $this->onReload( func_get_arg(0) );
            }
            else
            {
                $this->onReload();
            }
        }
        parent::show();
    }

}

