<?php

class ProfissionalForm extends TPage
{
    protected $form;
    private $formFields = [];
    private static $database = 'reabilitar';
    private static $activeRecord = 'Profissional';
    private static $primaryKey = 'id';
    private static $formName = 'form_Profissional';

    use BuilderMasterDetailTrait;

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {
        parent::__construct();

        if(!empty($param['target_container']))
        {
            $this->adianti_target_container = $param['target_container'];
        }

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);
        // define the form title
        $this->form->setFormTitle("Cadastro de profissional");


        $id = new TEntry('id');
        $matricula = new TEntry('matricula');
        $cpf = new TEntry('cpf');
        $cns_profissional = new TEntry('cns_profissional');
        $nome_profissional = new TEntry('nome_profissional');
        $telefone = new TEntry('telefone');
        $endereco_profissional_profissional_cep_logradouro = new TEntry('endereco_profissional_profissional_cep_logradouro');
        $endereco_profissional_profissional_id = new THidden('endereco_profissional_profissional_id');
        $endereco_profissional_profissional_id_tipo = new TDBCombo('endereco_profissional_profissional_id_tipo', 'reabilitar', 'TipoLogradouro', 'id', '{descricao}','id asc'  );
        $endereco_profissional_profissional_logradouro = new TEntry('endereco_profissional_profissional_logradouro');
        $endereco_profissional_profissional_num_logradouro = new TEntry('endereco_profissional_profissional_num_logradouro');
        $endereco_profissional_profissional_id_estado = new TDBCombo('endereco_profissional_profissional_id_estado', 'reabilitar', 'Estado', 'id', '{nome_estado}','id asc'  );
        $endereco_profissional_profissional_id_cidade = new TCombo('endereco_profissional_profissional_id_cidade');
        $endereco_profissional_profissional_id_bairro = new TCombo('endereco_profissional_profissional_id_bairro');
        $endereco_profissional_profissional_complemento = new TEntry('endereco_profissional_profissional_complemento');
        $endereco_profissional_profissional_ponto_referencia = new TEntry('endereco_profissional_profissional_ponto_referencia');
        $button_adicionar_endereco_profissional_profissional = new TButton('button_adicionar_endereco_profissional_profissional');
        $profissional_ocupacao_profissional_id_ocupacao = new TDBCombo('profissional_ocupacao_profissional_id_ocupacao', 'reabilitar', 'Ocupacao', 'id', '{descricao_ocupacao}','id asc'  );
        $profissional_ocupacao_profissional_id = new THidden('profissional_ocupacao_profissional_id');
        $button_adicionar_profissional_ocupacao_profissional = new TButton('button_adicionar_profissional_ocupacao_profissional');
        $profissional_unidade_profissional_id_unidade = new TDBCombo('profissional_unidade_profissional_id_unidade', 'reabilitar', 'UnidadeSaude', 'id', '{nome}','id asc'  );
        $profissional_unidade_profissional_id = new THidden('profissional_unidade_profissional_id');
        $profissional_unidade_profissional_id_setor = new TCombo('profissional_unidade_profissional_id_setor');
        $button_adicionar_profissional_unidade_profissional = new TButton('button_adicionar_profissional_unidade_profissional');
        $afastamento_profissional_profissional_data_inicio = new TDate('afastamento_profissional_profissional_data_inicio');
        $afastamento_profissional_profissional_id = new THidden('afastamento_profissional_profissional_id');
        $afastamento_profissional_profissional_data_fim = new TDate('afastamento_profissional_profissional_data_fim');
        $afastamento_profissional_profissional_moitvo_afastamento = new TEntry('afastamento_profissional_profissional_moitvo_afastamento');
        $button_adicionar_afastamento_profissional_profissional = new TButton('button_adicionar_afastamento_profissional_profissional');

        $endereco_profissional_profissional_id_estado->setChangeAction(new TAction([$this,'onChangeendereco_profissional_profissional_id_estado']));
        $endereco_profissional_profissional_id_cidade->setChangeAction(new TAction([$this,'onChangeendereco_profissional_profissional_id_cidade']));
        $profissional_unidade_profissional_id_unidade->setChangeAction(new TAction([$this,'onChangeprofissional_unidade_profissional_id_unidade']));

        $cpf->addValidation("Informe o CPF do profissional", new TRequiredValidator()); 
        $nome_profissional->addValidation("Informe o nome do profissional", new TRequiredValidator()); 

        $id->setEditable(false);
        $afastamento_profissional_profissional_data_fim->setDatabaseMask('yyyy-mm-dd');
        $afastamento_profissional_profissional_data_inicio->setDatabaseMask('yyyy-mm-dd');

        $button_adicionar_profissional_unidade_profissional->setAction(new TAction([$this, 'onAddDetailProfissionalUnidadeProfissional'],['static' => 1]), "Adicionar");
        $button_adicionar_endereco_profissional_profissional->setAction(new TAction([$this, 'onAddDetailEnderecoProfissionalProfissional'],['static' => 1]), "Adicionar");
        $button_adicionar_profissional_ocupacao_profissional->setAction(new TAction([$this, 'onAddDetailProfissionalOcupacaoProfissional'],['static' => 1]), "Adicionar");
        $button_adicionar_afastamento_profissional_profissional->setAction(new TAction([$this, 'onAddDetailAfastamentoProfissionalProfissional'],['static' => 1]), "Adicionar");

        $button_adicionar_profissional_unidade_profissional->addStyleClass('btn-default');
        $button_adicionar_endereco_profissional_profissional->addStyleClass('btn-default');
        $button_adicionar_profissional_ocupacao_profissional->addStyleClass('btn-default');
        $button_adicionar_afastamento_profissional_profissional->addStyleClass('btn-default');

        $button_adicionar_profissional_unidade_profissional->setImage('fas:plus #2ecc71');
        $button_adicionar_endereco_profissional_profissional->setImage('fas:plus #2ecc71');
        $button_adicionar_profissional_ocupacao_profissional->setImage('fas:plus #2ecc71');
        $button_adicionar_afastamento_profissional_profissional->setImage('fas:plus #2ecc71');

        $cpf->setMask('999.999.999-99');
        $telefone->setMask('(99)9-9999-9999');
        $afastamento_profissional_profissional_data_fim->setMask('dd/mm/yyyy');
        $endereco_profissional_profissional_cep_logradouro->setMask('99.999-999');
        $afastamento_profissional_profissional_data_inicio->setMask('dd/mm/yyyy');

        $cpf->setMaxLength(14);
        $nome_profissional->setMaxLength(50);
        $endereco_profissional_profissional_logradouro->setMaxLength(50);
        $endereco_profissional_profissional_complemento->setMaxLength(50);
        $endereco_profissional_profissional_cep_logradouro->setMaxLength(10);

        $button_adicionar_profissional_unidade_profissional->id = '60744fd1b8bbc';
        $button_adicionar_endereco_profissional_profissional->id = '60743930b8b66';
        $button_adicionar_profissional_ocupacao_profissional->id = '6074395bb8b6f';
        $button_adicionar_afastamento_profissional_profissional->id = '60743cc6b8b7e';

        $matricula->forceUpperCase();
        $nome_profissional->forceUpperCase();
        $endereco_profissional_profissional_logradouro->forceUpperCase();
        $endereco_profissional_profissional_complemento->forceUpperCase();
        $endereco_profissional_profissional_ponto_referencia->forceUpperCase();
        $afastamento_profissional_profissional_moitvo_afastamento->forceUpperCase();

        $id->setSize(100);
        $cpf->setSize('100%');
        $telefone->setSize('100%');
        $matricula->setSize('100%');
        $cns_profissional->setSize('100%');
        $nome_profissional->setSize('100%');
        $profissional_unidade_profissional_id->setSize(200);
        $profissional_ocupacao_profissional_id->setSize(200);
        $endereco_profissional_profissional_id->setSize(200);
        $afastamento_profissional_profissional_id->setSize(200);
        $endereco_profissional_profissional_id_tipo->setSize('50%');
        $profissional_unidade_profissional_id_setor->setSize('100%');
        $profissional_unidade_profissional_id_unidade->setSize('100%');
        $endereco_profissional_profissional_id_cidade->setSize('100%');
        $endereco_profissional_profissional_id_bairro->setSize('100%');
        $endereco_profissional_profissional_id_estado->setSize('100%');
        $endereco_profissional_profissional_logradouro->setSize('100%');
        $endereco_profissional_profissional_complemento->setSize('100%');
        $profissional_ocupacao_profissional_id_ocupacao->setSize('100%');
        $afastamento_profissional_profissional_data_fim->setSize('100%');
        $endereco_profissional_profissional_cep_logradouro->setSize('50%');
        $endereco_profissional_profissional_num_logradouro->setSize('100%');
        $afastamento_profissional_profissional_data_inicio->setSize('100%');
        $endereco_profissional_profissional_ponto_referencia->setSize('100%');
        $afastamento_profissional_profissional_moitvo_afastamento->setSize('100%');

        $this->form->appendPage("Dados Básicos");

        $this->form->addFields([new THidden('current_tab')]);
        $this->form->setTabFunction("$('[name=current_tab]').val($(this).attr('data-current_page'));");

        $row1 = $this->form->addFields([new TLabel("Código do Profissional:", null, '14px', null)],[$id],[new TLabel("Matrícula:", '#ff0000', '14px', null)],[$matricula]);
        $row2 = $this->form->addFields([new TLabel("CPF:", '#ff0000', '14px', null)],[$cpf],[new TLabel("CNS:", '#ff0000', '14px', null)],[$cns_profissional]);
        $row3 = $this->form->addFields([new TLabel("Nome:", '#ff0000', '14px', null)],[$nome_profissional]);
        $row4 = $this->form->addFields([new TLabel("Telefone:", '#ff0000', '14px', null)],[$telefone],[],[]);

        $this->form->appendPage("Endereço do Profissional");

        $this->detailFormEnderecoProfissionalProfissional = new BootstrapFormBuilder('detailFormEnderecoProfissionalProfissional');
        $this->detailFormEnderecoProfissionalProfissional->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormEnderecoProfissionalProfissional->setProperty('class', 'form-horizontal builder-detail-form');

        $row5 = $this->detailFormEnderecoProfissionalProfissional->addFields([new TLabel("CEP:", '#ff0000', '14px', null)],[$endereco_profissional_profissional_cep_logradouro],[$endereco_profissional_profissional_id],[]);
        $row6 = $this->detailFormEnderecoProfissionalProfissional->addFields([new TLabel("Tipo Logradouro:", '#ff0000', '14px', null)],[$endereco_profissional_profissional_id_tipo],[],[]);
        $row7 = $this->detailFormEnderecoProfissionalProfissional->addFields([new TLabel("Logradouro:", '#ff0000', '14px', null)],[$endereco_profissional_profissional_logradouro]);
        $row8 = $this->detailFormEnderecoProfissionalProfissional->addFields([new TLabel("Número:", '#ff0000', '14px', null)],[$endereco_profissional_profissional_num_logradouro],[new TLabel("Estado:", '#ff0000', '14px', null)],[$endereco_profissional_profissional_id_estado]);
        $row9 = $this->detailFormEnderecoProfissionalProfissional->addFields([new TLabel("Cidade:", '#ff0000', '14px', null)],[$endereco_profissional_profissional_id_cidade],[new TLabel("Bairro:", '#ff0000', '14px', null)],[$endereco_profissional_profissional_id_bairro]);
        $row10 = $this->detailFormEnderecoProfissionalProfissional->addFields([new TLabel("Complemento:", null, '14px', null)],[$endereco_profissional_profissional_complemento]);
        $row11 = $this->detailFormEnderecoProfissionalProfissional->addFields([new TLabel("Ponto Referência:", null, '14px', null)],[$endereco_profissional_profissional_ponto_referencia]);
        $row12 = $this->detailFormEnderecoProfissionalProfissional->addFields([$button_adicionar_endereco_profissional_profissional]);
        $row12->layout = [' col-sm-12'];

        $row13 = $this->detailFormEnderecoProfissionalProfissional->addFields([new THidden('endereco_profissional_profissional__row__id')]);
        $this->endereco_profissional_profissional_criteria = new TCriteria();

        $this->endereco_profissional_profissional_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->endereco_profissional_profissional_list->disableHtmlConversion();;
        $this->endereco_profissional_profissional_list->generateHiddenFields();
        $this->endereco_profissional_profissional_list->setId('endereco_profissional_profissional_list');

        $this->endereco_profissional_profissional_list->style = 'width:100%';
        $this->endereco_profissional_profissional_list->class .= ' table-bordered';

        $column_endereco_profissional_profissional_cep_logradouro = new TDataGridColumn('cep_logradouro', "CEP", 'center');
        $column_endereco_profissional_profissional_tipo_descricao = new TDataGridColumn('tipo->descricao', "Tipo", 'left');
        $column_endereco_profissional_profissional_logradouro = new TDataGridColumn('logradouro', "Logradouro", 'left');
        $column_endereco_profissional_profissional_num_logradouro = new TDataGridColumn('num_logradouro', "Núm.", 'left');
        $column_endereco_profissional_profissional_estado_nome_estado = new TDataGridColumn('estado->nome_estado', "Estado", 'left');
        $column_endereco_profissional_profissional_cidade_nome_cidade = new TDataGridColumn('cidade->nome_cidade', "Cidade", 'left');
        $column_endereco_profissional_profissional_bairro_nome_bairro = new TDataGridColumn('bairro->nome_bairro', "Bairro", 'left');

        $column_endereco_profissional_profissional__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_endereco_profissional_profissional__row__data->setVisibility(false);

        $action_onEditDetailEnderecoProfissional = new TDataGridAction(array('ProfissionalForm', 'onEditDetailEnderecoProfissional'));
        $action_onEditDetailEnderecoProfissional->setUseButton(false);
        $action_onEditDetailEnderecoProfissional->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailEnderecoProfissional->setLabel("Editar");
        $action_onEditDetailEnderecoProfissional->setImage('far:edit #478fca');
        $action_onEditDetailEnderecoProfissional->setFields(['__row__id', '__row__data']);

        $this->endereco_profissional_profissional_list->addAction($action_onEditDetailEnderecoProfissional);
        $action_onDeleteDetailEnderecoProfissional = new TDataGridAction(array('ProfissionalForm', 'onDeleteDetailEnderecoProfissional'));
        $action_onDeleteDetailEnderecoProfissional->setUseButton(false);
        $action_onDeleteDetailEnderecoProfissional->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailEnderecoProfissional->setLabel("Excluir");
        $action_onDeleteDetailEnderecoProfissional->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailEnderecoProfissional->setFields(['__row__id', '__row__data']);

        $this->endereco_profissional_profissional_list->addAction($action_onDeleteDetailEnderecoProfissional);

        $this->endereco_profissional_profissional_list->addColumn($column_endereco_profissional_profissional_cep_logradouro);
        $this->endereco_profissional_profissional_list->addColumn($column_endereco_profissional_profissional_tipo_descricao);
        $this->endereco_profissional_profissional_list->addColumn($column_endereco_profissional_profissional_logradouro);
        $this->endereco_profissional_profissional_list->addColumn($column_endereco_profissional_profissional_num_logradouro);
        $this->endereco_profissional_profissional_list->addColumn($column_endereco_profissional_profissional_estado_nome_estado);
        $this->endereco_profissional_profissional_list->addColumn($column_endereco_profissional_profissional_cidade_nome_cidade);
        $this->endereco_profissional_profissional_list->addColumn($column_endereco_profissional_profissional_bairro_nome_bairro);

        $this->endereco_profissional_profissional_list->addColumn($column_endereco_profissional_profissional__row__data);

        $this->endereco_profissional_profissional_list->createModel();
        $this->detailFormEnderecoProfissionalProfissional->addContent([$this->endereco_profissional_profissional_list]);

        $row14 = $this->form->addFields([$this->detailFormEnderecoProfissionalProfissional]);
        $row14->layout = [' col-sm-12'];

        $this->form->appendPage("Ocupação do Profissional");

        $this->detailFormProfissionalOcupacaoProfissional = new BootstrapFormBuilder('detailFormProfissionalOcupacaoProfissional');
        $this->detailFormProfissionalOcupacaoProfissional->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormProfissionalOcupacaoProfissional->setProperty('class', 'form-horizontal builder-detail-form');

        $row15 = $this->detailFormProfissionalOcupacaoProfissional->addFields([new TLabel("Ocupação:", '#ff0000', '14px', null)],[$profissional_ocupacao_profissional_id_ocupacao,$profissional_ocupacao_profissional_id]);
        $row16 = $this->detailFormProfissionalOcupacaoProfissional->addFields([$button_adicionar_profissional_ocupacao_profissional]);
        $row16->layout = [' col-sm-12'];

        $row17 = $this->detailFormProfissionalOcupacaoProfissional->addFields([new THidden('profissional_ocupacao_profissional__row__id')]);
        $this->profissional_ocupacao_profissional_criteria = new TCriteria();

        $this->profissional_ocupacao_profissional_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->profissional_ocupacao_profissional_list->disableHtmlConversion();;
        $this->profissional_ocupacao_profissional_list->generateHiddenFields();
        $this->profissional_ocupacao_profissional_list->setId('profissional_ocupacao_profissional_list');

        $this->profissional_ocupacao_profissional_list->style = 'width:100%';
        $this->profissional_ocupacao_profissional_list->class .= ' table-bordered';

        $column_profissional_ocupacao_profissional_ocupacao_descricao_ocupacao = new TDataGridColumn('ocupacao->descricao_ocupacao', "Ocupação", 'left');

        $column_profissional_ocupacao_profissional__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_profissional_ocupacao_profissional__row__data->setVisibility(false);

        $action_onEditDetailProfissionalOcupacao = new TDataGridAction(array('ProfissionalForm', 'onEditDetailProfissionalOcupacao'));
        $action_onEditDetailProfissionalOcupacao->setUseButton(false);
        $action_onEditDetailProfissionalOcupacao->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailProfissionalOcupacao->setLabel("Editar");
        $action_onEditDetailProfissionalOcupacao->setImage('far:edit #478fca');
        $action_onEditDetailProfissionalOcupacao->setFields(['__row__id', '__row__data']);

        $this->profissional_ocupacao_profissional_list->addAction($action_onEditDetailProfissionalOcupacao);
        $action_onDeleteDetailProfissionalOcupacao = new TDataGridAction(array('ProfissionalForm', 'onDeleteDetailProfissionalOcupacao'));
        $action_onDeleteDetailProfissionalOcupacao->setUseButton(false);
        $action_onDeleteDetailProfissionalOcupacao->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailProfissionalOcupacao->setLabel("Excluir");
        $action_onDeleteDetailProfissionalOcupacao->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailProfissionalOcupacao->setFields(['__row__id', '__row__data']);

        $this->profissional_ocupacao_profissional_list->addAction($action_onDeleteDetailProfissionalOcupacao);

        $this->profissional_ocupacao_profissional_list->addColumn($column_profissional_ocupacao_profissional_ocupacao_descricao_ocupacao);

        $this->profissional_ocupacao_profissional_list->addColumn($column_profissional_ocupacao_profissional__row__data);

        $this->profissional_ocupacao_profissional_list->createModel();
        $this->detailFormProfissionalOcupacaoProfissional->addContent([$this->profissional_ocupacao_profissional_list]);

        $row18 = $this->form->addFields([$this->detailFormProfissionalOcupacaoProfissional]);
        $row18->layout = [' col-sm-12'];

        $this->form->appendPage("Lotação do Profissional");

        $this->detailFormProfissionalUnidadeProfissional = new BootstrapFormBuilder('detailFormProfissionalUnidadeProfissional');
        $this->detailFormProfissionalUnidadeProfissional->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormProfissionalUnidadeProfissional->setProperty('class', 'form-horizontal builder-detail-form');

        $row19 = $this->detailFormProfissionalUnidadeProfissional->addFields([new TLabel("Unidade de Saúde:", '#ff0000', '14px', null)],[$profissional_unidade_profissional_id_unidade,$profissional_unidade_profissional_id]);
        $row20 = $this->detailFormProfissionalUnidadeProfissional->addFields([new TLabel("Setor:", '#ff0000', '14px', null)],[$profissional_unidade_profissional_id_setor]);
        $row21 = $this->detailFormProfissionalUnidadeProfissional->addFields([$button_adicionar_profissional_unidade_profissional]);
        $row21->layout = [' col-sm-12'];

        $row22 = $this->detailFormProfissionalUnidadeProfissional->addFields([new TLabel(" ", null, '14px', null)]);
        $row22->layout = [' col-sm-12'];

        $row23 = $this->detailFormProfissionalUnidadeProfissional->addFields([new THidden('profissional_unidade_profissional__row__id')]);
        $this->profissional_unidade_profissional_criteria = new TCriteria();

        $this->profissional_unidade_profissional_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->profissional_unidade_profissional_list->disableHtmlConversion();;
        $this->profissional_unidade_profissional_list->generateHiddenFields();
        $this->profissional_unidade_profissional_list->setId('profissional_unidade_profissional_list');

        $this->profissional_unidade_profissional_list->style = 'width:100%';
        $this->profissional_unidade_profissional_list->class .= ' table-bordered';

        $column_profissional_unidade_profissional_unidade_cnes_unidade = new TDataGridColumn('unidade->cnes_unidade', "CNES", 'center');
        $column_profissional_unidade_profissional_unidade_nome = new TDataGridColumn('unidade->nome', "Unidade de Saúde", 'left');
        $column_profissional_unidade_profissional_setor_descricao_setor = new TDataGridColumn('setor->descricao_setor', "Setor", 'left');

        $column_profissional_unidade_profissional__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_profissional_unidade_profissional__row__data->setVisibility(false);

        $action_onEditDetailProfissionalUnidade = new TDataGridAction(array('ProfissionalForm', 'onEditDetailProfissionalUnidade'));
        $action_onEditDetailProfissionalUnidade->setUseButton(false);
        $action_onEditDetailProfissionalUnidade->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailProfissionalUnidade->setLabel("Editar");
        $action_onEditDetailProfissionalUnidade->setImage('far:edit #478fca');
        $action_onEditDetailProfissionalUnidade->setFields(['__row__id', '__row__data']);

        $this->profissional_unidade_profissional_list->addAction($action_onEditDetailProfissionalUnidade);
        $action_onDeleteDetailProfissionalUnidade = new TDataGridAction(array('ProfissionalForm', 'onDeleteDetailProfissionalUnidade'));
        $action_onDeleteDetailProfissionalUnidade->setUseButton(false);
        $action_onDeleteDetailProfissionalUnidade->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailProfissionalUnidade->setLabel("Excluir");
        $action_onDeleteDetailProfissionalUnidade->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailProfissionalUnidade->setFields(['__row__id', '__row__data']);

        $this->profissional_unidade_profissional_list->addAction($action_onDeleteDetailProfissionalUnidade);

        $this->profissional_unidade_profissional_list->addColumn($column_profissional_unidade_profissional_unidade_cnes_unidade);
        $this->profissional_unidade_profissional_list->addColumn($column_profissional_unidade_profissional_unidade_nome);
        $this->profissional_unidade_profissional_list->addColumn($column_profissional_unidade_profissional_setor_descricao_setor);

        $this->profissional_unidade_profissional_list->addColumn($column_profissional_unidade_profissional__row__data);

        $this->profissional_unidade_profissional_list->createModel();
        $this->detailFormProfissionalUnidadeProfissional->addContent([$this->profissional_unidade_profissional_list]);

        $row24 = $this->form->addFields([$this->detailFormProfissionalUnidadeProfissional]);
        $row24->layout = [' col-sm-12'];

        $this->form->appendPage("Afastamentos do Profissional");

        $this->detailFormAfastamentoProfissionalProfissional = new BootstrapFormBuilder('detailFormAfastamentoProfissionalProfissional');
        $this->detailFormAfastamentoProfissionalProfissional->setProperty('style', 'border:none; box-shadow:none; width:100%;');

        $this->detailFormAfastamentoProfissionalProfissional->setProperty('class', 'form-horizontal builder-detail-form');

        $row25 = $this->detailFormAfastamentoProfissionalProfissional->addFields([new TLabel("Data de Início:", '#ff0000', '14px', null)],[$afastamento_profissional_profissional_data_inicio,$afastamento_profissional_profissional_id],[new TLabel("Data de Término:", '#ff0000', '14px', null)],[$afastamento_profissional_profissional_data_fim]);
        $row26 = $this->detailFormAfastamentoProfissionalProfissional->addFields([new TLabel("Moitvo do Afastamento:", '#ff0000', '14px', null)],[$afastamento_profissional_profissional_moitvo_afastamento]);
        $row27 = $this->detailFormAfastamentoProfissionalProfissional->addFields([$button_adicionar_afastamento_profissional_profissional]);
        $row27->layout = [' col-xs-12 col-sm-12 col-lg-12 col-md-12'];

        $row28 = $this->detailFormAfastamentoProfissionalProfissional->addFields([new THidden('afastamento_profissional_profissional__row__id')]);
        $this->afastamento_profissional_profissional_criteria = new TCriteria();

        $this->afastamento_profissional_profissional_list = new BootstrapDatagridWrapper(new TDataGrid);
        $this->afastamento_profissional_profissional_list->disableHtmlConversion();;
        $this->afastamento_profissional_profissional_list->generateHiddenFields();
        $this->afastamento_profissional_profissional_list->setId('afastamento_profissional_profissional_list');

        $this->afastamento_profissional_profissional_list->style = 'width:100%';
        $this->afastamento_profissional_profissional_list->class .= ' table-bordered';

        $column_afastamento_profissional_profissional_data_inicio_transformed = new TDataGridColumn('data_inicio', "Data de Início", 'center');
        $column_afastamento_profissional_profissional_data_fim_transformed = new TDataGridColumn('data_fim', "Data Término", 'center');
        $column_afastamento_profissional_profissional_moitvo_afastamento = new TDataGridColumn('moitvo_afastamento', "Moitvo do Afastamento", 'left');

        $column_afastamento_profissional_profissional__row__data = new TDataGridColumn('__row__data', '', 'center');
        $column_afastamento_profissional_profissional__row__data->setVisibility(false);

        $action_onEditDetailAfastamentoProfissional = new TDataGridAction(array('ProfissionalForm', 'onEditDetailAfastamentoProfissional'));
        $action_onEditDetailAfastamentoProfissional->setUseButton(false);
        $action_onEditDetailAfastamentoProfissional->setButtonClass('btn btn-default btn-sm');
        $action_onEditDetailAfastamentoProfissional->setLabel("Editar");
        $action_onEditDetailAfastamentoProfissional->setImage('far:edit #478fca');
        $action_onEditDetailAfastamentoProfissional->setFields(['__row__id', '__row__data']);

        $this->afastamento_profissional_profissional_list->addAction($action_onEditDetailAfastamentoProfissional);
        $action_onDeleteDetailAfastamentoProfissional = new TDataGridAction(array('ProfissionalForm', 'onDeleteDetailAfastamentoProfissional'));
        $action_onDeleteDetailAfastamentoProfissional->setUseButton(false);
        $action_onDeleteDetailAfastamentoProfissional->setButtonClass('btn btn-default btn-sm');
        $action_onDeleteDetailAfastamentoProfissional->setLabel("Excluir");
        $action_onDeleteDetailAfastamentoProfissional->setImage('fas:trash-alt #dd5a43');
        $action_onDeleteDetailAfastamentoProfissional->setFields(['__row__id', '__row__data']);

        $this->afastamento_profissional_profissional_list->addAction($action_onDeleteDetailAfastamentoProfissional);

        $this->afastamento_profissional_profissional_list->addColumn($column_afastamento_profissional_profissional_data_inicio_transformed);
        $this->afastamento_profissional_profissional_list->addColumn($column_afastamento_profissional_profissional_data_fim_transformed);
        $this->afastamento_profissional_profissional_list->addColumn($column_afastamento_profissional_profissional_moitvo_afastamento);

        $this->afastamento_profissional_profissional_list->addColumn($column_afastamento_profissional_profissional__row__data);

        $this->afastamento_profissional_profissional_list->createModel();
        $this->detailFormAfastamentoProfissionalProfissional->addContent([$this->afastamento_profissional_profissional_list]);

        $column_afastamento_profissional_profissional_data_inicio_transformed->setTransformer(function($value, $object, $row) 
        {
            if(!empty(trim($value)))
            {
                try
                {
                    $date = new DateTime($value);
                    return $date->format('d/m/Y');
                }
                catch (Exception $e)
                {
                    return $value;
                }
            }
        });

        $column_afastamento_profissional_profissional_data_fim_transformed->setTransformer(function($value, $object, $row) 
        {
            if(!empty(trim($value)))
            {
                try
                {
                    $date = new DateTime($value);
                    return $date->format('d/m/Y');
                }
                catch (Exception $e)
                {
                    return $value;
                }
            }
        });        $row29 = $this->form->addFields([$this->detailFormAfastamentoProfissionalProfissional]);
        $row29->layout = [' col-xs-12 col-sm-12 col-lg-12 col-md-12'];

        // create the form actions
        $btn_onsave = $this->form->addAction("Salvar", new TAction([$this, 'onSave'],['static' => 1]), 'fas:save #ffffff');
        $this->btn_onsave = $btn_onsave;
        $btn_onsave->addStyleClass('btn-primary'); 

        $btn_onclear = $this->form->addAction("Limpar formulário", new TAction([$this, 'onClear']), 'fas:eraser #dd5a43');
        $this->btn_onclear = $btn_onclear;

        $btn_onshow = $this->form->addAction("Voltar", new TAction(['ProfissionalHeaderList', 'onShow']), 'fas:arrow-left #000000');
        $this->btn_onshow = $btn_onshow;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        if(empty($param['target_container']))
        {
            $container->add(TBreadCrumb::create(["Pessoas","Cadastro de profissional"]));
        }
        $container->add($this->form);

        parent::add($container);

    }

    public static function onChangeendereco_profissional_profissional_id_estado($param)
    {
        try
        {

            if (isset($param['endereco_profissional_profissional_id_estado']) && $param['endereco_profissional_profissional_id_estado'])
            { 
                $criteria = TCriteria::create(['id_estado' => $param['endereco_profissional_profissional_id_estado']]);
                TDBCombo::reloadFromModel(self::$formName, 'endereco_profissional_profissional_id_cidade', 'reabilitar', 'Cidade', 'id', '{nome_cidade}', 'id asc', $criteria, TRUE); 
            } 
            else 
            { 
                TCombo::clearField(self::$formName, 'endereco_profissional_profissional_id_cidade'); 
            }  

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    } 

    public static function onChangeendereco_profissional_profissional_id_cidade($param)
    {
        try
        {

            if (isset($param['endereco_profissional_profissional_id_cidade']) && $param['endereco_profissional_profissional_id_cidade'])
            { 
                $criteria = TCriteria::create(['id_cidade' => $param['endereco_profissional_profissional_id_cidade']]);
                TDBCombo::reloadFromModel(self::$formName, 'endereco_profissional_profissional_id_bairro', 'reabilitar', 'Bairro', 'id', '{nome_bairro}', 'id asc', $criteria, TRUE); 
            } 
            else 
            { 
                TCombo::clearField(self::$formName, 'endereco_profissional_profissional_id_bairro'); 
            }  

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    } 

    public static function onChangeprofissional_unidade_profissional_id_unidade($param)
    {
        try
        {

            if (isset($param['profissional_unidade_profissional_id_unidade']) && $param['profissional_unidade_profissional_id_unidade'])
            { 
                $criteria = TCriteria::create(['id_unidade' => $param['profissional_unidade_profissional_id_unidade']]);
                TDBCombo::reloadFromModel(self::$formName, 'profissional_unidade_profissional_id_setor', 'reabilitar', 'Setor', 'id', '{descricao_setor}', 'id asc', $criteria, TRUE); 
            } 
            else 
            { 
                TCombo::clearField(self::$formName, 'profissional_unidade_profissional_id_setor'); 
            }  

        }
        catch (Exception $e)
        {
            new TMessage('error', $e->getMessage());
        }
    } 

    public  function onAddDetailEnderecoProfissionalProfissional($param = null) 
    {
        try
        {
            $data = $this->form->getData();

            $errors = [];
            $requiredFields = [];
            $requiredFields["endereco_profissional_profissional_cep_logradouro"] = "Cep logradouro";
            $requiredFields["endereco_profissional_profissional_id_tipo"] = "Id tipo";
            $requiredFields["endereco_profissional_profissional_logradouro"] = "Logradouro";
            $requiredFields["endereco_profissional_profissional_num_logradouro"] = "Num logradouro";
            $requiredFields["endereco_profissional_profissional_id_estado"] = "Id estado";
            $requiredFields["endereco_profissional_profissional_id_cidade"] = "Id cidade";
            $requiredFields["endereco_profissional_profissional_id_bairro"] = "Id bairro";
            foreach($requiredFields as $keyFieldName => $labelRequired)
            {
                try
                {
                    (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                }
                catch(Exception $e)
                {
                    $errors[] = $e->getMessage() . '.';
                }
             }
             if(count($errors) > 0)
             {
                 throw new Exception(implode('<br>', $errors));
             }

            $__row__id = !empty($data->endereco_profissional_profissional__row__id) ? $data->endereco_profissional_profissional__row__id : 'b'.uniqid();

            TTransaction::open(self::$database);

            $grid_data = new EnderecoProfissional();
            $grid_data->__row__id = $__row__id;
            $grid_data->cep_logradouro = $data->endereco_profissional_profissional_cep_logradouro;
            $grid_data->id = $data->endereco_profissional_profissional_id;
            $grid_data->id_tipo = $data->endereco_profissional_profissional_id_tipo;
            $grid_data->logradouro = $data->endereco_profissional_profissional_logradouro;
            $grid_data->num_logradouro = $data->endereco_profissional_profissional_num_logradouro;
            $grid_data->id_estado = $data->endereco_profissional_profissional_id_estado;
            $grid_data->id_cidade = $data->endereco_profissional_profissional_id_cidade;
            $grid_data->id_bairro = $data->endereco_profissional_profissional_id_bairro;
            $grid_data->complemento = $data->endereco_profissional_profissional_complemento;
            $grid_data->ponto_referencia = $data->endereco_profissional_profissional_ponto_referencia;

            $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
            $__row__data['__row__id'] = $__row__id;
            $__row__data['__display__']['cep_logradouro'] =  $param['endereco_profissional_profissional_cep_logradouro'] ?? null;
            $__row__data['__display__']['id'] =  $param['endereco_profissional_profissional_id'] ?? null;
            $__row__data['__display__']['id_tipo'] =  $param['endereco_profissional_profissional_id_tipo'] ?? null;
            $__row__data['__display__']['logradouro'] =  $param['endereco_profissional_profissional_logradouro'] ?? null;
            $__row__data['__display__']['num_logradouro'] =  $param['endereco_profissional_profissional_num_logradouro'] ?? null;
            $__row__data['__display__']['id_estado'] =  $param['endereco_profissional_profissional_id_estado'] ?? null;
            $__row__data['__display__']['id_cidade'] =  $param['endereco_profissional_profissional_id_cidade'] ?? null;
            $__row__data['__display__']['id_bairro'] =  $param['endereco_profissional_profissional_id_bairro'] ?? null;
            $__row__data['__display__']['complemento'] =  $param['endereco_profissional_profissional_complemento'] ?? null;
            $__row__data['__display__']['ponto_referencia'] =  $param['endereco_profissional_profissional_ponto_referencia'] ?? null;

            $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
            $row = $this->endereco_profissional_profissional_list->addItem($grid_data);
            $row->id = $grid_data->__row__id;

            TDataGrid::replaceRowById('endereco_profissional_profissional_list', $grid_data->__row__id, $row);

            TTransaction::close();

            $data = new stdClass;
            $data->endereco_profissional_profissional_cep_logradouro = '';
            $data->endereco_profissional_profissional_id = '';
            $data->endereco_profissional_profissional_id_tipo = '';
            $data->endereco_profissional_profissional_logradouro = '';
            $data->endereco_profissional_profissional_num_logradouro = '';
            $data->endereco_profissional_profissional_id_estado = '';
            $data->endereco_profissional_profissional_id_cidade = '';
            $data->endereco_profissional_profissional_id_bairro = '';
            $data->endereco_profissional_profissional_complemento = '';
            $data->endereco_profissional_profissional_ponto_referencia = '';
            $data->endereco_profissional_profissional__row__id = '';

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#60743930b8b66');
               if(typeof element.attr('add') != 'undefined')
               {
                   element.html(base64_decode(element.attr('add')));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public  function onAddDetailProfissionalOcupacaoProfissional($param = null) 
    {
        try
        {
            $data = $this->form->getData();

            $errors = [];
            $requiredFields = [];
            $requiredFields["profissional_ocupacao_profissional_id_ocupacao"] = "Id ocupacao";
            foreach($requiredFields as $keyFieldName => $labelRequired)
            {
                try
                {
                    (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                }
                catch(Exception $e)
                {
                    $errors[] = $e->getMessage() . '.';
                }
             }
             if(count($errors) > 0)
             {
                 throw new Exception(implode('<br>', $errors));
             }

            $__row__id = !empty($data->profissional_ocupacao_profissional__row__id) ? $data->profissional_ocupacao_profissional__row__id : 'b'.uniqid();

            TTransaction::open(self::$database);

            $grid_data = new ProfissionalOcupacao();
            $grid_data->__row__id = $__row__id;
            $grid_data->id_ocupacao = $data->profissional_ocupacao_profissional_id_ocupacao;
            $grid_data->id = $data->profissional_ocupacao_profissional_id;

            $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
            $__row__data['__row__id'] = $__row__id;
            $__row__data['__display__']['id_ocupacao'] =  $param['profissional_ocupacao_profissional_id_ocupacao'] ?? null;
            $__row__data['__display__']['id'] =  $param['profissional_ocupacao_profissional_id'] ?? null;

            $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
            $row = $this->profissional_ocupacao_profissional_list->addItem($grid_data);
            $row->id = $grid_data->__row__id;

            TDataGrid::replaceRowById('profissional_ocupacao_profissional_list', $grid_data->__row__id, $row);

            TTransaction::close();

            $data = new stdClass;
            $data->profissional_ocupacao_profissional_id_ocupacao = '';
            $data->profissional_ocupacao_profissional_id = '';
            $data->profissional_ocupacao_profissional__row__id = '';

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#6074395bb8b6f');
               if(typeof element.attr('add') != 'undefined')
               {
                   element.html(base64_decode(element.attr('add')));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public  function onAddDetailProfissionalUnidadeProfissional($param = null) 
    {
        try
        {
            $data = $this->form->getData();

            $errors = [];
            $requiredFields = [];
            $requiredFields["profissional_unidade_profissional_id_unidade"] = "Id unidade";
            foreach($requiredFields as $keyFieldName => $labelRequired)
            {
                try
                {
                    (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                }
                catch(Exception $e)
                {
                    $errors[] = $e->getMessage() . '.';
                }
             }
             if(count($errors) > 0)
             {
                 throw new Exception(implode('<br>', $errors));
             }

            $__row__id = !empty($data->profissional_unidade_profissional__row__id) ? $data->profissional_unidade_profissional__row__id : 'b'.uniqid();

            TTransaction::open(self::$database);

            $grid_data = new ProfissionalUnidade();
            $grid_data->__row__id = $__row__id;
            $grid_data->id_unidade = $data->profissional_unidade_profissional_id_unidade;
            $grid_data->id = $data->profissional_unidade_profissional_id;
            $grid_data->id_setor = $data->profissional_unidade_profissional_id_setor;

            $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
            $__row__data['__row__id'] = $__row__id;
            $__row__data['__display__']['id_unidade'] =  $param['profissional_unidade_profissional_id_unidade'] ?? null;
            $__row__data['__display__']['id'] =  $param['profissional_unidade_profissional_id'] ?? null;
            $__row__data['__display__']['id_setor'] =  $param['profissional_unidade_profissional_id_setor'] ?? null;

            $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
            $row = $this->profissional_unidade_profissional_list->addItem($grid_data);
            $row->id = $grid_data->__row__id;

            TDataGrid::replaceRowById('profissional_unidade_profissional_list', $grid_data->__row__id, $row);

            TTransaction::close();

            $data = new stdClass;
            $data->profissional_unidade_profissional_id_unidade = '';
            $data->profissional_unidade_profissional_id = '';
            $data->profissional_unidade_profissional_id_setor = '';
            $data->profissional_unidade_profissional__row__id = '';

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#60744fd1b8bbc');
               if(typeof element.attr('add') != 'undefined')
               {
                   element.html(base64_decode(element.attr('add')));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public  function onAddDetailAfastamentoProfissionalProfissional($param = null) 
    {
        try
        {
            $data = $this->form->getData();

            $errors = [];
            $requiredFields = [];
            $requiredFields["afastamento_profissional_profissional_data_inicio"] = "Data inicio";
            $requiredFields["afastamento_profissional_profissional_data_fim"] = "Data fim";
            $requiredFields["afastamento_profissional_profissional_moitvo_afastamento"] = "Moitvo afastamento";
            foreach($requiredFields as $keyFieldName => $labelRequired)
            {
                try
                {
                    (new TRequiredValidator)->validate($labelRequired, $data->{$keyFieldName});
                }
                catch(Exception $e)
                {
                    $errors[] = $e->getMessage() . '.';
                }
             }
             if(count($errors) > 0)
             {
                 throw new Exception(implode('<br>', $errors));
             }

            $__row__id = !empty($data->afastamento_profissional_profissional__row__id) ? $data->afastamento_profissional_profissional__row__id : 'b'.uniqid();

            TTransaction::open(self::$database);

            $grid_data = new AfastamentoProfissional();
            $grid_data->__row__id = $__row__id;
            $grid_data->data_inicio = $data->afastamento_profissional_profissional_data_inicio;
            $grid_data->id = $data->afastamento_profissional_profissional_id;
            $grid_data->data_fim = $data->afastamento_profissional_profissional_data_fim;
            $grid_data->moitvo_afastamento = $data->afastamento_profissional_profissional_moitvo_afastamento;

            $__row__data = array_merge($grid_data->toArray(), (array)$grid_data->getVirtualData());
            $__row__data['__row__id'] = $__row__id;
            $__row__data['__display__']['data_inicio'] =  $param['afastamento_profissional_profissional_data_inicio'] ?? null;
            $__row__data['__display__']['id'] =  $param['afastamento_profissional_profissional_id'] ?? null;
            $__row__data['__display__']['data_fim'] =  $param['afastamento_profissional_profissional_data_fim'] ?? null;
            $__row__data['__display__']['moitvo_afastamento'] =  $param['afastamento_profissional_profissional_moitvo_afastamento'] ?? null;

            $grid_data->__row__data = base64_encode(serialize((object)$__row__data));
            $row = $this->afastamento_profissional_profissional_list->addItem($grid_data);
            $row->id = $grid_data->__row__id;

            TDataGrid::replaceRowById('afastamento_profissional_profissional_list', $grid_data->__row__id, $row);

            TTransaction::close();

            $data = new stdClass;
            $data->afastamento_profissional_profissional_data_inicio = '';
            $data->afastamento_profissional_profissional_id = '';
            $data->afastamento_profissional_profissional_data_fim = '';
            $data->afastamento_profissional_profissional_moitvo_afastamento = '';
            $data->afastamento_profissional_profissional__row__id = '';

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#60743cc6b8b7e');
               if(typeof element.attr('add') != 'undefined')
               {
                   element.html(base64_decode(element.attr('add')));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }

    public static function onEditDetailEnderecoProfissional($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));
            $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

            $data = new stdClass;
            $data->endereco_profissional_profissional_cep_logradouro = $__row__data->__display__->cep_logradouro ?? null;
            $data->endereco_profissional_profissional_id = $__row__data->__display__->id ?? null;
            $data->endereco_profissional_profissional_id_tipo = $__row__data->__display__->id_tipo ?? null;
            $data->endereco_profissional_profissional_logradouro = $__row__data->__display__->logradouro ?? null;
            $data->endereco_profissional_profissional_num_logradouro = $__row__data->__display__->num_logradouro ?? null;
            $data->endereco_profissional_profissional_id_estado = $__row__data->__display__->id_estado ?? null;
            $data->endereco_profissional_profissional_id_cidade = $__row__data->__display__->id_cidade ?? null;
            $data->endereco_profissional_profissional_id_bairro = $__row__data->__display__->id_bairro ?? null;
            $data->endereco_profissional_profissional_complemento = $__row__data->__display__->complemento ?? null;
            $data->endereco_profissional_profissional_ponto_referencia = $__row__data->__display__->ponto_referencia ?? null;
            $data->endereco_profissional_profissional__row__id = $__row__data->__row__id;

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#60743930b8b66');
               if(!element.attr('add')){
                   element.attr('add', base64_encode(element.html()));
               }
               element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
               if(!element.attr('edit')){
                   element.attr('edit', base64_encode(element.html()));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onDeleteDetailEnderecoProfissional($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));

            $data = new stdClass;
            $data->endereco_profissional_profissional_cep_logradouro = '';
            $data->endereco_profissional_profissional_id = '';
            $data->endereco_profissional_profissional_id_tipo = '';
            $data->endereco_profissional_profissional_logradouro = '';
            $data->endereco_profissional_profissional_num_logradouro = '';
            $data->endereco_profissional_profissional_id_estado = '';
            $data->endereco_profissional_profissional_id_cidade = '';
            $data->endereco_profissional_profissional_id_bairro = '';
            $data->endereco_profissional_profissional_complemento = '';
            $data->endereco_profissional_profissional_ponto_referencia = '';
            $data->endereco_profissional_profissional__row__id = '';

            TForm::sendData(self::$formName, $data);

            TDataGrid::removeRowById('endereco_profissional_profissional_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onEditDetailProfissionalOcupacao($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));
            $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

            $data = new stdClass;
            $data->profissional_ocupacao_profissional_id_ocupacao = $__row__data->__display__->id_ocupacao ?? null;
            $data->profissional_ocupacao_profissional_id = $__row__data->__display__->id ?? null;
            $data->profissional_ocupacao_profissional__row__id = $__row__data->__row__id;

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#6074395bb8b6f');
               if(!element.attr('add')){
                   element.attr('add', base64_encode(element.html()));
               }
               element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
               if(!element.attr('edit')){
                   element.attr('edit', base64_encode(element.html()));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onDeleteDetailProfissionalOcupacao($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));

            $data = new stdClass;
            $data->profissional_ocupacao_profissional_id_ocupacao = '';
            $data->profissional_ocupacao_profissional_id = '';
            $data->profissional_ocupacao_profissional__row__id = '';

            TForm::sendData(self::$formName, $data);

            TDataGrid::removeRowById('profissional_ocupacao_profissional_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onEditDetailProfissionalUnidade($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));
            $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

            $data = new stdClass;
            $data->profissional_unidade_profissional_id_unidade = $__row__data->__display__->id_unidade ?? null;
            $data->profissional_unidade_profissional_id = $__row__data->__display__->id ?? null;
            $data->profissional_unidade_profissional_id_setor = $__row__data->__display__->id_setor ?? null;
            $data->profissional_unidade_profissional__row__id = $__row__data->__row__id;

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#60744fd1b8bbc');
               if(!element.attr('add')){
                   element.attr('add', base64_encode(element.html()));
               }
               element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
               if(!element.attr('edit')){
                   element.attr('edit', base64_encode(element.html()));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onDeleteDetailProfissionalUnidade($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));

            $data = new stdClass;
            $data->profissional_unidade_profissional_id_unidade = '';
            $data->profissional_unidade_profissional_id = '';
            $data->profissional_unidade_profissional_id_setor = '';
            $data->profissional_unidade_profissional__row__id = '';

            TForm::sendData(self::$formName, $data);

            TDataGrid::removeRowById('profissional_unidade_profissional_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onEditDetailAfastamentoProfissional($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));
            $__row__data->__display__ = is_array($__row__data->__display__) ? (object) $__row__data->__display__ : $__row__data->__display__;

            $data = new stdClass;
            $data->afastamento_profissional_profissional_data_inicio = $__row__data->__display__->data_inicio ?? null;
            $data->afastamento_profissional_profissional_id = $__row__data->__display__->id ?? null;
            $data->afastamento_profissional_profissional_data_fim = $__row__data->__display__->data_fim ?? null;
            $data->afastamento_profissional_profissional_moitvo_afastamento = $__row__data->__display__->moitvo_afastamento ?? null;
            $data->afastamento_profissional_profissional__row__id = $__row__data->__row__id;

            TForm::sendData(self::$formName, $data);
            TScript::create("
               var element = $('#60743cc6b8b7e');
               if(!element.attr('add')){
                   element.attr('add', base64_encode(element.html()));
               }
               element.html(\"<span><i class='far fa-edit' style='color:#478fca;padding-right:4px;'></i>Editar</span>\");
               if(!element.attr('edit')){
                   element.attr('edit', base64_encode(element.html()));
               }
            ");

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public static function onDeleteDetailAfastamentoProfissional($param = null) 
    {
        try
        {

            $__row__data = unserialize(base64_decode($param['__row__data']));

            $data = new stdClass;
            $data->afastamento_profissional_profissional_data_inicio = '';
            $data->afastamento_profissional_profissional_id = '';
            $data->afastamento_profissional_profissional_data_fim = '';
            $data->afastamento_profissional_profissional_moitvo_afastamento = '';
            $data->afastamento_profissional_profissional__row__id = '';

            TForm::sendData(self::$formName, $data);

            TDataGrid::removeRowById('afastamento_profissional_profissional_list', $__row__data->__row__id);

        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
        }
    }
    public function onSave($param = null) 
    {
        try
        {
            TTransaction::open(self::$database); // open a transaction

            $messageAction = null;

            $this->form->validate(); // validate form data

            $object = new Profissional(); // create an empty object 

            $data = $this->form->getData(); // get form data as array
            $object->fromArray( (array) $data); // load the object with data
            $object->flg_excluido = 'N';

            $object->store(); // save the object 

            $this->fireEvents($object);

            TForm::sendData(self::$formName, (object)['id' => $object->id]);

            $loadPageParam = [];

            if(!empty($param['target_container']))
            {
                $loadPageParam['target_container'] = $param['target_container'];
            }

            $profissional_unidade_profissional_items = $this->storeMasterDetailItems('ProfissionalUnidade', 'id_profissional', 'profissional_unidade_profissional', $object, $param['profissional_unidade_profissional_list___row__data'] ?? [], $this->form, $this->profissional_unidade_profissional_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            $afastamento_profissional_profissional_items = $this->storeMasterDetailItems('AfastamentoProfissional', 'id_profissional', 'afastamento_profissional_profissional', $object, $param['afastamento_profissional_profissional_list___row__data'] ?? [], $this->form, $this->afastamento_profissional_profissional_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            $profissional_ocupacao_profissional_items = $this->storeMasterDetailItems('ProfissionalOcupacao', 'id_profissional', 'profissional_ocupacao_profissional', $object, $param['profissional_ocupacao_profissional_list___row__data'] ?? [], $this->form, $this->profissional_ocupacao_profissional_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            $endereco_profissional_profissional_items = $this->storeMasterDetailItems('EnderecoProfissional', 'id_profissional', 'endereco_profissional_profissional', $object, $param['endereco_profissional_profissional_list___row__data'] ?? [], $this->form, $this->endereco_profissional_profissional_list, function($masterObject, $detailObject){ 

                //code here

            }); 

            // get the generated {PRIMARY_KEY}
            $data->id = $object->id; 

            $this->form->setData($data); // fill form data
            TTransaction::close(); // close the transaction

            TToast::show('success', "Registro salvo", 'topRight', 'far:check-circle');
            TApplication::loadPage('ProfissionalHeaderList', 'onShow', $loadPageParam); 

        }
        catch (Exception $e) // in case of exception
        {
            //</catchAutoCode>  

            new TMessage('error', $e->getMessage()); // shows the exception error message
            $this->form->setData( $this->form->getData() ); // keep form data
            TTransaction::rollback(); // undo all pending operations
        }
    }

    public function onEdit( $param )
    {
        try
        {
            if (isset($param['key']))
            {
                $key = $param['key'];  // get the parameter $key
                TTransaction::open(self::$database); // open a transaction

                $object = new Profissional($key); // instantiates the Active Record 

                $profissional_unidade_profissional_items = $this->loadMasterDetailItems('ProfissionalUnidade', 'id_profissional', 'profissional_unidade_profissional', $object, $this->form, $this->profissional_unidade_profissional_list, $this->profissional_unidade_profissional_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                    $objectItems->profissional_unidade_profissional_id_unidade = null;
                    if(isset($detailObject->id_unidade) && $detailObject->id_unidade)
                    {
                        $objectItems->__display__->id_unidade = $detailObject->id_unidade;
                    }

                    $objectItems->profissional_unidade_profissional_id_setor = null;
                    if(isset($detailObject->id_setor) && $detailObject->id_setor)
                    {
                        $objectItems->__display__->id_setor = $detailObject->id_setor;
                    }

                }); 

                $afastamento_profissional_profissional_items = $this->loadMasterDetailItems('AfastamentoProfissional', 'id_profissional', 'afastamento_profissional_profissional', $object, $this->form, $this->afastamento_profissional_profissional_list, $this->afastamento_profissional_profissional_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                }); 

                $profissional_ocupacao_profissional_items = $this->loadMasterDetailItems('ProfissionalOcupacao', 'id_profissional', 'profissional_ocupacao_profissional', $object, $this->form, $this->profissional_ocupacao_profissional_list, $this->profissional_ocupacao_profissional_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                }); 

                $endereco_profissional_profissional_items = $this->loadMasterDetailItems('EnderecoProfissional', 'id_profissional', 'endereco_profissional_profissional', $object, $this->form, $this->endereco_profissional_profissional_list, $this->endereco_profissional_profissional_criteria, function($masterObject, $detailObject, $objectItems){ 

                    //code here

                    $objectItems->endereco_profissional_profissional_id_cidade = null;
                    if(isset($detailObject->id_cidade) && $detailObject->id_cidade)
                    {
                        $objectItems->__display__->id_cidade = $detailObject->id_cidade;
                    }

                    $objectItems->endereco_profissional_profissional_id_bairro = null;
                    if(isset($detailObject->id_bairro) && $detailObject->id_bairro)
                    {
                        $objectItems->__display__->id_bairro = $detailObject->id_bairro;
                    }

                    $objectItems->endereco_profissional_profissional_id_estado = null;
                    if(isset($detailObject->id_estado) && $detailObject->id_estado)
                    {
                        $objectItems->__display__->id_estado = $detailObject->id_estado;
                    }

                    $objectItems->endereco_profissional_profissional_id_cidade = null;
                    if(isset($detailObject->id_cidade) && $detailObject->id_cidade)
                    {
                        $objectItems->__display__->id_cidade = $detailObject->id_cidade;
                    }

                }); 

                $this->form->setData($object); // fill the form 

                $this->fireEvents($object);

                TTransaction::close(); // close the transaction 
            }
            else
            {
                $this->form->clear();
            }
        }
        catch (Exception $e) // in case of exception
        {
            new TMessage('error', $e->getMessage()); // shows the exception error message
            TTransaction::rollback(); // undo all pending operations
        }
    }

    /**
     * Clear form data
     * @param $param Request
     */
    public function onClear( $param )
    {
        $this->form->clear(true);

    }

    public function onShow($param = null)
    {

    } 

    public function fireEvents( $object )
    {
        $obj = new stdClass;
        if(is_object($object) && get_class($object) == 'stdClass')
        {
            if(isset($object->endereco_profissional_profissional_id_estado))
            {
                $value = $object->endereco_profissional_profissional_id_estado;

                $obj->endereco_profissional_profissional_id_estado = $value;
            }
            if(isset($object->endereco_profissional_profissional_id_cidade))
            {
                $value = $object->endereco_profissional_profissional_id_cidade;

                $obj->endereco_profissional_profissional_id_cidade = $value;
            }
            if(isset($object->endereco_profissional_profissional_id_bairro))
            {
                $value = $object->endereco_profissional_profissional_id_bairro;

                $obj->endereco_profissional_profissional_id_bairro = $value;
            }
            if(isset($object->profissional_unidade_profissional_id_unidade))
            {
                $value = $object->profissional_unidade_profissional_id_unidade;

                $obj->profissional_unidade_profissional_id_unidade = $value;
            }
            if(isset($object->profissional_unidade_profissional_id_setor))
            {
                $value = $object->profissional_unidade_profissional_id_setor;

                $obj->profissional_unidade_profissional_id_setor = $value;
            }
        }
        elseif(is_object($object))
        {
            if(isset($object->endereco_profissional->profissional->id_estado))
            {
                $value = $object->endereco_profissional->profissional->id_estado;

                $obj->endereco_profissional_profissional_id_estado = $value;
            }
            if(isset($object->endereco_profissional->profissional->id_cidade))
            {
                $value = $object->endereco_profissional->profissional->id_cidade;

                $obj->endereco_profissional_profissional_id_cidade = $value;
            }
            if(isset($object->endereco_profissional->profissional->id_bairro))
            {
                $value = $object->endereco_profissional->profissional->id_bairro;

                $obj->endereco_profissional_profissional_id_bairro = $value;
            }
            if(isset($object->profissional_unidade->profissional->id_unidade))
            {
                $value = $object->profissional_unidade->profissional->id_unidade;

                $obj->profissional_unidade_profissional_id_unidade = $value;
            }
            if(isset($object->profissional_unidade->profissional->id_setor))
            {
                $value = $object->profissional_unidade->profissional->id_setor;

                $obj->profissional_unidade_profissional_id_setor = $value;
            }
        }
        TForm::sendData(self::$formName, $obj);
    }  

}

