<?php

class AgendaDiariaReport extends TPage
{
    private $form; // form
    private $loaded;
    private static $database = 'reabilitar';
    private static $activeRecord = 'Agendamento';
    private static $primaryKey = 'id';
    private static $formName = 'form_RelAgendaDiaria';

    /**
     * Class constructor
     * Creates the page, the form and the listing
     */
    public function __construct()
    {
        parent::__construct();

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);

        // define the form title
        $this->form->setFormTitle("Emitir Agenda Diária");

        $id_profissional = new TDBCombo('id_profissional', 'reabilitar', 'Profissional', 'id', '{nome_profissional}','id asc'  );
        $data_agendamento = new TDate('data_agendamento');

        $data_agendamento->setDatabaseMask('yyyy-mm-dd');
        $data_agendamento->setMask('dd/mm/yyyy');

        $id_profissional->setSize('100%');
        $data_agendamento->setSize('30%');

        $row1 = $this->form->addFields([new TLabel("Profissional :", null, '14px', null)],[$id_profissional]);
        $row2 = $this->form->addFields([new TLabel("Data:", null, '14px', null)],[$data_agendamento]);

        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        $btn_ongeneratehtml = $this->form->addAction("Gerar HTML", new TAction([$this, 'onGenerateHtml']), 'far:file-code #ffffff');
        $this->btn_ongeneratehtml = $btn_ongeneratehtml;
        $btn_ongeneratehtml->addStyleClass('btn-primary'); 

        $btn_ongeneratepdf = $this->form->addAction("Gerar PDF", new TAction([$this, 'onGeneratePdf']), 'far:file-pdf #d44734');
        $this->btn_ongeneratepdf = $btn_ongeneratepdf;

        $btn_ongeneratexls = $this->form->addAction("Gerar XLS", new TAction([$this, 'onGenerateXls']), 'far:file-excel #00a65a');
        $this->btn_ongeneratexls = $btn_ongeneratexls;

        $btn_ongeneratertf = $this->form->addAction("Gerar RTF", new TAction([$this, 'onGenerateRtf']), 'far:file-alt #324bcc');
        $this->btn_ongeneratertf = $btn_ongeneratertf;

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->class = 'form-container';
        $container->add(TBreadCrumb::create(["Relatórios","Emitir Agenda Diária"]));
        $container->add($this->form);

        parent::add($container);

    }

    public function onGenerateHtml($param = null) 
    {
        $this->onGenerate('html');
    }
    public function onGeneratePdf($param = null) 
    {
        $this->onGenerate('pdf');
    }
    public function onGenerateXls($param = null) 
    {
        $this->onGenerate('xls');
    }
    public function onGenerateRtf($param = null) 
    {
        $this->onGenerate('rtf');
    }

    /**
     * Register the filter in the session
     */
    public function getFilters()
    {
        // get the search form data
        $data = $this->form->getData();

        $filters = [];

        TSession::setValue(__CLASS__.'_filter_data', NULL);
        TSession::setValue(__CLASS__.'_filters', NULL);

        if (isset($data->id_profissional) AND ( (is_scalar($data->id_profissional) AND $data->id_profissional !== '') OR (is_array($data->id_profissional) AND (!empty($data->id_profissional)) )) )
        {

            $filters[] = new TFilter('id_profissional', '=', $data->id_profissional);// create the filter 
        }
        if (isset($data->data_agendamento) AND ( (is_scalar($data->data_agendamento) AND $data->data_agendamento !== '') OR (is_array($data->data_agendamento) AND (!empty($data->data_agendamento)) )) )
        {

            $filters[] = new TFilter('data_agendamento', '=', $data->data_agendamento);// create the filter 
        }

        // fill the form with data again
        $this->form->setData($data);

        // keep the search data in the session
        TSession::setValue(__CLASS__.'_filter_data', $data);

        return $filters;
    }

    public function onGenerate($format)
    {
        try
        {
            $filters = $this->getFilters();
            // open a transaction with database 'reabilitar'
            TTransaction::open(self::$database);
            $param = [];
            // creates a repository for Agendamento
            $repository = new TRepository(self::$activeRecord);
            // creates a criteria
            $criteria = new TCriteria;

            $criteria->setProperties($param);

            if ($filters)
            {
                foreach ($filters as $filter) 
                {
                    $criteria->add($filter);       
                }
            }

            // load the objects according to criteria
            $objects = $repository->load($criteria, FALSE);

            if ($objects)
            {
                $widths = array(200,10,200,200,200,200);

                switch ($format)
                {
                    case 'html':
                        $tr = new TTableWriterHTML($widths);
                        break;
                    case 'xls':
                        $tr = new TTableWriterXLS($widths);
                        break;
                    case 'pdf':
                        $tr = new TTableWriterPDF($widths, 'L', 'A4');
                        break;
                    case 'rtf':
                        if (!class_exists('PHPRtfLite_Autoloader'))
                        {
                            PHPRtfLite::registerAutoloader();
                        }
                        $tr = new TTableWriterRTF($widths, 'L', 'A4');
                        break;
                }

                if (!empty($tr))
                {
                    // create the document styles
                    $tr->addStyle('title', 'Helvetica', '10', 'B',   '#000000', '#dbdbdb');
                    $tr->addStyle('datap', 'Arial', '10', '',    '#333333', '#f0f0f0');
                    $tr->addStyle('datai', 'Arial', '10', '',    '#333333', '#ffffff');
                    $tr->addStyle('header', 'Helvetica', '16', 'B',   '#5a5a5a', '#6B6B6B');
                    $tr->addStyle('footer', 'Helvetica', '10', 'B',  '#5a5a5a', '#A3A3A3');
                    $tr->addStyle('break', 'Helvetica', '10', 'B',  '#ffffff', '#9a9a9a');
                    $tr->addStyle('total', 'Helvetica', '10', 'I',  '#000000', '#c7c7c7');
                    $tr->addStyle('breakTotal', 'Helvetica', '10', 'I',  '#000000', '#c6c8d0');

                    // add titles row
                    $tr->addRow();
                    $tr->addCell("Data", 'center', 'title');
                    $tr->addCell("MF", 'left', 'title');
                    $tr->addCell("Usuário", 'left', 'title');
                    $tr->addCell("Procedimento", 'left', 'title');
                    $tr->addCell("Profissional", 'left', 'title');
                    $tr->addCell("Tipo", 'left', 'title');

                    $grandTotal = [];
                    $breakTotal = [];
                    $breakValue = null;
                    $firstRow = true;

                    // controls the background filling
                    $colour = false;                
                    foreach ($objects as $object)
                    {
                        $style = $colour ? 'datap' : 'datai';

                        $firstRow = false;

                        $object->flg_tipo_agendamento = call_user_func(function($value, $object, $row)
                        {
                            //code here
                           switch ($value) {
                            case 1:
                                return "PRIMEIRA VEZ";
                                break;
                            case 2:
                                return "RETORNO";
                                break;
                            case 3:
                                return "ENCAIXE";
                                break;
                            }

                        }, $object->flg_tipo_agendamento, $object, null);

                        $tr->addRow();

                        $tr->addCell($object->data_agendamento, 'left', $style);
                        $tr->addCell($object->paciente->mf_paciente, 'left', $style);
                        $tr->addCell($object->paciente->nome_paciente, 'left', $style);
                        $tr->addCell($object->procedimento->descricao_procedimento, 'left', $style);
                        $tr->addCell($object->profissional->nome_profissional, 'left', $style);
                        $tr->addCell($object->flg_tipo_agendamento, 'center', $style);

                        $colour = !$colour;
                    }

                    $file = 'report_'.uniqid().".{$format}";
                    // stores the file
                    if (!file_exists("app/output/{$file}") || is_writable("app/output/{$file}"))
                    {
                        $tr->save("app/output/{$file}");
                    }
                    else
                    {
                        throw new Exception(_t('Permission denied') . ': ' . "app/output/{$file}");
                    }

                    parent::openFile("app/output/{$file}");

                    // shows the success message
                    new TMessage('info', _t('Report generated. Please, enable popups'));
                }
            }
            else
            {
                new TMessage('error', _t('No records found'));
            }

            // close the transaction
            TTransaction::close();
        }
        catch (Exception $e) // in case of exception
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());
            // undo all pending operations
            TTransaction::rollback();
        }
    }

    public function onShow($param = null)
    {

    }


}

