<?php

use Dompdf\Dompdf;
use Dompdf\Options;

class VwbpiprofissionalBatchDrawing extends TPage
{
    private static $database = 'reabilitar';
    private static $activeRecord = 'Vwbpiprofissional';
    private static $primaryKey = 'id';
    private static $svgFile = 'app/drawings/VwbpiprofissionalDrawingTemplate.svg';
    private static $formName = 'form_VwbpiprofissionalBatchDrawing';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct()
    {
        parent::__construct();

        // creates the form
        $this->form = new BootstrapFormBuilder(self::$formName);

        // define the form title
        $this->form->setFormTitle("testedesenho");

        $id = new TEntry('id');
        $data_atendimento = new TDate('data_atendimento');
        $nome_profissional = new TEntry('nome_profissional');
        $cns_profissional = new TEntry('cns_profissional');
        $nome_unidade = new TEntry('nome_unidade');
        $cnes_unidade = new TEntry('cnes_unidade');
        $descricao_procedimento = new TEntry('descricao_procedimento');
        $descricao_cid = new TEntry('descricao_cid');
        $cns_paciente = new TEntry('cns_paciente');
        $nome_paciente = new TEntry('nome_paciente');
        $sexo_paciente = new TEntry('sexo_paciente');
        $data_nascimento = new TEntry('data_nascimento');
        $mf_paciente = new TEntry('mf_paciente');
        $id_profissional = new TEntry('id_profissional');
        $seq = new TEntry('seq');

        $data_atendimento->setDatabaseMask('yyyy-mm-dd');
        $data_atendimento->setMask('dd/mm/yyyy');

        $id->setSize(100);
        $seq->setSize('100%');
        $mf_paciente->setSize('100%');
        $nome_unidade->setSize('100%');
        $cnes_unidade->setSize('100%');
        $cns_paciente->setSize('100%');
        $data_atendimento->setSize(110);
        $descricao_cid->setSize('100%');
        $nome_paciente->setSize('100%');
        $sexo_paciente->setSize('100%');
        $data_nascimento->setSize('100%');
        $id_profissional->setSize('100%');
        $cns_profissional->setSize('100%');
        $nome_profissional->setSize('100%');
        $descricao_procedimento->setSize('100%');

        $row1 = $this->form->addFields([new TLabel("Id:", null, '14px', null)],[$id]);
        $row2 = $this->form->addFields([new TLabel("Data atendimento:", null, '14px', null)],[$data_atendimento]);
        $row3 = $this->form->addFields([new TLabel("Nome profissional:", null, '14px', null)],[$nome_profissional]);
        $row4 = $this->form->addFields([new TLabel("Cns profissional:", null, '14px', null)],[$cns_profissional]);
        $row5 = $this->form->addFields([new TLabel("Nome unidade:", null, '14px', null)],[$nome_unidade]);
        $row6 = $this->form->addFields([new TLabel("Cnes unidade:", null, '14px', null)],[$cnes_unidade]);
        $row7 = $this->form->addFields([new TLabel("Descricao procedimento:", null, '14px', null)],[$descricao_procedimento]);
        $row8 = $this->form->addFields([new TLabel("Descricao cid:", null, '14px', null)],[$descricao_cid]);
        $row9 = $this->form->addFields([new TLabel("Cns paciente:", null, '14px', null)],[$cns_paciente]);
        $row10 = $this->form->addFields([new TLabel("Nome paciente:", null, '14px', null)],[$nome_paciente]);
        $row11 = $this->form->addFields([new TLabel("Sexo paciente:", null, '14px', null)],[$sexo_paciente]);
        $row12 = $this->form->addFields([new TLabel("Data nascimento:", null, '14px', null)],[$data_nascimento]);
        $row13 = $this->form->addFields([new TLabel("Mf paciente:", null, '14px', null)],[$mf_paciente]);
        $row14 = $this->form->addFields([new TLabel("Id profissional:", null, '14px', null)],[$id_profissional]);
        $row15 = $this->form->addFields([new TLabel("Seq:", null, '14px', null)],[$seq]);

        // keep the form filled during navigation with session data
        $this->form->setData( TSession::getValue(__CLASS__.'_filter_data') );

        $btn_ongenerate = $this->form->addAction("Gerar", new TAction([$this, 'onGenerate']), 'fas:cog #ffffff');
        $this->btn_ongenerate = $btn_ongenerate;
        $btn_ongenerate->addStyleClass('btn-primary'); 

        // vertical box container
        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->add(TBreadCrumb::create(["Relatórios","testedesenho"]));
        $container->add($this->form);

        parent::add($container);

    }

    public function onGenerate($param)
    {
        try 
        {
            TTransaction::open(self::$database);

            $data = $this->form->getData();
            $criteria = new TCriteria();

            if (isset($data->id) AND ( (is_scalar($data->id) AND $data->id !== '') OR (is_array($data->id) AND (!empty($data->id)) )) ) 
            {

                $criteria->add(new TFilter('id', '=', $data->id));
            }
            if (isset($data->data_atendimento) AND ( (is_scalar($data->data_atendimento) AND $data->data_atendimento !== '') OR (is_array($data->data_atendimento) AND (!empty($data->data_atendimento)) )) ) 
            {

                $criteria->add(new TFilter('data_atendimento', '=', $data->data_atendimento));
            }
            if (isset($data->nome_profissional) AND ( (is_scalar($data->nome_profissional) AND $data->nome_profissional !== '') OR (is_array($data->nome_profissional) AND (!empty($data->nome_profissional)) )) ) 
            {

                $criteria->add(new TFilter('nome_profissional', 'like', "%{$data->nome_profissional}%"));
            }
            if (isset($data->cns_profissional) AND ( (is_scalar($data->cns_profissional) AND $data->cns_profissional !== '') OR (is_array($data->cns_profissional) AND (!empty($data->cns_profissional)) )) ) 
            {

                $criteria->add(new TFilter('cns_profissional', 'like', "%{$data->cns_profissional}%"));
            }
            if (isset($data->nome_unidade) AND ( (is_scalar($data->nome_unidade) AND $data->nome_unidade !== '') OR (is_array($data->nome_unidade) AND (!empty($data->nome_unidade)) )) ) 
            {

                $criteria->add(new TFilter('nome_unidade', 'like', "%{$data->nome_unidade}%"));
            }
            if (isset($data->cnes_unidade) AND ( (is_scalar($data->cnes_unidade) AND $data->cnes_unidade !== '') OR (is_array($data->cnes_unidade) AND (!empty($data->cnes_unidade)) )) ) 
            {

                $criteria->add(new TFilter('cnes_unidade', '=', $data->cnes_unidade));
            }
            if (isset($data->descricao_procedimento) AND ( (is_scalar($data->descricao_procedimento) AND $data->descricao_procedimento !== '') OR (is_array($data->descricao_procedimento) AND (!empty($data->descricao_procedimento)) )) ) 
            {

                $criteria->add(new TFilter('descricao_procedimento', 'like', "%{$data->descricao_procedimento}%"));
            }
            if (isset($data->descricao_cid) AND ( (is_scalar($data->descricao_cid) AND $data->descricao_cid !== '') OR (is_array($data->descricao_cid) AND (!empty($data->descricao_cid)) )) ) 
            {

                $criteria->add(new TFilter('descricao_cid', 'like', "%{$data->descricao_cid}%"));
            }
            if (isset($data->cns_paciente) AND ( (is_scalar($data->cns_paciente) AND $data->cns_paciente !== '') OR (is_array($data->cns_paciente) AND (!empty($data->cns_paciente)) )) ) 
            {

                $criteria->add(new TFilter('cns_paciente', 'like', "%{$data->cns_paciente}%"));
            }
            if (isset($data->nome_paciente) AND ( (is_scalar($data->nome_paciente) AND $data->nome_paciente !== '') OR (is_array($data->nome_paciente) AND (!empty($data->nome_paciente)) )) ) 
            {

                $criteria->add(new TFilter('nome_paciente', 'like', "%{$data->nome_paciente}%"));
            }
            if (isset($data->sexo_paciente) AND ( (is_scalar($data->sexo_paciente) AND $data->sexo_paciente !== '') OR (is_array($data->sexo_paciente) AND (!empty($data->sexo_paciente)) )) ) 
            {

                $criteria->add(new TFilter('sexo_paciente', 'like', "%{$data->sexo_paciente}%"));
            }
            if (isset($data->data_nascimento) AND ( (is_scalar($data->data_nascimento) AND $data->data_nascimento !== '') OR (is_array($data->data_nascimento) AND (!empty($data->data_nascimento)) )) ) 
            {

                $criteria->add(new TFilter('data_nascimento', 'like', "%{$data->data_nascimento}%"));
            }
            if (isset($data->mf_paciente) AND ( (is_scalar($data->mf_paciente) AND $data->mf_paciente !== '') OR (is_array($data->mf_paciente) AND (!empty($data->mf_paciente)) )) ) 
            {

                $criteria->add(new TFilter('mf_paciente', '=', $data->mf_paciente));
            }
            if (isset($data->id_profissional) AND ( (is_scalar($data->id_profissional) AND $data->id_profissional !== '') OR (is_array($data->id_profissional) AND (!empty($data->id_profissional)) )) ) 
            {

                $criteria->add(new TFilter('id_profissional', '=', $data->id_profissional));
            }
            if (isset($data->seq) AND ( (is_scalar($data->seq) AND $data->seq !== '') OR (is_array($data->seq) AND (!empty($data->seq)) )) ) 
            {

                $criteria->add(new TFilter('seq', '=', $data->seq));
            }

            $options = new Options();
            $options->set('dpi', '72');
            $options->setIsRemoteEnabled(true);
            $options->setChroot(getcwd());
            $options->setIsHtml5ParserEnabled(true);

            $objects = Vwbpiprofissional::getObjects($criteria, FALSE);
            if ($objects)
            {
                $output = '';

                $count = 1;
                $count_records = count($objects);

                foreach ($objects as $object)
                {

                    $html = new AdiantiHTMLDocumentParser();
                    $html->setMaster($object);
                    $html->addContent("
                    <style>
                        @page {
                            margin: 0px 0px 0px 0px !important;
                            padding: 0px 0px 0px 0px !important;
                        }
                    </style>
                    ");

                    $html->setDOMOptions($options);

                    $html->parseImage(self::$svgFile, 580, 400);
                    $html->process();

                    if ($count < $count_records)
                    {
                        $html->addPageBreak();
                    }

                    $output .= $html->getContents();

                    $count++;
                }

                $document = 'tmp/'.uniqid().'.pdf'; 
                $html = AdiantiHTMLDocumentParser::newFromString($output);
                $html->setDOMOptions($options);
                $html->saveAsPDF($document, [580, 400]);

                parent::openFile($document);
                new TMessage('info', _t('Drawing successfully generated'));
            }
            else
            {
                new TMessage('info', _t('No records found'));   
            }

            TTransaction::close();

            TSession::setValue(__CLASS__.'_filter_data', $data);

            $this->form->setData($data);

        } 
        catch (Exception $e) 
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    } 

    public function onShow($param = null)
    {

    }

}

