<?php

use Dompdf\Dompdf;
use Dompdf\Options;

class VwbpiprofissionalDrawing extends TPage
{
    private static $database = 'reabilitar';
    private static $activeRecord = 'Vwbpiprofissional';
    private static $primaryKey = 'id';
    private static $svgFile = 'app/drawings/VwbpiprofissionalDrawingTemplate.svg';

    /**
     * Form constructor
     * @param $param Request
     */
    public function __construct( $param )
    {

    }

    public static function onGenerate($param)
    {
        try 
        {
            TTransaction::open(self::$database);

            $class = self::$activeRecord;
            $object = new $class($param['key']);

            $html = new AdiantiHTMLDocumentParser();
            $html->setMaster($object);
            $html->addContent("
            <style>
                @page {
                    margin: 0px 0px 0px 0px !important;
                    padding: 0px 0px 0px 0px !important;
                }
            </style>
            ");

            $options = new Options();
            $options->set('dpi', '72');
            $options->setIsRemoteEnabled(true);
            $options->setChroot(getcwd());
            $options->setIsHtml5ParserEnabled(true);

            $html->setDOMOptions($options);
            $html->parseImage(self::$svgFile, 580, 400);
            $html->process();

            $document = 'tmp/'.uniqid().'.pdf'; 
            $html->saveAsPDF($document, [580, 400]);

            TTransaction::close();

            parent::openFile($document);

            new TMessage('info', _t('Drawing successfully generated'));
        } 
        catch (Exception $e) 
        {
            // shows the exception error message
            new TMessage('error', $e->getMessage());

            // undo all pending operations
            TTransaction::rollback();
        }
    } 

}

