CREATE TABLE afastamento_profissional( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_profissional` int   NOT NULL  , 
      `data_inicio` date   NOT NULL  , 
      `data_fim` date   NOT NULL  , 
      `moitvo_afastamento` text   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE agendamento( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_paciente` int   NOT NULL  , 
      `id_escala` int   NOT NULL  , 
      `id_unidade_saude` int   NOT NULL  , 
      `id_situacao` int   NOT NULL  , 
      `id_procedimento` int   NOT NULL  , 
      `id_profissional` int   NOT NULL  , 
      `data_agendamento` date   NOT NULL  , 
      `flg_atendimento` varchar  (1)   NOT NULL  , 
      `flg_tipo_agendamento` varchar  (1)   , 
      `flg_app_agenda` varchar  (1)   , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE alergia_avaliacao( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_tipo_alergia` int   NOT NULL  , 
      `id_avaliacao_medica` int   NOT NULL  , 
      `especificacao` text   , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE avaliacao_abemid_paciente( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_paciente` int   NOT NULL  , 
      `id_escore_abemid` int   NOT NULL  , 
      `id_item_escore` int   NOT NULL  , 
      `id_classificacao` int   NOT NULL  , 
      `escore_abemid` int   NOT NULL  , 
      `data_avaliacao` date   NOT NULL  , 
      `pontuacao_obtida` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE avaliacao_medica( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_paciente` int   NOT NULL  , 
      `id_agendamento` int   NOT NULL  , 
      `data_cadastro` datetime   , 
      `data_atualizacao` datetime   , 
      `flg_bloqueador` int   NOT NULL  , 
      `flg_sedacao` int   NOT NULL  , 
      `data_avaliacao` date   , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE bairro( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_cidade` int   NOT NULL  , 
      `nome_bairro` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE cid10( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao_cid` varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE cidade( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_estado` int   NOT NULL  , 
      `id_regiao` int   NOT NULL  , 
      `nome_cidade` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE classificacao_abemid( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE distrito( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `nome_distrito` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE distrito_bairro( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_bairro` int   NOT NULL  , 
      `id_distrito` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE endereco_paciente( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_paciente` int   NOT NULL  , 
      `id_estado` int   NOT NULL  , 
      `id_cidade` int   NOT NULL  , 
      `id_bairro` int   NOT NULL  , 
      `id_tipo` int   NOT NULL  , 
      `logradouro` varchar  (50)   NOT NULL  , 
      `num_logradouro` int   NOT NULL  , 
      `complemento` varchar  (50)   , 
      `cep_logradouro` varchar  (10)   NOT NULL  , 
      `ponto_referencia` text   , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE endereco_profissional( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_profissional` int   NOT NULL  , 
      `id_estado` int   NOT NULL  , 
      `id_cidade` int   NOT NULL  , 
      `id_bairro` int   NOT NULL  , 
      `id_tipo` int   NOT NULL  , 
      `logradouro` varchar  (50)   NOT NULL  , 
      `num_logradouro` int   NOT NULL  , 
      `complemento` varchar  (50)   , 
      `cep_logradouro` varchar  (10)   NOT NULL  , 
      `ponto_referencia` text   , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE equipe( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_unidade` int   NOT NULL  , 
      `nome` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE escala( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_equipe` int   , 
      `id_profissional` int   , 
      `id_turno` int   NOT NULL  , 
      `id_unidade_saude` int   NOT NULL  , 
      `id_procedimento` int   NOT NULL  , 
      `qtd_primeira_vez` int   NOT NULL  , 
      `data_limite` date   NOT NULL  , 
      `qtd_retorno` int   NOT NULL  , 
      `encaixe` int   NOT NULL  , 
      `data_inicio` date   NOT NULL  , 
      `id_ocupacao` int   , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE escala_dia( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_escala` int   NOT NULL  , 
      `dia_semana` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE escore_abemid( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao_grupo` varchar  (50)   NOT NULL  , 
      `tipo_tabela_abemid` varchar  (10)   NOT NULL    DEFAULT 'Adulto', 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE estado( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `nome_estado` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE evento_agendamento( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao` varchar  (50)   NOT NULL  , 
      `sigla` varchar  (2)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE exame_avaliacao( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_avaliacao_medica` int   NOT NULL  , 
      `descricao_exame` varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE feriados( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao_feriado` varchar  (100)   NOT NULL  , 
      `data_feriado` date   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE historico_agendamento( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_status` int   NOT NULL  , 
      `id_agendamento` int   NOT NULL  , 
      `id_usuario` int   NOT NULL  , 
      `justificativa` varchar  (500)   NOT NULL  , 
      `data_hora` datetime   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE itens_escoreabemid( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_escore_abemid_adulto` int   NOT NULL  , 
      `descricao_item` varchar  (50)   NOT NULL  , 
      `qtd_pontos_item` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE medicamento_avaliacao( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_avaliacao_medica` int   NOT NULL  , 
      `descricao_medicamento` varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE ocupacao( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao_ocupacao` varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE paciente( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `cpf` varchar  (14)   , 
      `cns_paciente` int   , 
      `rg_paciente` varchar  (15)   , 
      `nome_paciente` varchar  (50)   NOT NULL  , 
      `data_nascimento` date   NOT NULL  , 
      `mae_paciente` varchar  (50)   NOT NULL  , 
      `telefone` varchar  (15)   NOT NULL  , 
      `pai_paciente` varchar  (50)   , 
      `responsavel_paciente` varchar  (50)   , 
      `cpf_responsavel` varchar  (14)   , 
      `celular_paciente` varchar  (15)   , 
      `mf_paciente` int   , 
      `naturalidade` varchar  (50)   , 
      `data_admissao` date   , 
      `sexo_paciente` varchar  (30)   , 
      `system_user_id` int   , 
      `flg_externo` varchar  (1)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE paciente_cid10( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_cid` int   NOT NULL  , 
      `id_paciente` int   NOT NULL  , 
      `id_tipo_cid` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE parametros( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `num_dias_abertura_agenda` int   NOT NULL  , 
      `num_dias_transferencia_agenda` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE procedimento( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `codigo_procedimento` varchar  (15)   NOT NULL  , 
      `descricao_procedimento` varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE profissional( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `cpf` varchar  (14)   NOT NULL  , 
      `nome_profissional` varchar  (50)   NOT NULL  , 
      `cns_profissional` varchar  (20)   NOT NULL  , 
      `matricula` int   NOT NULL  , 
      `telefone` varchar  (15)   NOT NULL  , 
      `flg_excluido` varchar  (1)   , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE profissional_equipe( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_profissional` int   NOT NULL  , 
      `id_equipe` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE profissional_ocupacao( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_profissional` int   NOT NULL  , 
      `id_ocupacao` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE profissional_unidade( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_profissional` int   NOT NULL  , 
      `id_unidade` int   NOT NULL  , 
      `id_setor` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE regiao( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `nome_regiao` varchar  (50)   NOT NULL  , 
      `id_estado` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE setor( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `id_unidade` int   NOT NULL  , 
      `descricao_setor` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE tipo_alergia( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao` varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE tipo_cid( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE tipo_logradouro( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `descricao` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE turno( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `nome` varchar  (50)   NOT NULL  , 
      `horario` varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

CREATE TABLE unidade_saude( 
      `id`  INT  AUTO_INCREMENT    NOT NULL  , 
      `nome` varchar  (50)   NOT NULL  , 
      `cnes_unidade` int   NOT NULL  , 
 PRIMARY KEY (id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci; 

 
 ALTER TABLE escala ADD UNIQUE (id);
 ALTER TABLE paciente ADD UNIQUE (id);
 ALTER TABLE profissional ADD UNIQUE (cpf);
  
 ALTER TABLE afastamento_profissional ADD CONSTRAINT fk_afastamento_profissional_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_2 FOREIGN KEY (id_escala) references escala(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_3 FOREIGN KEY (id_unidade_saude) references unidade_saude(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_5 FOREIGN KEY (id_procedimento) references procedimento(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_profissional FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE alergia_avaliacao ADD CONSTRAINT fk_alegia_avaliacao_1 FOREIGN KEY (id_avaliacao_medica) references avaliacao_medica(id); 
ALTER TABLE alergia_avaliacao ADD CONSTRAINT fk_alegia_avaliacao_2 FOREIGN KEY (id_tipo_alergia) references tipo_alergia(id); 
ALTER TABLE avaliacao_abemid_paciente ADD CONSTRAINT fk_avaliacao_abemid_paciente_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE avaliacao_abemid_paciente ADD CONSTRAINT fk_avaliacao_abemid_paciente_2 FOREIGN KEY (id_escore_abemid) references escore_abemid(id); 
ALTER TABLE avaliacao_abemid_paciente ADD CONSTRAINT fk_avaliacao_abemid_paciente_3 FOREIGN KEY (id_item_escore) references itens_escoreabemid(id); 
ALTER TABLE avaliacao_abemid_paciente ADD CONSTRAINT fk_avaliacao_abemid_paciente_4 FOREIGN KEY (id_classificacao) references classificacao_abemid(id); 
ALTER TABLE avaliacao_medica ADD CONSTRAINT fk_avaliacao_medica_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE avaliacao_medica ADD CONSTRAINT fk_avaliacao_medica_2 FOREIGN KEY (id_agendamento) references agendamento(id); 
ALTER TABLE bairro ADD CONSTRAINT fk_bairro_1 FOREIGN KEY (id_cidade) references cidade(id); 
ALTER TABLE cidade ADD CONSTRAINT fk_cidade_1 FOREIGN KEY (id_estado) references estado(id); 
ALTER TABLE cidade ADD CONSTRAINT fk_cidade_2 FOREIGN KEY (id_regiao) references regiao(id); 
ALTER TABLE distrito_bairro ADD CONSTRAINT fk_distrito_bairro_1 FOREIGN KEY (id_bairro) references bairro(id); 
ALTER TABLE distrito_bairro ADD CONSTRAINT fk_distrito_bairro_2 FOREIGN KEY (id_distrito) references distrito(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_2 FOREIGN KEY (id_estado) references estado(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_3 FOREIGN KEY (id_cidade) references cidade(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_4 FOREIGN KEY (id_bairro) references bairro(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_5 FOREIGN KEY (id_tipo) references tipo_logradouro(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_2 FOREIGN KEY (id_estado) references estado(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_3 FOREIGN KEY (id_cidade) references cidade(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_4 FOREIGN KEY (id_bairro) references bairro(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_5 FOREIGN KEY (id_tipo) references tipo_logradouro(id); 
ALTER TABLE equipe ADD CONSTRAINT fk_equipe_1 FOREIGN KEY (id_unidade) references unidade_saude(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_1 FOREIGN KEY (id_equipe) references equipe(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_2 FOREIGN KEY (id_turno) references turno(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_3 FOREIGN KEY (id_unidade_saude) references unidade_saude(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_6 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_5 FOREIGN KEY (id_procedimento) references procedimento(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_pcupacao FOREIGN KEY (id_ocupacao) references ocupacao(id); 
ALTER TABLE escala_dia ADD CONSTRAINT fk_escala_dia_1 FOREIGN KEY (id_escala) references escala(id); 
ALTER TABLE exame_avaliacao ADD CONSTRAINT fk_exame_avaliacao_1 FOREIGN KEY (id_avaliacao_medica) references avaliacao_medica(id); 
ALTER TABLE historico_agendamento ADD CONSTRAINT fk_historico_agendamento_eventos FOREIGN KEY (id_status) references evento_agendamento(id); 
ALTER TABLE historico_agendamento ADD CONSTRAINT fk_historico_agendamento FOREIGN KEY (id_agendamento) references agendamento(id); 
ALTER TABLE itens_escoreabemid ADD CONSTRAINT fk_itens_escoreabemid_adulto_1 FOREIGN KEY (id_escore_abemid_adulto) references escore_abemid(id); 
ALTER TABLE medicamento_avaliacao ADD CONSTRAINT fk_medicamento_avaliacao_1 FOREIGN KEY (id_avaliacao_medica) references avaliacao_medica(id); 
ALTER TABLE paciente_cid10 ADD CONSTRAINT fk_paciente_cid10_tipo_cid FOREIGN KEY (id_tipo_cid) references tipo_cid(id); 
ALTER TABLE paciente_cid10 ADD CONSTRAINT fk_paciente_cid10_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE paciente_cid10 ADD CONSTRAINT fk_paciente_cid10_2 FOREIGN KEY (id_cid) references cid10(id); 
ALTER TABLE profissional_equipe ADD CONSTRAINT fk_profissional_equipe_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE profissional_equipe ADD CONSTRAINT fk_profissional_equipe_2 FOREIGN KEY (id_equipe) references equipe(id); 
ALTER TABLE profissional_ocupacao ADD CONSTRAINT fk_profissional_ocupacao_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE profissional_ocupacao ADD CONSTRAINT fk_profissional_ocupacao_2 FOREIGN KEY (id_ocupacao) references ocupacao(id); 
ALTER TABLE profissional_unidade ADD CONSTRAINT fk_profissional_unidade_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE profissional_unidade ADD CONSTRAINT fk_profissional_unidade_2 FOREIGN KEY (id_unidade) references unidade_saude(id); 
ALTER TABLE profissional_unidade ADD CONSTRAINT fk_profissional_unidade_3 FOREIGN KEY (id_setor) references setor(id); 
ALTER TABLE regiao ADD CONSTRAINT fk_regiao_1 FOREIGN KEY (id_estado) references estado(id); 
ALTER TABLE setor ADD CONSTRAINT fk_new_table_23_1 FOREIGN KEY (id_unidade) references unidade_saude(id); 

 CREATE VIEW agendamento_escala AS SELECT 
    count(*) AS numero_de_agendamentos_dia,
    agendamento.data_agendamento as data_agendamento,
    agendamento.flg_tipo_agendamento as tipo_agendamento,
    agendamento.id_escala as id_escala  
FROM agendamento
GROUP BY agendamento.data_agendamento, agendamento.id_escala, agendamento.flg_tipo_agendamento

/*
select 
  count(*) as numero_de_agendamentos_dia,
  data_agendamento as data_agendamento,
  flg_tipo_agendamento as tipo_agendamento
from
  agendamento
group by data_agendamento, tipo_agendamento, id */
; 
CREATE VIEW vwAgendaDiariaProfissional AS SELECT 
   a.id as id,
   a.data_agendamento as data,
   p.cns_profissional as cns_profissional, 
   p.nome_profissional as nome_profissional,
   u.mf_paciente as mf,
   u.nome_paciente as nome_paciente
FROM 
  agendamento a,
  profissional p,
  paciente u
where 
  a.id_profissional = p.id and
  a.id_paciente = u.id; 
CREATE VIEW vwBpiProfissional AS SELECT 
  count(agendamento.id) as seq,
  agendamento.id as id,
  agendamento.data_agendamento as data_atendimento,
  profissional.id as id_profissional,
  profissional.nome_profissional as nome_profissional,
  profissional.cns_profissional as cns_profissional,
  unidade_saude.nome as nome_unidade,
  unidade_saude.cnes_unidade as cnes_unidade,
  procedimento.descricao_procedimento as descricao_procedimento,
  cid10.descricao_cid as descricao_cid,
  paciente.cns_paciente as cns_paciente,
  paciente.nome_paciente as nome_paciente,
  paciente.sexo_paciente as sexo_paciente,
  paciente.data_nascimento as data_nascimento,
  paciente.mf_paciente as mf_paciente
FROM
  agendamento
  INNER JOIN profissional ON (agendamento.id_profissional = profissional.id)
  INNER JOIN unidade_saude ON (agendamento.id_unidade_saude = unidade_saude.id)
  INNER JOIN profissional_unidade ON (profissional.id = profissional_unidade.id_profissional)
  AND (unidade_saude.id = profissional_unidade.id_unidade)
  INNER JOIN paciente ON (agendamento.id_paciente = paciente.id)
  INNER JOIN paciente_cid10 ON (paciente.id = paciente_cid10.id_paciente)
  INNER JOIN cid10 ON (paciente_cid10.id_cid = cid10.id)
  INNER JOIN procedimento ON (agendamento.id_procedimento = procedimento.id)
GROUP BY
   profissional.id, 
   profissional.nome_profissional,
   profissional.cns_profissional,
   unidade_saude.nome,
   unidade_saude.cnes_unidade,
   procedimento.descricao_procedimento,
   cid10.descricao_cid,
   paciente.cns_paciente,
   paciente.nome_paciente,
   paciente.sexo_paciente,
   paciente.data_nascimento,
   paciente.mf_paciente,
   agendamento.id,
   agendamento.data_agendamento; 
CREATE VIEW vw_num_agendamentos_escala AS select 
  id_escala as id_escala,
  (select count(*) as numero_de_agendamentos_dia from agendamento where flg_tipo_agendamento = '1' group by data_agendamento) as total_agendado_p_vez,
  (select count(*) as numero_de_agendamentos_dia from agendamento where flg_tipo_agendamento = '2' group by data_agendamento) as total_agendado_retorno
from 
agendamento
; 
 
