CREATE TABLE afastamento_profissional( 
      id number(10)    NOT NULL , 
      id_profissional number(10)    NOT NULL , 
      data_inicio date    NOT NULL , 
      data_fim date    NOT NULL , 
      moitvo_afastamento varchar(3000)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE agendamento( 
      id number(10)    NOT NULL , 
      id_paciente number(10)    NOT NULL , 
      id_escala number(10)    NOT NULL , 
      id_unidade_saude number(10)    NOT NULL , 
      id_situacao number(10)    NOT NULL , 
      id_procedimento number(10)    NOT NULL , 
      id_profissional number(10)    NOT NULL , 
      data_agendamento date    NOT NULL , 
      flg_atendimento varchar  (1)    NOT NULL , 
      flg_tipo_agendamento varchar  (1)   , 
      flg_app_agenda varchar  (1)   , 
 PRIMARY KEY (id)) ; 

CREATE TABLE alergia_avaliacao( 
      id number(10)    NOT NULL , 
      id_tipo_alergia number(10)    NOT NULL , 
      id_avaliacao_medica number(10)    NOT NULL , 
      especificacao varchar(3000)   , 
 PRIMARY KEY (id)) ; 

CREATE TABLE avaliacao_abemid_paciente( 
      id number(10)    NOT NULL , 
      id_paciente number(10)    NOT NULL , 
      id_escore_abemid number(10)    NOT NULL , 
      id_item_escore number(10)    NOT NULL , 
      id_classificacao number(10)    NOT NULL , 
      escore_abemid number(10)    NOT NULL , 
      data_avaliacao date    NOT NULL , 
      pontuacao_obtida number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE avaliacao_medica( 
      id number(10)    NOT NULL , 
      id_paciente number(10)    NOT NULL , 
      id_agendamento number(10)    NOT NULL , 
      data_cadastro timestamp(0)   , 
      data_atualizacao timestamp(0)   , 
      flg_bloqueador number(10)    NOT NULL , 
      flg_sedacao number(10)    NOT NULL , 
      data_avaliacao date   , 
 PRIMARY KEY (id)) ; 

CREATE TABLE bairro( 
      id number(10)    NOT NULL , 
      id_cidade number(10)    NOT NULL , 
      nome_bairro varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE cid10( 
      id number(10)    NOT NULL , 
      descricao_cid varchar  (100)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE cidade( 
      id number(10)    NOT NULL , 
      id_estado number(10)    NOT NULL , 
      id_regiao number(10)    NOT NULL , 
      nome_cidade varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE classificacao_abemid( 
      id number(10)    NOT NULL , 
      descricao varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE distrito( 
      id number(10)    NOT NULL , 
      nome_distrito varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE distrito_bairro( 
      id number(10)    NOT NULL , 
      id_bairro number(10)    NOT NULL , 
      id_distrito number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE endereco_paciente( 
      id number(10)    NOT NULL , 
      id_paciente number(10)    NOT NULL , 
      id_estado number(10)    NOT NULL , 
      id_cidade number(10)    NOT NULL , 
      id_bairro number(10)    NOT NULL , 
      id_tipo number(10)    NOT NULL , 
      logradouro varchar  (50)    NOT NULL , 
      num_logradouro number(10)    NOT NULL , 
      complemento varchar  (50)   , 
      cep_logradouro varchar  (10)    NOT NULL , 
      ponto_referencia varchar(3000)   , 
 PRIMARY KEY (id)) ; 

CREATE TABLE endereco_profissional( 
      id number(10)    NOT NULL , 
      id_profissional number(10)    NOT NULL , 
      id_estado number(10)    NOT NULL , 
      id_cidade number(10)    NOT NULL , 
      id_bairro number(10)    NOT NULL , 
      id_tipo number(10)    NOT NULL , 
      logradouro varchar  (50)    NOT NULL , 
      num_logradouro number(10)    NOT NULL , 
      complemento varchar  (50)   , 
      cep_logradouro varchar  (10)    NOT NULL , 
      ponto_referencia varchar(3000)   , 
 PRIMARY KEY (id)) ; 

CREATE TABLE equipe( 
      id number(10)    NOT NULL , 
      id_unidade number(10)    NOT NULL , 
      nome varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE escala( 
      id number(10)    NOT NULL , 
      id_equipe number(10)   , 
      id_profissional number(10)   , 
      id_turno number(10)    NOT NULL , 
      id_unidade_saude number(10)    NOT NULL , 
      id_procedimento number(10)    NOT NULL , 
      qtd_primeira_vez number(10)    NOT NULL , 
      data_limite date    NOT NULL , 
      qtd_retorno number(10)    NOT NULL , 
      encaixe number(10)    NOT NULL , 
      data_inicio date    NOT NULL , 
      id_ocupacao number(10)   , 
 PRIMARY KEY (id)) ; 

CREATE TABLE escala_dia( 
      id number(10)    NOT NULL , 
      id_escala number(10)    NOT NULL , 
      dia_semana number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE escore_abemid( 
      id number(10)    NOT NULL , 
      descricao_grupo varchar  (50)    NOT NULL , 
      tipo_tabela_abemid varchar  (10)    DEFAULT 'Adulto'  NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE estado( 
      id number(10)    NOT NULL , 
      nome_estado varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE evento_agendamento( 
      id number(10)    NOT NULL , 
      descricao varchar  (50)    NOT NULL , 
      sigla varchar  (2)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE exame_avaliacao( 
      id number(10)    NOT NULL , 
      id_avaliacao_medica number(10)    NOT NULL , 
      descricao_exame varchar  (100)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE feriados( 
      id number(10)    NOT NULL , 
      descricao_feriado varchar  (100)    NOT NULL , 
      data_feriado date    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE historico_agendamento( 
      id number(10)    NOT NULL , 
      id_status number(10)    NOT NULL , 
      id_agendamento number(10)    NOT NULL , 
      id_usuario number(10)    NOT NULL , 
      justificativa varchar  (500)    NOT NULL , 
      data_hora timestamp(0)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE itens_escoreabemid( 
      id number(10)    NOT NULL , 
      id_escore_abemid_adulto number(10)    NOT NULL , 
      descricao_item varchar  (50)    NOT NULL , 
      qtd_pontos_item number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE medicamento_avaliacao( 
      id number(10)    NOT NULL , 
      id_avaliacao_medica number(10)    NOT NULL , 
      descricao_medicamento varchar  (100)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE ocupacao( 
      id number(10)    NOT NULL , 
      descricao_ocupacao varchar  (100)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE paciente( 
      id number(10)    NOT NULL , 
      cpf varchar  (14)   , 
      cns_paciente number(10)   , 
      rg_paciente varchar  (15)   , 
      nome_paciente varchar  (50)    NOT NULL , 
      data_nascimento date    NOT NULL , 
      mae_paciente varchar  (50)    NOT NULL , 
      telefone varchar  (15)    NOT NULL , 
      pai_paciente varchar  (50)   , 
      responsavel_paciente varchar  (50)   , 
      cpf_responsavel varchar  (14)   , 
      celular_paciente varchar  (15)   , 
      mf_paciente number(10)   , 
      naturalidade varchar  (50)   , 
      data_admissao date   , 
      sexo_paciente varchar  (30)   , 
      system_user_id number(10)   , 
      flg_externo varchar  (1)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE paciente_cid10( 
      id number(10)    NOT NULL , 
      id_cid number(10)    NOT NULL , 
      id_paciente number(10)    NOT NULL , 
      id_tipo_cid number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE parametros( 
      id number(10)    NOT NULL , 
      num_dias_abertura_agenda number(10)    NOT NULL , 
      num_dias_transferencia_agenda number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE procedimento( 
      id number(10)    NOT NULL , 
      codigo_procedimento varchar  (15)    NOT NULL , 
      descricao_procedimento varchar  (100)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE profissional( 
      id number(10)    NOT NULL , 
      cpf varchar  (14)    NOT NULL , 
      nome_profissional varchar  (50)    NOT NULL , 
      cns_profissional varchar  (20)    NOT NULL , 
      matricula number(10)    NOT NULL , 
      telefone varchar  (15)    NOT NULL , 
      flg_excluido varchar  (1)   , 
 PRIMARY KEY (id)) ; 

CREATE TABLE profissional_equipe( 
      id number(10)    NOT NULL , 
      id_profissional number(10)    NOT NULL , 
      id_equipe number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE profissional_ocupacao( 
      id number(10)    NOT NULL , 
      id_profissional number(10)    NOT NULL , 
      id_ocupacao number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE profissional_unidade( 
      id number(10)    NOT NULL , 
      id_profissional number(10)    NOT NULL , 
      id_unidade number(10)    NOT NULL , 
      id_setor number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE regiao( 
      id number(10)    NOT NULL , 
      nome_regiao varchar  (50)    NOT NULL , 
      id_estado number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE setor( 
      id number(10)    NOT NULL , 
      id_unidade number(10)    NOT NULL , 
      descricao_setor varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE tipo_alergia( 
      id number(10)    NOT NULL , 
      descricao varchar  (100)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE tipo_cid( 
      id number(10)    NOT NULL , 
      descricao varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE tipo_logradouro( 
      id number(10)    NOT NULL , 
      descricao varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE turno( 
      id number(10)    NOT NULL , 
      nome varchar  (50)    NOT NULL , 
      horario varchar  (50)    NOT NULL , 
 PRIMARY KEY (id)) ; 

CREATE TABLE unidade_saude( 
      id number(10)    NOT NULL , 
      nome varchar  (50)    NOT NULL , 
      cnes_unidade number(10)    NOT NULL , 
 PRIMARY KEY (id)) ; 

 
 ALTER TABLE escala ADD UNIQUE (id);
 ALTER TABLE paciente ADD UNIQUE (id);
 ALTER TABLE profissional ADD UNIQUE (cpf);
  
 ALTER TABLE afastamento_profissional ADD CONSTRAINT fk_afastamento_profissional_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_2 FOREIGN KEY (id_escala) references escala(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_3 FOREIGN KEY (id_unidade_saude) references unidade_saude(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_5 FOREIGN KEY (id_procedimento) references procedimento(id); 
ALTER TABLE agendamento ADD CONSTRAINT fk_agendamento_profissional FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE alergia_avaliacao ADD CONSTRAINT fk_alegia_avaliacao_1 FOREIGN KEY (id_avaliacao_medica) references avaliacao_medica(id); 
ALTER TABLE alergia_avaliacao ADD CONSTRAINT fk_alegia_avaliacao_2 FOREIGN KEY (id_tipo_alergia) references tipo_alergia(id); 
ALTER TABLE avaliacao_abemid_paciente ADD CONSTRAINT fk_avaliacao_abemid_paciente_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE avaliacao_abemid_paciente ADD CONSTRAINT fk_avaliacao_abemid_paciente_2 FOREIGN KEY (id_escore_abemid) references escore_abemid(id); 
ALTER TABLE avaliacao_abemid_paciente ADD CONSTRAINT fk_avaliacao_abemid_paciente_3 FOREIGN KEY (id_item_escore) references itens_escoreabemid(id); 
ALTER TABLE avaliacao_abemid_paciente ADD CONSTRAINT fk_avaliacao_abemid_paciente_4 FOREIGN KEY (id_classificacao) references classificacao_abemid(id); 
ALTER TABLE avaliacao_medica ADD CONSTRAINT fk_avaliacao_medica_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE avaliacao_medica ADD CONSTRAINT fk_avaliacao_medica_2 FOREIGN KEY (id_agendamento) references agendamento(id); 
ALTER TABLE bairro ADD CONSTRAINT fk_bairro_1 FOREIGN KEY (id_cidade) references cidade(id); 
ALTER TABLE cidade ADD CONSTRAINT fk_cidade_1 FOREIGN KEY (id_estado) references estado(id); 
ALTER TABLE cidade ADD CONSTRAINT fk_cidade_2 FOREIGN KEY (id_regiao) references regiao(id); 
ALTER TABLE distrito_bairro ADD CONSTRAINT fk_distrito_bairro_1 FOREIGN KEY (id_bairro) references bairro(id); 
ALTER TABLE distrito_bairro ADD CONSTRAINT fk_distrito_bairro_2 FOREIGN KEY (id_distrito) references distrito(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_2 FOREIGN KEY (id_estado) references estado(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_3 FOREIGN KEY (id_cidade) references cidade(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_4 FOREIGN KEY (id_bairro) references bairro(id); 
ALTER TABLE endereco_paciente ADD CONSTRAINT fk_endereco_paciente_5 FOREIGN KEY (id_tipo) references tipo_logradouro(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_2 FOREIGN KEY (id_estado) references estado(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_3 FOREIGN KEY (id_cidade) references cidade(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_4 FOREIGN KEY (id_bairro) references bairro(id); 
ALTER TABLE endereco_profissional ADD CONSTRAINT fk_endereco_profissional_5 FOREIGN KEY (id_tipo) references tipo_logradouro(id); 
ALTER TABLE equipe ADD CONSTRAINT fk_equipe_1 FOREIGN KEY (id_unidade) references unidade_saude(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_1 FOREIGN KEY (id_equipe) references equipe(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_2 FOREIGN KEY (id_turno) references turno(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_3 FOREIGN KEY (id_unidade_saude) references unidade_saude(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_6 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_5 FOREIGN KEY (id_procedimento) references procedimento(id); 
ALTER TABLE escala ADD CONSTRAINT fk_escala_pcupacao FOREIGN KEY (id_ocupacao) references ocupacao(id); 
ALTER TABLE escala_dia ADD CONSTRAINT fk_escala_dia_1 FOREIGN KEY (id_escala) references escala(id); 
ALTER TABLE exame_avaliacao ADD CONSTRAINT fk_exame_avaliacao_1 FOREIGN KEY (id_avaliacao_medica) references avaliacao_medica(id); 
ALTER TABLE historico_agendamento ADD CONSTRAINT fk_historico_agendamento_eventos FOREIGN KEY (id_status) references evento_agendamento(id); 
ALTER TABLE historico_agendamento ADD CONSTRAINT fk_historico_agendamento FOREIGN KEY (id_agendamento) references agendamento(id); 
ALTER TABLE itens_escoreabemid ADD CONSTRAINT fk_itens_escoreabemid_adulto_1 FOREIGN KEY (id_escore_abemid_adulto) references escore_abemid(id); 
ALTER TABLE medicamento_avaliacao ADD CONSTRAINT fk_medicamento_avaliacao_1 FOREIGN KEY (id_avaliacao_medica) references avaliacao_medica(id); 
ALTER TABLE paciente_cid10 ADD CONSTRAINT fk_paciente_cid10_tipo_cid FOREIGN KEY (id_tipo_cid) references tipo_cid(id); 
ALTER TABLE paciente_cid10 ADD CONSTRAINT fk_paciente_cid10_1 FOREIGN KEY (id_paciente) references paciente(id); 
ALTER TABLE paciente_cid10 ADD CONSTRAINT fk_paciente_cid10_2 FOREIGN KEY (id_cid) references cid10(id); 
ALTER TABLE profissional_equipe ADD CONSTRAINT fk_profissional_equipe_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE profissional_equipe ADD CONSTRAINT fk_profissional_equipe_2 FOREIGN KEY (id_equipe) references equipe(id); 
ALTER TABLE profissional_ocupacao ADD CONSTRAINT fk_profissional_ocupacao_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE profissional_ocupacao ADD CONSTRAINT fk_profissional_ocupacao_2 FOREIGN KEY (id_ocupacao) references ocupacao(id); 
ALTER TABLE profissional_unidade ADD CONSTRAINT fk_profissional_unidade_1 FOREIGN KEY (id_profissional) references profissional(id); 
ALTER TABLE profissional_unidade ADD CONSTRAINT fk_profissional_unidade_2 FOREIGN KEY (id_unidade) references unidade_saude(id); 
ALTER TABLE profissional_unidade ADD CONSTRAINT fk_profissional_unidade_3 FOREIGN KEY (id_setor) references setor(id); 
ALTER TABLE regiao ADD CONSTRAINT fk_regiao_1 FOREIGN KEY (id_estado) references estado(id); 
ALTER TABLE setor ADD CONSTRAINT fk_new_table_23_1 FOREIGN KEY (id_unidade) references unidade_saude(id); 
 CREATE SEQUENCE afastamento_profissional_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER afastamento_profissional_id_seq_tr 

BEFORE INSERT ON afastamento_profissional FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT afastamento_profissional_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE agendamento_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER agendamento_id_seq_tr 

BEFORE INSERT ON agendamento FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT agendamento_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE alergia_avaliacao_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER alergia_avaliacao_id_seq_tr 

BEFORE INSERT ON alergia_avaliacao FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT alergia_avaliacao_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE avaliacao_abemid_paciente_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER avaliacao_abemid_paciente_id_seq_tr 

BEFORE INSERT ON avaliacao_abemid_paciente FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT avaliacao_abemid_paciente_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE avaliacao_medica_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER avaliacao_medica_id_seq_tr 

BEFORE INSERT ON avaliacao_medica FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT avaliacao_medica_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE bairro_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER bairro_id_seq_tr 

BEFORE INSERT ON bairro FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT bairro_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE cid10_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER cid10_id_seq_tr 

BEFORE INSERT ON cid10 FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT cid10_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE cidade_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER cidade_id_seq_tr 

BEFORE INSERT ON cidade FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT cidade_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE classificacao_abemid_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER classificacao_abemid_id_seq_tr 

BEFORE INSERT ON classificacao_abemid FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT classificacao_abemid_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE distrito_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER distrito_id_seq_tr 

BEFORE INSERT ON distrito FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT distrito_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE distrito_bairro_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER distrito_bairro_id_seq_tr 

BEFORE INSERT ON distrito_bairro FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT distrito_bairro_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE endereco_paciente_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER endereco_paciente_id_seq_tr 

BEFORE INSERT ON endereco_paciente FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT endereco_paciente_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE endereco_profissional_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER endereco_profissional_id_seq_tr 

BEFORE INSERT ON endereco_profissional FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT endereco_profissional_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE equipe_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER equipe_id_seq_tr 

BEFORE INSERT ON equipe FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT equipe_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE escala_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER escala_id_seq_tr 

BEFORE INSERT ON escala FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT escala_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE escala_dia_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER escala_dia_id_seq_tr 

BEFORE INSERT ON escala_dia FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT escala_dia_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE escore_abemid_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER escore_abemid_id_seq_tr 

BEFORE INSERT ON escore_abemid FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT escore_abemid_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE estado_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER estado_id_seq_tr 

BEFORE INSERT ON estado FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT estado_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE evento_agendamento_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER evento_agendamento_id_seq_tr 

BEFORE INSERT ON evento_agendamento FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT evento_agendamento_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE exame_avaliacao_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER exame_avaliacao_id_seq_tr 

BEFORE INSERT ON exame_avaliacao FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT exame_avaliacao_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE feriados_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER feriados_id_seq_tr 

BEFORE INSERT ON feriados FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT feriados_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE historico_agendamento_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER historico_agendamento_id_seq_tr 

BEFORE INSERT ON historico_agendamento FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT historico_agendamento_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE itens_escoreabemid_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER itens_escoreabemid_id_seq_tr 

BEFORE INSERT ON itens_escoreabemid FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT itens_escoreabemid_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE medicamento_avaliacao_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER medicamento_avaliacao_id_seq_tr 

BEFORE INSERT ON medicamento_avaliacao FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT medicamento_avaliacao_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE ocupacao_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER ocupacao_id_seq_tr 

BEFORE INSERT ON ocupacao FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT ocupacao_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE paciente_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER paciente_id_seq_tr 

BEFORE INSERT ON paciente FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT paciente_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE paciente_cid10_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER paciente_cid10_id_seq_tr 

BEFORE INSERT ON paciente_cid10 FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT paciente_cid10_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE parametros_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER parametros_id_seq_tr 

BEFORE INSERT ON parametros FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT parametros_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE procedimento_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER procedimento_id_seq_tr 

BEFORE INSERT ON procedimento FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT procedimento_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE profissional_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER profissional_id_seq_tr 

BEFORE INSERT ON profissional FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT profissional_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE profissional_equipe_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER profissional_equipe_id_seq_tr 

BEFORE INSERT ON profissional_equipe FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT profissional_equipe_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE profissional_ocupacao_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER profissional_ocupacao_id_seq_tr 

BEFORE INSERT ON profissional_ocupacao FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT profissional_ocupacao_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE profissional_unidade_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER profissional_unidade_id_seq_tr 

BEFORE INSERT ON profissional_unidade FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT profissional_unidade_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE regiao_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER regiao_id_seq_tr 

BEFORE INSERT ON regiao FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT regiao_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE setor_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER setor_id_seq_tr 

BEFORE INSERT ON setor FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT setor_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE tipo_alergia_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER tipo_alergia_id_seq_tr 

BEFORE INSERT ON tipo_alergia FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT tipo_alergia_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE tipo_cid_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER tipo_cid_id_seq_tr 

BEFORE INSERT ON tipo_cid FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT tipo_cid_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE tipo_logradouro_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER tipo_logradouro_id_seq_tr 

BEFORE INSERT ON tipo_logradouro FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT tipo_logradouro_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE turno_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER turno_id_seq_tr 

BEFORE INSERT ON turno FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT turno_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
CREATE SEQUENCE unidade_saude_id_seq START WITH 1 INCREMENT BY 1; 

CREATE OR REPLACE TRIGGER unidade_saude_id_seq_tr 

BEFORE INSERT ON unidade_saude FOR EACH ROW 

WHEN 

(NEW.id IS NULL) 

BEGIN 

SELECT unidade_saude_id_seq.NEXTVAL INTO :NEW.id FROM DUAL; 

END;
 
 CREATE VIEW agendamento_escala AS SELECT 
    count(*) AS numero_de_agendamentos_dia,
    agendamento.data_agendamento as data_agendamento,
    agendamento.flg_tipo_agendamento as tipo_agendamento,
    agendamento.id_escala as id_escala  
FROM agendamento
GROUP BY agendamento.data_agendamento, agendamento.id_escala, agendamento.flg_tipo_agendamento

/*
select 
  count(*) as numero_de_agendamentos_dia,
  data_agendamento as data_agendamento,
  flg_tipo_agendamento as tipo_agendamento
from
  agendamento
group by data_agendamento, tipo_agendamento, id */
; 
CREATE VIEW vwAgendaDiariaProfissional AS SELECT 
   a.id as id,
   a.data_agendamento as data,
   p.cns_profissional as cns_profissional, 
   p.nome_profissional as nome_profissional,
   u.mf_paciente as mf,
   u.nome_paciente as nome_paciente
FROM 
  agendamento a,
  profissional p,
  paciente u
where 
  a.id_profissional = p.id and
  a.id_paciente = u.id; 
CREATE VIEW vwBpiProfissional AS SELECT 
  count(agendamento.id) as seq,
  agendamento.id as id,
  agendamento.data_agendamento as data_atendimento,
  profissional.id as id_profissional,
  profissional.nome_profissional as nome_profissional,
  profissional.cns_profissional as cns_profissional,
  unidade_saude.nome as nome_unidade,
  unidade_saude.cnes_unidade as cnes_unidade,
  procedimento.descricao_procedimento as descricao_procedimento,
  cid10.descricao_cid as descricao_cid,
  paciente.cns_paciente as cns_paciente,
  paciente.nome_paciente as nome_paciente,
  paciente.sexo_paciente as sexo_paciente,
  paciente.data_nascimento as data_nascimento,
  paciente.mf_paciente as mf_paciente
FROM
  agendamento
  INNER JOIN profissional ON (agendamento.id_profissional = profissional.id)
  INNER JOIN unidade_saude ON (agendamento.id_unidade_saude = unidade_saude.id)
  INNER JOIN profissional_unidade ON (profissional.id = profissional_unidade.id_profissional)
  AND (unidade_saude.id = profissional_unidade.id_unidade)
  INNER JOIN paciente ON (agendamento.id_paciente = paciente.id)
  INNER JOIN paciente_cid10 ON (paciente.id = paciente_cid10.id_paciente)
  INNER JOIN cid10 ON (paciente_cid10.id_cid = cid10.id)
  INNER JOIN procedimento ON (agendamento.id_procedimento = procedimento.id)
GROUP BY
   profissional.id, 
   profissional.nome_profissional,
   profissional.cns_profissional,
   unidade_saude.nome,
   unidade_saude.cnes_unidade,
   procedimento.descricao_procedimento,
   cid10.descricao_cid,
   paciente.cns_paciente,
   paciente.nome_paciente,
   paciente.sexo_paciente,
   paciente.data_nascimento,
   paciente.mf_paciente,
   agendamento.id,
   agendamento.data_agendamento; 
CREATE VIEW vw_num_agendamentos_escala AS select 
  id_escala as id_escala,
  (select count(*) as numero_de_agendamentos_dia from agendamento where flg_tipo_agendamento = '1' group by data_agendamento) as total_agendado_p_vez,
  (select count(*) as numero_de_agendamentos_dia from agendamento where flg_tipo_agendamento = '2' group by data_agendamento) as total_agendado_retorno
from 
agendamento
; 
 
