PRAGMA foreign_keys=OFF; 

CREATE TABLE afastamento_profissional( 
      id  INTEGER    NOT NULL  , 
      id_profissional int   NOT NULL  , 
      data_inicio date   NOT NULL  , 
      data_fim date   NOT NULL  , 
      moitvo_afastamento text   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_profissional) REFERENCES profissional(id)) ; 

CREATE TABLE agendamento( 
      id  INTEGER    NOT NULL  , 
      id_paciente int   NOT NULL  , 
      id_escala int   NOT NULL  , 
      id_unidade_saude int   NOT NULL  , 
      id_situacao int   NOT NULL  , 
      id_procedimento int   NOT NULL  , 
      id_profissional int   NOT NULL  , 
      data_agendamento date   NOT NULL  , 
      flg_atendimento varchar  (1)   NOT NULL  , 
      flg_tipo_agendamento varchar  (1)   , 
      flg_app_agenda varchar  (1)   , 
 PRIMARY KEY (id),
FOREIGN KEY(id_paciente) REFERENCES paciente(id),
FOREIGN KEY(id_escala) REFERENCES escala(id),
FOREIGN KEY(id_unidade_saude) REFERENCES unidade_saude(id),
FOREIGN KEY(id_procedimento) REFERENCES procedimento(id),
FOREIGN KEY(id_profissional) REFERENCES profissional(id)) ; 

CREATE TABLE alergia_avaliacao( 
      id  INTEGER    NOT NULL  , 
      id_tipo_alergia int   NOT NULL  , 
      id_avaliacao_medica int   NOT NULL  , 
      especificacao text   , 
 PRIMARY KEY (id),
FOREIGN KEY(id_avaliacao_medica) REFERENCES avaliacao_medica(id),
FOREIGN KEY(id_tipo_alergia) REFERENCES tipo_alergia(id)) ; 

CREATE TABLE avaliacao_abemid_paciente( 
      id  INTEGER    NOT NULL  , 
      id_paciente int   NOT NULL  , 
      id_escore_abemid int   NOT NULL  , 
      id_item_escore int   NOT NULL  , 
      id_classificacao int   NOT NULL  , 
      escore_abemid int   NOT NULL  , 
      data_avaliacao date   NOT NULL  , 
      pontuacao_obtida int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_paciente) REFERENCES paciente(id),
FOREIGN KEY(id_escore_abemid) REFERENCES escore_abemid(id),
FOREIGN KEY(id_item_escore) REFERENCES itens_escoreabemid(id),
FOREIGN KEY(id_classificacao) REFERENCES classificacao_abemid(id)) ; 

CREATE TABLE avaliacao_medica( 
      id  INTEGER    NOT NULL  , 
      id_paciente int   NOT NULL  , 
      id_agendamento int   NOT NULL  , 
      data_cadastro datetime   , 
      data_atualizacao datetime   , 
      flg_bloqueador int   NOT NULL  , 
      flg_sedacao int   NOT NULL  , 
      data_avaliacao date   , 
 PRIMARY KEY (id),
FOREIGN KEY(id_paciente) REFERENCES paciente(id),
FOREIGN KEY(id_agendamento) REFERENCES agendamento(id)) ; 

CREATE TABLE bairro( 
      id  INTEGER    NOT NULL  , 
      id_cidade int   NOT NULL  , 
      nome_bairro varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_cidade) REFERENCES cidade(id)) ; 

CREATE TABLE cid10( 
      id  INTEGER    NOT NULL  , 
      descricao_cid varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE cidade( 
      id  INTEGER    NOT NULL  , 
      id_estado int   NOT NULL  , 
      id_regiao int   NOT NULL  , 
      nome_cidade varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_estado) REFERENCES estado(id),
FOREIGN KEY(id_regiao) REFERENCES regiao(id)) ; 

CREATE TABLE classificacao_abemid( 
      id  INTEGER    NOT NULL  , 
      descricao varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE distrito( 
      id  INTEGER    NOT NULL  , 
      nome_distrito varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE distrito_bairro( 
      id  INTEGER    NOT NULL  , 
      id_bairro int   NOT NULL  , 
      id_distrito int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_bairro) REFERENCES bairro(id),
FOREIGN KEY(id_distrito) REFERENCES distrito(id)) ; 

CREATE TABLE endereco_paciente( 
      id  INTEGER    NOT NULL  , 
      id_paciente int   NOT NULL  , 
      id_estado int   NOT NULL  , 
      id_cidade int   NOT NULL  , 
      id_bairro int   NOT NULL  , 
      id_tipo int   NOT NULL  , 
      logradouro varchar  (50)   NOT NULL  , 
      num_logradouro int   NOT NULL  , 
      complemento varchar  (50)   , 
      cep_logradouro varchar  (10)   NOT NULL  , 
      ponto_referencia text   , 
 PRIMARY KEY (id),
FOREIGN KEY(id_paciente) REFERENCES paciente(id),
FOREIGN KEY(id_estado) REFERENCES estado(id),
FOREIGN KEY(id_cidade) REFERENCES cidade(id),
FOREIGN KEY(id_bairro) REFERENCES bairro(id),
FOREIGN KEY(id_tipo) REFERENCES tipo_logradouro(id)) ; 

CREATE TABLE endereco_profissional( 
      id  INTEGER    NOT NULL  , 
      id_profissional int   NOT NULL  , 
      id_estado int   NOT NULL  , 
      id_cidade int   NOT NULL  , 
      id_bairro int   NOT NULL  , 
      id_tipo int   NOT NULL  , 
      logradouro varchar  (50)   NOT NULL  , 
      num_logradouro int   NOT NULL  , 
      complemento varchar  (50)   , 
      cep_logradouro varchar  (10)   NOT NULL  , 
      ponto_referencia text   , 
 PRIMARY KEY (id),
FOREIGN KEY(id_profissional) REFERENCES profissional(id),
FOREIGN KEY(id_estado) REFERENCES estado(id),
FOREIGN KEY(id_cidade) REFERENCES cidade(id),
FOREIGN KEY(id_bairro) REFERENCES bairro(id),
FOREIGN KEY(id_tipo) REFERENCES tipo_logradouro(id)) ; 

CREATE TABLE equipe( 
      id  INTEGER    NOT NULL  , 
      id_unidade int   NOT NULL  , 
      nome varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_unidade) REFERENCES unidade_saude(id)) ; 

CREATE TABLE escala( 
      id  INTEGER    NOT NULL  , 
      id_equipe int   , 
      id_profissional int   , 
      id_turno int   NOT NULL  , 
      id_unidade_saude int   NOT NULL  , 
      id_procedimento int   NOT NULL  , 
      qtd_primeira_vez int   NOT NULL  , 
      data_limite date   NOT NULL  , 
      qtd_retorno int   NOT NULL  , 
      encaixe int   NOT NULL  , 
      data_inicio date   NOT NULL  , 
      id_ocupacao int   , 
 PRIMARY KEY (id),
FOREIGN KEY(id_equipe) REFERENCES equipe(id),
FOREIGN KEY(id_turno) REFERENCES turno(id),
FOREIGN KEY(id_unidade_saude) REFERENCES unidade_saude(id),
FOREIGN KEY(id_profissional) REFERENCES profissional(id),
FOREIGN KEY(id_procedimento) REFERENCES procedimento(id),
FOREIGN KEY(id_ocupacao) REFERENCES ocupacao(id)) ; 

CREATE TABLE escala_dia( 
      id  INTEGER    NOT NULL  , 
      id_escala int   NOT NULL  , 
      dia_semana int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_escala) REFERENCES escala(id)) ; 

CREATE TABLE escore_abemid( 
      id  INTEGER    NOT NULL  , 
      descricao_grupo varchar  (50)   NOT NULL  , 
      tipo_tabela_abemid varchar  (10)   NOT NULL    DEFAULT 'Adulto', 
 PRIMARY KEY (id)) ; 

CREATE TABLE estado( 
      id  INTEGER    NOT NULL  , 
      nome_estado varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE evento_agendamento( 
      id  INTEGER    NOT NULL  , 
      descricao varchar  (50)   NOT NULL  , 
      sigla varchar  (2)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE exame_avaliacao( 
      id  INTEGER    NOT NULL  , 
      id_avaliacao_medica int   NOT NULL  , 
      descricao_exame varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_avaliacao_medica) REFERENCES avaliacao_medica(id)) ; 

CREATE TABLE feriados( 
      id  INTEGER    NOT NULL  , 
      descricao_feriado varchar  (100)   NOT NULL  , 
      data_feriado date   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE historico_agendamento( 
      id  INTEGER    NOT NULL  , 
      id_status int   NOT NULL  , 
      id_agendamento int   NOT NULL  , 
      id_usuario int   NOT NULL  , 
      justificativa varchar  (500)   NOT NULL  , 
      data_hora datetime   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_status) REFERENCES evento_agendamento(id),
FOREIGN KEY(id_agendamento) REFERENCES agendamento(id)) ; 

CREATE TABLE itens_escoreabemid( 
      id  INTEGER    NOT NULL  , 
      id_escore_abemid_adulto int   NOT NULL  , 
      descricao_item varchar  (50)   NOT NULL  , 
      qtd_pontos_item int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_escore_abemid_adulto) REFERENCES escore_abemid(id)) ; 

CREATE TABLE medicamento_avaliacao( 
      id  INTEGER    NOT NULL  , 
      id_avaliacao_medica int   NOT NULL  , 
      descricao_medicamento varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_avaliacao_medica) REFERENCES avaliacao_medica(id)) ; 

CREATE TABLE ocupacao( 
      id  INTEGER    NOT NULL  , 
      descricao_ocupacao varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE paciente( 
      id  INTEGER    NOT NULL  , 
      cpf varchar  (14)   , 
      cns_paciente int   , 
      rg_paciente varchar  (15)   , 
      nome_paciente varchar  (50)   NOT NULL  , 
      data_nascimento date   NOT NULL  , 
      mae_paciente varchar  (50)   NOT NULL  , 
      telefone varchar  (15)   NOT NULL  , 
      pai_paciente varchar  (50)   , 
      responsavel_paciente varchar  (50)   , 
      cpf_responsavel varchar  (14)   , 
      celular_paciente varchar  (15)   , 
      mf_paciente int   , 
      naturalidade varchar  (50)   , 
      data_admissao date   , 
      sexo_paciente varchar  (30)   , 
      system_user_id int   , 
      flg_externo varchar  (1)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE paciente_cid10( 
      id  INTEGER    NOT NULL  , 
      id_cid int   NOT NULL  , 
      id_paciente int   NOT NULL  , 
      id_tipo_cid int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_tipo_cid) REFERENCES tipo_cid(id),
FOREIGN KEY(id_paciente) REFERENCES paciente(id),
FOREIGN KEY(id_cid) REFERENCES cid10(id)) ; 

CREATE TABLE parametros( 
      id  INTEGER    NOT NULL  , 
      num_dias_abertura_agenda int   NOT NULL  , 
      num_dias_transferencia_agenda int   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE procedimento( 
      id  INTEGER    NOT NULL  , 
      codigo_procedimento varchar  (15)   NOT NULL  , 
      descricao_procedimento varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE profissional( 
      id  INTEGER    NOT NULL  , 
      cpf varchar  (14)   NOT NULL  , 
      nome_profissional varchar  (50)   NOT NULL  , 
      cns_profissional varchar  (20)   NOT NULL  , 
      matricula int   NOT NULL  , 
      telefone varchar  (15)   NOT NULL  , 
      flg_excluido varchar  (1)   , 
 PRIMARY KEY (id)) ; 

CREATE TABLE profissional_equipe( 
      id  INTEGER    NOT NULL  , 
      id_profissional int   NOT NULL  , 
      id_equipe int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_profissional) REFERENCES profissional(id),
FOREIGN KEY(id_equipe) REFERENCES equipe(id)) ; 

CREATE TABLE profissional_ocupacao( 
      id  INTEGER    NOT NULL  , 
      id_profissional int   NOT NULL  , 
      id_ocupacao int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_profissional) REFERENCES profissional(id),
FOREIGN KEY(id_ocupacao) REFERENCES ocupacao(id)) ; 

CREATE TABLE profissional_unidade( 
      id  INTEGER    NOT NULL  , 
      id_profissional int   NOT NULL  , 
      id_unidade int   NOT NULL  , 
      id_setor int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_profissional) REFERENCES profissional(id),
FOREIGN KEY(id_unidade) REFERENCES unidade_saude(id),
FOREIGN KEY(id_setor) REFERENCES setor(id)) ; 

CREATE TABLE regiao( 
      id  INTEGER    NOT NULL  , 
      nome_regiao varchar  (50)   NOT NULL  , 
      id_estado int   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_estado) REFERENCES estado(id)) ; 

CREATE TABLE setor( 
      id  INTEGER    NOT NULL  , 
      id_unidade int   NOT NULL  , 
      descricao_setor varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id),
FOREIGN KEY(id_unidade) REFERENCES unidade_saude(id)) ; 

CREATE TABLE tipo_alergia( 
      id  INTEGER    NOT NULL  , 
      descricao varchar  (100)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE tipo_cid( 
      id  INTEGER    NOT NULL  , 
      descricao varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE tipo_logradouro( 
      id  INTEGER    NOT NULL  , 
      descricao varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE turno( 
      id  INTEGER    NOT NULL  , 
      nome varchar  (50)   NOT NULL  , 
      horario varchar  (50)   NOT NULL  , 
 PRIMARY KEY (id)) ; 

CREATE TABLE unidade_saude( 
      id  INTEGER    NOT NULL  , 
      nome varchar  (50)   NOT NULL  , 
      cnes_unidade int   NOT NULL  , 
 PRIMARY KEY (id)) ; 

 
 CREATE UNIQUE INDEX unique_idx_escala_id ON escala(id);
 CREATE UNIQUE INDEX unique_idx_paciente_id ON paciente(id);
 CREATE UNIQUE INDEX unique_idx_profissional_cpf ON profissional(cpf);
 
 CREATE VIEW agendamento_escala AS SELECT 
    count(*) AS numero_de_agendamentos_dia,
    agendamento.data_agendamento as data_agendamento,
    agendamento.flg_tipo_agendamento as tipo_agendamento,
    agendamento.id_escala as id_escala  
FROM agendamento
GROUP BY agendamento.data_agendamento, agendamento.id_escala, agendamento.flg_tipo_agendamento

/*
select 
  count(*) as numero_de_agendamentos_dia,
  data_agendamento as data_agendamento,
  flg_tipo_agendamento as tipo_agendamento
from
  agendamento
group by data_agendamento, tipo_agendamento, id */
; 
CREATE VIEW vwAgendaDiariaProfissional AS SELECT 
   a.id as id,
   a.data_agendamento as data,
   p.cns_profissional as cns_profissional, 
   p.nome_profissional as nome_profissional,
   u.mf_paciente as mf,
   u.nome_paciente as nome_paciente
FROM 
  agendamento a,
  profissional p,
  paciente u
where 
  a.id_profissional = p.id and
  a.id_paciente = u.id; 
CREATE VIEW vwBpiProfissional AS SELECT 
  count(agendamento.id) as seq,
  agendamento.id as id,
  agendamento.data_agendamento as data_atendimento,
  profissional.id as id_profissional,
  profissional.nome_profissional as nome_profissional,
  profissional.cns_profissional as cns_profissional,
  unidade_saude.nome as nome_unidade,
  unidade_saude.cnes_unidade as cnes_unidade,
  procedimento.descricao_procedimento as descricao_procedimento,
  cid10.descricao_cid as descricao_cid,
  paciente.cns_paciente as cns_paciente,
  paciente.nome_paciente as nome_paciente,
  paciente.sexo_paciente as sexo_paciente,
  paciente.data_nascimento as data_nascimento,
  paciente.mf_paciente as mf_paciente
FROM
  agendamento
  INNER JOIN profissional ON (agendamento.id_profissional = profissional.id)
  INNER JOIN unidade_saude ON (agendamento.id_unidade_saude = unidade_saude.id)
  INNER JOIN profissional_unidade ON (profissional.id = profissional_unidade.id_profissional)
  AND (unidade_saude.id = profissional_unidade.id_unidade)
  INNER JOIN paciente ON (agendamento.id_paciente = paciente.id)
  INNER JOIN paciente_cid10 ON (paciente.id = paciente_cid10.id_paciente)
  INNER JOIN cid10 ON (paciente_cid10.id_cid = cid10.id)
  INNER JOIN procedimento ON (agendamento.id_procedimento = procedimento.id)
GROUP BY
   profissional.id, 
   profissional.nome_profissional,
   profissional.cns_profissional,
   unidade_saude.nome,
   unidade_saude.cnes_unidade,
   procedimento.descricao_procedimento,
   cid10.descricao_cid,
   paciente.cns_paciente,
   paciente.nome_paciente,
   paciente.sexo_paciente,
   paciente.data_nascimento,
   paciente.mf_paciente,
   agendamento.id,
   agendamento.data_agendamento; 
CREATE VIEW vw_num_agendamentos_escala AS select 
  id_escala as id_escala,
  (select count(*) as numero_de_agendamentos_dia from agendamento where flg_tipo_agendamento = '1' group by data_agendamento) as total_agendado_p_vez,
  (select count(*) as numero_de_agendamentos_dia from agendamento where flg_tipo_agendamento = '2' group by data_agendamento) as total_agendado_retorno
from 
agendamento
; 
 
