<?php

class Agendamento extends TRecord
{
    const TABLENAME  = 'agendamento';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $paciente;
    private $escala;
    private $unidade_saude;
    private $procedimento;
    private $profissional;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_paciente');
        parent::addAttribute('id_escala');
        parent::addAttribute('id_unidade_saude');
        parent::addAttribute('id_situacao');
        parent::addAttribute('id_procedimento');
        parent::addAttribute('id_profissional');
        parent::addAttribute('data_agendamento');
        parent::addAttribute('flg_atendimento');
        parent::addAttribute('flg_tipo_agendamento');
        parent::addAttribute('flg_app_agenda');
            
    }

    /**
     * Method set_paciente
     * Sample of usage: $var->paciente = $object;
     * @param $object Instance of Paciente
     */
    public function set_paciente(Paciente $object)
    {
        $this->paciente = $object;
        $this->id_paciente = $object->id;
    }

    /**
     * Method get_paciente
     * Sample of usage: $var->paciente->attribute;
     * @returns Paciente instance
     */
    public function get_paciente()
    {
    
        // loads the associated object
        if (empty($this->paciente))
            $this->paciente = new Paciente($this->id_paciente);
    
        // returns the associated object
        return $this->paciente;
    }
    /**
     * Method set_escala
     * Sample of usage: $var->escala = $object;
     * @param $object Instance of Escala
     */
    public function set_escala(Escala $object)
    {
        $this->escala = $object;
        $this->id_escala = $object->id;
    }

    /**
     * Method get_escala
     * Sample of usage: $var->escala->attribute;
     * @returns Escala instance
     */
    public function get_escala()
    {
    
        // loads the associated object
        if (empty($this->escala))
            $this->escala = new Escala($this->id_escala);
    
        // returns the associated object
        return $this->escala;
    }
    /**
     * Method set_unidade_saude
     * Sample of usage: $var->unidade_saude = $object;
     * @param $object Instance of UnidadeSaude
     */
    public function set_unidade_saude(UnidadeSaude $object)
    {
        $this->unidade_saude = $object;
        $this->id_unidade_saude = $object->id;
    }

    /**
     * Method get_unidade_saude
     * Sample of usage: $var->unidade_saude->attribute;
     * @returns UnidadeSaude instance
     */
    public function get_unidade_saude()
    {
    
        // loads the associated object
        if (empty($this->unidade_saude))
            $this->unidade_saude = new UnidadeSaude($this->id_unidade_saude);
    
        // returns the associated object
        return $this->unidade_saude;
    }
    /**
     * Method set_procedimento
     * Sample of usage: $var->procedimento = $object;
     * @param $object Instance of Procedimento
     */
    public function set_procedimento(Procedimento $object)
    {
        $this->procedimento = $object;
        $this->id_procedimento = $object->id;
    }

    /**
     * Method get_procedimento
     * Sample of usage: $var->procedimento->attribute;
     * @returns Procedimento instance
     */
    public function get_procedimento()
    {
    
        // loads the associated object
        if (empty($this->procedimento))
            $this->procedimento = new Procedimento($this->id_procedimento);
    
        // returns the associated object
        return $this->procedimento;
    }
    /**
     * Method set_profissional
     * Sample of usage: $var->profissional = $object;
     * @param $object Instance of Profissional
     */
    public function set_profissional(Profissional $object)
    {
        $this->profissional = $object;
        $this->id_profissional = $object->id;
    }

    /**
     * Method get_profissional
     * Sample of usage: $var->profissional->attribute;
     * @returns Profissional instance
     */
    public function get_profissional()
    {
    
        // loads the associated object
        if (empty($this->profissional))
            $this->profissional = new Profissional($this->id_profissional);
    
        // returns the associated object
        return $this->profissional;
    }

    /**
     * Method getAvaliacaoMedicas
     */
    public function getAvaliacaoMedicas()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_agendamento', '=', $this->id));
        return AvaliacaoMedica::getObjects( $criteria );
    }
    /**
     * Method getHistoricoAgendamentos
     */
    public function getHistoricoAgendamentos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_agendamento', '=', $this->id));
        return HistoricoAgendamento::getObjects( $criteria );
    }

    public function set_avaliacao_medica_paciente_to_string($avaliacao_medica_paciente_to_string)
    {
        if(is_array($avaliacao_medica_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $avaliacao_medica_paciente_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_medica_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_medica_paciente_to_string = $avaliacao_medica_paciente_to_string;
        }

        $this->vdata['avaliacao_medica_paciente_to_string'] = $this->avaliacao_medica_paciente_to_string;
    }

    public function get_avaliacao_medica_paciente_to_string()
    {
        if(!empty($this->avaliacao_medica_paciente_to_string))
        {
            return $this->avaliacao_medica_paciente_to_string;
        }
    
        $values = AvaliacaoMedica::where('id_agendamento', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_medica_agendamento_to_string($avaliacao_medica_agendamento_to_string)
    {
        if(is_array($avaliacao_medica_agendamento_to_string))
        {
            $values = Agendamento::where('id', 'in', $avaliacao_medica_agendamento_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_medica_agendamento_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_medica_agendamento_to_string = $avaliacao_medica_agendamento_to_string;
        }

        $this->vdata['avaliacao_medica_agendamento_to_string'] = $this->avaliacao_medica_agendamento_to_string;
    }

    public function get_avaliacao_medica_agendamento_to_string()
    {
        if(!empty($this->avaliacao_medica_agendamento_to_string))
        {
            return $this->avaliacao_medica_agendamento_to_string;
        }
    
        $values = AvaliacaoMedica::where('id_agendamento', '=', $this->id)->getIndexedArray('id_agendamento','{agendamento->id}');
        return implode(', ', $values);
    }

    public function set_historico_agendamento_status_to_string($historico_agendamento_status_to_string)
    {
        if(is_array($historico_agendamento_status_to_string))
        {
            $values = EventoAgendamento::where('id', 'in', $historico_agendamento_status_to_string)->getIndexedArray('id', 'id');
            $this->historico_agendamento_status_to_string = implode(', ', $values);
        }
        else
        {
            $this->historico_agendamento_status_to_string = $historico_agendamento_status_to_string;
        }

        $this->vdata['historico_agendamento_status_to_string'] = $this->historico_agendamento_status_to_string;
    }

    public function get_historico_agendamento_status_to_string()
    {
        if(!empty($this->historico_agendamento_status_to_string))
        {
            return $this->historico_agendamento_status_to_string;
        }
    
        $values = HistoricoAgendamento::where('id_agendamento', '=', $this->id)->getIndexedArray('id_status','{status->id}');
        return implode(', ', $values);
    }

    public function set_historico_agendamento_agendamento_to_string($historico_agendamento_agendamento_to_string)
    {
        if(is_array($historico_agendamento_agendamento_to_string))
        {
            $values = Agendamento::where('id', 'in', $historico_agendamento_agendamento_to_string)->getIndexedArray('id', 'id');
            $this->historico_agendamento_agendamento_to_string = implode(', ', $values);
        }
        else
        {
            $this->historico_agendamento_agendamento_to_string = $historico_agendamento_agendamento_to_string;
        }

        $this->vdata['historico_agendamento_agendamento_to_string'] = $this->historico_agendamento_agendamento_to_string;
    }

    public function get_historico_agendamento_agendamento_to_string()
    {
        if(!empty($this->historico_agendamento_agendamento_to_string))
        {
            return $this->historico_agendamento_agendamento_to_string;
        }
    
        $values = HistoricoAgendamento::where('id_agendamento', '=', $this->id)->getIndexedArray('id_agendamento','{agendamento->id}');
        return implode(', ', $values);
    }

    
}

