<?php

class AlergiaAvaliacao extends TRecord
{
    const TABLENAME  = 'alergia_avaliacao';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $avaliacao_medica;
    private $tipo_alergia;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_tipo_alergia');
        parent::addAttribute('id_avaliacao_medica');
        parent::addAttribute('especificacao');
            
    }

    /**
     * Method set_avaliacao_medica
     * Sample of usage: $var->avaliacao_medica = $object;
     * @param $object Instance of AvaliacaoMedica
     */
    public function set_avaliacao_medica(AvaliacaoMedica $object)
    {
        $this->avaliacao_medica = $object;
        $this->id_avaliacao_medica = $object->id;
    }

    /**
     * Method get_avaliacao_medica
     * Sample of usage: $var->avaliacao_medica->attribute;
     * @returns AvaliacaoMedica instance
     */
    public function get_avaliacao_medica()
    {
    
        // loads the associated object
        if (empty($this->avaliacao_medica))
            $this->avaliacao_medica = new AvaliacaoMedica($this->id_avaliacao_medica);
    
        // returns the associated object
        return $this->avaliacao_medica;
    }
    /**
     * Method set_tipo_alergia
     * Sample of usage: $var->tipo_alergia = $object;
     * @param $object Instance of TipoAlergia
     */
    public function set_tipo_alergia(TipoAlergia $object)
    {
        $this->tipo_alergia = $object;
        $this->id_tipo_alergia = $object->id;
    }

    /**
     * Method get_tipo_alergia
     * Sample of usage: $var->tipo_alergia->attribute;
     * @returns TipoAlergia instance
     */
    public function get_tipo_alergia()
    {
    
        // loads the associated object
        if (empty($this->tipo_alergia))
            $this->tipo_alergia = new TipoAlergia($this->id_tipo_alergia);
    
        // returns the associated object
        return $this->tipo_alergia;
    }

    
}

