<?php

class AvaliacaoAbemidPaciente extends TRecord
{
    const TABLENAME  = 'avaliacao_abemid_paciente';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $paciente;
    private $escore_abemid;
    private $item_escore;
    private $classificacao;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_paciente');
        parent::addAttribute('id_escore_abemid');
        parent::addAttribute('id_item_escore');
        parent::addAttribute('id_classificacao');
        parent::addAttribute('escore_abemid');
        parent::addAttribute('data_avaliacao');
        parent::addAttribute('pontuacao_obtida');
            
    }

    /**
     * Method set_paciente
     * Sample of usage: $var->paciente = $object;
     * @param $object Instance of Paciente
     */
    public function set_paciente(Paciente $object)
    {
        $this->paciente = $object;
        $this->id_paciente = $object->id;
    }

    /**
     * Method get_paciente
     * Sample of usage: $var->paciente->attribute;
     * @returns Paciente instance
     */
    public function get_paciente()
    {
    
        // loads the associated object
        if (empty($this->paciente))
            $this->paciente = new Paciente($this->id_paciente);
    
        // returns the associated object
        return $this->paciente;
    }
    /**
     * Method set_escore_abemid
     * Sample of usage: $var->escore_abemid = $object;
     * @param $object Instance of EscoreAbemid
     */
    public function set_escore_abemid(EscoreAbemid $object)
    {
        $this->escore_abemid = $object;
        $this->id_escore_abemid = $object->id;
    }

    /**
     * Method get_escore_abemid
     * Sample of usage: $var->escore_abemid->attribute;
     * @returns EscoreAbemid instance
     */
    public function get_escore_abemid()
    {
    
        // loads the associated object
        if (empty($this->escore_abemid))
            $this->escore_abemid = new EscoreAbemid($this->id_escore_abemid);
    
        // returns the associated object
        return $this->escore_abemid;
    }
    /**
     * Method set_itens_escoreabemid
     * Sample of usage: $var->itens_escoreabemid = $object;
     * @param $object Instance of ItensEscoreabemid
     */
    public function set_item_escore(ItensEscoreabemid $object)
    {
        $this->item_escore = $object;
        $this->id_item_escore = $object->id;
    }

    /**
     * Method get_item_escore
     * Sample of usage: $var->item_escore->attribute;
     * @returns ItensEscoreabemid instance
     */
    public function get_item_escore()
    {
    
        // loads the associated object
        if (empty($this->item_escore))
            $this->item_escore = new ItensEscoreabemid($this->id_item_escore);
    
        // returns the associated object
        return $this->item_escore;
    }
    /**
     * Method set_classificacao_abemid
     * Sample of usage: $var->classificacao_abemid = $object;
     * @param $object Instance of ClassificacaoAbemid
     */
    public function set_classificacao(ClassificacaoAbemid $object)
    {
        $this->classificacao = $object;
        $this->id_classificacao = $object->id;
    }

    /**
     * Method get_classificacao
     * Sample of usage: $var->classificacao->attribute;
     * @returns ClassificacaoAbemid instance
     */
    public function get_classificacao()
    {
    
        // loads the associated object
        if (empty($this->classificacao))
            $this->classificacao = new ClassificacaoAbemid($this->id_classificacao);
    
        // returns the associated object
        return $this->classificacao;
    }

    
}

