<?php

class AvaliacaoMedica extends TRecord
{
    const TABLENAME  = 'avaliacao_medica';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    const CREATEDAT  = 'data_cadastro';
    const UPDATEDAT  = 'data_atualizacao';

    private $paciente;
    private $agendamento;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_paciente');
        parent::addAttribute('id_agendamento');
        parent::addAttribute('data_cadastro');
        parent::addAttribute('data_atualizacao');
        parent::addAttribute('flg_bloqueador');
        parent::addAttribute('flg_sedacao');
        parent::addAttribute('data_avaliacao');
            
    }

    /**
     * Method set_paciente
     * Sample of usage: $var->paciente = $object;
     * @param $object Instance of Paciente
     */
    public function set_paciente(Paciente $object)
    {
        $this->paciente = $object;
        $this->id_paciente = $object->id;
    }

    /**
     * Method get_paciente
     * Sample of usage: $var->paciente->attribute;
     * @returns Paciente instance
     */
    public function get_paciente()
    {
    
        // loads the associated object
        if (empty($this->paciente))
            $this->paciente = new Paciente($this->id_paciente);
    
        // returns the associated object
        return $this->paciente;
    }
    /**
     * Method set_agendamento
     * Sample of usage: $var->agendamento = $object;
     * @param $object Instance of Agendamento
     */
    public function set_agendamento(Agendamento $object)
    {
        $this->agendamento = $object;
        $this->id_agendamento = $object->id;
    }

    /**
     * Method get_agendamento
     * Sample of usage: $var->agendamento->attribute;
     * @returns Agendamento instance
     */
    public function get_agendamento()
    {
    
        // loads the associated object
        if (empty($this->agendamento))
            $this->agendamento = new Agendamento($this->id_agendamento);
    
        // returns the associated object
        return $this->agendamento;
    }

    /**
     * Method getExameAvaliacaos
     */
    public function getExameAvaliacaos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_avaliacao_medica', '=', $this->id));
        return ExameAvaliacao::getObjects( $criteria );
    }
    /**
     * Method getMedicamentoAvaliacaos
     */
    public function getMedicamentoAvaliacaos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_avaliacao_medica', '=', $this->id));
        return MedicamentoAvaliacao::getObjects( $criteria );
    }
    /**
     * Method getAlergiaAvaliacaos
     */
    public function getAlergiaAvaliacaos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_avaliacao_medica', '=', $this->id));
        return AlergiaAvaliacao::getObjects( $criteria );
    }

    public function set_exame_avaliacao_avaliacao_medica_to_string($exame_avaliacao_avaliacao_medica_to_string)
    {
        if(is_array($exame_avaliacao_avaliacao_medica_to_string))
        {
            $values = AvaliacaoMedica::where('id', 'in', $exame_avaliacao_avaliacao_medica_to_string)->getIndexedArray('id', 'id');
            $this->exame_avaliacao_avaliacao_medica_to_string = implode(', ', $values);
        }
        else
        {
            $this->exame_avaliacao_avaliacao_medica_to_string = $exame_avaliacao_avaliacao_medica_to_string;
        }

        $this->vdata['exame_avaliacao_avaliacao_medica_to_string'] = $this->exame_avaliacao_avaliacao_medica_to_string;
    }

    public function get_exame_avaliacao_avaliacao_medica_to_string()
    {
        if(!empty($this->exame_avaliacao_avaliacao_medica_to_string))
        {
            return $this->exame_avaliacao_avaliacao_medica_to_string;
        }
    
        $values = ExameAvaliacao::where('id_avaliacao_medica', '=', $this->id)->getIndexedArray('id_avaliacao_medica','{avaliacao_medica->id}');
        return implode(', ', $values);
    }

    public function set_medicamento_avaliacao_avaliacao_medica_to_string($medicamento_avaliacao_avaliacao_medica_to_string)
    {
        if(is_array($medicamento_avaliacao_avaliacao_medica_to_string))
        {
            $values = AvaliacaoMedica::where('id', 'in', $medicamento_avaliacao_avaliacao_medica_to_string)->getIndexedArray('id', 'id');
            $this->medicamento_avaliacao_avaliacao_medica_to_string = implode(', ', $values);
        }
        else
        {
            $this->medicamento_avaliacao_avaliacao_medica_to_string = $medicamento_avaliacao_avaliacao_medica_to_string;
        }

        $this->vdata['medicamento_avaliacao_avaliacao_medica_to_string'] = $this->medicamento_avaliacao_avaliacao_medica_to_string;
    }

    public function get_medicamento_avaliacao_avaliacao_medica_to_string()
    {
        if(!empty($this->medicamento_avaliacao_avaliacao_medica_to_string))
        {
            return $this->medicamento_avaliacao_avaliacao_medica_to_string;
        }
    
        $values = MedicamentoAvaliacao::where('id_avaliacao_medica', '=', $this->id)->getIndexedArray('id_avaliacao_medica','{avaliacao_medica->id}');
        return implode(', ', $values);
    }

    public function set_alergia_avaliacao_tipo_alergia_to_string($alergia_avaliacao_tipo_alergia_to_string)
    {
        if(is_array($alergia_avaliacao_tipo_alergia_to_string))
        {
            $values = TipoAlergia::where('id', 'in', $alergia_avaliacao_tipo_alergia_to_string)->getIndexedArray('id', 'id');
            $this->alergia_avaliacao_tipo_alergia_to_string = implode(', ', $values);
        }
        else
        {
            $this->alergia_avaliacao_tipo_alergia_to_string = $alergia_avaliacao_tipo_alergia_to_string;
        }

        $this->vdata['alergia_avaliacao_tipo_alergia_to_string'] = $this->alergia_avaliacao_tipo_alergia_to_string;
    }

    public function get_alergia_avaliacao_tipo_alergia_to_string()
    {
        if(!empty($this->alergia_avaliacao_tipo_alergia_to_string))
        {
            return $this->alergia_avaliacao_tipo_alergia_to_string;
        }
    
        $values = AlergiaAvaliacao::where('id_avaliacao_medica', '=', $this->id)->getIndexedArray('id_tipo_alergia','{tipo_alergia->id}');
        return implode(', ', $values);
    }

    public function set_alergia_avaliacao_avaliacao_medica_to_string($alergia_avaliacao_avaliacao_medica_to_string)
    {
        if(is_array($alergia_avaliacao_avaliacao_medica_to_string))
        {
            $values = AvaliacaoMedica::where('id', 'in', $alergia_avaliacao_avaliacao_medica_to_string)->getIndexedArray('id', 'id');
            $this->alergia_avaliacao_avaliacao_medica_to_string = implode(', ', $values);
        }
        else
        {
            $this->alergia_avaliacao_avaliacao_medica_to_string = $alergia_avaliacao_avaliacao_medica_to_string;
        }

        $this->vdata['alergia_avaliacao_avaliacao_medica_to_string'] = $this->alergia_avaliacao_avaliacao_medica_to_string;
    }

    public function get_alergia_avaliacao_avaliacao_medica_to_string()
    {
        if(!empty($this->alergia_avaliacao_avaliacao_medica_to_string))
        {
            return $this->alergia_avaliacao_avaliacao_medica_to_string;
        }
    
        $values = AlergiaAvaliacao::where('id_avaliacao_medica', '=', $this->id)->getIndexedArray('id_avaliacao_medica','{avaliacao_medica->id}');
        return implode(', ', $values);
    }

    
}

