<?php

class Bairro extends TRecord
{
    const TABLENAME  = 'bairro';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $cidade;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_cidade');
        parent::addAttribute('nome_bairro');
            
    }

    /**
     * Method set_cidade
     * Sample of usage: $var->cidade = $object;
     * @param $object Instance of Cidade
     */
    public function set_cidade(Cidade $object)
    {
        $this->cidade = $object;
        $this->id_cidade = $object->id;
    }

    /**
     * Method get_cidade
     * Sample of usage: $var->cidade->attribute;
     * @returns Cidade instance
     */
    public function get_cidade()
    {
    
        // loads the associated object
        if (empty($this->cidade))
            $this->cidade = new Cidade($this->id_cidade);
    
        // returns the associated object
        return $this->cidade;
    }

    /**
     * Method getEnderecoPacientes
     */
    public function getEnderecoPacientes()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_bairro', '=', $this->id));
        return EnderecoPaciente::getObjects( $criteria );
    }
    /**
     * Method getEnderecoProfissionals
     */
    public function getEnderecoProfissionals()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_bairro', '=', $this->id));
        return EnderecoProfissional::getObjects( $criteria );
    }
    /**
     * Method getDistritoBairros
     */
    public function getDistritoBairros()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_bairro', '=', $this->id));
        return DistritoBairro::getObjects( $criteria );
    }

    public function set_endereco_paciente_paciente_to_string($endereco_paciente_paciente_to_string)
    {
        if(is_array($endereco_paciente_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $endereco_paciente_paciente_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_paciente_to_string = $endereco_paciente_paciente_to_string;
        }

        $this->vdata['endereco_paciente_paciente_to_string'] = $this->endereco_paciente_paciente_to_string;
    }

    public function get_endereco_paciente_paciente_to_string()
    {
        if(!empty($this->endereco_paciente_paciente_to_string))
        {
            return $this->endereco_paciente_paciente_to_string;
        }
    
        $values = EnderecoPaciente::where('id_bairro', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_estado_to_string($endereco_paciente_estado_to_string)
    {
        if(is_array($endereco_paciente_estado_to_string))
        {
            $values = Estado::where('id', 'in', $endereco_paciente_estado_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_estado_to_string = $endereco_paciente_estado_to_string;
        }

        $this->vdata['endereco_paciente_estado_to_string'] = $this->endereco_paciente_estado_to_string;
    }

    public function get_endereco_paciente_estado_to_string()
    {
        if(!empty($this->endereco_paciente_estado_to_string))
        {
            return $this->endereco_paciente_estado_to_string;
        }
    
        $values = EnderecoPaciente::where('id_bairro', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_cidade_to_string($endereco_paciente_cidade_to_string)
    {
        if(is_array($endereco_paciente_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $endereco_paciente_cidade_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_cidade_to_string = $endereco_paciente_cidade_to_string;
        }

        $this->vdata['endereco_paciente_cidade_to_string'] = $this->endereco_paciente_cidade_to_string;
    }

    public function get_endereco_paciente_cidade_to_string()
    {
        if(!empty($this->endereco_paciente_cidade_to_string))
        {
            return $this->endereco_paciente_cidade_to_string;
        }
    
        $values = EnderecoPaciente::where('id_bairro', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_bairro_to_string($endereco_paciente_bairro_to_string)
    {
        if(is_array($endereco_paciente_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $endereco_paciente_bairro_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_bairro_to_string = $endereco_paciente_bairro_to_string;
        }

        $this->vdata['endereco_paciente_bairro_to_string'] = $this->endereco_paciente_bairro_to_string;
    }

    public function get_endereco_paciente_bairro_to_string()
    {
        if(!empty($this->endereco_paciente_bairro_to_string))
        {
            return $this->endereco_paciente_bairro_to_string;
        }
    
        $values = EnderecoPaciente::where('id_bairro', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_tipo_to_string($endereco_paciente_tipo_to_string)
    {
        if(is_array($endereco_paciente_tipo_to_string))
        {
            $values = TipoLogradouro::where('id', 'in', $endereco_paciente_tipo_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_tipo_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_tipo_to_string = $endereco_paciente_tipo_to_string;
        }

        $this->vdata['endereco_paciente_tipo_to_string'] = $this->endereco_paciente_tipo_to_string;
    }

    public function get_endereco_paciente_tipo_to_string()
    {
        if(!empty($this->endereco_paciente_tipo_to_string))
        {
            return $this->endereco_paciente_tipo_to_string;
        }
    
        $values = EnderecoPaciente::where('id_bairro', '=', $this->id)->getIndexedArray('id_tipo','{tipo->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_profissional_to_string($endereco_profissional_profissional_to_string)
    {
        if(is_array($endereco_profissional_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $endereco_profissional_profissional_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_profissional_to_string = $endereco_profissional_profissional_to_string;
        }

        $this->vdata['endereco_profissional_profissional_to_string'] = $this->endereco_profissional_profissional_to_string;
    }

    public function get_endereco_profissional_profissional_to_string()
    {
        if(!empty($this->endereco_profissional_profissional_to_string))
        {
            return $this->endereco_profissional_profissional_to_string;
        }
    
        $values = EnderecoProfissional::where('id_bairro', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_estado_to_string($endereco_profissional_estado_to_string)
    {
        if(is_array($endereco_profissional_estado_to_string))
        {
            $values = Estado::where('id', 'in', $endereco_profissional_estado_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_estado_to_string = $endereco_profissional_estado_to_string;
        }

        $this->vdata['endereco_profissional_estado_to_string'] = $this->endereco_profissional_estado_to_string;
    }

    public function get_endereco_profissional_estado_to_string()
    {
        if(!empty($this->endereco_profissional_estado_to_string))
        {
            return $this->endereco_profissional_estado_to_string;
        }
    
        $values = EnderecoProfissional::where('id_bairro', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_cidade_to_string($endereco_profissional_cidade_to_string)
    {
        if(is_array($endereco_profissional_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $endereco_profissional_cidade_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_cidade_to_string = $endereco_profissional_cidade_to_string;
        }

        $this->vdata['endereco_profissional_cidade_to_string'] = $this->endereco_profissional_cidade_to_string;
    }

    public function get_endereco_profissional_cidade_to_string()
    {
        if(!empty($this->endereco_profissional_cidade_to_string))
        {
            return $this->endereco_profissional_cidade_to_string;
        }
    
        $values = EnderecoProfissional::where('id_bairro', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_bairro_to_string($endereco_profissional_bairro_to_string)
    {
        if(is_array($endereco_profissional_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $endereco_profissional_bairro_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_bairro_to_string = $endereco_profissional_bairro_to_string;
        }

        $this->vdata['endereco_profissional_bairro_to_string'] = $this->endereco_profissional_bairro_to_string;
    }

    public function get_endereco_profissional_bairro_to_string()
    {
        if(!empty($this->endereco_profissional_bairro_to_string))
        {
            return $this->endereco_profissional_bairro_to_string;
        }
    
        $values = EnderecoProfissional::where('id_bairro', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_tipo_to_string($endereco_profissional_tipo_to_string)
    {
        if(is_array($endereco_profissional_tipo_to_string))
        {
            $values = TipoLogradouro::where('id', 'in', $endereco_profissional_tipo_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_tipo_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_tipo_to_string = $endereco_profissional_tipo_to_string;
        }

        $this->vdata['endereco_profissional_tipo_to_string'] = $this->endereco_profissional_tipo_to_string;
    }

    public function get_endereco_profissional_tipo_to_string()
    {
        if(!empty($this->endereco_profissional_tipo_to_string))
        {
            return $this->endereco_profissional_tipo_to_string;
        }
    
        $values = EnderecoProfissional::where('id_bairro', '=', $this->id)->getIndexedArray('id_tipo','{tipo->id}');
        return implode(', ', $values);
    }

    public function set_distrito_bairro_bairro_to_string($distrito_bairro_bairro_to_string)
    {
        if(is_array($distrito_bairro_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $distrito_bairro_bairro_to_string)->getIndexedArray('id', 'id');
            $this->distrito_bairro_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->distrito_bairro_bairro_to_string = $distrito_bairro_bairro_to_string;
        }

        $this->vdata['distrito_bairro_bairro_to_string'] = $this->distrito_bairro_bairro_to_string;
    }

    public function get_distrito_bairro_bairro_to_string()
    {
        if(!empty($this->distrito_bairro_bairro_to_string))
        {
            return $this->distrito_bairro_bairro_to_string;
        }
    
        $values = DistritoBairro::where('id_bairro', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_distrito_bairro_distrito_to_string($distrito_bairro_distrito_to_string)
    {
        if(is_array($distrito_bairro_distrito_to_string))
        {
            $values = Distrito::where('id', 'in', $distrito_bairro_distrito_to_string)->getIndexedArray('id', 'id');
            $this->distrito_bairro_distrito_to_string = implode(', ', $values);
        }
        else
        {
            $this->distrito_bairro_distrito_to_string = $distrito_bairro_distrito_to_string;
        }

        $this->vdata['distrito_bairro_distrito_to_string'] = $this->distrito_bairro_distrito_to_string;
    }

    public function get_distrito_bairro_distrito_to_string()
    {
        if(!empty($this->distrito_bairro_distrito_to_string))
        {
            return $this->distrito_bairro_distrito_to_string;
        }
    
        $values = DistritoBairro::where('id_bairro', '=', $this->id)->getIndexedArray('id_distrito','{distrito->id}');
        return implode(', ', $values);
    }

    
}

