<?php

class Cid10 extends TRecord
{
    const TABLENAME  = 'cid10';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('descricao_cid');
            
    }

    /**
     * Method getPacienteCid10s
     */
    public function getPacienteCid10s()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_cid', '=', $this->id));
        return PacienteCid10::getObjects( $criteria );
    }

    public function set_paciente_cid10_cid_to_string($paciente_cid10_cid_to_string)
    {
        if(is_array($paciente_cid10_cid_to_string))
        {
            $values = Cid10::where('id', 'in', $paciente_cid10_cid_to_string)->getIndexedArray('id', 'id');
            $this->paciente_cid10_cid_to_string = implode(', ', $values);
        }
        else
        {
            $this->paciente_cid10_cid_to_string = $paciente_cid10_cid_to_string;
        }

        $this->vdata['paciente_cid10_cid_to_string'] = $this->paciente_cid10_cid_to_string;
    }

    public function get_paciente_cid10_cid_to_string()
    {
        if(!empty($this->paciente_cid10_cid_to_string))
        {
            return $this->paciente_cid10_cid_to_string;
        }
    
        $values = PacienteCid10::where('id_cid', '=', $this->id)->getIndexedArray('id_cid','{cid->id}');
        return implode(', ', $values);
    }

    public function set_paciente_cid10_paciente_to_string($paciente_cid10_paciente_to_string)
    {
        if(is_array($paciente_cid10_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $paciente_cid10_paciente_to_string)->getIndexedArray('id', 'id');
            $this->paciente_cid10_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->paciente_cid10_paciente_to_string = $paciente_cid10_paciente_to_string;
        }

        $this->vdata['paciente_cid10_paciente_to_string'] = $this->paciente_cid10_paciente_to_string;
    }

    public function get_paciente_cid10_paciente_to_string()
    {
        if(!empty($this->paciente_cid10_paciente_to_string))
        {
            return $this->paciente_cid10_paciente_to_string;
        }
    
        $values = PacienteCid10::where('id_cid', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_paciente_cid10_tipo_cid_to_string($paciente_cid10_tipo_cid_to_string)
    {
        if(is_array($paciente_cid10_tipo_cid_to_string))
        {
            $values = TipoCid::where('id', 'in', $paciente_cid10_tipo_cid_to_string)->getIndexedArray('id', 'id');
            $this->paciente_cid10_tipo_cid_to_string = implode(', ', $values);
        }
        else
        {
            $this->paciente_cid10_tipo_cid_to_string = $paciente_cid10_tipo_cid_to_string;
        }

        $this->vdata['paciente_cid10_tipo_cid_to_string'] = $this->paciente_cid10_tipo_cid_to_string;
    }

    public function get_paciente_cid10_tipo_cid_to_string()
    {
        if(!empty($this->paciente_cid10_tipo_cid_to_string))
        {
            return $this->paciente_cid10_tipo_cid_to_string;
        }
    
        $values = PacienteCid10::where('id_cid', '=', $this->id)->getIndexedArray('id_tipo_cid','{tipo_cid->id}');
        return implode(', ', $values);
    }

    
}

