<?php

class Cidade extends TRecord
{
    const TABLENAME  = 'cidade';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $estado;
    private $regiao;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_estado');
        parent::addAttribute('id_regiao');
        parent::addAttribute('nome_cidade');
            
    }

    /**
     * Method set_estado
     * Sample of usage: $var->estado = $object;
     * @param $object Instance of Estado
     */
    public function set_estado(Estado $object)
    {
        $this->estado = $object;
        $this->id_estado = $object->id;
    }

    /**
     * Method get_estado
     * Sample of usage: $var->estado->attribute;
     * @returns Estado instance
     */
    public function get_estado()
    {
    
        // loads the associated object
        if (empty($this->estado))
            $this->estado = new Estado($this->id_estado);
    
        // returns the associated object
        return $this->estado;
    }
    /**
     * Method set_regiao
     * Sample of usage: $var->regiao = $object;
     * @param $object Instance of Regiao
     */
    public function set_regiao(Regiao $object)
    {
        $this->regiao = $object;
        $this->id_regiao = $object->id;
    }

    /**
     * Method get_regiao
     * Sample of usage: $var->regiao->attribute;
     * @returns Regiao instance
     */
    public function get_regiao()
    {
    
        // loads the associated object
        if (empty($this->regiao))
            $this->regiao = new Regiao($this->id_regiao);
    
        // returns the associated object
        return $this->regiao;
    }

    /**
     * Method getBairros
     */
    public function getBairros()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_cidade', '=', $this->id));
        return Bairro::getObjects( $criteria );
    }
    /**
     * Method getEnderecoPacientes
     */
    public function getEnderecoPacientes()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_cidade', '=', $this->id));
        return EnderecoPaciente::getObjects( $criteria );
    }
    /**
     * Method getEnderecoProfissionals
     */
    public function getEnderecoProfissionals()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_cidade', '=', $this->id));
        return EnderecoProfissional::getObjects( $criteria );
    }

    public function set_bairro_cidade_to_string($bairro_cidade_to_string)
    {
        if(is_array($bairro_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $bairro_cidade_to_string)->getIndexedArray('id', 'id');
            $this->bairro_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->bairro_cidade_to_string = $bairro_cidade_to_string;
        }

        $this->vdata['bairro_cidade_to_string'] = $this->bairro_cidade_to_string;
    }

    public function get_bairro_cidade_to_string()
    {
        if(!empty($this->bairro_cidade_to_string))
        {
            return $this->bairro_cidade_to_string;
        }
    
        $values = Bairro::where('id_cidade', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_paciente_to_string($endereco_paciente_paciente_to_string)
    {
        if(is_array($endereco_paciente_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $endereco_paciente_paciente_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_paciente_to_string = $endereco_paciente_paciente_to_string;
        }

        $this->vdata['endereco_paciente_paciente_to_string'] = $this->endereco_paciente_paciente_to_string;
    }

    public function get_endereco_paciente_paciente_to_string()
    {
        if(!empty($this->endereco_paciente_paciente_to_string))
        {
            return $this->endereco_paciente_paciente_to_string;
        }
    
        $values = EnderecoPaciente::where('id_cidade', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_estado_to_string($endereco_paciente_estado_to_string)
    {
        if(is_array($endereco_paciente_estado_to_string))
        {
            $values = Estado::where('id', 'in', $endereco_paciente_estado_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_estado_to_string = $endereco_paciente_estado_to_string;
        }

        $this->vdata['endereco_paciente_estado_to_string'] = $this->endereco_paciente_estado_to_string;
    }

    public function get_endereco_paciente_estado_to_string()
    {
        if(!empty($this->endereco_paciente_estado_to_string))
        {
            return $this->endereco_paciente_estado_to_string;
        }
    
        $values = EnderecoPaciente::where('id_cidade', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_cidade_to_string($endereco_paciente_cidade_to_string)
    {
        if(is_array($endereco_paciente_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $endereco_paciente_cidade_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_cidade_to_string = $endereco_paciente_cidade_to_string;
        }

        $this->vdata['endereco_paciente_cidade_to_string'] = $this->endereco_paciente_cidade_to_string;
    }

    public function get_endereco_paciente_cidade_to_string()
    {
        if(!empty($this->endereco_paciente_cidade_to_string))
        {
            return $this->endereco_paciente_cidade_to_string;
        }
    
        $values = EnderecoPaciente::where('id_cidade', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_bairro_to_string($endereco_paciente_bairro_to_string)
    {
        if(is_array($endereco_paciente_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $endereco_paciente_bairro_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_bairro_to_string = $endereco_paciente_bairro_to_string;
        }

        $this->vdata['endereco_paciente_bairro_to_string'] = $this->endereco_paciente_bairro_to_string;
    }

    public function get_endereco_paciente_bairro_to_string()
    {
        if(!empty($this->endereco_paciente_bairro_to_string))
        {
            return $this->endereco_paciente_bairro_to_string;
        }
    
        $values = EnderecoPaciente::where('id_cidade', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_tipo_to_string($endereco_paciente_tipo_to_string)
    {
        if(is_array($endereco_paciente_tipo_to_string))
        {
            $values = TipoLogradouro::where('id', 'in', $endereco_paciente_tipo_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_tipo_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_tipo_to_string = $endereco_paciente_tipo_to_string;
        }

        $this->vdata['endereco_paciente_tipo_to_string'] = $this->endereco_paciente_tipo_to_string;
    }

    public function get_endereco_paciente_tipo_to_string()
    {
        if(!empty($this->endereco_paciente_tipo_to_string))
        {
            return $this->endereco_paciente_tipo_to_string;
        }
    
        $values = EnderecoPaciente::where('id_cidade', '=', $this->id)->getIndexedArray('id_tipo','{tipo->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_profissional_to_string($endereco_profissional_profissional_to_string)
    {
        if(is_array($endereco_profissional_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $endereco_profissional_profissional_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_profissional_to_string = $endereco_profissional_profissional_to_string;
        }

        $this->vdata['endereco_profissional_profissional_to_string'] = $this->endereco_profissional_profissional_to_string;
    }

    public function get_endereco_profissional_profissional_to_string()
    {
        if(!empty($this->endereco_profissional_profissional_to_string))
        {
            return $this->endereco_profissional_profissional_to_string;
        }
    
        $values = EnderecoProfissional::where('id_cidade', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_estado_to_string($endereco_profissional_estado_to_string)
    {
        if(is_array($endereco_profissional_estado_to_string))
        {
            $values = Estado::where('id', 'in', $endereco_profissional_estado_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_estado_to_string = $endereco_profissional_estado_to_string;
        }

        $this->vdata['endereco_profissional_estado_to_string'] = $this->endereco_profissional_estado_to_string;
    }

    public function get_endereco_profissional_estado_to_string()
    {
        if(!empty($this->endereco_profissional_estado_to_string))
        {
            return $this->endereco_profissional_estado_to_string;
        }
    
        $values = EnderecoProfissional::where('id_cidade', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_cidade_to_string($endereco_profissional_cidade_to_string)
    {
        if(is_array($endereco_profissional_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $endereco_profissional_cidade_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_cidade_to_string = $endereco_profissional_cidade_to_string;
        }

        $this->vdata['endereco_profissional_cidade_to_string'] = $this->endereco_profissional_cidade_to_string;
    }

    public function get_endereco_profissional_cidade_to_string()
    {
        if(!empty($this->endereco_profissional_cidade_to_string))
        {
            return $this->endereco_profissional_cidade_to_string;
        }
    
        $values = EnderecoProfissional::where('id_cidade', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_bairro_to_string($endereco_profissional_bairro_to_string)
    {
        if(is_array($endereco_profissional_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $endereco_profissional_bairro_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_bairro_to_string = $endereco_profissional_bairro_to_string;
        }

        $this->vdata['endereco_profissional_bairro_to_string'] = $this->endereco_profissional_bairro_to_string;
    }

    public function get_endereco_profissional_bairro_to_string()
    {
        if(!empty($this->endereco_profissional_bairro_to_string))
        {
            return $this->endereco_profissional_bairro_to_string;
        }
    
        $values = EnderecoProfissional::where('id_cidade', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_tipo_to_string($endereco_profissional_tipo_to_string)
    {
        if(is_array($endereco_profissional_tipo_to_string))
        {
            $values = TipoLogradouro::where('id', 'in', $endereco_profissional_tipo_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_tipo_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_tipo_to_string = $endereco_profissional_tipo_to_string;
        }

        $this->vdata['endereco_profissional_tipo_to_string'] = $this->endereco_profissional_tipo_to_string;
    }

    public function get_endereco_profissional_tipo_to_string()
    {
        if(!empty($this->endereco_profissional_tipo_to_string))
        {
            return $this->endereco_profissional_tipo_to_string;
        }
    
        $values = EnderecoProfissional::where('id_cidade', '=', $this->id)->getIndexedArray('id_tipo','{tipo->id}');
        return implode(', ', $values);
    }

    
}

