<?php

class ClassificacaoAbemid extends TRecord
{
    const TABLENAME  = 'classificacao_abemid';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('descricao');
            
    }

    /**
     * Method getAvaliacaoAbemidPacientes
     */
    public function getAvaliacaoAbemidPacientes()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_classificacao', '=', $this->id));
        return AvaliacaoAbemidPaciente::getObjects( $criteria );
    }

    public function set_avaliacao_abemid_paciente_paciente_to_string($avaliacao_abemid_paciente_paciente_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $avaliacao_abemid_paciente_paciente_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_paciente_to_string = $avaliacao_abemid_paciente_paciente_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_paciente_to_string'] = $this->avaliacao_abemid_paciente_paciente_to_string;
    }

    public function get_avaliacao_abemid_paciente_paciente_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_paciente_to_string))
        {
            return $this->avaliacao_abemid_paciente_paciente_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_classificacao', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_escore_abemid_to_string($avaliacao_abemid_paciente_escore_abemid_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_escore_abemid_to_string))
        {
            $values = EscoreAbemid::where('id', 'in', $avaliacao_abemid_paciente_escore_abemid_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_escore_abemid_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_escore_abemid_to_string = $avaliacao_abemid_paciente_escore_abemid_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_escore_abemid_to_string'] = $this->avaliacao_abemid_paciente_escore_abemid_to_string;
    }

    public function get_avaliacao_abemid_paciente_escore_abemid_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_escore_abemid_to_string))
        {
            return $this->avaliacao_abemid_paciente_escore_abemid_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_classificacao', '=', $this->id)->getIndexedArray('id_escore_abemid','{escore_abemid->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_item_escore_to_string($avaliacao_abemid_paciente_item_escore_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_item_escore_to_string))
        {
            $values = ItensEscoreabemid::where('id', 'in', $avaliacao_abemid_paciente_item_escore_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_item_escore_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_item_escore_to_string = $avaliacao_abemid_paciente_item_escore_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_item_escore_to_string'] = $this->avaliacao_abemid_paciente_item_escore_to_string;
    }

    public function get_avaliacao_abemid_paciente_item_escore_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_item_escore_to_string))
        {
            return $this->avaliacao_abemid_paciente_item_escore_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_classificacao', '=', $this->id)->getIndexedArray('id_item_escore','{item_escore->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_classificacao_to_string($avaliacao_abemid_paciente_classificacao_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_classificacao_to_string))
        {
            $values = ClassificacaoAbemid::where('id', 'in', $avaliacao_abemid_paciente_classificacao_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_classificacao_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_classificacao_to_string = $avaliacao_abemid_paciente_classificacao_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_classificacao_to_string'] = $this->avaliacao_abemid_paciente_classificacao_to_string;
    }

    public function get_avaliacao_abemid_paciente_classificacao_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_classificacao_to_string))
        {
            return $this->avaliacao_abemid_paciente_classificacao_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_classificacao', '=', $this->id)->getIndexedArray('id_classificacao','{classificacao->id}');
        return implode(', ', $values);
    }

    
}

