<?php

class Distrito extends TRecord
{
    const TABLENAME  = 'distrito';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('nome_distrito');
            
    }

    /**
     * Method getDistritoBairros
     */
    public function getDistritoBairros()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_distrito', '=', $this->id));
        return DistritoBairro::getObjects( $criteria );
    }

    public function set_distrito_bairro_bairro_to_string($distrito_bairro_bairro_to_string)
    {
        if(is_array($distrito_bairro_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $distrito_bairro_bairro_to_string)->getIndexedArray('id', 'id');
            $this->distrito_bairro_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->distrito_bairro_bairro_to_string = $distrito_bairro_bairro_to_string;
        }

        $this->vdata['distrito_bairro_bairro_to_string'] = $this->distrito_bairro_bairro_to_string;
    }

    public function get_distrito_bairro_bairro_to_string()
    {
        if(!empty($this->distrito_bairro_bairro_to_string))
        {
            return $this->distrito_bairro_bairro_to_string;
        }
    
        $values = DistritoBairro::where('id_distrito', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_distrito_bairro_distrito_to_string($distrito_bairro_distrito_to_string)
    {
        if(is_array($distrito_bairro_distrito_to_string))
        {
            $values = Distrito::where('id', 'in', $distrito_bairro_distrito_to_string)->getIndexedArray('id', 'id');
            $this->distrito_bairro_distrito_to_string = implode(', ', $values);
        }
        else
        {
            $this->distrito_bairro_distrito_to_string = $distrito_bairro_distrito_to_string;
        }

        $this->vdata['distrito_bairro_distrito_to_string'] = $this->distrito_bairro_distrito_to_string;
    }

    public function get_distrito_bairro_distrito_to_string()
    {
        if(!empty($this->distrito_bairro_distrito_to_string))
        {
            return $this->distrito_bairro_distrito_to_string;
        }
    
        $values = DistritoBairro::where('id_distrito', '=', $this->id)->getIndexedArray('id_distrito','{distrito->id}');
        return implode(', ', $values);
    }

    
}

