<?php

class DistritoBairro extends TRecord
{
    const TABLENAME  = 'distrito_bairro';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $bairro;
    private $distrito;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_bairro');
        parent::addAttribute('id_distrito');
            
    }

    /**
     * Method set_bairro
     * Sample of usage: $var->bairro = $object;
     * @param $object Instance of Bairro
     */
    public function set_bairro(Bairro $object)
    {
        $this->bairro = $object;
        $this->id_bairro = $object->id;
    }

    /**
     * Method get_bairro
     * Sample of usage: $var->bairro->attribute;
     * @returns Bairro instance
     */
    public function get_bairro()
    {
    
        // loads the associated object
        if (empty($this->bairro))
            $this->bairro = new Bairro($this->id_bairro);
    
        // returns the associated object
        return $this->bairro;
    }
    /**
     * Method set_distrito
     * Sample of usage: $var->distrito = $object;
     * @param $object Instance of Distrito
     */
    public function set_distrito(Distrito $object)
    {
        $this->distrito = $object;
        $this->id_distrito = $object->id;
    }

    /**
     * Method get_distrito
     * Sample of usage: $var->distrito->attribute;
     * @returns Distrito instance
     */
    public function get_distrito()
    {
    
        // loads the associated object
        if (empty($this->distrito))
            $this->distrito = new Distrito($this->id_distrito);
    
        // returns the associated object
        return $this->distrito;
    }

    
}

