<?php

class EnderecoPaciente extends TRecord
{
    const TABLENAME  = 'endereco_paciente';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $paciente;
    private $estado;
    private $cidade;
    private $bairro;
    private $tipo;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_paciente');
        parent::addAttribute('id_estado');
        parent::addAttribute('id_cidade');
        parent::addAttribute('id_bairro');
        parent::addAttribute('id_tipo');
        parent::addAttribute('logradouro');
        parent::addAttribute('num_logradouro');
        parent::addAttribute('complemento');
        parent::addAttribute('cep_logradouro');
        parent::addAttribute('ponto_referencia');
            
    }

    /**
     * Method set_paciente
     * Sample of usage: $var->paciente = $object;
     * @param $object Instance of Paciente
     */
    public function set_paciente(Paciente $object)
    {
        $this->paciente = $object;
        $this->id_paciente = $object->id;
    }

    /**
     * Method get_paciente
     * Sample of usage: $var->paciente->attribute;
     * @returns Paciente instance
     */
    public function get_paciente()
    {
    
        // loads the associated object
        if (empty($this->paciente))
            $this->paciente = new Paciente($this->id_paciente);
    
        // returns the associated object
        return $this->paciente;
    }
    /**
     * Method set_estado
     * Sample of usage: $var->estado = $object;
     * @param $object Instance of Estado
     */
    public function set_estado(Estado $object)
    {
        $this->estado = $object;
        $this->id_estado = $object->id;
    }

    /**
     * Method get_estado
     * Sample of usage: $var->estado->attribute;
     * @returns Estado instance
     */
    public function get_estado()
    {
    
        // loads the associated object
        if (empty($this->estado))
            $this->estado = new Estado($this->id_estado);
    
        // returns the associated object
        return $this->estado;
    }
    /**
     * Method set_cidade
     * Sample of usage: $var->cidade = $object;
     * @param $object Instance of Cidade
     */
    public function set_cidade(Cidade $object)
    {
        $this->cidade = $object;
        $this->id_cidade = $object->id;
    }

    /**
     * Method get_cidade
     * Sample of usage: $var->cidade->attribute;
     * @returns Cidade instance
     */
    public function get_cidade()
    {
    
        // loads the associated object
        if (empty($this->cidade))
            $this->cidade = new Cidade($this->id_cidade);
    
        // returns the associated object
        return $this->cidade;
    }
    /**
     * Method set_bairro
     * Sample of usage: $var->bairro = $object;
     * @param $object Instance of Bairro
     */
    public function set_bairro(Bairro $object)
    {
        $this->bairro = $object;
        $this->id_bairro = $object->id;
    }

    /**
     * Method get_bairro
     * Sample of usage: $var->bairro->attribute;
     * @returns Bairro instance
     */
    public function get_bairro()
    {
    
        // loads the associated object
        if (empty($this->bairro))
            $this->bairro = new Bairro($this->id_bairro);
    
        // returns the associated object
        return $this->bairro;
    }
    /**
     * Method set_tipo_logradouro
     * Sample of usage: $var->tipo_logradouro = $object;
     * @param $object Instance of TipoLogradouro
     */
    public function set_tipo(TipoLogradouro $object)
    {
        $this->tipo = $object;
        $this->id_tipo = $object->id;
    }

    /**
     * Method get_tipo
     * Sample of usage: $var->tipo->attribute;
     * @returns TipoLogradouro instance
     */
    public function get_tipo()
    {
    
        // loads the associated object
        if (empty($this->tipo))
            $this->tipo = new TipoLogradouro($this->id_tipo);
    
        // returns the associated object
        return $this->tipo;
    }

    
}

