<?php

class EnderecoProfissional extends TRecord
{
    const TABLENAME  = 'endereco_profissional';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $profissional;
    private $estado;
    private $cidade;
    private $bairro;
    private $tipo;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_profissional');
        parent::addAttribute('id_estado');
        parent::addAttribute('id_cidade');
        parent::addAttribute('id_bairro');
        parent::addAttribute('id_tipo');
        parent::addAttribute('logradouro');
        parent::addAttribute('num_logradouro');
        parent::addAttribute('complemento');
        parent::addAttribute('cep_logradouro');
        parent::addAttribute('ponto_referencia');
            
    }

    /**
     * Method set_profissional
     * Sample of usage: $var->profissional = $object;
     * @param $object Instance of Profissional
     */
    public function set_profissional(Profissional $object)
    {
        $this->profissional = $object;
        $this->id_profissional = $object->id;
    }

    /**
     * Method get_profissional
     * Sample of usage: $var->profissional->attribute;
     * @returns Profissional instance
     */
    public function get_profissional()
    {
    
        // loads the associated object
        if (empty($this->profissional))
            $this->profissional = new Profissional($this->id_profissional);
    
        // returns the associated object
        return $this->profissional;
    }
    /**
     * Method set_estado
     * Sample of usage: $var->estado = $object;
     * @param $object Instance of Estado
     */
    public function set_estado(Estado $object)
    {
        $this->estado = $object;
        $this->id_estado = $object->id;
    }

    /**
     * Method get_estado
     * Sample of usage: $var->estado->attribute;
     * @returns Estado instance
     */
    public function get_estado()
    {
    
        // loads the associated object
        if (empty($this->estado))
            $this->estado = new Estado($this->id_estado);
    
        // returns the associated object
        return $this->estado;
    }
    /**
     * Method set_cidade
     * Sample of usage: $var->cidade = $object;
     * @param $object Instance of Cidade
     */
    public function set_cidade(Cidade $object)
    {
        $this->cidade = $object;
        $this->id_cidade = $object->id;
    }

    /**
     * Method get_cidade
     * Sample of usage: $var->cidade->attribute;
     * @returns Cidade instance
     */
    public function get_cidade()
    {
    
        // loads the associated object
        if (empty($this->cidade))
            $this->cidade = new Cidade($this->id_cidade);
    
        // returns the associated object
        return $this->cidade;
    }
    /**
     * Method set_bairro
     * Sample of usage: $var->bairro = $object;
     * @param $object Instance of Bairro
     */
    public function set_bairro(Bairro $object)
    {
        $this->bairro = $object;
        $this->id_bairro = $object->id;
    }

    /**
     * Method get_bairro
     * Sample of usage: $var->bairro->attribute;
     * @returns Bairro instance
     */
    public function get_bairro()
    {
    
        // loads the associated object
        if (empty($this->bairro))
            $this->bairro = new Bairro($this->id_bairro);
    
        // returns the associated object
        return $this->bairro;
    }
    /**
     * Method set_tipo_logradouro
     * Sample of usage: $var->tipo_logradouro = $object;
     * @param $object Instance of TipoLogradouro
     */
    public function set_tipo(TipoLogradouro $object)
    {
        $this->tipo = $object;
        $this->id_tipo = $object->id;
    }

    /**
     * Method get_tipo
     * Sample of usage: $var->tipo->attribute;
     * @returns TipoLogradouro instance
     */
    public function get_tipo()
    {
    
        // loads the associated object
        if (empty($this->tipo))
            $this->tipo = new TipoLogradouro($this->id_tipo);
    
        // returns the associated object
        return $this->tipo;
    }

    
}

