<?php

class Escala extends TRecord
{
    const TABLENAME  = 'escala';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $equipe;
    private $turno;
    private $unidade_saude;
    private $profissional;
    private $procedimento;
    private $ocupacao;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_equipe');
        parent::addAttribute('id_profissional');
        parent::addAttribute('id_turno');
        parent::addAttribute('id_unidade_saude');
        parent::addAttribute('id_procedimento');
        parent::addAttribute('qtd_primeira_vez');
        parent::addAttribute('data_limite');
        parent::addAttribute('qtd_retorno');
        parent::addAttribute('encaixe');
        parent::addAttribute('data_inicio');
        parent::addAttribute('id_ocupacao');
            
    }

    /**
     * Method set_equipe
     * Sample of usage: $var->equipe = $object;
     * @param $object Instance of Equipe
     */
    public function set_equipe(Equipe $object)
    {
        $this->equipe = $object;
        $this->id_equipe = $object->id;
    }

    /**
     * Method get_equipe
     * Sample of usage: $var->equipe->attribute;
     * @returns Equipe instance
     */
    public function get_equipe()
    {
    
        // loads the associated object
        if (empty($this->equipe))
            $this->equipe = new Equipe($this->id_equipe);
    
        // returns the associated object
        return $this->equipe;
    }
    /**
     * Method set_turno
     * Sample of usage: $var->turno = $object;
     * @param $object Instance of Turno
     */
    public function set_turno(Turno $object)
    {
        $this->turno = $object;
        $this->id_turno = $object->id;
    }

    /**
     * Method get_turno
     * Sample of usage: $var->turno->attribute;
     * @returns Turno instance
     */
    public function get_turno()
    {
    
        // loads the associated object
        if (empty($this->turno))
            $this->turno = new Turno($this->id_turno);
    
        // returns the associated object
        return $this->turno;
    }
    /**
     * Method set_unidade_saude
     * Sample of usage: $var->unidade_saude = $object;
     * @param $object Instance of UnidadeSaude
     */
    public function set_unidade_saude(UnidadeSaude $object)
    {
        $this->unidade_saude = $object;
        $this->id_unidade_saude = $object->id;
    }

    /**
     * Method get_unidade_saude
     * Sample of usage: $var->unidade_saude->attribute;
     * @returns UnidadeSaude instance
     */
    public function get_unidade_saude()
    {
    
        // loads the associated object
        if (empty($this->unidade_saude))
            $this->unidade_saude = new UnidadeSaude($this->id_unidade_saude);
    
        // returns the associated object
        return $this->unidade_saude;
    }
    /**
     * Method set_profissional
     * Sample of usage: $var->profissional = $object;
     * @param $object Instance of Profissional
     */
    public function set_profissional(Profissional $object)
    {
        $this->profissional = $object;
        $this->id_profissional = $object->id;
    }

    /**
     * Method get_profissional
     * Sample of usage: $var->profissional->attribute;
     * @returns Profissional instance
     */
    public function get_profissional()
    {
    
        // loads the associated object
        if (empty($this->profissional))
            $this->profissional = new Profissional($this->id_profissional);
    
        // returns the associated object
        return $this->profissional;
    }
    /**
     * Method set_procedimento
     * Sample of usage: $var->procedimento = $object;
     * @param $object Instance of Procedimento
     */
    public function set_procedimento(Procedimento $object)
    {
        $this->procedimento = $object;
        $this->id_procedimento = $object->id;
    }

    /**
     * Method get_procedimento
     * Sample of usage: $var->procedimento->attribute;
     * @returns Procedimento instance
     */
    public function get_procedimento()
    {
    
        // loads the associated object
        if (empty($this->procedimento))
            $this->procedimento = new Procedimento($this->id_procedimento);
    
        // returns the associated object
        return $this->procedimento;
    }
    /**
     * Method set_ocupacao
     * Sample of usage: $var->ocupacao = $object;
     * @param $object Instance of Ocupacao
     */
    public function set_ocupacao(Ocupacao $object)
    {
        $this->ocupacao = $object;
        $this->id_ocupacao = $object->id;
    }

    /**
     * Method get_ocupacao
     * Sample of usage: $var->ocupacao->attribute;
     * @returns Ocupacao instance
     */
    public function get_ocupacao()
    {
    
        // loads the associated object
        if (empty($this->ocupacao))
            $this->ocupacao = new Ocupacao($this->id_ocupacao);
    
        // returns the associated object
        return $this->ocupacao;
    }

    /**
     * Method getAgendamentos
     */
    public function getAgendamentos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_escala', '=', $this->id));
        return Agendamento::getObjects( $criteria );
    }
    /**
     * Method getEscalaDias
     */
    public function getEscalaDias()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_escala', '=', $this->id));
        return EscalaDia::getObjects( $criteria );
    }

    public function set_agendamento_paciente_to_string($agendamento_paciente_to_string)
    {
        if(is_array($agendamento_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $agendamento_paciente_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_paciente_to_string = $agendamento_paciente_to_string;
        }

        $this->vdata['agendamento_paciente_to_string'] = $this->agendamento_paciente_to_string;
    }

    public function get_agendamento_paciente_to_string()
    {
        if(!empty($this->agendamento_paciente_to_string))
        {
            return $this->agendamento_paciente_to_string;
        }
    
        $values = Agendamento::where('id_escala', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_escala_to_string($agendamento_escala_to_string)
    {
        if(is_array($agendamento_escala_to_string))
        {
            $values = Escala::where('id', 'in', $agendamento_escala_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_escala_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_escala_to_string = $agendamento_escala_to_string;
        }

        $this->vdata['agendamento_escala_to_string'] = $this->agendamento_escala_to_string;
    }

    public function get_agendamento_escala_to_string()
    {
        if(!empty($this->agendamento_escala_to_string))
        {
            return $this->agendamento_escala_to_string;
        }
    
        $values = Agendamento::where('id_escala', '=', $this->id)->getIndexedArray('id_escala','{escala->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_unidade_saude_to_string($agendamento_unidade_saude_to_string)
    {
        if(is_array($agendamento_unidade_saude_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $agendamento_unidade_saude_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_unidade_saude_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_unidade_saude_to_string = $agendamento_unidade_saude_to_string;
        }

        $this->vdata['agendamento_unidade_saude_to_string'] = $this->agendamento_unidade_saude_to_string;
    }

    public function get_agendamento_unidade_saude_to_string()
    {
        if(!empty($this->agendamento_unidade_saude_to_string))
        {
            return $this->agendamento_unidade_saude_to_string;
        }
    
        $values = Agendamento::where('id_escala', '=', $this->id)->getIndexedArray('id_unidade_saude','{unidade_saude->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_procedimento_to_string($agendamento_procedimento_to_string)
    {
        if(is_array($agendamento_procedimento_to_string))
        {
            $values = Procedimento::where('id', 'in', $agendamento_procedimento_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_procedimento_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_procedimento_to_string = $agendamento_procedimento_to_string;
        }

        $this->vdata['agendamento_procedimento_to_string'] = $this->agendamento_procedimento_to_string;
    }

    public function get_agendamento_procedimento_to_string()
    {
        if(!empty($this->agendamento_procedimento_to_string))
        {
            return $this->agendamento_procedimento_to_string;
        }
    
        $values = Agendamento::where('id_escala', '=', $this->id)->getIndexedArray('id_procedimento','{procedimento->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_profissional_to_string($agendamento_profissional_to_string)
    {
        if(is_array($agendamento_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $agendamento_profissional_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_profissional_to_string = $agendamento_profissional_to_string;
        }

        $this->vdata['agendamento_profissional_to_string'] = $this->agendamento_profissional_to_string;
    }

    public function get_agendamento_profissional_to_string()
    {
        if(!empty($this->agendamento_profissional_to_string))
        {
            return $this->agendamento_profissional_to_string;
        }
    
        $values = Agendamento::where('id_escala', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_escala_dia_escala_to_string($escala_dia_escala_to_string)
    {
        if(is_array($escala_dia_escala_to_string))
        {
            $values = Escala::where('id', 'in', $escala_dia_escala_to_string)->getIndexedArray('id', 'id');
            $this->escala_dia_escala_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_dia_escala_to_string = $escala_dia_escala_to_string;
        }

        $this->vdata['escala_dia_escala_to_string'] = $this->escala_dia_escala_to_string;
    }

    public function get_escala_dia_escala_to_string()
    {
        if(!empty($this->escala_dia_escala_to_string))
        {
            return $this->escala_dia_escala_to_string;
        }
    
        $values = EscalaDia::where('id_escala', '=', $this->id)->getIndexedArray('id_escala','{escala->id}');
        return implode(', ', $values);
    }

    
}

