<?php

class EscalaDia extends TRecord
{
    const TABLENAME  = 'escala_dia';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $escala;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_escala');
        parent::addAttribute('dia_semana');
            
    }

    /**
     * Method set_escala
     * Sample of usage: $var->escala = $object;
     * @param $object Instance of Escala
     */
    public function set_escala(Escala $object)
    {
        $this->escala = $object;
        $this->id_escala = $object->id;
    }

    /**
     * Method get_escala
     * Sample of usage: $var->escala->attribute;
     * @returns Escala instance
     */
    public function get_escala()
    {
    
        // loads the associated object
        if (empty($this->escala))
            $this->escala = new Escala($this->id_escala);
    
        // returns the associated object
        return $this->escala;
    }

    
}

