<?php

class Estado extends TRecord
{
    const TABLENAME  = 'estado';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('nome_estado');
            
    }

    /**
     * Method getCidades
     */
    public function getCidades()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_estado', '=', $this->id));
        return Cidade::getObjects( $criteria );
    }
    /**
     * Method getRegiaos
     */
    public function getRegiaos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_estado', '=', $this->id));
        return Regiao::getObjects( $criteria );
    }
    /**
     * Method getEnderecoPacientes
     */
    public function getEnderecoPacientes()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_estado', '=', $this->id));
        return EnderecoPaciente::getObjects( $criteria );
    }
    /**
     * Method getEnderecoProfissionals
     */
    public function getEnderecoProfissionals()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_estado', '=', $this->id));
        return EnderecoProfissional::getObjects( $criteria );
    }

    public function set_cidade_estado_to_string($cidade_estado_to_string)
    {
        if(is_array($cidade_estado_to_string))
        {
            $values = Estado::where('id', 'in', $cidade_estado_to_string)->getIndexedArray('id', 'id');
            $this->cidade_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->cidade_estado_to_string = $cidade_estado_to_string;
        }

        $this->vdata['cidade_estado_to_string'] = $this->cidade_estado_to_string;
    }

    public function get_cidade_estado_to_string()
    {
        if(!empty($this->cidade_estado_to_string))
        {
            return $this->cidade_estado_to_string;
        }
    
        $values = Cidade::where('id_estado', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_cidade_regiao_to_string($cidade_regiao_to_string)
    {
        if(is_array($cidade_regiao_to_string))
        {
            $values = Regiao::where('id', 'in', $cidade_regiao_to_string)->getIndexedArray('id', 'id');
            $this->cidade_regiao_to_string = implode(', ', $values);
        }
        else
        {
            $this->cidade_regiao_to_string = $cidade_regiao_to_string;
        }

        $this->vdata['cidade_regiao_to_string'] = $this->cidade_regiao_to_string;
    }

    public function get_cidade_regiao_to_string()
    {
        if(!empty($this->cidade_regiao_to_string))
        {
            return $this->cidade_regiao_to_string;
        }
    
        $values = Cidade::where('id_estado', '=', $this->id)->getIndexedArray('id_regiao','{regiao->id}');
        return implode(', ', $values);
    }

    public function set_regiao_estado_to_string($regiao_estado_to_string)
    {
        if(is_array($regiao_estado_to_string))
        {
            $values = Estado::where('id', 'in', $regiao_estado_to_string)->getIndexedArray('id', 'id');
            $this->regiao_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->regiao_estado_to_string = $regiao_estado_to_string;
        }

        $this->vdata['regiao_estado_to_string'] = $this->regiao_estado_to_string;
    }

    public function get_regiao_estado_to_string()
    {
        if(!empty($this->regiao_estado_to_string))
        {
            return $this->regiao_estado_to_string;
        }
    
        $values = Regiao::where('id_estado', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_paciente_to_string($endereco_paciente_paciente_to_string)
    {
        if(is_array($endereco_paciente_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $endereco_paciente_paciente_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_paciente_to_string = $endereco_paciente_paciente_to_string;
        }

        $this->vdata['endereco_paciente_paciente_to_string'] = $this->endereco_paciente_paciente_to_string;
    }

    public function get_endereco_paciente_paciente_to_string()
    {
        if(!empty($this->endereco_paciente_paciente_to_string))
        {
            return $this->endereco_paciente_paciente_to_string;
        }
    
        $values = EnderecoPaciente::where('id_estado', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_estado_to_string($endereco_paciente_estado_to_string)
    {
        if(is_array($endereco_paciente_estado_to_string))
        {
            $values = Estado::where('id', 'in', $endereco_paciente_estado_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_estado_to_string = $endereco_paciente_estado_to_string;
        }

        $this->vdata['endereco_paciente_estado_to_string'] = $this->endereco_paciente_estado_to_string;
    }

    public function get_endereco_paciente_estado_to_string()
    {
        if(!empty($this->endereco_paciente_estado_to_string))
        {
            return $this->endereco_paciente_estado_to_string;
        }
    
        $values = EnderecoPaciente::where('id_estado', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_cidade_to_string($endereco_paciente_cidade_to_string)
    {
        if(is_array($endereco_paciente_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $endereco_paciente_cidade_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_cidade_to_string = $endereco_paciente_cidade_to_string;
        }

        $this->vdata['endereco_paciente_cidade_to_string'] = $this->endereco_paciente_cidade_to_string;
    }

    public function get_endereco_paciente_cidade_to_string()
    {
        if(!empty($this->endereco_paciente_cidade_to_string))
        {
            return $this->endereco_paciente_cidade_to_string;
        }
    
        $values = EnderecoPaciente::where('id_estado', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_bairro_to_string($endereco_paciente_bairro_to_string)
    {
        if(is_array($endereco_paciente_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $endereco_paciente_bairro_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_bairro_to_string = $endereco_paciente_bairro_to_string;
        }

        $this->vdata['endereco_paciente_bairro_to_string'] = $this->endereco_paciente_bairro_to_string;
    }

    public function get_endereco_paciente_bairro_to_string()
    {
        if(!empty($this->endereco_paciente_bairro_to_string))
        {
            return $this->endereco_paciente_bairro_to_string;
        }
    
        $values = EnderecoPaciente::where('id_estado', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_tipo_to_string($endereco_paciente_tipo_to_string)
    {
        if(is_array($endereco_paciente_tipo_to_string))
        {
            $values = TipoLogradouro::where('id', 'in', $endereco_paciente_tipo_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_tipo_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_tipo_to_string = $endereco_paciente_tipo_to_string;
        }

        $this->vdata['endereco_paciente_tipo_to_string'] = $this->endereco_paciente_tipo_to_string;
    }

    public function get_endereco_paciente_tipo_to_string()
    {
        if(!empty($this->endereco_paciente_tipo_to_string))
        {
            return $this->endereco_paciente_tipo_to_string;
        }
    
        $values = EnderecoPaciente::where('id_estado', '=', $this->id)->getIndexedArray('id_tipo','{tipo->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_profissional_to_string($endereco_profissional_profissional_to_string)
    {
        if(is_array($endereco_profissional_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $endereco_profissional_profissional_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_profissional_to_string = $endereco_profissional_profissional_to_string;
        }

        $this->vdata['endereco_profissional_profissional_to_string'] = $this->endereco_profissional_profissional_to_string;
    }

    public function get_endereco_profissional_profissional_to_string()
    {
        if(!empty($this->endereco_profissional_profissional_to_string))
        {
            return $this->endereco_profissional_profissional_to_string;
        }
    
        $values = EnderecoProfissional::where('id_estado', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_estado_to_string($endereco_profissional_estado_to_string)
    {
        if(is_array($endereco_profissional_estado_to_string))
        {
            $values = Estado::where('id', 'in', $endereco_profissional_estado_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_estado_to_string = $endereco_profissional_estado_to_string;
        }

        $this->vdata['endereco_profissional_estado_to_string'] = $this->endereco_profissional_estado_to_string;
    }

    public function get_endereco_profissional_estado_to_string()
    {
        if(!empty($this->endereco_profissional_estado_to_string))
        {
            return $this->endereco_profissional_estado_to_string;
        }
    
        $values = EnderecoProfissional::where('id_estado', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_cidade_to_string($endereco_profissional_cidade_to_string)
    {
        if(is_array($endereco_profissional_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $endereco_profissional_cidade_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_cidade_to_string = $endereco_profissional_cidade_to_string;
        }

        $this->vdata['endereco_profissional_cidade_to_string'] = $this->endereco_profissional_cidade_to_string;
    }

    public function get_endereco_profissional_cidade_to_string()
    {
        if(!empty($this->endereco_profissional_cidade_to_string))
        {
            return $this->endereco_profissional_cidade_to_string;
        }
    
        $values = EnderecoProfissional::where('id_estado', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_bairro_to_string($endereco_profissional_bairro_to_string)
    {
        if(is_array($endereco_profissional_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $endereco_profissional_bairro_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_bairro_to_string = $endereco_profissional_bairro_to_string;
        }

        $this->vdata['endereco_profissional_bairro_to_string'] = $this->endereco_profissional_bairro_to_string;
    }

    public function get_endereco_profissional_bairro_to_string()
    {
        if(!empty($this->endereco_profissional_bairro_to_string))
        {
            return $this->endereco_profissional_bairro_to_string;
        }
    
        $values = EnderecoProfissional::where('id_estado', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_tipo_to_string($endereco_profissional_tipo_to_string)
    {
        if(is_array($endereco_profissional_tipo_to_string))
        {
            $values = TipoLogradouro::where('id', 'in', $endereco_profissional_tipo_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_tipo_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_tipo_to_string = $endereco_profissional_tipo_to_string;
        }

        $this->vdata['endereco_profissional_tipo_to_string'] = $this->endereco_profissional_tipo_to_string;
    }

    public function get_endereco_profissional_tipo_to_string()
    {
        if(!empty($this->endereco_profissional_tipo_to_string))
        {
            return $this->endereco_profissional_tipo_to_string;
        }
    
        $values = EnderecoProfissional::where('id_estado', '=', $this->id)->getIndexedArray('id_tipo','{tipo->id}');
        return implode(', ', $values);
    }

    
}

