<?php

class EventoAgendamento extends TRecord
{
    const TABLENAME  = 'evento_agendamento';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('descricao');
        parent::addAttribute('sigla');
            
    }

    /**
     * Method getHistoricoAgendamentos
     */
    public function getHistoricoAgendamentos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_status', '=', $this->id));
        return HistoricoAgendamento::getObjects( $criteria );
    }

    public function set_historico_agendamento_status_to_string($historico_agendamento_status_to_string)
    {
        if(is_array($historico_agendamento_status_to_string))
        {
            $values = EventoAgendamento::where('id', 'in', $historico_agendamento_status_to_string)->getIndexedArray('id', 'id');
            $this->historico_agendamento_status_to_string = implode(', ', $values);
        }
        else
        {
            $this->historico_agendamento_status_to_string = $historico_agendamento_status_to_string;
        }

        $this->vdata['historico_agendamento_status_to_string'] = $this->historico_agendamento_status_to_string;
    }

    public function get_historico_agendamento_status_to_string()
    {
        if(!empty($this->historico_agendamento_status_to_string))
        {
            return $this->historico_agendamento_status_to_string;
        }
    
        $values = HistoricoAgendamento::where('id_status', '=', $this->id)->getIndexedArray('id_status','{status->id}');
        return implode(', ', $values);
    }

    public function set_historico_agendamento_agendamento_to_string($historico_agendamento_agendamento_to_string)
    {
        if(is_array($historico_agendamento_agendamento_to_string))
        {
            $values = Agendamento::where('id', 'in', $historico_agendamento_agendamento_to_string)->getIndexedArray('id', 'id');
            $this->historico_agendamento_agendamento_to_string = implode(', ', $values);
        }
        else
        {
            $this->historico_agendamento_agendamento_to_string = $historico_agendamento_agendamento_to_string;
        }

        $this->vdata['historico_agendamento_agendamento_to_string'] = $this->historico_agendamento_agendamento_to_string;
    }

    public function get_historico_agendamento_agendamento_to_string()
    {
        if(!empty($this->historico_agendamento_agendamento_to_string))
        {
            return $this->historico_agendamento_agendamento_to_string;
        }
    
        $values = HistoricoAgendamento::where('id_status', '=', $this->id)->getIndexedArray('id_agendamento','{agendamento->id}');
        return implode(', ', $values);
    }

    
}

