<?php

class HistoricoAgendamento extends TRecord
{
    const TABLENAME  = 'historico_agendamento';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $status;
    private $agendamento;
    private $usuario;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_status');
        parent::addAttribute('id_agendamento');
        parent::addAttribute('id_usuario');
        parent::addAttribute('justificativa');
        parent::addAttribute('data_hora');
            
    }

    /**
     * Method set_evento_agendamento
     * Sample of usage: $var->evento_agendamento = $object;
     * @param $object Instance of EventoAgendamento
     */
    public function set_status(EventoAgendamento $object)
    {
        $this->status = $object;
        $this->id_status = $object->id;
    }

    /**
     * Method get_status
     * Sample of usage: $var->status->attribute;
     * @returns EventoAgendamento instance
     */
    public function get_status()
    {
    
        // loads the associated object
        if (empty($this->status))
            $this->status = new EventoAgendamento($this->id_status);
    
        // returns the associated object
        return $this->status;
    }
    /**
     * Method set_agendamento
     * Sample of usage: $var->agendamento = $object;
     * @param $object Instance of Agendamento
     */
    public function set_agendamento(Agendamento $object)
    {
        $this->agendamento = $object;
        $this->id_agendamento = $object->id;
    }

    /**
     * Method get_agendamento
     * Sample of usage: $var->agendamento->attribute;
     * @returns Agendamento instance
     */
    public function get_agendamento()
    {
    
        // loads the associated object
        if (empty($this->agendamento))
            $this->agendamento = new Agendamento($this->id_agendamento);
    
        // returns the associated object
        return $this->agendamento;
    }
    /**
     * Method set_system_users
     * Sample of usage: $var->system_users = $object;
     * @param $object Instance of SystemUsers
     */
    public function set_usuario(SystemUsers $object)
    {
        $this->usuario = $object;
        $this->id_usuario = $object->id;
    }

    /**
     * Method get_usuario
     * Sample of usage: $var->usuario->attribute;
     * @returns SystemUsers instance
     */
    public function get_usuario()
    {
        TTransaction::open('permission');
        // loads the associated object
        if (empty($this->usuario))
            $this->usuario = new SystemUsers($this->id_usuario);
        TTransaction::close();
        // returns the associated object
        return $this->usuario;
    }

    
}

