<?php

class ItensEscoreabemid extends TRecord
{
    const TABLENAME  = 'itens_escoreabemid';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $escore_abemadulto;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_escore_abemid_adulto');
        parent::addAttribute('descricao_item');
        parent::addAttribute('qtd_pontos_item');
            
    }

    /**
     * Method set_escore_abemid
     * Sample of usage: $var->escore_abemid = $object;
     * @param $object Instance of EscoreAbemid
     */
    public function set_escore_abemadulto(EscoreAbemid $object)
    {
        $this->escore_abemadulto = $object;
        $this->id_escore_abemid_adulto = $object->id;
    }

    /**
     * Method get_escore_abemadulto
     * Sample of usage: $var->escore_abemadulto->attribute;
     * @returns EscoreAbemid instance
     */
    public function get_escore_abemadulto()
    {
    
        // loads the associated object
        if (empty($this->escore_abemadulto))
            $this->escore_abemadulto = new EscoreAbemid($this->id_escore_abemid_adulto);
    
        // returns the associated object
        return $this->escore_abemadulto;
    }

    /**
     * Method getAvaliacaoAbemidPacientes
     */
    public function getAvaliacaoAbemidPacientes()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_item_escore', '=', $this->id));
        return AvaliacaoAbemidPaciente::getObjects( $criteria );
    }

    public function set_avaliacao_abemid_paciente_paciente_to_string($avaliacao_abemid_paciente_paciente_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $avaliacao_abemid_paciente_paciente_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_paciente_to_string = $avaliacao_abemid_paciente_paciente_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_paciente_to_string'] = $this->avaliacao_abemid_paciente_paciente_to_string;
    }

    public function get_avaliacao_abemid_paciente_paciente_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_paciente_to_string))
        {
            return $this->avaliacao_abemid_paciente_paciente_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_item_escore', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_escore_abemid_to_string($avaliacao_abemid_paciente_escore_abemid_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_escore_abemid_to_string))
        {
            $values = EscoreAbemid::where('id', 'in', $avaliacao_abemid_paciente_escore_abemid_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_escore_abemid_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_escore_abemid_to_string = $avaliacao_abemid_paciente_escore_abemid_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_escore_abemid_to_string'] = $this->avaliacao_abemid_paciente_escore_abemid_to_string;
    }

    public function get_avaliacao_abemid_paciente_escore_abemid_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_escore_abemid_to_string))
        {
            return $this->avaliacao_abemid_paciente_escore_abemid_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_item_escore', '=', $this->id)->getIndexedArray('id_escore_abemid','{escore_abemid->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_item_escore_to_string($avaliacao_abemid_paciente_item_escore_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_item_escore_to_string))
        {
            $values = ItensEscoreabemid::where('id', 'in', $avaliacao_abemid_paciente_item_escore_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_item_escore_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_item_escore_to_string = $avaliacao_abemid_paciente_item_escore_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_item_escore_to_string'] = $this->avaliacao_abemid_paciente_item_escore_to_string;
    }

    public function get_avaliacao_abemid_paciente_item_escore_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_item_escore_to_string))
        {
            return $this->avaliacao_abemid_paciente_item_escore_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_item_escore', '=', $this->id)->getIndexedArray('id_item_escore','{item_escore->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_classificacao_to_string($avaliacao_abemid_paciente_classificacao_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_classificacao_to_string))
        {
            $values = ClassificacaoAbemid::where('id', 'in', $avaliacao_abemid_paciente_classificacao_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_classificacao_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_classificacao_to_string = $avaliacao_abemid_paciente_classificacao_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_classificacao_to_string'] = $this->avaliacao_abemid_paciente_classificacao_to_string;
    }

    public function get_avaliacao_abemid_paciente_classificacao_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_classificacao_to_string))
        {
            return $this->avaliacao_abemid_paciente_classificacao_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_item_escore', '=', $this->id)->getIndexedArray('id_classificacao','{classificacao->id}');
        return implode(', ', $values);
    }

    
}

