<?php

class MedicamentoAvaliacao extends TRecord
{
    const TABLENAME  = 'medicamento_avaliacao';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $avaliacao_medica;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_avaliacao_medica');
        parent::addAttribute('descricao_medicamento');
            
    }

    /**
     * Method set_avaliacao_medica
     * Sample of usage: $var->avaliacao_medica = $object;
     * @param $object Instance of AvaliacaoMedica
     */
    public function set_avaliacao_medica(AvaliacaoMedica $object)
    {
        $this->avaliacao_medica = $object;
        $this->id_avaliacao_medica = $object->id;
    }

    /**
     * Method get_avaliacao_medica
     * Sample of usage: $var->avaliacao_medica->attribute;
     * @returns AvaliacaoMedica instance
     */
    public function get_avaliacao_medica()
    {
    
        // loads the associated object
        if (empty($this->avaliacao_medica))
            $this->avaliacao_medica = new AvaliacaoMedica($this->id_avaliacao_medica);
    
        // returns the associated object
        return $this->avaliacao_medica;
    }

    
}

