<?php

class Ocupacao extends TRecord
{
    const TABLENAME  = 'ocupacao';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('descricao_ocupacao');
            
    }

    /**
     * Method getProfissionalOcupacaos
     */
    public function getProfissionalOcupacaos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_ocupacao', '=', $this->id));
        return ProfissionalOcupacao::getObjects( $criteria );
    }
    /**
     * Method getEscalas
     */
    public function getEscalas()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_ocupacao', '=', $this->id));
        return Escala::getObjects( $criteria );
    }

    public function set_profissional_ocupacao_profissional_to_string($profissional_ocupacao_profissional_to_string)
    {
        if(is_array($profissional_ocupacao_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $profissional_ocupacao_profissional_to_string)->getIndexedArray('id', 'id');
            $this->profissional_ocupacao_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_ocupacao_profissional_to_string = $profissional_ocupacao_profissional_to_string;
        }

        $this->vdata['profissional_ocupacao_profissional_to_string'] = $this->profissional_ocupacao_profissional_to_string;
    }

    public function get_profissional_ocupacao_profissional_to_string()
    {
        if(!empty($this->profissional_ocupacao_profissional_to_string))
        {
            return $this->profissional_ocupacao_profissional_to_string;
        }
    
        $values = ProfissionalOcupacao::where('id_ocupacao', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_profissional_ocupacao_ocupacao_to_string($profissional_ocupacao_ocupacao_to_string)
    {
        if(is_array($profissional_ocupacao_ocupacao_to_string))
        {
            $values = Ocupacao::where('id', 'in', $profissional_ocupacao_ocupacao_to_string)->getIndexedArray('descricao_ocupacao', 'descricao_ocupacao');
            $this->profissional_ocupacao_ocupacao_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_ocupacao_ocupacao_to_string = $profissional_ocupacao_ocupacao_to_string;
        }

        $this->vdata['profissional_ocupacao_ocupacao_to_string'] = $this->profissional_ocupacao_ocupacao_to_string;
    }

    public function get_profissional_ocupacao_ocupacao_to_string()
    {
        if(!empty($this->profissional_ocupacao_ocupacao_to_string))
        {
            return $this->profissional_ocupacao_ocupacao_to_string;
        }
    
        $values = ProfissionalOcupacao::where('id_ocupacao', '=', $this->id)->getIndexedArray('id_ocupacao','{ocupacao->descricao_ocupacao}');
        return implode(', ', $values);
    }

    public function set_escala_equipe_to_string($escala_equipe_to_string)
    {
        if(is_array($escala_equipe_to_string))
        {
            $values = Equipe::where('id', 'in', $escala_equipe_to_string)->getIndexedArray('id', 'id');
            $this->escala_equipe_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_equipe_to_string = $escala_equipe_to_string;
        }

        $this->vdata['escala_equipe_to_string'] = $this->escala_equipe_to_string;
    }

    public function get_escala_equipe_to_string()
    {
        if(!empty($this->escala_equipe_to_string))
        {
            return $this->escala_equipe_to_string;
        }
    
        $values = Escala::where('id_ocupacao', '=', $this->id)->getIndexedArray('id_equipe','{equipe->id}');
        return implode(', ', $values);
    }

    public function set_escala_profissional_to_string($escala_profissional_to_string)
    {
        if(is_array($escala_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $escala_profissional_to_string)->getIndexedArray('id', 'id');
            $this->escala_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_profissional_to_string = $escala_profissional_to_string;
        }

        $this->vdata['escala_profissional_to_string'] = $this->escala_profissional_to_string;
    }

    public function get_escala_profissional_to_string()
    {
        if(!empty($this->escala_profissional_to_string))
        {
            return $this->escala_profissional_to_string;
        }
    
        $values = Escala::where('id_ocupacao', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_escala_turno_to_string($escala_turno_to_string)
    {
        if(is_array($escala_turno_to_string))
        {
            $values = Turno::where('id', 'in', $escala_turno_to_string)->getIndexedArray('id', 'id');
            $this->escala_turno_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_turno_to_string = $escala_turno_to_string;
        }

        $this->vdata['escala_turno_to_string'] = $this->escala_turno_to_string;
    }

    public function get_escala_turno_to_string()
    {
        if(!empty($this->escala_turno_to_string))
        {
            return $this->escala_turno_to_string;
        }
    
        $values = Escala::where('id_ocupacao', '=', $this->id)->getIndexedArray('id_turno','{turno->id}');
        return implode(', ', $values);
    }

    public function set_escala_unidade_saude_to_string($escala_unidade_saude_to_string)
    {
        if(is_array($escala_unidade_saude_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $escala_unidade_saude_to_string)->getIndexedArray('id', 'id');
            $this->escala_unidade_saude_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_unidade_saude_to_string = $escala_unidade_saude_to_string;
        }

        $this->vdata['escala_unidade_saude_to_string'] = $this->escala_unidade_saude_to_string;
    }

    public function get_escala_unidade_saude_to_string()
    {
        if(!empty($this->escala_unidade_saude_to_string))
        {
            return $this->escala_unidade_saude_to_string;
        }
    
        $values = Escala::where('id_ocupacao', '=', $this->id)->getIndexedArray('id_unidade_saude','{unidade_saude->id}');
        return implode(', ', $values);
    }

    public function set_escala_procedimento_to_string($escala_procedimento_to_string)
    {
        if(is_array($escala_procedimento_to_string))
        {
            $values = Procedimento::where('id', 'in', $escala_procedimento_to_string)->getIndexedArray('id', 'id');
            $this->escala_procedimento_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_procedimento_to_string = $escala_procedimento_to_string;
        }

        $this->vdata['escala_procedimento_to_string'] = $this->escala_procedimento_to_string;
    }

    public function get_escala_procedimento_to_string()
    {
        if(!empty($this->escala_procedimento_to_string))
        {
            return $this->escala_procedimento_to_string;
        }
    
        $values = Escala::where('id_ocupacao', '=', $this->id)->getIndexedArray('id_procedimento','{procedimento->id}');
        return implode(', ', $values);
    }

    public function set_escala_ocupacao_to_string($escala_ocupacao_to_string)
    {
        if(is_array($escala_ocupacao_to_string))
        {
            $values = Ocupacao::where('id', 'in', $escala_ocupacao_to_string)->getIndexedArray('descricao_ocupacao', 'descricao_ocupacao');
            $this->escala_ocupacao_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_ocupacao_to_string = $escala_ocupacao_to_string;
        }

        $this->vdata['escala_ocupacao_to_string'] = $this->escala_ocupacao_to_string;
    }

    public function get_escala_ocupacao_to_string()
    {
        if(!empty($this->escala_ocupacao_to_string))
        {
            return $this->escala_ocupacao_to_string;
        }
    
        $values = Escala::where('id_ocupacao', '=', $this->id)->getIndexedArray('id_ocupacao','{ocupacao->descricao_ocupacao}');
        return implode(', ', $values);
    }

    
}

