<?php

class Paciente extends TRecord
{
    const TABLENAME  = 'paciente';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $system_user;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('cpf');
        parent::addAttribute('cns_paciente');
        parent::addAttribute('rg_paciente');
        parent::addAttribute('nome_paciente');
        parent::addAttribute('data_nascimento');
        parent::addAttribute('mae_paciente');
        parent::addAttribute('telefone');
        parent::addAttribute('pai_paciente');
        parent::addAttribute('responsavel_paciente');
        parent::addAttribute('cpf_responsavel');
        parent::addAttribute('celular_paciente');
        parent::addAttribute('mf_paciente');
        parent::addAttribute('naturalidade');
        parent::addAttribute('data_admissao');
        parent::addAttribute('sexo_paciente');
        parent::addAttribute('system_user_id');
        parent::addAttribute('flg_externo');
            
    }

    /**
     * Method set_system_users
     * Sample of usage: $var->system_users = $object;
     * @param $object Instance of SystemUsers
     */
    public function set_system_user(SystemUsers $object)
    {
        $this->system_user = $object;
        $this->system_user_id = $object->id;
    }

    /**
     * Method get_system_user
     * Sample of usage: $var->system_user->attribute;
     * @returns SystemUsers instance
     */
    public function get_system_user()
    {
        TTransaction::open('permission');
        // loads the associated object
        if (empty($this->system_user))
            $this->system_user = new SystemUsers($this->system_user_id);
        TTransaction::close();
        // returns the associated object
        return $this->system_user;
    }

    /**
     * Method getAgendamentos
     */
    public function getAgendamentos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_paciente', '=', $this->id));
        return Agendamento::getObjects( $criteria );
    }
    /**
     * Method getEnderecoPacientes
     */
    public function getEnderecoPacientes()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_paciente', '=', $this->id));
        return EnderecoPaciente::getObjects( $criteria );
    }
    /**
     * Method getPacienteCid10s
     */
    public function getPacienteCid10s()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_paciente', '=', $this->id));
        return PacienteCid10::getObjects( $criteria );
    }
    /**
     * Method getAvaliacaoAbemidPacientes
     */
    public function getAvaliacaoAbemidPacientes()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_paciente', '=', $this->id));
        return AvaliacaoAbemidPaciente::getObjects( $criteria );
    }
    /**
     * Method getAvaliacaoMedicas
     */
    public function getAvaliacaoMedicas()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_paciente', '=', $this->id));
        return AvaliacaoMedica::getObjects( $criteria );
    }

    public function set_agendamento_paciente_to_string($agendamento_paciente_to_string)
    {
        if(is_array($agendamento_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $agendamento_paciente_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_paciente_to_string = $agendamento_paciente_to_string;
        }

        $this->vdata['agendamento_paciente_to_string'] = $this->agendamento_paciente_to_string;
    }

    public function get_agendamento_paciente_to_string()
    {
        if(!empty($this->agendamento_paciente_to_string))
        {
            return $this->agendamento_paciente_to_string;
        }
    
        $values = Agendamento::where('id_paciente', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_escala_to_string($agendamento_escala_to_string)
    {
        if(is_array($agendamento_escala_to_string))
        {
            $values = Escala::where('id', 'in', $agendamento_escala_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_escala_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_escala_to_string = $agendamento_escala_to_string;
        }

        $this->vdata['agendamento_escala_to_string'] = $this->agendamento_escala_to_string;
    }

    public function get_agendamento_escala_to_string()
    {
        if(!empty($this->agendamento_escala_to_string))
        {
            return $this->agendamento_escala_to_string;
        }
    
        $values = Agendamento::where('id_paciente', '=', $this->id)->getIndexedArray('id_escala','{escala->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_unidade_saude_to_string($agendamento_unidade_saude_to_string)
    {
        if(is_array($agendamento_unidade_saude_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $agendamento_unidade_saude_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_unidade_saude_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_unidade_saude_to_string = $agendamento_unidade_saude_to_string;
        }

        $this->vdata['agendamento_unidade_saude_to_string'] = $this->agendamento_unidade_saude_to_string;
    }

    public function get_agendamento_unidade_saude_to_string()
    {
        if(!empty($this->agendamento_unidade_saude_to_string))
        {
            return $this->agendamento_unidade_saude_to_string;
        }
    
        $values = Agendamento::where('id_paciente', '=', $this->id)->getIndexedArray('id_unidade_saude','{unidade_saude->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_procedimento_to_string($agendamento_procedimento_to_string)
    {
        if(is_array($agendamento_procedimento_to_string))
        {
            $values = Procedimento::where('id', 'in', $agendamento_procedimento_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_procedimento_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_procedimento_to_string = $agendamento_procedimento_to_string;
        }

        $this->vdata['agendamento_procedimento_to_string'] = $this->agendamento_procedimento_to_string;
    }

    public function get_agendamento_procedimento_to_string()
    {
        if(!empty($this->agendamento_procedimento_to_string))
        {
            return $this->agendamento_procedimento_to_string;
        }
    
        $values = Agendamento::where('id_paciente', '=', $this->id)->getIndexedArray('id_procedimento','{procedimento->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_profissional_to_string($agendamento_profissional_to_string)
    {
        if(is_array($agendamento_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $agendamento_profissional_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_profissional_to_string = $agendamento_profissional_to_string;
        }

        $this->vdata['agendamento_profissional_to_string'] = $this->agendamento_profissional_to_string;
    }

    public function get_agendamento_profissional_to_string()
    {
        if(!empty($this->agendamento_profissional_to_string))
        {
            return $this->agendamento_profissional_to_string;
        }
    
        $values = Agendamento::where('id_paciente', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_paciente_to_string($endereco_paciente_paciente_to_string)
    {
        if(is_array($endereco_paciente_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $endereco_paciente_paciente_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_paciente_to_string = $endereco_paciente_paciente_to_string;
        }

        $this->vdata['endereco_paciente_paciente_to_string'] = $this->endereco_paciente_paciente_to_string;
    }

    public function get_endereco_paciente_paciente_to_string()
    {
        if(!empty($this->endereco_paciente_paciente_to_string))
        {
            return $this->endereco_paciente_paciente_to_string;
        }
    
        $values = EnderecoPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_estado_to_string($endereco_paciente_estado_to_string)
    {
        if(is_array($endereco_paciente_estado_to_string))
        {
            $values = Estado::where('id', 'in', $endereco_paciente_estado_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_estado_to_string = $endereco_paciente_estado_to_string;
        }

        $this->vdata['endereco_paciente_estado_to_string'] = $this->endereco_paciente_estado_to_string;
    }

    public function get_endereco_paciente_estado_to_string()
    {
        if(!empty($this->endereco_paciente_estado_to_string))
        {
            return $this->endereco_paciente_estado_to_string;
        }
    
        $values = EnderecoPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_cidade_to_string($endereco_paciente_cidade_to_string)
    {
        if(is_array($endereco_paciente_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $endereco_paciente_cidade_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_cidade_to_string = $endereco_paciente_cidade_to_string;
        }

        $this->vdata['endereco_paciente_cidade_to_string'] = $this->endereco_paciente_cidade_to_string;
    }

    public function get_endereco_paciente_cidade_to_string()
    {
        if(!empty($this->endereco_paciente_cidade_to_string))
        {
            return $this->endereco_paciente_cidade_to_string;
        }
    
        $values = EnderecoPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_bairro_to_string($endereco_paciente_bairro_to_string)
    {
        if(is_array($endereco_paciente_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $endereco_paciente_bairro_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_bairro_to_string = $endereco_paciente_bairro_to_string;
        }

        $this->vdata['endereco_paciente_bairro_to_string'] = $this->endereco_paciente_bairro_to_string;
    }

    public function get_endereco_paciente_bairro_to_string()
    {
        if(!empty($this->endereco_paciente_bairro_to_string))
        {
            return $this->endereco_paciente_bairro_to_string;
        }
    
        $values = EnderecoPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_endereco_paciente_tipo_to_string($endereco_paciente_tipo_to_string)
    {
        if(is_array($endereco_paciente_tipo_to_string))
        {
            $values = TipoLogradouro::where('id', 'in', $endereco_paciente_tipo_to_string)->getIndexedArray('id', 'id');
            $this->endereco_paciente_tipo_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_paciente_tipo_to_string = $endereco_paciente_tipo_to_string;
        }

        $this->vdata['endereco_paciente_tipo_to_string'] = $this->endereco_paciente_tipo_to_string;
    }

    public function get_endereco_paciente_tipo_to_string()
    {
        if(!empty($this->endereco_paciente_tipo_to_string))
        {
            return $this->endereco_paciente_tipo_to_string;
        }
    
        $values = EnderecoPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_tipo','{tipo->id}');
        return implode(', ', $values);
    }

    public function set_paciente_cid10_cid_to_string($paciente_cid10_cid_to_string)
    {
        if(is_array($paciente_cid10_cid_to_string))
        {
            $values = Cid10::where('id', 'in', $paciente_cid10_cid_to_string)->getIndexedArray('id', 'id');
            $this->paciente_cid10_cid_to_string = implode(', ', $values);
        }
        else
        {
            $this->paciente_cid10_cid_to_string = $paciente_cid10_cid_to_string;
        }

        $this->vdata['paciente_cid10_cid_to_string'] = $this->paciente_cid10_cid_to_string;
    }

    public function get_paciente_cid10_cid_to_string()
    {
        if(!empty($this->paciente_cid10_cid_to_string))
        {
            return $this->paciente_cid10_cid_to_string;
        }
    
        $values = PacienteCid10::where('id_paciente', '=', $this->id)->getIndexedArray('id_cid','{cid->id}');
        return implode(', ', $values);
    }

    public function set_paciente_cid10_paciente_to_string($paciente_cid10_paciente_to_string)
    {
        if(is_array($paciente_cid10_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $paciente_cid10_paciente_to_string)->getIndexedArray('id', 'id');
            $this->paciente_cid10_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->paciente_cid10_paciente_to_string = $paciente_cid10_paciente_to_string;
        }

        $this->vdata['paciente_cid10_paciente_to_string'] = $this->paciente_cid10_paciente_to_string;
    }

    public function get_paciente_cid10_paciente_to_string()
    {
        if(!empty($this->paciente_cid10_paciente_to_string))
        {
            return $this->paciente_cid10_paciente_to_string;
        }
    
        $values = PacienteCid10::where('id_paciente', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_paciente_cid10_tipo_cid_to_string($paciente_cid10_tipo_cid_to_string)
    {
        if(is_array($paciente_cid10_tipo_cid_to_string))
        {
            $values = TipoCid::where('id', 'in', $paciente_cid10_tipo_cid_to_string)->getIndexedArray('id', 'id');
            $this->paciente_cid10_tipo_cid_to_string = implode(', ', $values);
        }
        else
        {
            $this->paciente_cid10_tipo_cid_to_string = $paciente_cid10_tipo_cid_to_string;
        }

        $this->vdata['paciente_cid10_tipo_cid_to_string'] = $this->paciente_cid10_tipo_cid_to_string;
    }

    public function get_paciente_cid10_tipo_cid_to_string()
    {
        if(!empty($this->paciente_cid10_tipo_cid_to_string))
        {
            return $this->paciente_cid10_tipo_cid_to_string;
        }
    
        $values = PacienteCid10::where('id_paciente', '=', $this->id)->getIndexedArray('id_tipo_cid','{tipo_cid->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_paciente_to_string($avaliacao_abemid_paciente_paciente_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $avaliacao_abemid_paciente_paciente_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_paciente_to_string = $avaliacao_abemid_paciente_paciente_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_paciente_to_string'] = $this->avaliacao_abemid_paciente_paciente_to_string;
    }

    public function get_avaliacao_abemid_paciente_paciente_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_paciente_to_string))
        {
            return $this->avaliacao_abemid_paciente_paciente_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_escore_abemid_to_string($avaliacao_abemid_paciente_escore_abemid_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_escore_abemid_to_string))
        {
            $values = EscoreAbemid::where('id', 'in', $avaliacao_abemid_paciente_escore_abemid_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_escore_abemid_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_escore_abemid_to_string = $avaliacao_abemid_paciente_escore_abemid_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_escore_abemid_to_string'] = $this->avaliacao_abemid_paciente_escore_abemid_to_string;
    }

    public function get_avaliacao_abemid_paciente_escore_abemid_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_escore_abemid_to_string))
        {
            return $this->avaliacao_abemid_paciente_escore_abemid_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_escore_abemid','{escore_abemid->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_item_escore_to_string($avaliacao_abemid_paciente_item_escore_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_item_escore_to_string))
        {
            $values = ItensEscoreabemid::where('id', 'in', $avaliacao_abemid_paciente_item_escore_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_item_escore_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_item_escore_to_string = $avaliacao_abemid_paciente_item_escore_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_item_escore_to_string'] = $this->avaliacao_abemid_paciente_item_escore_to_string;
    }

    public function get_avaliacao_abemid_paciente_item_escore_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_item_escore_to_string))
        {
            return $this->avaliacao_abemid_paciente_item_escore_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_item_escore','{item_escore->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_abemid_paciente_classificacao_to_string($avaliacao_abemid_paciente_classificacao_to_string)
    {
        if(is_array($avaliacao_abemid_paciente_classificacao_to_string))
        {
            $values = ClassificacaoAbemid::where('id', 'in', $avaliacao_abemid_paciente_classificacao_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_abemid_paciente_classificacao_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_abemid_paciente_classificacao_to_string = $avaliacao_abemid_paciente_classificacao_to_string;
        }

        $this->vdata['avaliacao_abemid_paciente_classificacao_to_string'] = $this->avaliacao_abemid_paciente_classificacao_to_string;
    }

    public function get_avaliacao_abemid_paciente_classificacao_to_string()
    {
        if(!empty($this->avaliacao_abemid_paciente_classificacao_to_string))
        {
            return $this->avaliacao_abemid_paciente_classificacao_to_string;
        }
    
        $values = AvaliacaoAbemidPaciente::where('id_paciente', '=', $this->id)->getIndexedArray('id_classificacao','{classificacao->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_medica_paciente_to_string($avaliacao_medica_paciente_to_string)
    {
        if(is_array($avaliacao_medica_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $avaliacao_medica_paciente_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_medica_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_medica_paciente_to_string = $avaliacao_medica_paciente_to_string;
        }

        $this->vdata['avaliacao_medica_paciente_to_string'] = $this->avaliacao_medica_paciente_to_string;
    }

    public function get_avaliacao_medica_paciente_to_string()
    {
        if(!empty($this->avaliacao_medica_paciente_to_string))
        {
            return $this->avaliacao_medica_paciente_to_string;
        }
    
        $values = AvaliacaoMedica::where('id_paciente', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_avaliacao_medica_agendamento_to_string($avaliacao_medica_agendamento_to_string)
    {
        if(is_array($avaliacao_medica_agendamento_to_string))
        {
            $values = Agendamento::where('id', 'in', $avaliacao_medica_agendamento_to_string)->getIndexedArray('id', 'id');
            $this->avaliacao_medica_agendamento_to_string = implode(', ', $values);
        }
        else
        {
            $this->avaliacao_medica_agendamento_to_string = $avaliacao_medica_agendamento_to_string;
        }

        $this->vdata['avaliacao_medica_agendamento_to_string'] = $this->avaliacao_medica_agendamento_to_string;
    }

    public function get_avaliacao_medica_agendamento_to_string()
    {
        if(!empty($this->avaliacao_medica_agendamento_to_string))
        {
            return $this->avaliacao_medica_agendamento_to_string;
        }
    
        $values = AvaliacaoMedica::where('id_paciente', '=', $this->id)->getIndexedArray('id_agendamento','{agendamento->id}');
        return implode(', ', $values);
    }

    
}

