<?php

class PacienteCid10 extends TRecord
{
    const TABLENAME  = 'paciente_cid10';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $tipo_cid;
    private $paciente;
    private $cid;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_cid');
        parent::addAttribute('id_paciente');
        parent::addAttribute('id_tipo_cid');
            
    }

    /**
     * Method set_tipo_cid
     * Sample of usage: $var->tipo_cid = $object;
     * @param $object Instance of TipoCid
     */
    public function set_tipo_cid(TipoCid $object)
    {
        $this->tipo_cid = $object;
        $this->id_tipo_cid = $object->id;
    }

    /**
     * Method get_tipo_cid
     * Sample of usage: $var->tipo_cid->attribute;
     * @returns TipoCid instance
     */
    public function get_tipo_cid()
    {
    
        // loads the associated object
        if (empty($this->tipo_cid))
            $this->tipo_cid = new TipoCid($this->id_tipo_cid);
    
        // returns the associated object
        return $this->tipo_cid;
    }
    /**
     * Method set_paciente
     * Sample of usage: $var->paciente = $object;
     * @param $object Instance of Paciente
     */
    public function set_paciente(Paciente $object)
    {
        $this->paciente = $object;
        $this->id_paciente = $object->id;
    }

    /**
     * Method get_paciente
     * Sample of usage: $var->paciente->attribute;
     * @returns Paciente instance
     */
    public function get_paciente()
    {
    
        // loads the associated object
        if (empty($this->paciente))
            $this->paciente = new Paciente($this->id_paciente);
    
        // returns the associated object
        return $this->paciente;
    }
    /**
     * Method set_cid10
     * Sample of usage: $var->cid10 = $object;
     * @param $object Instance of Cid10
     */
    public function set_cid(Cid10 $object)
    {
        $this->cid = $object;
        $this->id_cid = $object->id;
    }

    /**
     * Method get_cid
     * Sample of usage: $var->cid->attribute;
     * @returns Cid10 instance
     */
    public function get_cid()
    {
    
        // loads the associated object
        if (empty($this->cid))
            $this->cid = new Cid10($this->id_cid);
    
        // returns the associated object
        return $this->cid;
    }

    
}

